<?php
declare(strict_types=1);
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

require '../core.php';
require_once __DIR__ . '/functions.php';

/** Conexão robusta ($connect pode vir do core; se não, tenta criar) */
try {
  if (!isset($connect) || !$connect) {
    if (function_exists('connect')) {
      if (isset($database)) { $connect = @connect($database); }
      if (!$connect)        { $connect = @connect(); }
    }
  }
} catch (Throwable $e) {
  // segue; páginas abaixo tratam erro de conexão
}

/** Polyfill: getTotalItemsByUser */
if (!function_exists('getTotalItemsByUser')) {
  if (function_exists('getTotalItemsByUserr')) {
    function getTotalItemsByUser($user_id) { return getTotalItemsByUserr((int)$user_id); }
  } else {
    function getTotalItemsByUser($user_id) { return 0; }
  }
}

if (isLogged($connect)) {

  $userProfile = getUserInfo();
  $userDetails = getUserInfoById($userProfile['user_id'] ?? 0);
  $planDetails = getPlanById($connect, (int)($userDetails['user_plan'] ?? 0));
  $userTotalOUploaded = getTotalItemsByUser((int)($userDetails['user_id'] ?? 0));

  if (!isSeller()) {
    if (!headers_sent()) { header('Location: ./denied.php'); }
    exit;
  }

  // Checagem de expiração
  if (isExpiredSubscription()) {
    if (!headers_sent()) { header('Location: ./home.php'); }
    exit;
  }

  $getLocations  = getLocations($connect);
  $getStores     = getStoresForUser($connect, (int)($userProfile['user_id'] ?? 0));
  $getCategories = getCategories($connect);

  require './header.php';
  require './views/new_item.view.php';
  require './footer.php';

} else {
  if (!headers_sent()) { header('Location: ./login.php'); }
  exit;
}
