<?php
declare(strict_types=1);

/*--------------------*
 | Dashboard: Profile |
 *--------------------*/

if (!headers_sent()) { @ob_start(); }
if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }

/* Núcleo + funções do projeto */
require_once __DIR__ . '/../core.php';
require_once __DIR__ . '/functions.php';   // <- usa o functions.php da raiz
// (se você realmente tiver um functions.php específico do dashboard, pode manter um require opcional aqui)

/* Idioma (se existir) */
if (is_file(__DIR__ . '/../init_lang.php')) {
  require_once __DIR__ . '/../init_lang.php';
}

/* Conexão PDO (segura) */
$connect = $connect ?? null;
try {
  if (!isset($connect) || !$connect) {
    if (isset($database)) { $connect = @connect($database); }
    if (!$connect)        { $connect = @connect(); }
  }
} catch (\Throwable $e) {
  // segue; as funções de auth abaixo toleram $connect nulo
}

/* --------- Polyfills (não interferem se as oficiais existirem) ---------- */

/** getTotalItemsByUser shim (evita fatals quando só existe ...ByUserr) */
if (!function_exists('getTotalItemsByUser')) {
  if (function_exists('getTotalItemsByUserr')) {
    function getTotalItemsByUser($user_id) { return (int) getTotalItemsByUserr($user_id); }
  } else {
    function getTotalItemsByUser($user_id) { return 0; }
  }
}

/** isSeller shim (só usado se a função oficial não existir) */
if (!function_exists('isSeller')) {
  function isSeller(): bool {
    // 1) indício por sessão (ajuste se seu projeto usa outro valor para anunciante)
    if (!empty($_SESSION['user_role']) && (int)$_SESSION['user_role'] === 3) {
      return true;
    }

    // 2) tenta pelo helper getUserInfo()
    try {
      if (function_exists('getUserInfo')) {
        $u = (array) getUserInfo();
        if (isset($u['user_is_seller']) && (int)$u['user_is_seller'] === 1) { return true; }
        if (isset($u['user_role_slug']) && in_array($u['user_role_slug'], ['seller','vendedor'], true)) { return true; }
      }
    } catch (\Throwable $e) {}

    // 3) tenta tabela sellers (status ativo)
    try {
      $pdo = $GLOBALS['connect'] ?? null;
      if (!$pdo && function_exists('connect')) { $pdo = connect(); }
      if ($pdo && function_exists('getUserInfo')) {
        $u = (array) getUserInfo();
        $uid = (int)($u['user_id'] ?? 0);
        if ($uid > 0) {
          $st = $pdo->prepare("SELECT 1 FROM sellers WHERE seller_user = :uid AND seller_status = 1 LIMIT 1");
          $st->execute([':uid' => $uid]);
          if ($st->fetchColumn()) { return true; }
        }
      }
    } catch (\Throwable $e) {}

    return false;
  }
}
/* ----------------------------------------------------------------------- */

/* Autorização básica */
$logged = false;
try { $logged = function_exists('isLogged') ? (bool) isLogged($connect) : (!empty($_SESSION['user_id'])); }
catch (\Throwable $e) { $logged = !empty($_SESSION['user_id']); }

if (!$logged) {
  if (!headers_sent()) { header('Location: ./login.php'); }
  exit;
}

/* Carrega dados do usuário */
$userProfile = [];
$userDetails = [];
try {
  if (function_exists('getUserInfo')) {
    $userProfile = (array) getUserInfo();
  }
  if (empty($userProfile) && !empty($_SESSION['user_id']) && function_exists('getUserInfoById')) {
    $userProfile = (array) getUserInfoById((int)$_SESSION['user_id']);
  }
  if (!empty($userProfile['user_id']) && function_exists('getUserInfoById')) {
    $userDetails = (array) getUserInfoById((int)$userProfile['user_id']);
  }
} catch (\Throwable $e) {
  $userProfile = $userProfile ?? [];
  $userDetails = $userDetails ?? [];
}

/* Gate: somente anunciantees acessam esta rota */
if (!isSeller()) {
  if (!headers_sent()) { header('Location: ./denied.php'); }
  exit;
}

/* Assinatura expirada? */
try {
  if (function_exists('isExpiredSubscription') && isExpiredSubscription()) {
    if (!headers_sent()) { header('Location: ./home.php'); }
    exit;
  }
} catch (\Throwable $e) {
  // se a função não existir ou falhar, ignora
}

/* Se por algum motivo não veio o perfil detalhado, volta ao home */
if (empty($userDetails)) {
  if (!headers_sent()) { header('Location: ./home.php'); }
  exit;
}

/* Billing seguro (evita warnings) */
$userBilling = [];
if (!empty($userDetails['user_billing'])) {
  $dec = json_decode((string)$userDetails['user_billing'], true);
  if (json_last_error() === JSON_ERROR_NONE && is_array($dec)) {
    $userBilling = $dec;
  }
}

/* Render do dashboard */
require __DIR__ . '/header.php';
require __DIR__ . '/views/profile.view.php';
require __DIR__ . '/footer.php';

if (ob_get_level() > 0) { @ob_end_flush(); }
