<?php
declare(strict_types=1);

/*--------------------*/
// Dashboard - Minhas Submissões (seller area)
/*--------------------*/

if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }

require_once __DIR__ . '/../core.php';
require_once __DIR__ . '/functions.php';
if (is_file(__DIR__ . '/../init_lang.php')) { require_once __DIR__ . '/../init_lang.php'; }

/* ========= Conexão PDO segura ========= */
$connect = $connect ?? null;
try {
  if (!isset($connect) || !$connect) {
    if (function_exists('connect')) {
      if (isset($database)) { $connect = @connect($database); }
      if (!$connect)        { $connect = @connect(); }
    }
  }
} catch (Throwable $e) {
  // tolera sem derrubar; as funções abaixo lidam com $connect nulo
}

/* ========= Guards / Polyfills ========= */
if (!function_exists('nd_is_logged')) {
  function nd_is_logged($conn = null): bool {
    if (function_exists('isLogged')) {
      try { return isset($conn) ? (bool)isLogged($conn) : (bool)isLogged(); }
      catch (Throwable $e) { return false; }
    }
    return !empty($_SESSION['user_id']) || !empty($_SESSION['user']);
  }
}
if (!function_exists('nd_is_seller')) {
  function nd_is_seller(): bool {
    if (function_exists('isSeller')) {
      try { return (bool)isSeller(); } catch (Throwable $e) { return false; }
    }
    return false; // se não existir, trate como não-seller
  }
}
/* getTotalItemsByUser pode existir como getTotalItemsByUserr em alguns forks */
if (!function_exists('getTotalItemsByUser')) {
  if (function_exists('getTotalItemsByUserr')) {
    function getTotalItemsByUser($user_id) { return getTotalItemsByUserr($user_id); }
  } else {
    function getTotalItemsByUser($user_id) { return 0; }
  }
}

/* ========= Gates ========= */
if (!nd_is_logged($connect)) {
  if (!headers_sent()) { header('Location: ./login.php'); }
  exit;
}
if (!nd_is_seller()) {
  if (!headers_sent()) { header('Location: ./denied.php'); }
  exit;
}

/* ========= Carrega dados do usuário ========= */
$userProfile = [];
$userDetails = [];
try { if (function_exists('getUserInfo')) $userProfile = (array)getUserInfo(); } catch (Throwable $e) {}

try {
  if (function_exists('getUserInfoById') && !empty($userProfile['user_id'])) {
    $userDetails = (array)getUserInfoById((int)$userProfile['user_id']);
  }
} catch (Throwable $e) {}

/* Plano do usuário (se disponível) */
$userPlanSettings = [];
try {
  if (!empty($userDetails['user_plan']) && function_exists('getPlanById') && $connect) {
    $userPlanSettings = (array)getPlanById($connect, (int)$userDetails['user_plan']);
  }
} catch (Throwable $e) {}

/* Total de itens enviados pelo usuário */
$userTotalOUploaded = 0;
try {
  if (!empty($userDetails['user_id'])) {
    $userTotalOUploaded = (int)getTotalItemsByUser((int)$userDetails['user_id']);
  }
} catch (Throwable $e) { $userTotalOUploaded = 0; }


/* ========= Cotas de plano (ofertas, destaques, exclusivas) ========= */
$userRemainingDeals      = 0;
$userRemainingFeatured   = 0;
$userRemainingExclusive  = 0;

try {
  if (!empty($userDetails['user_id']) && $connect) {
    $uid = (int)$userDetails['user_id'];
    if (function_exists('nd_user_remaining_deals')) {
      $userRemainingDeals = nd_user_remaining_deals($connect, $uid);
    }
    if (function_exists('nd_user_remaining_featured')) {
      $userRemainingFeatured = nd_user_remaining_featured($connect, $uid);
    }
    if (function_exists('nd_user_remaining_exclusive')) {
      $userRemainingExclusive = nd_user_remaining_exclusive($connect, $uid);
    }
  }
} catch (Throwable $e) {
  // silencioso: se der erro continuamos sem bloquear a tela
}


/* ========= Lista de submissões =========
   Tentamos múltiplos nomes de função (dependendo do fork do script):
   - get_all_deals_by_user($user_id, $limit)
   - getDealsByUser($user_id, $limit)
   - get_user_items($user_id, $limit)
*/
$submissions = [];
try {
  $uid  = (int)($userProfile['user_id'] ?? 0);
  $lim  = 50;

  if ($uid > 0) {
    if (function_exists('get_all_deals_by_user')) {
      $submissions = (array)get_all_deals_by_user($uid, $lim);
    } elseif (function_exists('getDealsByUser')) {
      $submissions = (array)getDealsByUser($uid, $lim);
    } elseif (function_exists('get_user_items')) {
      $submissions = (array)get_user_items($uid, $lim);
    } else {
      $submissions = []; // sem função, a view deve tolerar vazio
    }
  }
} catch (Throwable $e) {
  $submissions = [];
}

/* ========= Traduções (fallbacks) ========= */
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  'tr_240' => 'Minhas Submissões',
  'tr_241' => 'Minhas Lojas',
  'tr_242' => 'Assinatura',
  'tr_244' => 'Perfil',
];

/* ========= Render ========= */
require __DIR__ . '/header.php';
/* A view deve usar $submissions, $userTotalOUploaded, $userDetails, $userPlanSettings quando disponível */
require __DIR__ . '/views/submissions.view.php';
require __DIR__ . '/footer.php';
