<?php
// Vars esperadas: $orders, $counts
$orders = isset($orders) && is_array($orders) ? $orders : [];
$counts = isset($counts) && is_array($counts) ? $counts : [];

function nd_status_badge(string $status): array {
  $s = strtolower(trim($status));
  return match ($s) {
    'pending_payment'    => ['Pendente de pagamento', 'uk-label uk-label-warning'],
    'pending_activation' => ['Pendente de ativação', 'uk-label uk-label-warning'],
    'active'             => ['Ativo', 'uk-label uk-label-success'],
    'expired'            => ['Expirado', 'uk-label'],
    'canceled'           => ['Cancelado', 'uk-label uk-label-danger'],
    default              => [($status ?: '—'), 'uk-label'],
  };
}
?>
<?php require __DIR__ . '/../menu.php'; ?>

<div class="content-padder">
  <div class="uk-section-small uk-background-muted">
    <div class="uk-container uk-container-large">

      <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-medium-bottom">
        <div>
          <h2 class="uk-margin-remove">Add-ons</h2>
          <div class="uk-text-meta">Acompanhe seus destaques e exclusividades (status e validade).</div>
        </div>
        <div class="uk-visible@m">
          <a class="uk-button uk-button-primary uk-border-rounded" href="/pricing">Comprar / renovar</a>
        </div>
      </div>

      <?php if (!empty($counts['pending_payment'])): ?>
        <div class="uk-alert-warning" uk-alert>
          <p class="uk-margin-remove">
            Você tem <b><?php echo (int)$counts['pending_payment']; ?></b> add-on(s) com pagamento pendente.
            Assim que o pagamento for confirmado, eles ficam "pendente de ativação".
          </p>
        </div>
      <?php endif; ?>

      <?php if (!empty($counts['pending_activation'])): ?>
        <div class="uk-alert-primary" uk-alert>
          <p class="uk-margin-remove">
            Você tem <b><?php echo (int)$counts['pending_activation']; ?></b> add-on(s) "pendente de ativação".
            Em breve sua campanha entra no ar conforme o período contratado.
          </p>
        </div>
      <?php endif; ?>

      <div class="uk-grid-small uk-child-width-1-1 uk-child-width-1-3@m" uk-grid>
        <div>
          <div class="uk-card uk-card-default uk-card-body">
            <div class="uk-text-meta">Ativos</div>
            <div class="uk-text-large uk-text-bold"><?php echo (int)($counts['active'] ?? 0); ?></div>
          </div>
        </div>
        <div>
          <div class="uk-card uk-card-default uk-card-body">
            <div class="uk-text-meta">Pendente</div>
            <div class="uk-text-large uk-text-bold"><?php echo (int)(($counts['pending_payment'] ?? 0) + ($counts['pending_activation'] ?? 0)); ?></div>
          </div>
        </div>
        <div>
          <div class="uk-card uk-card-default uk-card-body">
            <div class="uk-text-meta">Expirados/Cancelados</div>
            <div class="uk-text-large uk-text-bold"><?php echo (int)(($counts['expired'] ?? 0) + ($counts['canceled'] ?? 0)); ?></div>
          </div>
        </div>
      </div>

      <div class="uk-card uk-card-default uk-card-body uk-margin-medium-top">
        <?php if (empty($orders)): ?>
          <div class="uk-text-muted">Nenhum add-on encontrado para sua conta ainda.</div>
        <?php else: ?>
          <div class="uk-overflow-auto">
            <table class="uk-table uk-table-divider uk-table-small">
              <thead>
                <tr>
                  <th>Add-on</th>
                  <th>Loja</th>
                  <th>Status</th>
                  <th>Período</th>
                  <th>Valor</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach ($orders as $o): ?>
                <?php
                  [$label, $cls] = nd_status_badge((string)($o['status'] ?? ''));
                  $p1 = (string)($o['start_date'] ?? '');
                  $p2 = (string)($o['end_date'] ?? '');
                  $period = '-';
                  if ($p1 !== '' || $p2 !== '') {
                    $period = ($p1 !== '' ? date('d/m/Y', strtotime($p1)) : '—') . ' → ' . ($p2 !== '' ? date('d/m/Y', strtotime($p2)) : '—');
                  }
                ?>
                <tr>
                  <td>
                    <div class="uk-text-bold"><?php echo htmlspecialchars((string)($o['addon_title'] ?? $o['addon_key'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></div>
                    <div class="uk-text-meta"><?php echo htmlspecialchars((string)($o['addon_key'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></div>
                  </td>
                  <td><?php echo htmlspecialchars((string)($o['store_title'] ?? '-'), ENT_QUOTES, 'UTF-8'); ?></td>
                  <td><span class="<?php echo $cls; ?>"><?php echo htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?></span></td>
                  <td><?php echo htmlspecialchars($period, ENT_QUOTES, 'UTF-8'); ?></td>
                  <td>R$ <?php echo number_format((float)($o['amount_total'] ?? 0), 2, ',', '.'); ?></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>

      <div class="uk-hidden@m uk-margin-top">
        <a class="uk-button uk-button-primary uk-width-1-1 uk-border-rounded" href="/pricing">Comprar / renovar</a>
      </div>

    </div>
  </div>
</div>
