<?php
// Guards de variáveis
$associate           = isset($associate) && is_array($associate) ? $associate : [];
$associateName       = (string)($associate['associate_name'] ?? '');
$associateCode       = (string)($associate['associate_code'] ?? '');
$totalClickToday     = isset($totalClicksToday)    ? (int)$totalClicksToday    : 0;
$totalClicksLast30   = isset($totalClicksLast30)   ? (int)$totalClicksLast30   : 0;
$totalClicksLast7    = isset($totalClicksLast7)    ? (int)$totalClicksLast7    : 0;
$totalClicks         = isset($totalClicks)         ? (int)$totalClicks         : 0;
$totalUniqueClicks   = isset($totalUniqueClicks)   ? (int)$totalUniqueClicks   : 0;
$chartLabels         = isset($chartLabels) && is_array($chartLabels) ? $chartLabels : [];
$chartValues         = isset($chartValues) && is_array($chartValues) ? $chartValues : [];
$qrText              = isset($qrText) ? (string)$qrText : '';
$qrImg               = isset($qrImg)  ? (string)$qrImg  : '';
$topAssociates       = isset($topAssociates) && is_array($topAssociates) ? $topAssociates : [];
$rankingMonthLabel   = isset($rankingMonthLabel) ? (string)$rankingMonthLabel : date('m/Y');
$lastClickAtBr       = isset($lastClickAtBr) ? (string)$lastClickAtBr : '';

// Helper de saída
if (!function_exists('echoOutput')) {
    function echoOutput($v){ echo htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
?>

<?php require __DIR__ . '/../menu.php'; ?>


<style>
  @media (max-width: 640px) {
    .nd-period-btn { margin-bottom: 4px; }
    .nd-summary-card-grid { margin-bottom: 10px; }
  }

  .nd-assoc-ranking-table { width:100%; border-collapse:collapse; font-size:13px; }
  .nd-assoc-ranking-table th,
  .nd-assoc-ranking-table td { padding:6px 8px; border-bottom:1px solid #eee; }
  .nd-assoc-ranking-table th { text-align:left; font-weight:600; color:#555; }
  .nd-assoc-ranking-table th:nth-child(1),
  .nd-assoc-ranking-table td:nth-child(1),
  .nd-assoc-ranking-table th:nth-child(3),
  .nd-assoc-ranking-table td:nth-child(3),
  .nd-assoc-ranking-table th:nth-child(4),
  .nd-assoc-ranking-table td:nth-child(4) { text-align:center; white-space:nowrap; }
  .nd-assoc-ranking-medal { font-size:16px; }
  .nd-assoc-ranking-highlight { background:#f5f9ff; }

</style>

<div class="content-padder">
  <div class="uk-section-small uk-background-muted">

    <div class="uk-container uk-container-large uk-margin-bottom">
      <h3 class="uk-heading-line">
        <span>
          Bem-vindo, <b><?php echo echoOutput($associateName); ?></b>!
        </span>
      </h3>
      <p class="uk-text-muted">
        Aqui você acompanha o desempenho do seu QR Code.
      </p>
      <p class="uk-text-emphasis uk-margin-small-top">
        Você recebeu <b><?php echo echoOutput($totalClicksLast7); ?></b> cliques nos últimos 7 dias.
      </p>
    </div>

    <div class="uk-section-small">
      <div class="uk-container uk-container-large">

        <!-- Cards de métricas principais -->
        <div uk-grid class="uk-grid-match uk-child-width-1-1 uk-child-width-1-2@s uk-child-width-1-2@m uk-child-width-1-4@xl nd-summary-card-grid">
          <div>
            <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
              <span class="statistics-text">Cliques hoje</span><br />
              <span class="statistics-number"><?php echo echoOutput($totalClickToday); ?></span>
            </div>
          </div>
          <div>
            <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
              <span class="statistics-text">Cliques nos últimos 30 dias</span><br />
              <span class="statistics-number"><?php echo echoOutput($totalClicksLast30); ?></span>
            </div>
          </div>
          <div>
            <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
              <span class="statistics-text">Todos os cliques</span><br />
              <span class="statistics-number"><?php echo echoOutput($totalClicks); ?></span>
            </div>
          </div>
          <div>
            <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
              <span class="statistics-text">Cliques únicos</span><br />
              <span class="statistics-number"><?php echo echoOutput($totalUniqueClicks); ?></span>
            </div>
          </div>
        </div>

        <!-- Cards de métricas avançadas -->
        <div class="uk-margin-top" uk-grid>
          <div class="uk-width-1-1 uk-width-1-3@m">
            <div class="uk-card uk-card-small uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
              <span class="statistics-text">Média de cliques (dias com registro)</span><br />
              <span class="statistics-number"><?php echo echoOutput(number_format($avgClicksLast30, 2, ',', '.')); ?></span>
            </div>
          </div>
          <div class="uk-width-1-1 uk-width-1-3@m">
            <div class="uk-card uk-card-small uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
              <span class="statistics-text">Melhor dia</span><br />
              <?php if ($bestDayLabel): ?>
                <span class="statistics-number"><?php echo echoOutput($bestDayValue); ?></span>
                <div class="uk-text-meta">em <?php echo echoOutput($bestDayLabel); ?></div>
              <?php else: ?>
                <span class="statistics-number">0</span>
              <?php endif; ?>
            </div>
          </div>
          <div class="uk-width-1-1 uk-width-1-3@m">
            <div class="uk-card uk-card-small uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
              <span class="statistics-text">Último clique</span><br />
              <?php if ($lastClickAtBr): ?>
                <span class="statistics-number"><?php echo echoOutput($lastClickAtBr); ?></span>
              <?php else: ?>
                <span class="statistics-number">-</span>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Gráfico + QRCode -->
        <div class="uk-grid-match" uk-grid>
          <div class="uk-width-1-1@s uk-width-expand@l">
            <div class="uk-card uk-card-default uk-border-rounded uk-card-bordered">
              <div class="uk-card-header">
                <div class="uk-flex uk-flex-middle uk-flex-between uk-flex-wrap nd-assoc-chart-header" uk-grid>
                  <div class="uk-width-expand">
                    Gráfico de cliques
                  </div>
                  <div class="uk-width-auto">
                    <div class="uk-button-group nd-assoc-chart-buttons">
                      <button class="uk-button uk-button-default uk-button-small nd-period-btn" data-period="7">7 dias</button>
                      <button class="uk-button uk-button-default uk-button-small nd-period-btn" data-period="30">30 dias</button>
                      <button class="uk-button uk-button-default uk-button-small nd-period-btn" data-period="90">90 dias</button>
                      <button class="uk-button uk-button-default uk-button-small nd-period-btn" data-period="all">Tudo</button>
                      <a class="uk-button uk-button-primary uk-button-small" href="associate_export_csv.php" target="_blank">
                        Exportar CSV
                      </a>
                    </div>
                  </div>
                </div>
              </div>
              <div class="uk-card-body">
                <?php if (!empty($chartLabels)): ?>
                  <canvas id="assocDashboardChart" height="160"></canvas>
                <?php else: ?>
                  <p class="uk-text-meta">Ainda não há cliques registrados no período analisado.</p>
                <?php endif; ?>
              </div>
            </div>
          </div>

          <div class="uk-width-1-1@s uk-width-1-3@l">
            <div class="uk-card uk-card-default uk-border-rounded uk-card-bordered">
              <div class="uk-card-header">
                <span>QR Code do associado</span>
              </div>
              <div class="uk-card-body uk-text-center">
                <?php if ($qrImg && $qrText): ?>
                  <div class="uk-margin-small">
                    <img src="<?php echo htmlspecialchars($qrImg, ENT_QUOTES, 'UTF-8'); ?>" alt="QR do associado" style="max-width:220px;">
                  </div>
                  <div class="uk-text-small uk-text-break">
                    <strong>URL do QR:</strong><br>
                    <code class="uk-text-break nd-assoc-qr-url">
                      <?php echo htmlspecialchars($qrText, ENT_QUOTES, 'UTF-8'); ?>
                    </code>
                  </div>
                  </div>
                <?php else: ?>
                  <p class="uk-text-meta">Não foi possível gerar o QR Code. Verifique se este associado possui um código cadastrado.</p>
                <?php endif; ?>
              </div>
            </div>
          </div>

        <div class="uk-width-1-1 uk-margin-top">
          <div class="uk-card uk-card-default uk-border-rounded uk-card-bordered">
            <div class="uk-card-header">
              <div class="uk-flex uk-flex-middle uk-flex-between">
                <span>Top 10 associados em cliques (mês atual)</span>
                <span class="uk-text-meta">Período: <?php echo echoOutput($rankingMonthLabel); ?></span>
              </div>
            </div>
            <div class="uk-card-body">
              <?php if (!empty($topAssociates)): ?>
                <div class="uk-overflow-auto">
                  <table class="uk-table uk-table-divider uk-table-small uk-margin-remove nd-assoc-ranking-table">
                    <thead>
                      <tr>
                        <th>#</th>
                        <th>Associado</th>
                        <th>Código</th>
                        <th>Cliques no mês</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $pos = 0; foreach ($topAssociates as $row): $pos++; ?>
                        <?php
                          $rowCode = isset($row['associate_code']) ? (string)$row['associate_code'] : '';
                          $rowName = isset($row['associate_name']) ? (string)$row['associate_name'] : '';
                          $rowTotal = isset($row['total_clicks_month']) ? (int)$row['total_clicks_month'] : 0;
                          $isMe = ($associateCode !== '' && $rowCode === $associateCode);
                        ?>
                        <tr class="<?php echo $isMe ? 'nd-assoc-ranking-highlight' : ''; ?>">
                          <td class="nd-assoc-ranking-medal">
                            <?php if ($pos === 1): ?>
                              🥇
                            <?php elseif ($pos === 2): ?>
                              🥈
                            <?php elseif ($pos === 3): ?>
                              🥉
                            <?php else: ?>
                              <?php echo (int)$pos; ?>
                            <?php endif; ?>
                          </td>
                          <td><?php echo echoOutput($rowName); ?></td>
                          <td class="uk-text-center"><?php echo echoOutput($rowCode); ?></td>
                          <td class="uk-text-center"><?php echo echoOutput($rowTotal); ?></td>
                        </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              <?php else: ?>
                <p class="uk-text-meta">Ainda não há dados de ranking para este mês.</p>
              <?php endif; ?>
            </div>
          </div>
        </div>
        </div>

      </div>
    </div>

  </div>
</div>

<?php if (!empty($chartLabels)): ?>
<script>
(function() {
  if (typeof Chart === 'undefined') return;
  var el = document.getElementById('assocDashboardChart');
  if (!el) return;

  var fullLabels = <?php echo json_encode(array_values($chartLabels)); ?>;
  var fullData   = <?php echo json_encode(array_values($chartValues)); ?>;
  if (!fullLabels.length) return;

  function sliceData(period) {
    if (period === 'all') {
      return { labels: fullLabels.slice(), data: fullData.slice() };
    }
    var n = parseInt(period, 10);
    if (!n || fullLabels.length <= n) {
      return { labels: fullLabels.slice(), data: fullData.slice() };
    }
    return {
      labels: fullLabels.slice(fullLabels.length - n),
      data:   fullData.slice(fullData.length - n)
    };
  }

  var initial = sliceData(30);
  var ctx = el.getContext('2d');
  var chart = new Chart(ctx, {
    type: 'line',
    data: {
      labels: initial.labels,
      datasets: [{
        label: 'Cliques por dia',
        data: initial.data,
        borderWidth: 2,
        fill: false,
        pointRadius: 3,
        tension: 0
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      scales: {
        x: { ticks: { autoSkip: true, maxTicksLimit: 10 } },
        y: { beginAtZero: true, ticks: { precision: 0 } }
      }
    }
  });

  // Controle de filtros
  var buttons = document.querySelectorAll('.nd-period-btn');
  buttons.forEach(function(btn) {
    btn.addEventListener('click', function(e) {
      e.preventDefault();
      var p = this.getAttribute('data-period') || 'all';
      var sliced = sliceData(p);
      chart.data.labels = sliced.labels;
      chart.data.datasets[0].data = sliced.data;
      chart.update();

      buttons.forEach(function(b){ b.classList.remove('uk-button-primary'); });
      this.classList.add('uk-button-primary');
    });
  });

})();
</script>
<?php endif; ?>
