<?php include $_SERVER['DOCUMENT_ROOT'] . '/partials/lang-switch.php'; ?>
<?php
// Traduções básicas para o login do associado
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
    'assoc_login_title'       => $translation['assoc_login_title']       ?? 'Login do associado',
    'assoc_login_code_label'  => $translation['assoc_login_code_label']  ?? 'Código do associado',
    'assoc_login_submit'      => $translation['assoc_login_submit']      ?? 'Entrar',
    'tr_47'                   => $translation['tr_47']                   ?? 'Voltar ao site',
];

// Helper de saída
if (!function_exists('echoOutput')) {
    function echoOutput($v){ echo htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}
?>
<div class="uk-height-1-1">
  <div class="uk-flex uk-flex-middle uk-flex-center" uk-height-viewport>
    <div class="uk-width-1-1 uk-width-1-3@m">
      <div class="uk-card uk-card-default uk-border-rounded uk-card-hover">
        <div class="uk-card-header">
          <?php echo echoOutput($translation['assoc_login_title']); ?>
        </div>
        <div class="uk-card-body">
          <center>
            <a href="<?php echo $urlPath->dashboard(); ?>">
              <img class="uk-logo-small" src="<?php echo $urlPath->image($theme['th_logo']); ?>" alt="Logo">
            </a>
            <br />
          </center>

          <?php if (!empty($errors)): ?>
            <?php foreach ($errors as $err): ?>
              <div class="uk-alert-danger" uk-alert>
                <p class="uk-margin-remove"><?php echo htmlspecialchars((string)$err, ENT_QUOTES, 'UTF-8'); ?></p>
              </div>
            <?php endforeach; ?>
          <?php endif; ?>

          <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">
            <fieldset class="uk-fieldset">

              <div class="uk-margin">
                <div class="uk-position-relative">
                  <span class="uk-form-icon" uk-icon="key"></span>
                  <input name="associate_code" class="uk-input uk-border-rounded" type="text"
                         placeholder="<?php echo echoOutput($translation['assoc_login_code_label']); ?>" required>
                </div>
              </div>

              <div class="uk-margin">
                <button type="submit" class="uk-button uk-button-primary uk-border-rounded uk-width-1-1">
                  <?php echo echoOutput($translation['assoc_login_submit']); ?>
                </button>
              </div>

              <div class="uk-margin-small uk-text-center">
                <a href="/associate_register.php" class="uk-button uk-button-primary uk-border-rounded uk-margin-small-right">
                  Quero ser associado
                </a>
                <a href="<?php echo $urlPath->home(); ?>" class="uk-button uk-button-default uk-border-rounded">
                  &larr; <?php echo echoOutput($translation['tr_47']); ?>
                </a>
              </div>

            </fieldset>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
