<?php
// View: Meus Dados do Associado

// Sempre garantimos que $associate seja carregado do banco aqui na view,
// usando o ID do associado guardado em sessão. Isso evita qualquer conflito
// com outros includes que possam ter sobrescrito a variável.
if (session_status() !== PHP_SESSION_ACTIVE) {
    @session_start();
}

$associate = [];

$assocIdFromSession = isset($_SESSION['associate_id']) ? (int)$_SESSION['associate_id'] : 0;
if ($assocIdFromSession > 0 && function_exists('connect')) {
    try {
        $pdo = connect();
        if ($pdo instanceof PDO) {
            $stmt = $pdo->prepare('SELECT * FROM associates WHERE associate_id = :id LIMIT 1');
            $stmt->execute([':id' => $assocIdFromSession]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            if (is_array($row)) {
                $associate = $row;
            }
        }
    } catch (Throwable $e) {
        // Em caso de erro, $associate permanece como array vazio
    }
}

$errors        = isset($errors) && is_array($errors) ? $errors : [];
$success       = isset($success) ? (string)$success : '';
$assocName   = (string)($associate['associate_name']  ?? '');
$assocEmail  = (string)($associate['associate_email'] ?? '');
$assocPhone  = (string)($associate['associate_phone'] ?? '');
$assocCity   = (string)($associate['associate_city']  ?? '');
$assocState  = (string)($associate['associate_state'] ?? '');
$assocGroup  = (string)($associate['associate_group'] ?? '');
$assocCode   = (string)($associate['associate_code']  ?? '');
if ($assocCode === '') {
    $assocCode = 'Ainda não gerado';
}

// Garante que helpers básicos existem
if (!function_exists('echoOutput')) {
  function echoOutput($v){ echo htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

?>

<?php require __DIR__ . '/../menu.php'; ?>

<div class="content-padder uk-background-muted">

  <div class="uk-section-small">
    <div class="uk-container uk-container-large">

      <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered uk-margin-bottom">
        <h3 class="uk-heading-line uk-text-bold">
          <span>Meus Dados</span>
        </h3>
        <p class="uk-text-meta">Atualize seus dados pessoais e a foto que aparece no painel.</p>

        <?php if ($success): ?>
          <div class="uk-alert-success" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <p><?php echo echoOutput($success); ?></p>
          </div>
        <?php endif; ?>

        <?php if ($errors): ?>
          <div class="uk-alert-danger" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <ul class="uk-margin-small-left">
              <?php foreach ($errors as $e): ?>
                <li><?php echo echoOutput($e); ?></li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>

        <form class="uk-form-stacked" method="post" enctype="multipart/form-data">

          <div class="uk-grid-small" uk-grid>
            <div class="uk-width-1-1 uk-width-1-2@s">
              <div class="uk-margin">
                <label class="uk-form-label">Nome</label>
                <div class="uk-form-controls">
                  <input class="uk-input" type="text" name="associate_name" required
                         value="<?php echo echoOutput($associate['associate_name'] ?? ''); ?>">
                </div>
              </div>
            </div>

            <div class="uk-width-1-1 uk-width-1-2@s">
              <div class="uk-margin">
                <label class="uk-form-label">E-mail</label>
                <div class="uk-form-controls">
                  <input class="uk-input" type="email" name="associate_email"
                         value="<?php echo echoOutput($associate['associate_email'] ?? ''); ?>">
                </div>
              </div>
            </div>

            <div class="uk-width-1-1 uk-width-1-3@s">
              <div class="uk-margin">
                <label class="uk-form-label">Telefone</label>
                <div class="uk-form-controls">
                  <input class="uk-input" type="tel" name="associate_phone" id="associate_phone"
                         inputmode="tel" placeholder="(00) 00000-0000"
                         value="<?php echo echoOutput($associate['associate_phone'] ?? ''); ?>">
                </div>
              </div>
            </div>

            <div class="uk-width-1-1 uk-width-1-3@s">
              <div class="uk-margin">
                <label class="uk-form-label">Cidade</label>
                <div class="uk-form-controls">
                  <input class="uk-input" type="text" name="associate_city"
                         value="<?php echo echoOutput($associate['associate_city'] ?? ''); ?>">
                </div>
              </div>
            </div>

            <div class="uk-width-1-1 uk-width-1-3@s">
              <div class="uk-margin">
                <label class="uk-form-label">UF</label>
                <div class="uk-form-controls">
                  <input class="uk-input" type="text" name="associate_state" maxlength="2"
                         value="<?php echo echoOutput($associate['associate_state'] ?? ''); ?>">
                </div>
              </div>
            </div>

            <div class="uk-width-1-1 uk-width-1-3@s">
              <div class="uk-margin">
                <label class="uk-form-label">Grupo</label>
                <div class="uk-form-controls">
                  <select class="uk-select" name="associate_group">
                    <?php $g = $associate['associate_group'] ?? ''; ?>
                    <option value="">Selecione...</option>
                    <option value="Uber"        <?php echo ($g === 'Uber')        ? 'selected' : ''; ?>>Uber</option>
                    <option value="99"          <?php echo ($g === '99')          ? 'selected' : ''; ?>>99</option>
                    <option value="Taxi"        <?php echo ($g === 'Taxi')        ? 'selected' : ''; ?>>Taxi</option>
                    <option value="Van Turismo" <?php echo ($g === 'Van Turismo') ? 'selected' : ''; ?>>Van Turismo</option>
                    <option value="Motoboy"     <?php echo ($g === 'Motoboy')     ? 'selected' : ''; ?>>Motoboy</option>
                    <option value="Carteiro"    <?php echo ($g === 'Carteiro')    ? 'selected' : ''; ?>>Carteiro</option>
                    <option value="Outros"      <?php echo ($g === 'Outros')      ? 'selected' : ''; ?>>Outros</option>
                  </select>
                </div>
              </div>
            </div>

            <div class="uk-width-1-1 uk-width-1-3@s">
              <div class="uk-margin">
                <label class="uk-form-label">Código do associado</label>
                <div class="uk-form-controls">
                  <input class="uk-input" type="text" value="<?php echo echoOutput($assocCode); ?>" disabled>
                </div>
              </div>
            </div>

            <div class="uk-width-1-1 uk-width-1-3@s">
              <div class="uk-margin">
                <label class="uk-form-label">Foto (avatar)</label>
                <div class="uk-form-controls">
                  <input class="uk-input" type="file" name="associate_avatar" accept="image/*">
                  <small class="uk-text-meta">Formatos aceitos: JPG ou PNG.</small>
                </div>
              </div>
            </div>

          </div>

          <div class="uk-margin-top">
            <button class="uk-button uk-button-primary uk-border-rounded" type="submit">
              Salvar alterações
            </button>
          </div>

        </form>

      </div>

    </div>
  </div>

</div>

<script>
(function() {
  var input = document.getElementById('associate_phone');
  if (!input) return;

  function maskPhone(value) {
    value = value.replace(/\D/g, '');
    if (value.length > 11) value = value.slice(0, 11);

    if (value.length <= 10) {
      // (99) 9999-9999
      value = value.replace(/(\d{2})(\d{0,4})(\d{0,4})/, function(match, ddd, p1, p2) {
        var out = '';
        if (ddd) out = '(' + ddd + ')';
        if (p1) out += ' ' + p1;
        if (p2) out += '-' + p2;
        return out;
      });
    } else {
      // (99) 99999-9999
      value = value.replace(/(\d{2})(\d{0,5})(\d{0,4})/, function(match, ddd, p1, p2) {
        var out = '';
        if (ddd) out = '(' + ddd + ')';
        if (p1) out += ' ' + p1;
        if (p2) out += '-' + p2;
        return out;
      });
    }
    return value;
  }

  function onInput(e) {
    var start = input.selectionStart;
    var end   = input.selectionEnd;
    var oldLength = input.value.length;

    input.value = maskPhone(input.value);

    var newLength = input.value.length;
    var diff = newLength - oldLength;
    input.setSelectionRange(start + diff, end + diff);
  }

  input.addEventListener('input', onInput);
  // aplica máscara no load se já tiver valor
  if (input.value) {
    input.value = maskPhone(input.value);
  }
})();
</script>