<?php
// View: Meus Cupons (dashboard)
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  'nd_coupons_title'        => 'Meus Cupons',
  'nd_coupons_new'          => 'Criar novo cupom',
  'nd_coupons_deal'         => 'Oferta',
  'nd_coupons_coupon_title' => 'Título do cupom',
  'nd_coupons_coupon_code'  => 'Código do cupom',
  'nd_coupons_discount'     => 'Desconto (%)',
  'nd_coupons_quantity'     => 'Quantidade (opcional)',
  'nd_coupons_save'         => 'Salvar cupom',
  'nd_coupons_list'         => 'Cupons cadastrados',
];
$titlePage   = $translation['nd_coupons_title'] ?? 'Meus Cupons';
?>
<?php require 'menu.php'; ?>

<div class="content-padder">
  <div class="uk-section-small">
    <div class="uk-container uk-margin-top uk-margin-bottom">
  <div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-1">
      <h2 class="uk-heading-line"><span><?php echo htmlspecialchars($titlePage, ENT_QUOTES, 'UTF-8'); ?></span></h2>
    </div>
  </div>

  <?php if (!empty($success)): ?>
    <div class="uk-alert-success" uk-alert>
      <p>Cupom criado com sucesso.</p>
    </div>
  <?php endif; ?>

  <?php if (!empty($errors) && is_array($errors)): ?>
    <div class="uk-alert-danger" uk-alert>
      <ul class="uk-list uk-list-bullet uk-margin-remove">
        <?php foreach ($errors as $err): ?>
          <li><?php echo htmlspecialchars((string)$err, ENT_QUOTES, 'UTF-8'); ?></li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <div class="uk-grid-medium" uk-grid>
    <div class="uk-width-1-1 uk-width-1-2@m">
      <div class="uk-card uk-card-default uk-card-body">
        <h3 class="uk-card-title"><?php echo htmlspecialchars($translation['nd_coupons_new'] ?? 'Criar novo cupom', ENT_QUOTES, 'UTF-8'); ?></h3>

        <form method="post" class="uk-form-stacked">
          <input type="hidden" name="action" value="create_coupon">

          <div class="uk-margin">
            <label class="uk-form-label"><?php echo htmlspecialchars($translation['nd_coupons_deal'] ?? 'Oferta', ENT_QUOTES, 'UTF-8'); ?></label>
            <div class="uk-form-controls">
              <select class="uk-select" name="deal_id" required>
                <option value="">Selecione uma oferta</option>
                <?php foreach ((array)$deals as $d): ?>
                  <option value="<?php echo (int)($d['deal_id'] ?? 0); ?>">
                    <?php echo htmlspecialchars($d['deal_title'] ?? ('#'.($d['deal_id'] ?? '')), ENT_QUOTES, 'UTF-8'); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>

          <div class="uk-margin">
            <label class="uk-form-label"><?php echo htmlspecialchars($translation['nd_coupons_coupon_title'] ?? 'Título do cupom', ENT_QUOTES, 'UTF-8'); ?></label>
            <div class="uk-form-controls">
              <input class="uk-input" type="text" name="coupon_title" required>
            </div>
          </div>

          <div class="uk-margin">
            <label class="uk-form-label"><?php echo htmlspecialchars($translation['nd_coupons_coupon_code'] ?? 'Código do cupom', ENT_QUOTES, 'UTF-8'); ?></label>
            <div class="uk-form-controls">
              <input class="uk-input" type="text" name="coupon_code" required>
            </div>
          </div>

          <div class="uk-margin">
            <label class="uk-form-label"><?php echo htmlspecialchars($translation['nd_coupons_discount'] ?? 'Desconto (%)', ENT_QUOTES, 'UTF-8'); ?></label>
            <div class="uk-form-controls">
              <input class="uk-input" type="number" name="discount_percent" min="1" max="100" required>
            </div>
          </div>

          <div class="uk-margin">
            <label class="uk-form-label"><?php echo htmlspecialchars($translation['nd_coupons_quantity'] ?? 'Quantidade (opcional)', ENT_QUOTES, 'UTF-8'); ?></label>
            <div class="uk-form-controls">
              <input class="uk-input" type="number" name="quantity" min="0" placeholder="Em branco = ilimitado">
            </div>
          </div>

          <div class="uk-margin">
            <button class="uk-button uk-button-primary" type="submit">
              <?php echo htmlspecialchars($translation['nd_coupons_save'] ?? 'Salvar cupom', ENT_QUOTES, 'UTF-8'); ?>
            </button>
          </div>

        </form>
      </div>
    </div>

    <div class="uk-width-1-1 uk-width-1-2@m">
      <div class="uk-card uk-card-default uk-card-body">
        <h3 class="uk-card-title"><?php echo htmlspecialchars($translation['nd_coupons_list'] ?? 'Cupons cadastrados', ENT_QUOTES, 'UTF-8'); ?></h3>

        
        <?php if (!empty($dealSummary)): ?>
          <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-margin-small-top">
            <h4 class="uk-text-bold uk-margin-small-bottom">Resumo de conversão por oferta</h4>
            <p class="uk-text-meta uk-margin-small-top">
              Conversão estimada baseada em <strong>usos registrados</strong> / <strong>quantidade total definida</strong>.
              Quando houver cupons sem quantidade definida, a conversão aparece como “—”.
            </p>

            <div class="uk-overflow-auto">
              <table class="uk-table uk-table-divider uk-table-small">
                <thead>
                  <tr>
                    <th>Oferta</th>
                    <th class="uk-text-center">Cupons</th>
                    <th class="uk-text-center">Qtd. total</th>
                    <th class="uk-text-center">Usos</th>
                    <th class="uk-text-center">Conversão</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($dealSummary as $ds): ?>
                    <?php
                      $couponsCount   = (int) ($ds['coupons_count'] ?? 0);
                      $qtyTotal       = (int) ($ds['total_quantity'] ?? 0);
                      $unlimitedCount = (int) ($ds['unlimited_count'] ?? 0);
                      $usedTotal      = (int) ($ds['total_used'] ?? 0);

                      if ($unlimitedCount > 0) {
                        $qtyLabel = '&infin;';
                      } elseif ($qtyTotal > 0) {
                        $qtyLabel = (string) $qtyTotal;
                      } else {
                        $qtyLabel = '—';
                      }

                      $convLabel = '—';
                      if ($qtyTotal > 0 && $unlimitedCount === 0) {
                        $conv = round(($usedTotal / max(1, $qtyTotal)) * 100, 1);
                        $convLabel = $conv . '%';
                      }
                    ?>
                    <tr>
                      <td><?php echo htmlspecialchars($ds['deal_title'] ?? ('Oferta #' . (int)($ds['deal_id'] ?? 0)), ENT_QUOTES, 'UTF-8'); ?></td>
                      <td class="uk-text-center"><?php echo $couponsCount; ?></td>
                      <td class="uk-text-center"><?php echo $qtyLabel; ?></td>
                      <td class="uk-text-center"><?php echo $usedTotal; ?></td>
                      <td class="uk-text-center"><strong><?php echo $convLabel; ?></strong></td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        <?php endif; ?>

<?php if (empty($coupons)): ?>
          <p class="uk-text-meta">Nenhum cupom cadastrado ainda.</p>
        <?php else: ?>
          <table class="uk-table uk-table-divider uk-table-small uk-table-middle">
            <thead>
              <tr>
                <th>Oferta</th>
                <th>Código</th>
                <th>Desconto</th>
                <th>Usos</th>
                <th>Qtd.</th>
                <th>Ações</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($coupons as $cp): ?>
                <tr>
                  <td><?php echo htmlspecialchars($cp['deal_title'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                  <td><code><?php echo htmlspecialchars($cp['coupon_code'] ?? '', ENT_QUOTES, 'UTF-8'); ?></code></td>
                  <td><?php echo (int)($cp['discount_percent'] ?? 0); ?>%</td>
                  <td>
                    <?php echo isset($cp['times_used']) ? (int)$cp['times_used'] : 0; ?>
                  </td>
                  <td>
                    <?php
                      if (!isset($cp['quantity']) || $cp['quantity'] === '' || $cp['quantity'] === null) {
                        echo '&infin;';
                      } else {
                        echo (int)$cp['quantity'];
                      }
                    ?>
                  </td>
                  <td>
                    <button type="button"
                            class="uk-button uk-button-default uk-button-small nd-use-coupon"
                            data-deal-id="<?php echo (int)($cp['deal_id'] ?? 0); ?>"
                            data-code="<?php echo htmlspecialchars($cp['coupon_code'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                            data-title="<?php echo htmlspecialchars($cp['coupon_title'] ?? ($cp['coupon_code'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
                      Marcar como usado
                    </button>
                  </td>

                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

  </div>
</div>


<script>
(function(){
  function bindUseButtons(){
    var btns = document.querySelectorAll('.nd-use-coupon');
    if (!btns || !btns.length) return;

    btns.forEach(function(btn){
      if (btn.__ndBound) return;
      btn.__ndBound = true;

      btn.addEventListener('click', function(){
        try {
          var dealId = btn.getAttribute('data-deal-id') || '';
          var code   = btn.getAttribute('data-code') || '';
          var title  = btn.getAttribute('data-title') || '';

          if (!dealId || !code) {
            alert('Cupom inválido.');
            return;
          }

          if (!confirm('Confirmar uso do cupom ' + code + '?')) {
            return;
          }

          var body = new URLSearchParams();
          body.set('deal_id', dealId);
          body.set('coupon_code', code);
          if (title) body.set('coupon_title', title);

          fetch('./use_coupon_ajax.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
            credentials: 'same-origin',
            body: body.toString()
          })
          .then(function(r){ return r.json().catch(function(){ return {}; }); })
          .then(function(data){
            if (data && data.ok) {
              btn.classList.add('uk-button-primary');
              btn.textContent = 'Cupom utilizado';
              btn.disabled = true;
            } else {
              alert('Não foi possível registrar o uso do cupom.');
            }
          })
          .catch(function(){
            alert('Falha de conexão ao registrar o uso do cupom.');
          });

        } catch(e){
          alert('Erro inesperado ao registrar uso do cupom.');
        }
      });
    });
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', bindUseButtons);
  } else {
    bindUseButtons();
  }
})();
</script>
