<?php
require 'menu.php';

/* Helper de tradução com fallback seguro */
if (!function_exists('__t')) {
  function __t(string $key, string $default = ''): string {
    $table = $GLOBALS['translation'] ?? [];
    return (isset($table[$key]) && $table[$key] !== '')
      ? (string)$table[$key]
      : ($default !== '' ? $default : $key);
  }
}
?>

<div class="content-padder">
  <div class="uk-container uk-container-large uk-padding">

    <h4><b><?php echo echoOutput(__t('tr_390', 'Acesso negado')); ?></b></h4>

    <hr>

    <h4 class="uk-margin-remove">
      <?php echo echoOutput(__t('tr_391', 'Você não tem permissão para acessar esta área.')); ?>
    </h4>

    <p>
      <?php echo echoOutput(__t('tr_392', 'Para continuar, atualize seu plano ou solicite acesso.')); ?>
    </p>

    <a href="<?php echo $urlPath->pricing(); ?>"
       class="uk-button uk-button-secondary uk-border-rounded"
       target="_blank">
      <?php echo echoOutput(__t('tr_393', 'Ver planos')); ?>
    </a>

  </div>
</div>
