<?php
declare(strict_types=1);

/**
 * View de <head> do Dashboard
 * - Usa $translation e força locale pt-BR (se for o caso)
 * - Não imprime nada antes do DOCTYPE!
 */

$translation = (isset($translation) && is_array($translation)) ? $translation : [];

if (!function_exists('tr')) {
  function tr(string $k, string $default = ''): string {
    $t = $GLOBALS['translation'] ?? [];
    $v = isset($t[$k]) && $t[$k] !== '' ? (string)$t[$k] : $default;
    return htmlspecialchars($v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}

$langDir    = isset($langDir) ? $langDir : 'ltr';
$siteLocale = isset($siteLocale) ? $siteLocale : 'pt-BR';

$urlPath = isset($urlPath) ? $urlPath : null;
$theme   = isset($theme) && is_array($theme) ? $theme : [];

$favicon = '';
if ($urlPath && is_object($urlPath) && method_exists($urlPath, 'image')) {
  $fav = $theme['th_favicon'] ?? 'favicon.png';
  $favicon = $urlPath->image($fav);
}

$title = tr('tr_231', 'Dashboard');

?>
<!DOCTYPE html>
<html lang="<?php echo htmlspecialchars($siteLocale, ENT_QUOTES, 'UTF-8'); ?>" dir="<?php echo htmlspecialchars($langDir, ENT_QUOTES, 'UTF-8'); ?>" <?php echo (isset($fullHeight) ? 'class="uk-height-1-1"' : ''); ?>>
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <?php if ($favicon): ?>
    <link rel="icon" href="<?php echo htmlspecialchars($favicon, ENT_QUOTES, 'UTF-8'); ?>">
  <?php endif; ?>

  <title><?php echo $title; ?></title>

  <!-- CSS base -->
  <link rel="stylesheet" href="./assets/css/uikit.min.css">
  <link rel="stylesheet" href="./assets/css/flag-icons.min.css">
  <link rel="stylesheet" href="./assets/css/style.css">
  <link rel="stylesheet" href="./assets/css/sweetalert.css">
  <link rel="stylesheet" href="./assets/css/font/font-fileuploader.css">
  <link rel="stylesheet" href="./assets/css/jquery.fileuploader.min.css">

  <!-- JS base -->
  <script src="./assets/js/jquery.min.js"></script>
  <script src="./assets/js/uikit.min.js"></script>
  <script src="./assets/js/uikit-icons.min.js"></script>
  <script src="./assets/js/chart.min.js"></script>
  <script src="./assets/js/fileuploader.min.js"></script>

  <!-- reCAPTCHA se for utilizado em alguma página -->
  <script async src="https://www.google.com/recaptcha/api.js"></script>

  <!-- DataTables em PT-BR (sem depender de internet, se você tiver o arquivo local) -->
  <script>
    // Se você tiver o arquivo local (recomendado):
    // const DT_LANG_URL = "<?php echo (defined('SITE_URL') ? SITE_URL : ''); ?>/assets/js/datatables.i18n.pt-BR.json";

    // Caso não tenha, usa objeto inline:
    window.DT_LANG_PTBR = {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Buscar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    };

    // Quando DataTables for carregado em alguma página, você pode fazer:
    // $.extend(true, $.fn.dataTable.defaults, { language: window.DT_LANG_PTBR });
  </script>

  <script>
    // Variáveis globais JS usadas pelo dashboard
    (function(){
      var SITEURL = "<?php echo defined('SITE_URL') ? SITE_URL : ''; ?>";
      var IMAGES_FOLDER = "<?php
        if ($urlPath && is_object($urlPath) && method_exists($urlPath, 'image')) {
          echo htmlspecialchars(rtrim($urlPath->image(''), '/').'/',
            ENT_QUOTES, 'UTF-8');
        } else {
          echo '/images/';
        }
      ?>";
      window.SITEURL = SITEURL;
      window.IMAGES_FOLDER = IMAGES_FOLDER;

      // Strings em pt-BR
      window.ST = {
        AREYOUSUREDELETE  : "<?php echo tr('tr_313', 'Tem certeza que deseja excluir?'); ?>",
        AREYOUSUREDISABLE : "<?php echo tr('tr_317', 'Tem certeza que deseja desativar?'); ?>",
        AREYOUSUREENABLE  : "<?php echo tr('tr_319', 'Tem certeza que deseja ativar?'); ?>",
        YOUWILLNOT        : "<?php echo tr('tr_314', 'Esta ação não poderá ser desfeita.'); ?>",
        YESDELETE         : "<?php echo tr('tr_316', 'Sim, excluir'); ?>",
        YESDISABLE        : "<?php echo tr('tr_318', 'Sim, desativar'); ?>",
        YESENABLE         : "<?php echo tr('tr_320', 'Sim, ativar'); ?>",
        CANCELBUTTONALERT : "<?php echo tr('tr_315', 'Cancelar'); ?>",
        CONFIRMCANCEL     : "<?php echo tr('tr_425', 'Confirmar cancelamento'); ?>",
        AREYOUSURECANCEL  : "<?php echo tr('tr_426', 'Tem certeza que deseja cancelar?'); ?>",
        YESCANCEL         : "<?php echo tr('tr_427', 'Sim, cancelar'); ?>",
        CANCELBUTTON      : "<?php echo tr('tr_428', 'Voltar'); ?>",
        PAYCOMPLETED      : "<?php echo tr('tr_429', 'Pagamento concluído'); ?>",
        PAYUNKNOWN        : "<?php echo tr('tr_430', 'Status desconhecido'); ?>",
        ALLCLICKS         : "<?php echo tr('tr_235', 'Todos os cliques'); ?>",
        UNIQUECLICKS      : "<?php echo tr('tr_236', 'Cliques únicos'); ?>"
      };
    })();
  </script>
  <script src="/assets/js/nd-geolocation.js"></script>
</head>
<body class="uk-background-muted">
    <script>
  // aplica idioma padrão para todas as DataTables
  if (window.DT_LANG_PTBR && jQuery && jQuery.fn && jQuery.fn.dataTable) {
    jQuery.extend(true, jQuery.fn.dataTable.defaults, {
      language: window.DT_LANG_PTBR
    });
  }
</script>

