<?php include $_SERVER['DOCUMENT_ROOT'] . '/partials/lang-switch.php'; ?>
<?php
// Guards simples de tradução para evitar Undefined array key
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  'tr_144' => $translation['tr_144'] ?? 'Login',
  'tr_145' => $translation['tr_145'] ?? 'E-mail',
  'tr_146' => $translation['tr_146'] ?? 'Senha',
  'tr_147' => $translation['tr_147'] ?? 'Esqueceu a senha?',
  'tr_148' => $translation['tr_148'] ?? 'Lembrar-me',
  'tr_149' => $translation['tr_149'] ?? 'Criar conta de anunciante',
  'tr_150' => $translation['tr_150'] ?? 'Entrar',
  'tr_47'  => $translation['tr_47']  ?? 'Voltar ao site',
];
?>
<div class="uk-height-1-1">
            <div class="uk-section-large">
                <div class="uk-container uk-container-large">
                    <div uk-grid class="uk-child-width-1-1@s uk-child-width-2-3@l">
                        <div class="uk-width-1-1@s uk-width-1-5@l uk-width-1-3@xl"></div>
                        <div class="uk-width-1-1@s uk-width-3-5@l uk-width-1-3@xl">
                            <div class="uk-card uk-card-default uk-border-rounded uk-card-bordered">
                                <div class="uk-card-header">
                                <?php
echo echoOutput($translation['tr_144']); ?>
                                </div>
                                <div class="uk-card-body">
                                <center>
                                        <a href="<?php echo $urlPath->dashboard(); ?>">
                                        <img class="uk-logo-small" src="<?php echo $urlPath->image($theme['th_logo']); ?>">
                                        </a>
                                        <br />
                                    </center>
                                    
                                    <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" id="submit-form" method="post">  

                                    <fieldset class="uk-fieldset">

                                            <div class="uk-margin">
                                                <div class="uk-position-relative">
                                                    <span class="uk-form-icon" uk-icon="user"></span>
                                                    <input name="user_email" class="uk-input uk-border-rounded" type="email" placeholder="<?php echo echoOutput($translation['tr_145']); ?>" required="">
                                                </div>
                                            </div>

                                            <div class="uk-margin">
                                                <div class="uk-position-relative">
                                                    <span class="uk-form-icon" uk-icon="lock"></span>
                                                    <input name="user_password" class="uk-input uk-border-rounded" type="password" placeholder="<?php echo echoOutput($translation['tr_146']); ?>" required="">
                                                </div>
                                            </div>

                                            <div class="uk-margin uk-flex uk-flex-middle uk-flex-left uk-flex-wrap">
    <label class="uk-flex uk-flex-middle" style="gap:6px;">
        <input class="uk-checkbox" type="checkbox" name="remember" value="1">
        <span><?php echo echoOutput($translation['tr_148']); ?></span>
    </label>
</div>

                                            <div class="uk-margin">
                                            <button class="uk-button uk-button-primary uk-border-rounded" type="submit" data-sitekey="<?php echo echoOutput($siteKey); ?>">
                                            <span uk-icon="sign-in"></span>&nbsp; <?php echo echoOutput($translation['tr_150']); ?>
                                            </button>
                                            </div>

                                                <?php if(!empty($errors)): ?>
                                                <div class="uk-width-1-1 uk-text-left">
                                                <div class="uk-margin">
                                                <div class="uk-alert-danger uk-padding-small uk-text-small uk-border-rounded uk-margin-remove">
                                                <ul class="uk-margin-remove">
                                                <?php foreach($errors as $key => $value):?>
                                                <li><?php echo echoOutput($value); ?></li>
                                                <?php endforeach; ?>
                                                </ul>
                                                </div>
                                                </div>
                                                </div>
                                                <?php endif; ?>

                                            <hr />

<center>
    <a href="<?php echo $urlPath->forgot(); ?>" class="uk-button uk-button-default uk-border-rounded uk-margin-small-bottom">
        <?php echo echoOutput($translation['tr_147']); ?>
    </a>
    <br />
    <a href="register.php" class="uk-button uk-button-default uk-border-rounded nd-create-account-btn">
        <span uk-icon="arrow-right"></span>&nbsp; <?php echo echoOutput($translation['tr_149']); ?>
    </a>
</center>
                                            
                                        </fieldset>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="uk-width-1-1@s uk-width-1-5@l uk-width-1-3@xl"></div>
                    </div>
                </div>

                <div class="uk-container uk-margin-medium-top">
    <div uk-grid>
        <div class="uk-width-1-1 uk-text-center">
            <a href="<?php echo $urlPath->home(); ?>" class="uk-button uk-button-default uk-border-rounded">
                <?php echo echoOutput($translation['tr_47']); ?>
            </a>
        </div>
    </div>
</div>
                
            </div>
        </div>