<?php
// Guards de i18n para evitar "Undefined array key"
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  'tr_242' => 'Assinatura',
  'tr_408' => 'Plano atual',
  'tr_409' => 'Status',
  'tr_410' => 'Ativa',
  'tr_411' => 'Expirada',
  'tr_413' => 'Data de expiração',
  'tr_414' => 'Valor',
  'tr_415' => 'Você ainda não possui um plano ativo.',
  'tr_416' => 'Pagamentos',
  'tr_417' => 'Plano',
  'tr_418' => 'Data',
  'tr_419' => 'Total',
  'tr_420' => 'Moeda',
  'tr_421' => 'Status',
  'tr_422' => 'Ação',
  'tr_423' => 'Alterar plano',
  'tr_424' => 'Cancelar assinatura',
  'tr_448' => 'Sem assinatura',
  'tr_449' => 'Assinar agora',
  'tr_450' => 'Plano manual ativo',
  'tr_451' => 'Plano manual expirado',
];

require 'menu.php'; ?>

<div class="content-padder uk-background-muted">

  <div class="uk-section-small">
    <div class="uk-container uk-container-large">  

      <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">

        <h3 class="uk-heading-line uk-text-bold">
          <span><?php echo echoOutput($translation['tr_242']); ?></span>
        </h3>

        <?php if (!empty($userPlan)): ?>

          <div class="uk-grid-small" uk-grid>

            <div class="uk-width-1-expand uk-width-1-4@s">
              <h4 class="uk-margin-remove"><?php echo echoOutput($translation['tr_408']); ?></h4>
              <h3 class="uk-margin-remove"><?php echo echoOutput($userPlan['plan_title']); ?></h3>

              <div class="uk-margin-top" uk-margin>
                <?php if (!empty($userPlan['user_payment_subscription_id']) && !isset($userPlan['user_plan_canceled_date'])): ?>
                  <a class="uk-flex uk-flex-middle uk-link-text" href="<?php echo $urlPath->pricing(); ?>">
                    <span class="uk-margin-small-right" uk-icon="icon: refresh; ratio: 0.8"></span>
                    <?php echo echoOutput($translation['tr_423']); ?>
                  </a>

                  <a class="uk-flex uk-flex-middle uk-text-danger cancelSubscription"
                     data-url="cancel_subscription.php"
                     data-url="canceled.php">
                    <span class="uk-margin-small-right" uk-icon="icon: ban; ratio: 0.8"></span>
                    <?php echo echoOutput($translation['tr_424']); ?>
                  </a>
                <?php else: ?>
                  <a class="uk-flex uk-flex-middle uk-text-success" target="_blank" href="<?php echo $urlPath->pricing(); ?>">
                    <span class="uk-margin-small-right" uk-icon="icon: play-circle; ratio: 1"></span>
                    <?php echo echoOutput($translation['tr_449']); ?>
                  </a>
                <?php endif; ?>
              </div>
            </div>

            <div class="uk-width-expand">
              <table class="uk-table uk-table-divider">
                <tbody>
                  <tr>
                    <td><?php echo echoOutput($translation['tr_409']); ?></td>
                     <td>
                       <?php
                         $has_subscription = !empty($userPlan['user_payment_subscription_id']);
                         $has_plan = !empty($userPlan['plan_title']) || !empty($userPlan['user_plan_expiration_date']);
                       ?>

                        <?php if ($has_plan && !isExpiredSubscription()): ?>
                          <?php if ($has_subscription): ?>
                            <span class="uk-text-success uk-text-bold"><?php echo echoOutput($translation['tr_410']); ?></span>
                          <?php else: ?>
                            <span class="uk-text-success uk-text-bold"><?php echo echoOutput($translation['tr_450']); ?></span>
                          <?php endif; ?>
                        <?php elseif ($has_plan && isExpiredSubscription()): ?>
                          <?php if ($has_subscription): ?>
                            <span class="uk-text-warning uk-text-bold"><?php echo echoOutput($translation['tr_411']); ?></span>
                          <?php else: ?>
                            <span class="uk-text-warning uk-text-bold"><?php echo echoOutput($translation['tr_451']); ?></span>
                          <?php endif; ?>
                        <?php else: ?>
                          <span class="uk-text-danger uk-text-bold"><?php echo echoOutput($translation['tr_448']); ?></span>
                        <?php endif; ?>
                     </td>
                  </tr>

                  <tr>
                    <td><?php echo echoOutput($translation['tr_413']); ?></td>
                    <td><?php echo formatDate($userPlan['user_plan_expiration_date']); ?></td>
                  </tr>

                  <tr>
                    <td><?php echo echoOutput($translation['tr_414']); ?></td>
                    <td>
                      <span class="uk-text-nowrap">
                        <?php echo echoOutput($settings['st_currency'] ?? 'R$'); ?>
                        <?php echo echoOutput($userPlan['payment_total_amount']); ?>
                      </span>
                      /
                      <span class="uk-text-capitalize">
                        <?php echo getFrequencyText($userPlan['payment_frequency']); ?>
                      </span>
                    </td>
                  </tr>

                  <?php
                    // ND: mostra limites do plano de forma “vendável”
                    $uid = (int)($userProfile['user_id'] ?? ($userDetails['user_id'] ?? 0));
                    $nd_plan = [];
                    try {
                      if ($uid > 0 && $connect && function_exists('nd_get_user_plan_settings')) {
                        $nd_plan = (array)nd_get_user_plan_settings($connect, $uid);
                      }
                    } catch (Throwable $e) { $nd_plan = []; }

                    $activeDeals = null;
                    $maxActiveDeals = null;
                    try {
                      if ($uid > 0 && $connect && function_exists('nd_count_user_active_deals')) {
                        $activeDeals = (int)nd_count_user_active_deals($connect, $uid);
                      }
                      if (!empty($nd_plan) && isset($nd_plan['plan_limit'])) {
                        $maxActiveDeals = (int)$nd_plan['plan_limit'];
                      }
                    } catch (Throwable $e) {}

                    $updatesUsed = null;
                    $updatesLimit = null;
                    $updatesRemain = null;
                    try {
                      if ($uid > 0 && $connect && function_exists('nd_get_deal_updates_used') && function_exists('nd_plan_deal_updates_limit')) {
                        $updatesUsed = (int)nd_get_deal_updates_used($connect, $uid);
                        $updatesLimit = (int)nd_plan_deal_updates_limit($nd_plan);
                        if (function_exists('nd_is_unlimited') && nd_is_unlimited($updatesLimit)) {
                          $updatesRemain = 'Ilimitado';
                        } else {
                          $updatesRemain = max(0, $updatesLimit - $updatesUsed);
                        }
                      }
                    } catch (Throwable $e) {}
                  ?>

                  <?php if ($activeDeals !== null && $maxActiveDeals !== null && $maxActiveDeals !== 0): ?>
                  <tr>
                    <td>Ofertas ativas</td>
                    <td>
                      <?php if (function_exists('nd_is_unlimited') && nd_is_unlimited($maxActiveDeals)): ?>
                        <b><?php echo (int)$activeDeals; ?></b> / Ilimitado
                      <?php else: ?>
                        <b><?php echo (int)$activeDeals; ?></b> / <?php echo (int)$maxActiveDeals; ?>
                      <?php endif; ?>
                    </td>
                  </tr>
                  <?php endif; ?>

                  <?php if ($updatesRemain !== null): ?>
                  <tr>
                    <td>Atualizações restantes (mês)</td>
                    <td>
                      <?php if ($updatesRemain === 'Ilimitado'): ?>
                        Ilimitado
                      <?php else: ?>
                        <b><?php echo (int)$updatesRemain; ?></b>
                        <span class="uk-text-muted">(usadas: <?php echo (int)$updatesUsed; ?>)</span>
                      <?php endif; ?>
                    </td>
                  </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>

          </div>

        <?php endif; ?>

        <?php if (empty($userPlan)): ?>
          <p><?php echo echoOutput($translation['tr_415']); ?></p>
        <?php endif; ?>

      </div>

      <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered uk-margin-top">

        <h3 class="uk-heading-line uk-text-bold">
          <span><?php echo echoOutput($translation['tr_416']); ?></span>
        </h3>

        <div class="uk-overflow-auto">
<table id="table_id" class="uk-table uk-table-middle uk-table-divider" style="width: 100%">
          <thead>
            <tr>
              <th><?php echo echoOutput($translation['tr_417']); ?></th>
              <th><?php echo echoOutput($translation['tr_418']); ?></th>
              <th><?php echo echoOutput($translation['tr_419']); ?></th>
              <th><?php echo echoOutput($translation['tr_420']); ?></th>
              <th><?php echo echoOutput($translation['tr_421']); ?></th>
              <th><?php echo echoOutput($translation['tr_422']); ?></th>
            </tr>
          </thead>
        </table>
</div>

      </div>

    </div>
  </div>
</div>

<script>
'use strict';
$(document).ready(function(){

  // evita reinicialização
  if ($.fn.DataTable.isDataTable('#table_id')) {
    $('#table_id').DataTable().destroy();
    $('#table_id').empty();
  }
  
  $('#table_id').DataTable({
    language: (window.DT_LANG_PTBR || {}), // <- PT-BR
    bProcessing: true,
    sAjaxSource: SITEURL + "/dashboard/data.php?type=payments",
    responsive: true,
    bPaginate: true,
    scrollX: true,
    sPaginationType: "simple_numbers",
    iDisplayLength: 10,
    lengthChange: false,
    /*"language": { search: "" },*/
    fnCreatedRow: function(nRow, data){
      $(nRow).addClass("id-" + data.payment_id);
    },
    aoColumns: [
      { mData: null , className:"uk-text-left",
        mRender : function (data) {
          return '<span>' + (data.plan_title||'') + '</span>';
        }
      },
      { mData: null , className:"uk-text-left",
        mRender : function (data) {
          return '<span class="uk-text-capitalize">' + (data.date_payment||'') + '</span>';
        }
      },
      { mData: null , width:"8%", className:"uk-text-center",
        mRender : function (data) {
          return '<span>' + (data.payment_total_amount||'') + '</span>';
        }
      },
      { mData: null , width:"8%", className:"uk-text-center",
        mRender : function (data) {
          return '<span>' + (data.payment_currency||'') + '</span>';
        }
      },
      { mData: null , width:"5%", className:"status uk-text-center",
        mRender : function (data) {
          if (String(data.payment_status) === '1') {
            return '<span class="uk-text-success uk-text-bold">'+(window.ST_PAYCOMPLETED || 'Concluído')+'</span>';
          } else {
            return '<span class="uk-text-warning uk-text-bold">'+(window.ST_PAYUNKNOWN || 'Desconhecido')+'</span>';
          }
        }
      },
      { mData: null , className:"uk-text-center",
        mRender : function (data) {
          if (String(data.payment_status) === '1') {
            return '<a class="uk-button uk-button-default uk-border-rounded uk-button-small uk-text-capitalize" href="./invoice.php?id='+data.payment_id+'"><span uk-icon="icon: print; ratio: 0.8"></span></a>';
          }
          return '';
        }
      }
    ]
  });

});
</script>