<?php
declare(strict_types=1);
// ---------- GUARDS & FALLBACKS ----------
$translation   = (isset($translation)   && is_array($translation))   ? $translation   : [];
$translations  = (isset($translations)  && is_array($translations))  ? $translations  : [];
$theme         = (isset($theme)         && is_array($theme))         ? $theme         : [];
$userDetails   = (isset($userDetails)   && is_array($userDetails))   ? $userDetails   : [];
$userProfile   = (isset($userProfile)   && is_array($userProfile))   ? $userProfile   : [];
$menuItems     = (isset($menuItems)     && is_array($menuItems))     ? $menuItems     : [];
$T             = $translation + $translations;

if (!function_exists('trf')) {
  function trf(array $map, string $key, string $fallback): string {
    if (!array_key_exists($key, $map)) return $fallback;
    $v = (string)$map[$key];
    return trim($v) === '' ? $fallback : $v;
  }
}

// --- Avatar URL seguro ---
$menu_avatar_raw = $userDetails['seller_logo']
  ?? $userDetails['user_avatar']
  ?? $userProfile['user_avatar']
  ?? '';

// normaliza e aplica fallback se vier vazio / só espaços
$menu_avatar_raw = trim((string)$menu_avatar_raw);
if ($menu_avatar_raw === '') {
  $menu_avatar_raw = 'avatar.png';
}

$menu_avatar_raw = str_replace('\\','/', $menu_avatar_raw);
if (preg_match('~^https?://|^/~', $menu_avatar_raw)) {
  $menu_avatar = $menu_avatar_raw;
} else {
  $menu_avatar = isset($urlPath) ? $urlPath->image($menu_avatar_raw) : '/images/'.$menu_avatar_raw;
}

// --- Nome & email ---
$menu_name  = $userDetails['seller_title']
  ?? $userDetails['user_name']
  ?? $userProfile['user_name']
  ?? 'Usuário';

$menu_email = $userDetails['user_email']
  ?? $userProfile['user_email']
  ?? '';

$menu_email_masked = '';
if ($menu_email !== '') {
  try { $menu_email_masked = function_exists('maskEmail') ? maskEmail($menu_email) : $menu_email; }
  catch (\Throwable $e) { $menu_email_masked = $menu_email; }
}

// --- Logo do topo ---
if (!empty($theme['th_whitelogo'])) {
  $menu_logo = isset($urlPath) ? $urlPath->image($theme['th_whitelogo']) : $theme['th_whitelogo'];
} else {
  $menu_logo = isset($urlPath) ? $urlPath->image('logo-white.png') : '/images/logo-white.png';
}

// --- URL de logout e rótulo ---
$logoutUrl = (isset($urlPath) && method_exists($urlPath, 'signout')) ? $urlPath->signout() : '/signout';
$btnLogout = trf($T, 'tr_181', 'Sair');

// --- Itens do menu (fallback) ---
if (!$menuItems) {
  $menuItems = [
    ['url'=>'submissions.php','icon'=>'album','title'=>trf($T,'tr_240','Meus Envios')],
    ['url'=>'seller.php','icon'=>'cart','title'=>trf($T,'tr_241','Minhas Lojas')],
    ['url'=>'my_stores.php','icon'=>'home','title'=>trf($T,'tr_452','Minhas Lojas')],
    ['url'=>'coupons.php','icon'=>'tag','title'=>trf($T,'tr_nd_coupons','Meus Cupons')],
    ['url'=>'membership.php','icon'=>'bookmark','title'=>trf($T,'tr_242','Assinatura')],
    ['url'=>'profile.php','icon'=>'user','title'=>trf($T,'tr_244','Perfil')],
  ];
}
// Define a home padrão do logo: dashboard "normal"
$homeHref = 'home.php';
// Se estiver no dashboard do associado, aponta para a home específica do associado
if (defined('ND_ASSOCIATE_DASHBOARD') && ND_ASSOCIATE_DASHBOARD === true) {
  $homeHref = 'https://conecta.ndmidia.com.br/dashboard/associate_home.php';
}
?>
<!-- NAV SUPERIOR -->
<div uk-sticky class="uk-section-primary uk-preserve-color">
  <div class="uk-navbar-container uk-navbar-transparent">
    <div class="uk-container uk-container-expand uk-dark">
      <nav uk-navbar>
        <div class="uk-navbar-left">
          <a id="sidebar_toggle" class="uk-navbar-toggle" uk-navbar-toggle-icon></a>
          <a href="<?php echo htmlspecialchars($homeHref, ENT_QUOTES, 'UTF-8'); ?>" class="uk-navbar-item uk-logo">
            <img class="uk-logo-navbar" src="<?php echo htmlspecialchars($menu_logo, ENT_QUOTES, 'UTF-8'); ?>" alt="Logo">
          </a>
        </div>

        <div class="uk-navbar-right uk-light uk-margin-small-right">
          <!-- Seletor de idiomas embutido e deduplicado -->
          <div id="langInline" class="lang-inline">
            <?php
            $__lang_partial = $_SERVER['DOCUMENT_ROOT'] . '/partials/lang-switch.php';
            if (is_file($__lang_partial)) {
              include $__lang_partial;
            } else {
              // Fallback simples (bandeira + código)
              $current = $_GET['lang'] ?? ($GLOBALS['currentLang'] ?? 'pt');
              echo '<div id="langSwitchRoot" class="lang-switch" aria-label="Selecionar idioma">';
              $opts = [
                ['pt','fi fi-br','PT'],
                ['en','fi fi-us','EN'],
                ['es','fi fi-es','ES'],
              ];
              foreach ($opts as [$code,$flag,$label]) {
                $active = ($current === $code) ? 'active' : '';
                echo '<a href="?lang='.$code.'" class="'.$active.'" data-lang="'.$code.'"><span class="'.$flag.'"></span><b>'.$label.'</b></a>';
              }
              echo '</div>';
            }
            ?>
          </div>


          <a class="uk-button uk-button-default uk-text-capitalize uk-border-rounded uk-visible@m"
             href="https://conecta.ndmidia.com.br/">
            <i uk-icon="icon: link-external"></i>
            <span class="uk-visible@s">Ver site</span>
          </a>
          <a class="uk-button uk-button-default uk-text-capitalize uk-border-rounded uk-hidden@m"
             href="https://conecta.ndmidia.com.br/">
            <i uk-icon="icon: link-external"></i>
            <span>Ver site</span>
          </a>

          <a class="uk-button uk-button-default uk-text-capitalize uk-border-rounded"
             href="<?php echo htmlspecialchars($logoutUrl, ENT_QUOTES, 'UTF-8'); ?>">
            <i uk-icon="icon: sign-out"></i>
            <span class="uk-visible@s"><?php echo htmlspecialchars($btnLogout, ENT_QUOTES, 'UTF-8'); ?></span>
          </a>
        </div>
      </nav>
    </div>
  </div>
</div>

<!-- SIDEBAR -->
<div id="sidebar" class="tm-sidebar-left uk-background-default" style="width:260px;min-width:260px;">
  <a href="javascript:void(0)"
     class="nd-sidebar-close uk-position-small uk-position-top-right uk-hidden@m"
    
     aria-label="Fechar menu">
    <span uk-icon="icon: close"></span>
  </a>

  <center>
    <div class="user">
      <div class="uk-inline">
        <img id="avatar" width="100" class="uk-border-circle"
             src="<?php echo htmlspecialchars($menu_avatar, ENT_QUOTES, 'UTF-8'); ?>" alt="Avatar">
      </div>
      <div class="uk-margin-top"></div>
      <div id="name" class="uk-text-truncate uk-text-bold" style="max-width:200px;">
        <?php echo htmlspecialchars($menu_name, ENT_QUOTES, 'UTF-8'); ?>
      </div>
      <div id="email" class="uk-text-truncate uk-text-muted"
           style="max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;">
        <?php echo htmlspecialchars($menu_email_masked, ENT_QUOTES, 'UTF-8'); ?>
      </div>
    </div>
    <br>
  </center>

  <ul class="uk-nav uk-nav-default uk-nav-parent-icon" data-uk-nav>
    <?php foreach ($menuItems as $item): ?>
      <li>
        <a href="<?php echo htmlspecialchars($item['url'], ENT_QUOTES, 'UTF-8'); ?>"
           class="menu-link"
           style="display:flex;align-items:center;gap:8px;font-size:14px;line-height:1.4;text-indent:0;color:#333;white-space:nowrap;overflow:visible;width:auto;padding-left:14px;opacity:1;visibility:visible;">
          <span class="uk-margin-small-right" uk-icon="icon: <?php echo htmlspecialchars($item['icon'], ENT_QUOTES, 'UTF-8'); ?>"></span>
          <span class="menu-title"
                style="display:inline-block !important;font-size:14px !important;text-indent:0 !important;color:#333 !important;opacity:1 !important;visibility:visible !important;">
            <?php echo htmlspecialchars($item['title'], ENT_QUOTES, 'UTF-8'); ?>
          </span>
        </a>
      </li>
    <?php endforeach; ?>
  </ul>
</div>

<!-- CSS (nav + sidebar + idioma) -->
<style>
  .uk-navbar-right { 
    display:flex; 
    align-items:center; 
    gap:8px; 
    flex-wrap:wrap; 
    justify-content:flex-end;
  }
  @media (max-width: 480px){
    .uk-navbar-right {
      justify-content: flex-end;
    }
    .uk-navbar-right .uk-button {
      font-size: 12px;
      padding: 0 10px;
    }
    .lang-inline{
      margin-right: 4px;
    }
  }
  .lang-inline     { display:flex; align-items:center; margin-right:12px; }

  /* Neutraliza posições "fixas" do parcial para caber na navbar */
  #langInline .nd-lang,
  #langInline #langSwitchRoot{
    position: static !important;
    top: auto !important;
    right: auto !important;
    z-index: auto !important;
  }

  /* ===== DESIGN do seletor (chips iguais ao antigo) ===== */
  #langInline .lang-switch{
    display:flex;
    align-items:center;
    gap:6px;
  }
  #langInline .lang-switch a{
    display:inline-flex;
    align-items:center;
    gap:6px;
    padding:4px 8px;
    border-radius:9999px;
    border:1px solid rgba(255,255,255,.45);
    background:rgba(255,255,255,.92);
    color:#1a1a1a;
    line-height:1;
    font-size:12px;
    text-decoration:none !important;
    transition:all .15s ease;
    box-shadow: 0 1px 1px rgba(0,0,0,.06);
  }
  /* Bandeiras (flag-icons) */
  #langInline .lang-switch .fi{
    width:18px; height:13px;
    border-radius:2px;
    box-shadow: inset 0 0 0 1px rgba(0,0,0,.05);
  }
  #langInline .lang-switch a b{ font-weight:600; letter-spacing:.2px; }

  #langInline .lang-switch a:hover{
    background:#fff;
    border-color:#fff;
  }
  /* Ativo: azul (UIKit primary ~ #1e87f0) */
  #langInline .lang-switch a.active{
    background:#1e87f0;
    border-color:#1e87f0;
    color:#fff;
    box-shadow: 0 1px 2px rgba(0,0,0,.12);
  }
  #langInline .lang-switch a.active b{ color:#fff; }
  #langInline .lang-switch a:focus{
    outline:none;
    box-shadow: 0 0 0 2px rgba(30,135,240,.35);
  }

  /* Sidebar sempre aberta (rótulos visíveis) */
  #sidebar.tm-sidebar-left{ width:260px !important; min-width:260px !important; }
  body.tm-sidebar-collapsed #sidebar{ width:260px !important; }

  #sidebar .uk-nav > li > a{
    display:flex !important; align-items:center; gap:8px;
    font-size:14px !important; color:#333 !important;
    white-space:nowrap; text-indent:0 !important; opacity:1 !important;
    padding-left:14px;
  }
  #sidebar .uk-nav > li > a [uk-icon]{ min-width:18px; }
  #sidebar .menu-title{
    display:inline-block !important; font-size:14px !important;
    color:#333 !important; opacity:1 !important; visibility:visible !important;
  }
  #sidebar .user #avatar{ width:100px; height:100px; object-fit:cover; }
  #sidebar .user #name{ max-width:200px; }
  #sidebar .user #email{ max-width:200px; overflow:hidden; text-overflow:ellipsis; white-space:nowrap; }

  /* Ajustes extras para telas muito estreitas (até ~480px) */
  @media (max-width: 480px) {
    /* Idiomas: permite quebra em mais de uma linha e reduz tamanho */
    #langInline .lang-switch{
      flex-wrap: wrap;
      justify-content: flex-end;
      row-gap: 4px;
    }
    #langInline .lang-switch a{
      padding: 3px 6px;
      font-size: 11px;
    }

    /* Nome/e-mail no sidebar com largura menor em celulares pequenos */
    #sidebar .user #name,
    #sidebar .user #email{
      max-width: 160px;
    }

    /* Navbar com menos "gordura" nas laterais */
    .uk-navbar-container .uk-navbar-left{
      padding-left: 4px;
    }
    .uk-navbar-container .uk-navbar-right{
      padding-right: 4px;
    }
  }


  /* Sidebar ocupa toda a largura em telas menores que 960px (menu não fica "cortado") */
  @media (max-width: 960px) {
    #sidebar.tm-sidebar-left,
    body.tm-sidebar-collapsed #sidebar{
      width: 100% !important;
      min-width: 100% !important;
    }
  }

</style>

<!-- JS: mantém sidebar, garante rótulos e deduplica/move seletor -->
<script>
(function(){
  const CLS = ['sidebar-mini','tm-sidebar-collapsed','uk-closed','collapsed','mini','mini-sidebar','sidebar-collapsed'];

  function expandSidebar(){
    try{
      CLS.forEach(c => document.body.classList.remove(c));
      const sb = document.getElementById('sidebar');
      if (sb) { sb.style.width = '260px'; sb.style.minWidth = '260px'; }
    }catch(e){}
  }

  function ensureMenuTitles(){
    try{
      document.querySelectorAll('#sidebar .uk-nav > li > a').forEach(a=>{
        const clone = a.cloneNode(true);
        clone.querySelectorAll('[uk-icon]').forEach(i=>i.remove());
        const txt = (clone.textContent || '').trim();
        if (!a.querySelector('.menu-title') && txt){
          const icon = a.querySelector('[uk-icon]');
          a.innerHTML = '';
          if (icon) a.appendChild(icon);
          const t = document.createElement('span');
          t.className = 'menu-title';
          t.textContent = txt;
          a.appendChild(t);
        } else {
          const t = a.querySelector('.menu-title');
          if (t){ t.style.display='inline-block'; t.style.opacity='1'; t.style.visibility='visible'; }
        }
      });
    }catch(e){}
  }

  // Move/deduplica seletor: mantém apenas o que estiver na navbar (#langInline)
  function normalizeLangSwitch(){
    try{
      const host = document.getElementById('langInline');
      if (!host) return;

      const candidates = Array.from(document.querySelectorAll('#langSwitchRoot, .lang-switch, .nd-lang'));
      if (!candidates.length) return;

      let keep = candidates.find(el => host.contains(el)) || candidates[0];

      if (!host.contains(keep)) {
        host.innerHTML = '';
        host.appendChild(keep);
      }
      candidates.forEach(el => { if (el !== keep && el.parentNode) el.parentNode.removeChild(el); });

      // Zera estilos agressivos
      keep.style.position = '';
      keep.style.right = '';
      keep.style.top = '';
      keep.querySelectorAll('*').forEach(n=>{
        if (!n.style) return;
        if (n.style.position==='fixed' || n.style.position==='absolute') n.style.position='';
        n.style.right=''; n.style.top='';
      });
    }catch(e){}
  }

  function refreshAll(){ expandSidebar(); ensureMenuTitles(); normalizeLangSwitch(); }
  document.addEventListener('DOMContentLoaded', refreshAll);
  window.addEventListener('load', refreshAll);
  document.addEventListener('click', function(){ setTimeout(refreshAll, 80); });
})();
</script>
