<div class="uk-container uk-margin-top uk-margin-bottom">
  <div class="tas-card uk-card uk-card-default uk-border-rounded">
    <div class="uk-card-header">
      <h3 class="uk-card-title">Minhas Lojas</h3>
    </div>

    <div class="uk-card-body">
      <?php if (!empty($errors)): ?>
        <div class="uk-alert uk-alert-danger">
          <ul class="uk-list">
            <?php foreach ($errors as $er): ?><li><?php echo echoOutput($er); ?></li><?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <?php if (!empty($success)): ?>
        <div class="uk-alert uk-alert-success"><?php echo echoOutput($success); ?></div>
      <?php endif; ?>

      <h4 class="uk-heading-bullet">Adicionar nova loja</h4>
      <form class="uk-form-stacked" method="post" enctype="multipart/form-data">
        <input type="hidden" name="action" value="create">
        <div class="uk-margin">
          <label class="uk-form-label">Nome da loja *</label>
          <div class="uk-form-controls">
            <input class="uk-input uk-border-rounded" type="text" name="store_title" required>
          </div>
        </div>
        <div class="uk-margin">
          <label class="uk-form-label">Descrição</label>
          <div class="uk-form-controls">
            <textarea class="uk-textarea uk-border-rounded" rows="3" name="store_description"></textarea>
          </div>
        
        </div>

        <div class="uk-margin">
          <label class="uk-form-label">Endereço</label>
          <div class="uk-form-controls">
            <input class="uk-input uk-border-rounded" type="text" name="store_address" placeholder="Rua, número, bairro, cidade">
          </div>
        </div>
        <div class="uk-margin">
          <label class="uk-form-label">Horário de atendimento</label>
          <div class="uk-form-controls">
            <div class="uk-grid-small" uk-grid>
              <div>
                <small class="uk-text-meta">Abre</small>
                <input class="uk-input uk-border-rounded" type="time" name="store_hours_open">
              </div>
              <div>
                <small class="uk-text-meta">Fecha</small>
                <input class="uk-input uk-border-rounded" type="time" name="store_hours_close">
              </div>
            </div>
            <small class="uk-text-meta">
              Se preferir, descreva o horário em texto (opcional). Se os horários acima ficarem vazios,
              usaremos apenas o texto abaixo.
            </small>
            <input class="uk-input uk-border-rounded uk-margin-small-top" type="text" name="store_hours" placeholder="Ex: Seg a Sex, 8h às 18h">
          </div>
        </div>
        <div class="uk-margin">
          <label class="uk-form-label">WhatsApp</label>
          <div class="uk-form-controls">
            <input class="uk-input uk-border-rounded" type="text" name="store_whatsapp" placeholder="(48) 9 9999-9999 ou link completo">
          </div>
        </div>

        <div class="uk-grid-small" data-uk-grid>
          <div class="uk-width-1-3">
            <label class="uk-form-label">Status</label>
            <select class="uk-select uk-border-rounded" name="store_status">
              <option value="1">Ativado</option>
              <option value="0">Desativado</option>
            </select>
          </div>
          <div class="uk-width-1-3">
            <label class="uk-form-label">Destaque</label>
            <select class="uk-select uk-border-rounded" name="store_featured">
              <option value="0">Não</option>
              <option value="1">Sim</option>
            </select>
          </div>
          <div class="uk-width-1-3">
            <label class="uk-form-label">Logo</label>
            <input class="uk-input uk-border-rounded" type="file" name="store_image" accept=".jpg,.jpeg,.png,.gif">
          </div>
        </div>
        <button class="uk-button uk-button-primary uk-border-rounded" type="submit">Criar loja</button>

      </form>

      <hr class="uk-divider-icon">

      <h4 class="uk-heading-bullet">Minhas lojas cadastradas</h4>
      <?php if (empty($myStores)): ?>
        <p>Você ainda não possui lojas. Crie a primeira acima.</p>
      <?php else: ?>
        <div class="uk-overflow-auto">
          <table class="uk-table uk-table-divider">
            <thead>
              <tr>
                <th>#</th>
                <th>Nome</th>
                <th>Slug</th>
                <th>Ações</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($myStores as $st): ?>
                <tr>
                  <td><?php echo (int)($st['store_id'] ?? 0); ?></td>
                  <td>
                    <form method="post" class="uk-form-inline">
                      <input type="hidden" name="action" value="update">
                      <input type="hidden" name="store_id" value="<?php echo (int)($st['store_id'] ?? 0); ?>">

                      <input class="uk-input uk-border-rounded" type="text" name="store_title" value="<?php echo echoOutput($st['store_title'] ?? ''); ?>" placeholder="Nome da loja" style="max-width:220px">

                      <input class="uk-input uk-border-rounded uk-margin-small-left" type="text" name="store_description" value="<?php echo echoOutput($st['store_description'] ?? ''); ?>" placeholder="Descrição (opcional)" style="max-width:260px">

                      <input class="uk-input uk-border-rounded uk-margin-small-left" type="text" name="store_address" value="<?php echo echoOutput($st['store_address'] ?? ''); ?>" placeholder="Endereço" style="max-width:260px">

                      <input class="uk-input uk-border-rounded uk-margin-small-left" type="text" name="store_hours" value="<?php echo echoOutput($st['store_hours'] ?? ''); ?>" placeholder="Horário" style="max-width:220px">

                      <input class="uk-input uk-border-rounded uk-margin-small-left" type="text" name="store_whatsapp" value="<?php echo echoOutput($st['store_whatsapp'] ?? ''); ?>" placeholder="WhatsApp" style="max-width:200px">

                      <select class="uk-select uk-border-rounded uk-margin-small-left" name="store_status">
                        <option value="1" <?php echo !empty($st['store_status']) ? 'selected' : ''; ?>>Ativado</option>
                        <option value="0" <?php echo empty($st['store_status']) ? 'selected' : ''; ?>>Desativado</option>
                      </select>

                      <select class="uk-select uk-border-rounded uk-margin-small-left" name="store_featured">
                        <option value="0" <?php echo empty($st['store_featured']) ? 'selected' : ''; ?>>Não</option>
                        <option value="1" <?php echo !empty($st['store_featured']) ? 'selected' : ''; ?>>Sim</option>
                      </select>

                      <input class="uk-input uk-border-rounded uk-margin-small-left" type="file" name="store_image" accept=".jpg,.jpeg,.png,.gif" style="max-width:220px">

                      <button class="uk-button uk-button-primary uk-border-rounded uk-margin-small-left" type="submit">Salvar</button>

                    </form>
                  </td>
                  <td><?php echo echoOutput($st['store_slug'] ?? ''); ?></td>
                  <td>
                    <form method="post" onsubmit="return confirm('Remover esta loja?');" style="display:inline-block">
                      <input type="hidden" name="action" value="delete">
                      <input type="hidden" name="store_id" value="<?php echo (int)($st['store_id'] ?? 0); ?>">
                      <button class="uk-button uk-button-danger uk-border-rounded" type="submit">Excluir</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>