<?php
// ===== GUARDS (antes de qualquer saída) =====
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  // Fallbacks mínimos usados nesta view
  'tr_248' => 'Ver planos',
  'tr_192' => 'Formatos suportados: JPG, PNG.',
  'tr_274' => 'Título',
  'tr_275' => 'Tagline',
  'tr_276' => 'Descrição',
  'tr_277' => 'Categoria',
  'tr_278' => 'Subcategoria',
  'tr_279' => 'Loja',
  'tr_280' => 'Localização',
  'tr_281' => 'Preço',
  'tr_282' => 'Preço antigo',
  'tr_286' => 'Imagem principal',
  'tr_287' => 'Link do produto',
  'tr_288' => 'Vídeo',
  'tr_289' => 'GIF',
  'tr_293' => 'Informações principais',
  'tr_294' => 'Classificação',
  'tr_295' => 'Preços',
  'tr_296' => 'Mídia & Links',
  'tr_300' => 'Galeria',
  'tr_312' => 'Tamanho recomendado:',
  'tr_440' => 'Imagens',
  'tr_441' => 'Vídeo (opcional)',
  'tr_442' => 'URL do vídeo',
  'tr_445' => 'Você atingiu o limite do seu plano.',
  'tr_292' => 'Enviar',
  'tr_placeholder_subcat' => '— Selecione uma categoria —',
];

$getCategories    = (isset($getCategories)    && is_array($getCategories))    ? $getCategories    : [];
$getStores        = (isset($getStores)        && is_array($getStores))        ? $getStores        : [];
$getLocations     = (isset($getLocations)     && is_array($getLocations))     ? $getLocations     : [];
$getSubCategories = (isset($getSubCategories) && is_array($getSubCategories)) ? $getSubCategories : []; // pode vir vazio no load inicial

if (!function_exists('echoOutput')) {
  function echoOutput($v){ echo htmlspecialchars((string)$v, ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8'); }
}
// ===== /GUARDS =====
require 'menu.php'; ?>

<div class="content-padder">
  <div class="uk-section-small uk-background-muted">
    <div class="uk-container uk-container-large">   

      <?php if (isset($planDetails) && !empty($planDetails)): ?>
        <?php
          $planTotal = (int)($planDetails['plan_total'] ?? 0);
          $uploaded  = (int)($userTotalOUploaded ?? 0);
        ?>
        <?php if ($planTotal !== -1 && $uploaded >= $planTotal): ?>
          <div class="uk-border-rounded uk-flex uk-flex-middle tas-notify tas-notify-warning uk-margin-bottom">
            <p class="uk-margin-remove"><?php echo echoOutput($translation['tr_445']); ?></p>
            <a class="uk-margin-small-left uk-button uk-button-default uk-text-bold uk-border-rounded uk-button-small uk-text-warning" href="<?php echo $urlPath->pricing(); ?>">
              <?php echo echoOutput($translation['tr_248']); ?>
            </a>
          </div>
        <?php endif; ?>
      <?php endif; ?>

      <form enctype="multipart/form-data" class="uk-form-stacked" id="submission-form" method="post">
        <input type="hidden" value="<?php echo echoOutput($userDetails['user_id'] ?? ''); ?>" name="deal_author">

        <div uk-grid>

          <!-- EXPAND BLOCK -->
          <div class="uk-width-1-1 uk-width-expand@m">

            <div id="errors" class="uk-width-1-1 uk-text-left" style="display:none;">
              <div class="uk-margin">
                <div class="tas-notify tas-notify-danger uk-border-rounded uk-margin-remove uk-padding-small">
                  <ul class="uk-margin-remove" id="errorsMsg"></ul>
                </div>
              </div>
            </div>

            <div id="success" class="uk-width-1-1 uk-text-left" style="display:none;">
              <div class="uk-margin">
                <div class="tas-notify tas-notify-success uk-border-rounded uk-margin-remove uk-padding-small">
                  <ul class="uk-margin-remove" id="successMsg"></ul>
                </div>
              </div>
            </div>

            <div id="formInputs">

              <!-- Bloco: Informações principais -->
              <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-margin-medium-bottom uk-card-bordered">
                <h3 class="uk-heading-line uk-margin-medium-bottom uk-text-bold">
                  <span><?php echo echoOutput($translation['tr_293']); ?></span>
                </h3>

                <div class="uk-grid-small" uk-grid>
                  <div class="uk-width-1-1">

                    <div class="uk-margin">
                      <label class="uk-form-label">
                        <?php echo echoOutput($translation['tr_274']); ?> <b class="uk-text-danger">*</b>
                      </label>
                      <input class="uk-input uk-border-rounded" type="text" maxlength="100" name="deal_title" required>
                    </div>

                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_276']); ?></label>
                      <textarea class="advancedtinymce uk-textarea" name="deal_description"></textarea>
                    </div>

                  </div>
                </div>
              </div>

              <!-- Bloco: Classificação -->
              <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-margin-medium-bottom uk-card-bordered">
                <h3 class="uk-heading-line uk-margin-medium-bottom uk-text-bold">
                  <span><?php echo echoOutput($translation['tr_294']); ?></span>
                </h3>

                <div class="uk-grid-small" uk-grid>

                  <div class="uk-width-1-2@s">
                    <div class="uk-margin">
                      <label class="uk-form-label">
                        <?php echo echoOutput($translation['tr_277']); ?> <b class="uk-text-danger">*</b>
                      </label>
                      <select class="uk-select uk-border-rounded" name="deal_category" id="categories-dropdown" required>
                        <option value="">---</option>
                        <?php foreach ($getCategories as $item): ?>
                          <option value="<?php echo echoOutput($item['category_id'] ?? ''); ?>">
                            <?php echo echoOutput($item['category_title'] ?? ''); ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                  </div>

                  <div class="uk-width-1-2@s">
                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_278']); ?></label>
                      <select class="uk-select uk-border-rounded" name="deal_subcategory" id="subcategories-dropdown">
                        <?php if (!empty($getSubCategories)): ?>
                          <?php foreach ($getSubCategories as $item): ?>
                            <option value="<?php echo echoOutput($item['subcategory_id'] ?? ''); ?>">
                              <?php echo echoOutput($item['subcategory_title'] ?? ''); ?>
                            </option>
                          <?php endforeach; ?>
                        <?php else: ?>
                          <option value=""><?php echo echoOutput($translation['tr_placeholder_subcat']); ?></option>
                        <?php endif; ?>
                      </select>
                    </div>
                  </div>

                  <div class="uk-width-1-2@s">
                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_279']); ?></label>
                      <?php if (empty($getStores)): ?>
                        <div class="tas-notify tas-notify-warning uk-border-rounded uk-padding-small">
                          <span>Você ainda não cadastrou sua loja.</span>
                          <a class="uk-button uk-button-text uk-text-primary uk-margin-small-left" href="seller.php">Cadastrar agora</a>
                        </div>
                        <select class="uk-select uk-border-rounded" name="deal_store" disabled>
                          <option value="">---</option>
                        </select>
                      <?php else: ?>
                      <select class="uk-select uk-border-rounded" name="deal_store">
                        <option value="">---</option>
                        <?php foreach ($getStores as $item): ?>
                          <option value="<?php echo echoOutput($item['store_id'] ?? ''); ?>">
                            <?php echo echoOutput($item['store_title'] ?? ''); ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                      <?php endif; ?>
                      </select>
                    </div>
                  </div>

                  <div class="uk-width-1-2@s">
                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_280']); ?></label>
                      <select class="uk-select uk-border-rounded" name="deal_location">
                        <option value="">---</option>
                        <?php foreach ($getLocations as $item): ?>
                          <option value="<?php echo echoOutput($item['location_id'] ?? ''); ?>">
                            <?php echo echoOutput($item['location_title'] ?? ''); ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                  </div>

                  <div class="uk-width-1-1">
                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_275']); ?></label>
                      <input class="uk-input uk-border-rounded" type="text" maxlength="200" name="deal_tagline">
                    </div>
                  </div>

                </div>
              </div>

              <!-- Bloco: Preços -->
              <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-margin-medium-bottom uk-card-bordered">
                <h3 class="uk-heading-line uk-margin-medium-bottom uk-text-bold">
                  <span><?php echo echoOutput($translation['tr_295']); ?></span>
                </h3>

                <div class="uk-grid-small" uk-grid>
                  <div class="uk-width-1-2@s">
                    <div class="uk-margin">
                      <label class="uk-form-label">
                        <?php echo echoOutput($translation['tr_281']); ?>
                        (<?php echo echoOutput($settings['st_currencycode'] ?? ''); ?>)
                        <b class="uk-text-danger">*</b>
                      </label>
                      <input class="uk-input uk-border-rounded" type="number" name="deal_price" required>
                    </div>
                  </div>

                  <div class="uk-width-1-2@s">
                    <div class="uk-margin">
                      <label class="uk-form-label">
                        <?php echo echoOutput($translation['tr_282']); ?>
                        (<?php echo echoOutput($settings['st_currencycode'] ?? ''); ?>)
                      </label>
                      <input class="uk-input uk-border-rounded" type="number" name="deal_oldprice">
                    </div>
                  </div>
                </div>
              </div>

              <!-- Bloco: Mídia & Links -->
              <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-margin-bottom uk-card-bordered">
                <h3 class="uk-heading-line uk-margin-medium-bottom uk-text-bold">
                  <span><?php echo echoOutput($translation['tr_296']); ?></span>
                </h3>

                <div class="uk-grid-small" uk-grid>
                  <div class="uk-width-1-1">
                    <div class="uk-margin">
                      <label class="uk-form-label">
                        <?php echo echoOutput($translation['tr_286']); ?> <b class="uk-text-danger">*</b>
                      </label>

                      <div class="uk-margin">
                        <div uk-form-custom="target: true">
                          <input type="file" name="deal_image" accept=".jpg,.jpeg,.png">
                          <input class="uk-input uk-form-width-medium uk-border-rounded" type="text" placeholder="Selecionar arquivo" disabled>
                          <button class="uk-button uk-button-default uk-border-rounded padding-left-5 padding-right-5" type="button" tabindex="-1"><span uk-icon="folder"></span></button>
                        </div>
                      </div>
                      <p class="uk-text-danger uk-text-small uk-margin-remove">
                        <?php echo echoOutput($translation['tr_312']); ?> 650x350px
                      </p>
                      <p class="uk-text-small uk-margin-remove">
                        <?php echo echoOutput($translation['tr_192']); ?>
                      </p>
                    </div>
                  </div>

                  <div class="uk-width-1-1">
                    <div class="uk-margin">
                      <label class="uk-form-label">
                        <?php echo echoOutput($translation['tr_287']); ?> <b class="uk-text-danger">*</b>
                      </label>
                      <input class="uk-input uk-border-rounded" type="url" pattern="https://.*" name="deal_link" required>
                    </div>
                  </div>

                  <div class="uk-width-1-1">
                    <div class="uk-margin">
                      <label class="uk-form-label">
                        <?php echo echoOutput($translation['tr_288']); ?> (<b>Youtube/Vimeo</b>)
                      </label>
                      <input class="uk-input uk-border-rounded" type="text" name="deal_video" placeholder="https://youtu.be/... ou https://vimeo.com/...">
                    </div>
                  </div>

                  <div class="uk-width-1-1">
                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_289']); ?></label>
                      <input class="uk-input uk-border-rounded" type="text" name="deal_gif" placeholder="https://...gif">
                    </div>
                  </div>

                  <div class="uk-width-1-1">
                    <div class="uk-margin">
                      <label class="uk-form-label"><?php echo echoOutput($translation['tr_300']); ?></label>
                      <input type="file" name="files" accept=".jpg,.jpeg,.png" multiple>
                    </div>
                  </div>
                </div>
              </div>

              <div class="uk-margin">
                <button class="uk-button uk-button-success uk-flex-center uk-flex uk-flex-middle uk-border-rounded uk-text-capitalize"
                        value="<?php echo echoOutput($translation['tr_292']); ?>" type="submit">
                  <span id="loadingText"><?php echo echoOutput($translation['tr_292']); ?></span>
                  <span id="loading" class="uk-margin-small-left"></span>
                </button>
              </div>

            </div>

          </div>
          <!-- /EXPAND BLOCK -->

          <!-- SIDEMENU -->
          <div class="uk-width-1-1 uk-width-1-3@m">
            <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
              <h4 class="uk-heading-line uk-text-bold"><span><?php echo echoOutput($translation['tr_440']); ?></span></h4>
              <p><?php echo echoOutput($translation['tr_441']); ?></p>
              <p><?php echo echoOutput($translation['tr_442']); ?></p>
            </div>
          </div>
          <!-- /SIDEMENU -->

        </div>
      </form>
    </div>
  </div>
</div>

<script>
'use strict';
$(document).ready(function() {
  // enable fileuploader plugin
  $('input[name="files"]').fileuploader({
    limit: 8,
    fileMaxSize: 1,          // MB
    extensions: ['jpg', 'png', 'jpeg'],
    addMore: true
  });
});
</script>




<!-- ND_FILEUP_CAPTIONS -->
<script>
(function(){
  function applyCaptions(ctx){
    try{
      var feedback = '<?= htmlspecialchars($translation["tr_upl_feedback"] ?? "Escolha arquivos para enviar", ENT_QUOTES) ?>';
      var button   = '<?= htmlspecialchars($translation["tr_upl_button"]   ?? "Escolher", ENT_QUOTES) ?>';

      var caps = (ctx||document).querySelectorAll('.fileuploader-input-caption span');
      caps.forEach(function(el){ if(el.textContent !== feedback){ el.textContent = feedback; }});

      var btns = (ctx||document).querySelectorAll('.fileuploader-input .uk-button, .fileuploader-input button');
      btns.forEach(function(btn){
        var sp = btn.querySelector('span');
        if (sp){
          if (sp.textContent !== button){ sp.textContent = button; }
        } else {
          if (btn.textContent !== button){ btn.textContent = button; }
        }
      });
    }catch(e){}
  }

  if (document.readyState !== 'loading') applyCaptions();
  document.addEventListener('DOMContentLoaded', function(){ applyCaptions(); });
  window.addEventListener('load', function(){ applyCaptions(); });

  try{
    var obs = new MutationObserver(function(){ applyCaptions(); });
    obs.observe(document.body, { childList: true, subtree: true });
  }catch(e){}
})();
</script>