<?php
declare(strict_types=1);

/* ============================================================
   GUARDS, FALLBACKS E NORMALIZAÇÃO
   ============================================================ */
$translation = (isset($translation) && is_array($translation)) ? $translation : [];

/* Fallbacks de tradução usados nesta view */
$translation += [
  // Títulos/seções
  'tr_244' => 'Perfil',
  'tr_312' => 'Informações de cobrança',
  'tr_325' => 'Nome',
  'tr_356' => 'Nome de faturamento',
  'tr_357' => 'Endereço',
  'tr_358' => 'País',
  'tr_359' => 'Cidade',
  'tr_360' => 'CEP',
  'tr_361' => 'Telefone',
  'tr_362' => 'Empresa',
  'tr_363' => 'Documento fiscal',
  'tr_364' => 'Tipo de documento',
  'tr_456' => 'Salvar alterações',

  // Placeholders/aux
  'tr_save_success' => 'Dados atualizados com sucesso.',
  'tr_save_error'   => 'Não foi possível salvar no momento.',
];

/* Helper de saída segura */
if (!function_exists('echoEsc')) {
  function echoEsc(?string $s): void {
    echo htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}

/* Normaliza $userBilling para ARRAY, independente da origem */
$ubRaw = $userBilling ?? null;
if (is_string($ubRaw) && $ubRaw !== '') {
  // Caso algum controller tenha enviado a string JSON diretamente
  $tmp = json_decode($ubRaw, true);
  if (json_last_error() === JSON_ERROR_NONE) {
    $ubRaw = $tmp;
  }
}
if (is_object($ubRaw)) {
  $ub = get_object_vars($ubRaw);
} elseif (is_array($ubRaw)) {
  $ub = $ubRaw;
} else {
  $ub = [];
}

/* Helper para obter valor de billing com fallback */
if (!function_exists('ubv')) {
  function ubv(string $key, string $default = ''): string {
    $arr = $GLOBALS['ub'] ?? [];
    $val = $arr[$key] ?? $default;
    return is_scalar($val) ? (string)$val : $default;
  }
}

/* Alguns campos comuns, já prontos */
$bill_name     = ubv('user_billing_name');
$bill_address  = ubv('user_billing_address');
$bill_country  = ubv('user_billing_country');
$bill_city     = ubv('user_billing_city');
$bill_zip      = ubv('user_billing_zip');
$bill_phone    = ubv('user_billing_phone');
$bill_company  = ubv('user_billing_company');
$bill_tax_id   = ubv('user_billing_tax_id');
$bill_doc_type = ubv('user_billing_doc_type'); // caso exista
?>

<?php require 'menu.php'; ?>

<div class="content-padder uk-background-muted">

  <div class="uk-section-small">
    <div class="uk-container uk-container-large">

      <!-- TÍTULO -->
      <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
        <h3 class="uk-heading-line uk-text-bold">
          <span><?php echoEsc($translation['tr_244']); ?></span>
        </h3>

        <!-- BLOCO: INFORMAÇÕES DE COBRANÇA -->
        <h4 class="uk-margin-remove-top uk-margin-medium-bottom">
          <?php echoEsc($translation['tr_312']); ?>
        </h4>

        <form class="uk-form-stacked" method="post" action="profile.php">
          <div class="uk-grid-small" uk-grid>
            <div class="uk-width-1-2@s">
              <label class="uk-form-label"><?php echoEsc($translation['tr_356']); ?></label>
              <div class="uk-form-controls">
                <input class="uk-input" type="text" name="user_billing_name" value="<?php echoEsc($bill_name); ?>" placeholder="<?php echoEsc($translation['tr_325']); ?>">
              </div>
            </div>

            <div class="uk-width-1-2@s">
              <label class="uk-form-label"><?php echoEsc($translation['tr_361']); ?></label>
              <div class="uk-form-controls">
                <input class="uk-input" type="text" name="user_billing_phone" value="<?php echoEsc($bill_phone); ?>" placeholder="+55 11 99999-9999">
              </div>
            </div>

            <div class="uk-width-1-1">
              <label class="uk-form-label"><?php echoEsc($translation['tr_357']); ?></label>
              <div class="uk-form-controls">
                <input class="uk-input" type="text" name="user_billing_address" value="<?php echoEsc($bill_address); ?>" placeholder="Rua, número, complemento">
              </div>
            </div>

            <div class="uk-width-1-2@s">
              <label class="uk-form-label"><?php echoEsc($translation['tr_359']); ?></label>
              <div class="uk-form-controls">
                <input class="uk-input" type="text" name="user_billing_city" value="<?php echoEsc($bill_city); ?>" placeholder="Cidade">
              </div>
            </div>

            <div class="uk-width-1-4@s">
              <label class="uk-form-label"><?php echoEsc($translation['tr_360']); ?></label>
              <div class="uk-form-controls">
                <input class="uk-input" type="text" name="user_billing_zip" value="<?php echoEsc($bill_zip); ?>" placeholder="CEP">
              </div>
            </div>

            <div class="uk-width-1-4@s">
              <label class="uk-form-label"><?php echoEsc($translation['tr_358']); ?></label>
              <div class="uk-form-controls">
                <input class="uk-input" type="text" name="user_billing_country" value="<?php echoEsc($bill_country); ?>" placeholder="Brasil">
              </div>
            </div>

            <div class="uk-width-1-2@s">
              <label class="uk-form-label"><?php echoEsc($translation['tr_362']); ?></label>
              <div class="uk-form-controls">
                <input class="uk-input" type="text" name="user_billing_company" value="<?php echoEsc($bill_company); ?>" placeholder="Empresa (opcional)">
              </div>
            </div>

            <div class="uk-width-1-4@s">
              <label class="uk-form-label"><?php echoEsc($translation['tr_364']); ?></label>
              <div class="uk-form-controls">
                <input class="uk-input" type="text" name="user_billing_doc_type" value="<?php echoEsc($bill_doc_type); ?>" placeholder="CPF/CNPJ">
              </div>
            </div>

            <div class="uk-width-1-4@s">
              <label class="uk-form-label"><?php echoEsc($translation['tr_363']); ?></label>
              <div class="uk-form-controls">
                <input class="uk-input" type="text" name="user_billing_tax_id" value="<?php echoEsc($bill_tax_id); ?>" placeholder="000.000.000-00">
              </div>
            </div>
          </div>

          <div class="uk-margin-top">
            <button class="uk-button uk-button-primary uk-border-rounded" type="submit" name="save_billing" value="1">
              <?php echoEsc($translation['tr_456']); ?>
            </button>
          </div>
        </form>
      </div>

    </div>
  </div>
</div>
