<?php include $_SERVER['DOCUMENT_ROOT'] . '/partials/lang-switch.php'; ?>
<?php
// Fallbacks de tradução específicos desta view
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  'tr_seller_signup_title' => $translation['tr_seller_signup_title'] ?? 'Criar conta de anunciante',
  'tr_seller_signup_sub'   => $translation['tr_seller_signup_sub']   ?? 'Cadastre-se para anunciar suas ofertas.',
  'tr_fullname'            => $translation['tr_fullname']            ?? 'Nome completo',
  'tr_email'               => $translation['tr_email']               ?? 'E-mail',
  'tr_password'            => $translation['tr_password']            ?? 'Senha',
  'tr_password_confirm'    => $translation['tr_password_confirm']    ?? 'Confirmar senha',
  'tr_store_name'          => $translation['tr_store_name']          ?? 'Nome da loja',
  'tr_store_desc'          => $translation['tr_store_desc']          ?? 'Descrição da loja',
  'tr_store_website'       => $translation['tr_store_website']       ?? 'Site da loja (opcional)',
  'tr_btn_create_account'  => $translation['tr_btn_create_account']  ?? 'Criar conta',
  'tr_have_account'        => $translation['tr_have_account']        ?? 'Já tem uma conta?',
  'tr_go_login'            => $translation['tr_go_login']            ?? 'Ir para o login',
];

$name          = isset($name) ? (string)$name : '';
$email         = isset($email) ? (string)$email : '';
$store_title   = isset($store_title) ? (string)$store_title : '';
$store_desc    = isset($store_desc) ? (string)$store_desc : '';
$store_website = isset($store_website) ? (string)$store_website : '';
$errors        = isset($errors) && is_array($errors) ? $errors : [];
?>
<div class="uk-height-1-1">
  <div class="uk-flex uk-flex-center uk-flex-middle uk-height-1-1" uk-grid>
    <div class="uk-width-1-1">
      <div class="uk-section uk-section-muted uk-flex uk-flex-middle uk-animation-fade">
        <div class="uk-width-1-1">
          <div class="uk-container">

            <div class="uk-grid-match" uk-grid>
              <div class="uk-width-1-1@s uk-width-1-5@l uk-width-1-3@xl"></div>

              <div class="uk-width-1-1@s uk-width-4-5@l uk-width-3-5@xl">
                <div class="uk-card uk-card-default uk-card-body uk-border-rounded">
                  <h3 class="uk-card-title uk-text-bold uk-text-center">
                    <?php echo echoOutput($translation['tr_seller_signup_title']); ?>
                  </h3>
                  <p class="uk-text-center uk-text-muted">
                    <?php echo echoOutput($translation['tr_seller_signup_sub']); ?>
                  </p>

                  <center>
                    <a href="<?php echo $urlPath->home(); ?>">
                      <img class="uk-logo-small" src="<?php echo $urlPath->image($theme['th_logo']); ?>">
                    </a>
                    <br />
                  </center>

                  <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8'); ?>" method="post" class="uk-form-stacked">

                    
<fieldset class="uk-fieldset">

                      <div class="uk-grid-small" uk-grid>
                        <div class="uk-width-1-1@s uk-width-1-2@m">
                          <div class="uk-margin">
                            <label class="uk-form-label"><?php echo echoOutput($translation['tr_fullname']); ?></label>
                            <div class="uk-form-controls">
                              <input class="uk-input" type="text" name="name" value="<?php echo echoOutput($name); ?>" required>
                            </div>
                          </div>
                        </div>

                        <div class="uk-width-1-1@s uk-width-1-2@m">
                          <div class="uk-margin">
                            <label class="uk-form-label"><?php echo echoOutput($translation['tr_email']); ?></label>
                            <div class="uk-form-controls">
                              <input class="uk-input" type="email" name="email" value="<?php echo echoOutput($email); ?>" required>
                            </div>
                          </div>
                        </div>

                        <div class="uk-width-1-1@s uk-width-1-2@m">
                          <div class="uk-margin">
                            <label class="uk-form-label"><?php echo echoOutput($translation['tr_password']); ?></label>
                            <div class="uk-form-controls">
                              <input class="uk-input" type="password" name="password" required>
                            </div>
                          </div>
                        </div>

                        <div class="uk-width-1-1@s uk-width-1-2@m">
                          <div class="uk-margin">
                            <label class="uk-form-label"><?php echo echoOutput($translation['tr_password_confirm']); ?></label>
                            <div class="uk-form-controls">
                              <input class="uk-input" type="password" name="password2" required>
                            </div>
                          </div>
                        </div>
                      </div>

                      <hr class="uk-margin">


                      <div class="uk-margin">
                        <label class="uk-form-label"><?php echo echoOutput($translation['tr_store_name']); ?></label>
                        <div class="uk-form-controls">
                          <input class="uk-input" type="text" name="store_title" value="<?php echo echoOutput($store_title); ?>" required>
                        </div>
                      </div>

                      <div class="uk-margin">
                        <label class="uk-form-label"><?php echo echoOutput($translation['tr_store_desc']); ?></label>
                        <div class="uk-form-controls">
                          <textarea class="uk-textarea" name="store_desc" rows="3" placeholder="Ex: descrição breve da loja"><?php echo echoOutput($store_desc); ?></textarea>
                        </div>
                      </div>

                      <div class="uk-margin">
                        <label class="uk-form-label"><?php echo echoOutput($translation['tr_store_website']); ?></label>
                        <div class="uk-form-controls">
                          <input class="uk-input" type="url" name="store_website" value="<?php echo echoOutput($store_website); ?>" placeholder="https://minhaloja.com.br">
                        </div>
                      </div>

                      <div class="uk-margin">
                        <button class="uk-button uk-button-primary uk-border-rounded uk-button-large uk-width-1-1" type="submit">
                          <span uk-icon="sign-in"></span>&nbsp; <?php echo echoOutput($translation['tr_btn_create_account']); ?>
                        </button>
                      </div>

                      <?php if (!empty($errors)): ?>
                        <div class="uk-alert-danger uk-margin" uk-alert>
                          <a class="uk-alert-close" uk-close></a>
                          <ul class="uk-list">
                            <?php foreach ($errors as $err): ?>
                              <li><?php echo echoOutput($err); ?></li>
                            <?php endforeach; ?>
                          </ul>
                        </div>
                      <?php endif; ?>

                      <hr />

                      <center>
                        <p><?php echo echoOutput($translation['tr_have_account']); ?></p>
                        <a href="login.php" class="uk-button uk-button-default uk-border-rounded uk-margin-small-bottom">
                          <span uk-icon="arrow-left"></span>&nbsp; <?php echo echoOutput($translation['tr_go_login']); ?>
                        </a>
                        <br />
                        <a href="<?php echo $urlPath->home(); ?>" class="uk-button uk-button-default uk-border-rounded uk-margin-small-top">
                          &larr; <?php echo echoOutput($translation['tr_47'] ?? 'Voltar ao site'); ?>
                        </a>
                      </center>

                    </fieldset>
                  </form>

                </div>
              </div>

              <div class="uk-width-1-1@s uk-width-1-5@l uk-width-1-3@xl"></div>
            </div>

          </div>
        </div>
      </div>

    </div>
  </div>
</div>
