<?php
// Vars esperadas: $stores, $filterStoreId, $start, $end, $summary, $topDeals, $hasEventsTable, $storeIds
//               : $overall, $topAssociates

$map = [];
foreach (($summary ?? []) as $row) {
  $map[(string)($row['event_name'] ?? '')] = $row;
}

$views  = (int)($map['view_deal']['total'] ?? 0);
$clicks = (int)($map['click_deal_link']['total'] ?? 0);
$copies = (int)($map['copy_coupon']['total'] ?? 0);

$ctr = ($views > 0) ? round(($clicks / $views) * 100, 1) : 0.0;
$copyRate = ($clicks > 0) ? round(($copies / $clicks) * 100, 1) : 0.0;
$copyRateView = ($views > 0) ? round(($copies / $views) * 100, 1) : 0.0;

function nd_pct($v): string {
  $s = number_format((float)$v, 1, ',', '.');
  return $s . '%';
}
?>
<?php require 'menu.php'; ?>

<div class="content-padder">
  <div class="uk-section-small uk-background-muted">
    <div class="uk-container uk-container-large uk-margin-bottom">

    <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-medium-bottom">
      <div>
        <h2 class="uk-margin-remove">Relatórios</h2>
        <div class="uk-text-meta">Acompanhe visualizações, cliques e engajamento das suas ofertas.</div>
      </div>
      <div class="uk-visible@m">
        <a class="uk-button uk-button-default" href="reports_export_csv.php?store_id=<?php echo (int)($filterStoreId ?? 0); ?>&from=<?php echo htmlspecialchars($start->format('Y-m-d'), ENT_QUOTES, 'UTF-8'); ?>&to=<?php echo htmlspecialchars($end->format('Y-m-d'), ENT_QUOTES, 'UTF-8'); ?>">
          <span uk-icon="download"></span> Baixar CSV
        </a>
      </div>
    </div>

    <!-- Mini-resumo (vendável) -->
    <div class="uk-card uk-card-primary uk-card-body uk-border-rounded uk-margin-bottom" style="padding:16px 18px;">
      <div class="uk-flex uk-flex-middle uk-flex-between" uk-grid>
        <div class="uk-width-expand@m">
          <div class="uk-text-bold" style="font-size:16px;">
            Seu plano gerou <span style="font-size:18px;"><?php echo (int)($mtd['clicks'] ?? 0); ?></span> cliques no CTA este mês.
          </div>
          <div class="uk-text-small" style="opacity:.9;">
            Mês atual: <?php echo (int)($mtd['views'] ?? 0); ?> visualizações • <?php echo (int)($mtd['copies'] ?? 0); ?> cupons copiados
          </div>
        </div>
        <div class="uk-width-auto@m uk-visible@m">
          <a class="uk-button uk-button-default uk-border-rounded" href="submissions.php">Criar nova oferta</a>
        </div>
      </div>
    </div>

    <?php if (!empty($publicReportError)): ?>
      <div class="uk-alert-warning" uk-alert>
        <p class="uk-margin-remove"><?php echo htmlspecialchars((string)$publicReportError, ENT_QUOTES, 'UTF-8'); ?></p>
      </div>
    <?php endif; ?>

    <?php if (!empty($publicReportUrl)): ?>
      <div class="uk-alert-success" uk-alert>
        <div class="uk-flex uk-flex-middle uk-flex-between" uk-grid>
          <div class="uk-width-expand@m">
            <div class="uk-text-bold">Link público do relatório (sem login)</div>
            <div class="uk-text-small uk-text-muted">Envie no WhatsApp para o anunciante: ele verá os números da loja.</div>
            <div class="uk-margin-small-top">
              <input id="nd_public_report_url" class="uk-input" type="text" readonly value="<?php echo htmlspecialchars((string)$publicReportUrl, ENT_QUOTES, 'UTF-8'); ?>">
            </div>
          </div>
          <div class="uk-width-auto@m">
            <button class="uk-button uk-button-primary uk-border-rounded" type="button" onclick="window.NDcopyPublicReport && NDcopyPublicReport();">
              Copiar
            </button>
          </div>
        </div>
      </div>
      <script>
        window.NDcopyPublicReport = function(){
          var el = document.getElementById('nd_public_report_url');
          if (!el) return;
          el.focus(); el.select();
          try {
            if (navigator.clipboard && navigator.clipboard.writeText) {
              navigator.clipboard.writeText(el.value);
            } else {
              document.execCommand('copy');
            }
          } catch (e) {}
          UIkit && UIkit.notification && UIkit.notification({message: 'Link copiado!', status: 'success'});
        }
      </script>
    <?php endif; ?>

    <?php if (!$hasEventsTable): ?>
      <div class="uk-alert-warning" uk-alert>
        <p class="uk-margin-remove">
          Ainda não encontrei a tabela <code>nd_events</code> no banco.
          Rode o arquivo <code>nd_events_migration.sql</code> (na raiz do site) para ativar os relatórios.
        </p>
      </div>
    <?php elseif (empty($storeIds)): ?>
      <div class="uk-alert-primary" uk-alert>
        <p class="uk-margin-remove">Você ainda não tem nenhuma loja cadastrada vinculada à sua conta.</p>
      </div>
    <?php endif; ?>

    <div class="uk-card uk-card-default uk-card-body uk-margin-medium-bottom">
      <form class="uk-grid-small" uk-grid method="get" action="">
        <div class="uk-width-1-1 uk-width-1-3@m">
          <label class="uk-form-label">Loja</label>
          <div class="uk-form-controls">
            <select class="uk-select" name="store_id">
              <option value="0">Todas as lojas</option>
              <?php foreach (($stores ?? []) as $s): ?>
                <?php $sid = (int)($s['store_id'] ?? 0); ?>
                <option value="<?php echo $sid; ?>" <?php echo ($filterStoreId === $sid ? 'selected' : ''); ?>>
                  <?php echo htmlspecialchars((string)($s['store_title'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>
        </div>

        <div class="uk-width-1-2 uk-width-1-4@m">
          <label class="uk-form-label">De</label>
          <input class="uk-input" type="date" name="from" value="<?php echo htmlspecialchars($start->format('Y-m-d'), ENT_QUOTES, 'UTF-8'); ?>">
        </div>

        <div class="uk-width-1-2 uk-width-1-4@m">
          <label class="uk-form-label">Até</label>
          <input class="uk-input" type="date" name="to" value="<?php echo htmlspecialchars($end->format('Y-m-d'), ENT_QUOTES, 'UTF-8'); ?>">
        </div>

        <div class="uk-width-1-1 uk-width-1-6@m uk-flex uk-flex-middle">
          <button class="uk-button uk-button-primary uk-width-1-1" type="submit" style="margin-top:24px;">Filtrar</button>
        </div>

        <div class="uk-hidden@m uk-width-1-1">
          <a class="uk-button uk-button-default uk-width-1-1" href="reports_export_csv.php?store_id=<?php echo (int)($filterStoreId ?? 0); ?>&from=<?php echo htmlspecialchars($start->format('Y-m-d'), ENT_QUOTES, 'UTF-8'); ?>&to=<?php echo htmlspecialchars($end->format('Y-m-d'), ENT_QUOTES, 'UTF-8'); ?>">
            <span uk-icon="download"></span> Baixar CSV
          </a>
        </div>
      </form>

      <!-- Link público do relatório (por loja) -->
      <hr class="uk-margin-medium-top uk-margin-medium-bottom" />
      <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
        <div class="uk-width-expand@m">
          <div class="uk-text-bold">Link público (por loja)</div>
          <div class="uk-text-small uk-text-muted">
            Selecione uma loja acima e gere um link para enviar no WhatsApp (o anunciante não precisa logar).
          </div>
        </div>
        <div class="uk-width-auto@m">
          <form method="post" action="" class="uk-display-inline">
            <input type="hidden" name="nd_public_link" value="1" />
            <input type="hidden" name="store_id" value="<?php echo (int)($filterStoreId ?? 0); ?>" />
            <button class="uk-button uk-button-default uk-border-rounded" type="submit" <?php echo ((int)($filterStoreId ?? 0) <= 0 ? 'disabled' : ''); ?>>Gerar link</button>
          </form>
          <form method="post" action="" class="uk-display-inline uk-margin-small-left">
            <input type="hidden" name="nd_public_link" value="1" />
            <input type="hidden" name="regenerate" value="1" />
            <input type="hidden" name="store_id" value="<?php echo (int)($filterStoreId ?? 0); ?>" />
            <button class="uk-button uk-button-text" type="submit" <?php echo ((int)($filterStoreId ?? 0) <= 0 ? 'disabled' : ''); ?>>Regenerar</button>
          </form>
        </div>
      </div>
    </div>

    <div class="uk-grid-small uk-child-width-1-1 uk-child-width-1-2@m uk-child-width-1-4@l" uk-grid>
      <div>
        <div class="uk-card uk-card-default uk-card-body">
          <div class="uk-text-meta">Visualizações</div>
          <div class="uk-text-large uk-text-bold"><?php echo $views; ?></div>
          <div class="uk-text-meta">Ofertas abertas no período</div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-body">
          <div class="uk-text-meta">Cliques no CTA</div>
          <div class="uk-text-large uk-text-bold"><?php echo $clicks; ?></div>
          <div class="uk-text-meta">Cliques para visitar / comprar</div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-body">
          <div class="uk-text-meta">CTR (cliques / views)</div>
          <div class="uk-text-large uk-text-bold"><?php echo nd_pct($ctr); ?></div>
          <div class="uk-text-meta">Efetividade do CTA</div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-body">
          <div class="uk-text-meta">Cópias de cupom</div>
          <div class="uk-text-large uk-text-bold"><?php echo $copies; ?></div>
          <div class="uk-text-meta">Quando o cliente copia o código</div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-body">
          <div class="uk-text-meta">Taxa de cupom</div>
          <div class="uk-text-large uk-text-bold"><?php echo nd_pct($copyRate); ?></div>
          <div class="uk-text-meta">Cópias / cliques</div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-body">
          <div class="uk-text-meta">Sessões únicas</div>
          <div class="uk-text-large uk-text-bold"><?php echo (int)($overall['sessions'] ?? 0); ?></div>
          <div class="uk-text-meta">Visitantes únicos aproximados</div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-body">
          <div class="uk-text-meta">Associados únicos</div>
          <div class="uk-text-large uk-text-bold"><?php echo (int)($overall['associates'] ?? 0); ?></div>
          <div class="uk-text-meta">Associados que geraram eventos</div>
        </div>
      </div>

      <div>
        <div class="uk-card uk-card-default uk-card-body">
          <div class="uk-text-meta">Taxa cupom / views</div>
          <div class="uk-text-large uk-text-bold"><?php echo nd_pct($copyRateView); ?></div>
          <div class="uk-text-meta">Indicador de intenção</div>
        </div>
      </div>
    </div>

    <div class="uk-card uk-card-default uk-card-body uk-margin-large-top">
      <h3 class="uk-margin-remove-bottom">Top ofertas (período)</h3>
      <div class="uk-text-meta uk-margin-small-top">Ordenado por cliques no CTA e visualizações.</div>

      <div class="uk-overflow-auto uk-margin-medium-top">
        <table class="uk-table uk-table-divider uk-table-middle">
          <thead>
            <tr>
              <th>Oferta</th>
              <th class="uk-text-right">Views</th>
              <th class="uk-text-right">Cliques</th>
              <th class="uk-text-right">CTR</th>
              <th class="uk-text-right">Cupom copiado</th>
            </tr>
          </thead>
          <tbody>
          <?php if (empty($topDeals)): ?>
            <tr><td colspan="5" class="uk-text-center uk-text-meta">Sem dados no período selecionado.</td></tr>
          <?php else: ?>
            <?php foreach ($topDeals as $d): ?>
              <?php
                $dv = (int)($d['views'] ?? 0);
                $dc = (int)($d['clicks'] ?? 0);
                $dctr = ($dv > 0) ? round(($dc / $dv) * 100, 1) : 0.0;
              ?>
              <tr>
                <td>
                  <div class="uk-text-bold"><?php echo htmlspecialchars((string)($d['deal_title'] ?? ('#' . (int)$d['deal_id'])), ENT_QUOTES, 'UTF-8'); ?></div>
                  <div class="uk-text-meta">ID: <?php echo (int)($d['deal_id'] ?? 0); ?></div>
                </td>
                <td class="uk-text-right"><?php echo $dv; ?></td>
                <td class="uk-text-right"><?php echo $dc; ?></td>
                <td class="uk-text-right"><?php echo nd_pct($dctr); ?></td>
                <td class="uk-text-right"><?php echo (int)($d['coupon_copies'] ?? 0); ?></td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="uk-text-meta">
        * Dica: use esses números para justificar ROI para o anunciante ("X cliques em Y dias") e ajustar o plano.
      </div>
    </div>

    <div class="uk-card uk-card-default uk-card-body uk-margin-large-top">
      <h3 class="uk-margin-remove-bottom">Top associados (período)</h3>
      <div class="uk-text-meta uk-margin-small-top">Quem mais gerou ações para suas ofertas.</div>

      <div class="uk-overflow-auto uk-margin-medium-top">
        <table class="uk-table uk-table-divider uk-table-middle">
          <thead>
            <tr>
              <th>Associado</th>
              <th>Local/Grupo</th>
              <th class="uk-text-right">Views</th>
              <th class="uk-text-right">Cliques</th>
              <th class="uk-text-right">CTR</th>
              <th class="uk-text-right">Cupom</th>
            </tr>
          </thead>
          <tbody>
          <?php if (empty($topAssociates)): ?>
            <tr><td colspan="6" class="uk-text-center uk-text-meta">Sem dados de associados no período.</td></tr>
          <?php else: ?>
            <?php foreach ($topAssociates as $a): ?>
              <?php
                $av = (int)($a['views'] ?? 0);
                $ac = (int)($a['clicks'] ?? 0);
                $actr = ($av > 0) ? round(($ac / $av) * 100, 1) : 0.0;
                $place = trim((string)($a['associate_city'] ?? ''));
                $state = trim((string)($a['associate_state'] ?? ''));
                $grp = trim((string)($a['associate_group'] ?? ''));
                $loc = $place;
                if ($state !== '') $loc = ($loc !== '' ? ($loc . ' / ' . $state) : $state);
                if ($grp !== '') $loc = ($loc !== '' ? ($loc . ' • ' . $grp) : $grp);
              ?>
              <tr>
                <td>
                  <div class="uk-text-bold"><?php echo htmlspecialchars((string)($a['associate_name'] ?? ('#' . (int)$a['associate_id'])), ENT_QUOTES, 'UTF-8'); ?></div>
                  <div class="uk-text-meta">ID: <?php echo (int)($a['associate_id'] ?? 0); ?></div>
                </td>
                <td><?php echo htmlspecialchars($loc !== '' ? $loc : '-', ENT_QUOTES, 'UTF-8'); ?></td>
                <td class="uk-text-right"><?php echo $av; ?></td>
                <td class="uk-text-right"><?php echo $ac; ?></td>
                <td class="uk-text-right"><?php echo nd_pct($actr); ?></td>
                <td class="uk-text-right"><?php echo (int)($a['coupon_copies'] ?? 0); ?></td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="uk-text-meta">
        * Dica: isso ajuda a premiar os melhores associados (por performance) e a reforçar a prova social do ecossistema.
      </div>
    </div>

    </div>
  </div>
</div>
