<?php
declare(strict_types=1);

/* ==== GUARDS: traduções, arrays e helpers ==== */
$translation   = (isset($translation)   && is_array($translation))   ? $translation   : [];
$userDetails   = (isset($userDetails)   && is_array($userDetails))   ? $userDetails   : [];
$sellerDetails = (isset($sellerDetails) && is_array($sellerDetails)) ? $sellerDetails : [];

/* Apenas as chaves realmente usadas aqui */
$translation += [
  'tr_241' => 'Minhas Lojas',
  'tr_274' => 'Nome da loja',
  'tr_276' => 'Descrição',
  'tr_443' => 'Website',
  'tr_371' => 'Logo',
  'tr_312' => 'Tamanho recomendado:',
  'tr_192' => 'Formatos permitidos: JPG, PNG, GIF.',
  'tr_291' => 'Salvar alterações',
  'tr_455' => 'Ver minha página',
];

/* Helper de saída (define só se não existir) */
if (!function_exists('echoOutput')) {
  function echoOutput($v){ echo htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

require 'menu.php';
?>

<div class="content-padder uk-background-muted">
<!-- ================= MINHAS LOJAS (multi-loja) ================= -->
  <div class="uk-section-small">
    <div class="uk-container uk-container-large">
      <?php if (!empty($storeErrors)): ?>
        <div class="tas-notify tas-notify-danger uk-border-rounded uk-margin">
          <ul class="uk-margin-remove">
            <?php foreach ($storeErrors as $er): ?><li><?php echo echoOutput($er); ?></li><?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <?php if (!empty($storeSuccess)): ?>
        <div class="tas-notify tas-notify-success uk-border-rounded uk-margin">
          <?php echo echoOutput($storeSuccess); ?>
        </div>
      <?php endif; ?>

      <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
        <h3 class="uk-heading-line uk-text-bold"><span><?php echo echoOutput(trf($translation,'tr_452','Minhas Lojas')); ?></span></h3>

        <!-- Novo cadastro -->
        <form class="uk-form-stacked" method="post" enctype="multipart/form-data">
          <input type="hidden" name="store_action" value="create">
          <div class="uk-grid-small" uk-grid>
            <div class="uk-width-1-2@s">
              <label class="uk-form-label">Nome da loja *</label>
              <input class="uk-input uk-border-rounded" type="text" name="store_title" required>
            </div>
            <div class="uk-width-1-2@s">
              <label class="uk-form-label">Descrição</label>
              <input class="uk-input uk-border-rounded" type="text" name="store_description">
            </div>
            <div class="uk-width-1-3@s">
              <label class="uk-form-label">Status</label>
              <select class="uk-select uk-border-rounded" name="store_status">
                <option value="1">Ativado</option>
                <option value="0">Desativado</option>
              </select>
            </div>
            <div class="uk-width-1-3@s">
              <label class="uk-form-label">Destaque</label>
              <select class="uk-select uk-border-rounded" name="store_featured">
                <option value="0">Não</option>
                <option value="1">Sim</option>
              </select>
            </div>
            <div class="uk-width-1-3@s">
              <label class="uk-form-label">Logo</label>
              <input class="uk-input uk-border-rounded" type="file" name="store_image" accept=".jpg,.jpeg,.png,.gif">
            </div>
          </div>
          <button class="uk-button uk-button-primary uk-border-rounded uk-margin-small-top" type="submit">Criar loja</button>
        </form>

        <hr class="uk-divider-icon">

        <!-- Lista de lojas -->
        <?php if (empty($myStores)): ?>
          <p>Você ainda não possui lojas. Crie a primeira acima.</p>
        <?php else: ?>
          <div class="uk-overflow-auto">
            
          <table class="uk-table uk-table-divider">
            <thead>
              <tr>
                <th>#</th>
                <th>Loja</th>
                <th>Ações</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($myStores as $st): ?>
                <tr>
                  <td><?php echo (int)($st['store_id'] ?? 0); ?></td>
                  <td>
                    <form method="post" enctype="multipart/form-data" class="uk-form-stacked">
                      <input type="hidden" name="store_action" value="update">
                      <input type="hidden" name="store_id" value="<?php echo (int)($st['store_id'] ?? 0); ?>">
                      <div class="uk-margin-small">
                        <input class="uk-input uk-border-rounded" type="text" name="store_title" value="<?php echo echoOutput($st['store_title'] ?? ''); ?>" placeholder="Nome da loja">
                      </div>
                      <div class="uk-margin-small">
                        <input class="uk-input uk-border-rounded" type="text" name="store_description" value="<?php echo echoOutput($st['store_description'] ?? ''); ?>" placeholder="Descrição (opcional)">
                      </div>
                      <div class="uk-grid-small" uk-grid>
                        <div class="uk-width-1-3@s">
                          <label class="uk-form-label uk-text-small">Status</label>
                          <select class="uk-select uk-border-rounded" name="store_status">
                            <option value="1" <?php echo !empty($st['store_status']) ? 'selected' : ''; ?>>Ativado</option>
                            <option value="0" <?php echo empty($st['store_status']) ? 'selected' : ''; ?>>Desativado</option>
                          </select>
                        </div>
                        <div class="uk-width-1-3@s">
                          <label class="uk-form-label uk-text-small">Destaque</label>
                          <select class="uk-select uk-border-rounded" name="store_featured">
                            <option value="0" <?php echo empty($st['store_featured']) ? 'selected' : ''; ?>>Não</option>
                            <option value="1" <?php echo !empty($st['store_featured']) ? 'selected' : ''; ?>>Sim</option>
                          </select>
                        </div>
                        <div class="uk-width-1-3@s">
                          <label class="uk-form-label uk-text-small">Logo</label>
                          <input class="uk-input uk-border-rounded" type="file" name="store_image" accept=".jpg,.jpeg,.png,.gif">
                          <?php if (!empty($st['store_image'])): ?>
                            <div class="uk-margin-small-top">
                              <img class="uk-border-rounded" src="<?php echo $urlPath->image($st['store_image']); ?>" alt="<?php echo echoOutput($st['store_title'] ?? ''); ?>" width="50" height="50">
                            </div>
                          <?php endif; ?>

                        </div>
                      </div>
                      <div class="uk-margin-small">
                        <span class="uk-text-meta">Slug: <?php echo echoOutput($st['store_slug'] ?? ''); ?></span>
                        <span class="uk-label <?php echo !empty($st['store_status']) ? 'uk-label-success' : 'uk-label-danger'; ?> uk-margin-small-left">
                          <?php echo !empty($st['store_status']) ? 'Ativo' : 'Inativo'; ?>
                        </span>
                      </div>
                      <button class="uk-button uk-button-primary uk-border-rounded uk-margin-small-top" type="submit">Salvar</button>
                    </form>
                  </td>
                  <td>
                    <form method="post" onsubmit="return confirm('Remover esta loja?');">
                      <input type="hidden" name="store_action" value="delete">
                      <input type="hidden" name="store_id" value="<?php echo (int)($st['store_id'] ?? 0); ?>">
                      <button class="uk-button uk-button-danger uk-border-rounded" type="submit">Excluir</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
