<?php
// --- GUARD de tradução que faltava nesse arquivo ---
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  // Fallbacks necessários nesta view
  'tr_245' => 'Novo item',
  'tr_240' => 'Envios',
  'tr_258' => 'Imagem',
  'tr_259' => 'Título',
  'tr_260' => 'Cliques',
  'tr_261' => 'Preço',
  'tr_262' => 'Status',
  'tr_108' => 'Ações',
  'tr_250' => 'Ativo',
  'tr_251' => 'Pendente',
  'tr_252' => 'Em revisão',
  'tr_266' => 'Rejeitado',
  'tr_366' => 'itens',
];
?>
<?php

// --- GUARD de tradução que faltava nesse arquivo ---
$translation = (isset($translation) && is_array($translation)) ? $translation : [];
$translation += [
  // usado na coluna de status quando deal_status == 5
  'tr_447' => 'Pendente',
];
?>
<?php require 'menu.php'; ?>

<div class="content-padder">

    <div class="uk-section-small">
        <div class="uk-container uk-container-large">  

                <div class="uk-margin-bottom uk-flex uk-flex-middle" uk-grid>

                        <?php if(!empty($userPlanSettings)): ?>
                        <?php
                          $planTotal = isset($userPlanSettings['plan_total']) ? (int)$userPlanSettings['plan_total'] : 0;
                          $planUsed  = isset($userPlanSettings['plan_used']) ? (int)$userPlanSettings['plan_used'] : 0;
                          $unlimited = ($planTotal <= 0);
                          if ($unlimited) {
                            $planLabelMain = 'Envios ilimitados';
                            $planSubLabel  = 'Você pode criar quantos itens quiser.';
                            $progressMax   = 1;
                            $progressVal   = 1;
                          } else {
                            $planRemaining = max(0, $planTotal - $planUsed);
                            $planLabelMain = $planRemaining . ' ' . ($translation['tr_365'] ?? $translation['tr_366'] ?? 'itens restantes');
                            $planSubLabel  = 'Usados: ' . $planUsed . ' / ' . $planTotal;
                            $progressMax   = max(1, $planTotal);
                            $progressVal   = max(0, min($planUsed, $progressMax));
                          }
                        ?>
                        <div class="uk-width-auto uk-text-left">
                          <p class="uk-margin-remove uk-text-bold"><?php echo echoOutput($planLabelMain); ?></p>
                          <p class="uk-margin-remove uk-text-small uk-text-muted"><?php echo echoOutput($planSubLabel); ?></p>
                          <progress style="height: 8px;" class="uk-progress uk-margin-small-top" value="<?php echo $progressVal; ?>" max="<?php echo $progressMax; ?>"></progress>
                        </div>
                        <?php endif; ?>


                        <div class="uk-width-expand uk-text-right">
                        <a class="uk-button uk-button-secondary uk-text-capitalize uk-border-rounded" href="new_item.php">
                        <i uk-icon="icon: plus"></i>
                        <span class="uk-visible@s"><?php echo echoOutput($translation['tr_245']); ?></span>
                        </a>
                        </div>
                </div>

            <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">

            
<h3 class="uk-heading-line uk-text-bold"><span><?php echo echoOutput($translation['tr_240']); ?></span></h3>

                                <div class="uk-alert-primary uk-border-rounded uk-padding-small uk-margin-small-top" uk-alert>
                                  <p class="uk-margin-small">
                                    <?php
                                      $planName = '';
                                      if (!empty($userPlanSettings) && isset($userPlanSettings['plan_title'])) {
                                        $planName = $userPlanSettings['plan_title'];
                                      }
                                    ?>
                                    <?php if($planName): ?>
                                      <strong>Você está no plano <?php echo htmlspecialchars($planName, ENT_QUOTES, 'UTF-8'); ?>.</strong><br>
                                    <?php endif; ?>
                                    <strong>Limites do seu plano:</strong><br>
                                    <?php if(isset($userRemainingDeals)): ?>
                                      • Você ainda pode ativar
                                        <strong><?php echo ($userRemainingDeals === PHP_INT_MAX ? 'ofertas ilimitadas' : (int)$userRemainingDeals . ' oferta(s)'); ?></strong>.<br>
                                    <?php endif; ?>
                                    <?php if(isset($userRemainingFeatured)): ?>
                                      • Destaques disponíveis:
                                        <strong><?php echo ($userRemainingFeatured === PHP_INT_MAX ? 'ilimitados' : (int)$userRemainingFeatured); ?></strong>.<br>
                                    <?php endif; ?>
                                    <?php if(isset($userRemainingExclusive)): ?>
                                      • Ofertas exclusivas disponíveis:
                                        <strong><?php echo ($userRemainingExclusive === PHP_INT_MAX ? 'ilimitadas' : (int)$userRemainingExclusive); ?></strong>.
                                    <?php endif; ?>
                                  </p>
                                </div>


                                
                                <div class="uk-overflow-auto">
<table id="table_id" class="uk-table uk-table-middle uk-table-divider" style="width: 100%">

                                <thead>
                                <tr>
                                    <th><?php echo echoOutput($translation['tr_258']); ?></th>
                                    <th><?php echo echoOutput($translation['tr_259']); ?></th>
                                    <th><?php echo echoOutput($translation['tr_260']); ?></th>
                                    <th><?php echo echoOutput($translation['tr_261']); ?></th>
                                    <th><?php echo echoOutput($translation['tr_262']); ?></th>
                                    <th><?php echo echoOutput($translation['tr_108']); ?></th>
                                </tr>
                                </thead>
                                </table>
</div>

            </div></div></div></div>

        <script>
            'use strict';
            $(document).ready(function(){

                // evita reinicialização
                if ($.fn.DataTable.isDataTable('#table_id')) {
                  $('#table_id').DataTable().destroy();
                  $('#table_id').empty();
                }
            
                $('#table_id').DataTable({
                  language: (window.DT_LANG_PTBR || {}), // <- PT-BR
                  bProcessing: true,
                  sAjaxSource: SITEURL+"/dashboard/data.php?type=submissions",
                  responsive: true,
                  scrollX: true,
                  bPaginate:true,
                  sPaginationType:"simple_numbers",
                  iDisplayLength: 10,
                  lengthChange: false,
                  /*"language": { search: "" },*/
                  fnCreatedRow: function( nRow, data ) {
                    $(nRow).addClass("id-"+data.deal_id);
                  },
                  aoColumns: [
                    { mData: null , width: "10%", className: "uk-text-center", orderable: false, searchable: false,
                      mRender : function (data) {
                        return '<a href="item.php?id='+data.deal_id+'"><img src="'+IMAGES_FOLDER+data.deal_image+'" class="uk-border-rounded"/></a>';
                      }
                    },
                    { mData: null,
                      mRender : function (data) {
                        return '<a href="item.php?id='+data.deal_id+'" class="uk-link-reset">'+data.deal_title+'</a>';
                      }
                    },
                    { mData: null,
                      mRender : function (data) {
                        return '<span>'+formatCount(data.deal_clicks)+'</span>';
                      }
                    },
                    { mData: null , width: "5%", className:"uk-text-center",
                      mRender : function (data) {
                        return '<span>'+formatPrice(data.deal_price, "<?php echo $settings['st_currency']; ?>", "<?php echo $settings['st_currencyposition']; ?>", "<?php echo $settings['st_decimalnumber']; ?>", "<?php echo $settings['st_decimalseparator']; ?>")+'</span>';
                      }
                    },
                    { mData: null , width: "5%", className:"status uk-text-center",
                      mRender : function (data) {
                        if (data.deal_status == 1) {
                            return '<span class="uk-label uk-label-success"><?php echo echoOutput($translation['tr_250']); ?></span>';
                        }else if (data.deal_status == 2) {
                            return '<span class="uk-label uk-label-warning"><?php echo echoOutput($translation['tr_251']); ?></span>';
                        }else if (data.deal_status == 3) {
                            return '<span class="uk-label uk-label-warning"><?php echo echoOutput($translation['tr_252']); ?></span>';
                        }else if (data.deal_status == 4) {
                            return '<span class="uk-label uk-label-danger"><?php echo echoOutput($translation['tr_266']); ?></span>';
                        }else if (data.deal_status == 5) {
                            return '<span class="uk-label uk-label-warning"><?php echo echoOutput($translation['tr_447']); ?></span>';
                        }
                      }
                    },
                    { mData: null , width: "14%", className:"uk-text-center", orderable: false, searchable: false,
                      mRender : function (data) {
                        if (data.deal_status == 4) {
                          return null;
                        }else if (data.deal_status == 2) {
                          return '<div class="uk-flex uk-flex-center" uk-margin><a class="enableItem uk-text-success" uk-tooltip="Enable" uk-icon="check" data-url="enable_item.php?id='+data.deal_id+'"></a></div>';
                        }else{
                          return '<div class="uk-flex uk-flex-center" uk-margin><a class="uk-link-muted" uk-tooltip="View" uk-icon="file-text" href="item.php?id='+data.deal_id+'"></a> <a class="uk-text-primary" uk-tooltip="Edit" uk-icon="file-edit" href="edit_item.php?id='+data.deal_id+'"></a> <a class="disableItem uk-text-warning" uk-tooltip="Disable" uk-icon="ban" data-url="disable_item.php?id='+data.deal_id+'"></a></div>';
                        }
                      }
                    }
                  ]
                });

            });
        </script>