<?php
declare(strict_types=1);
/**
 * diag_bootstrap.php
 * Força log detalhado e um handler visível.
 * Incluir como primeiro require em páginas que você quer diagnosticar.
 */
@ini_set('display_errors', '0');
@ini_set('log_errors', '1');
@ini_set('error_reporting', (string)E_ALL);
@error_reporting(E_ALL);

$__diag_log = __DIR__ . '/_diag.log';
@ini_set('error_log', $__diag_log);

/** Cabeçalho de diagnóstico (útil no DevTools->Network->Response Headers) */
header('X-Diag-Bootstrap: 1');
header('X-PHP-Version: ' . PHP_VERSION);
header('X-Req-URI: ' . ($_SERVER['REQUEST_URI'] ?? ''));

function __diag_log(string $msg): void {
  $ts = date('Y-m-d H:i:s');
  $line = "[$ts] $msg\n";
  error_log($line);
}

set_exception_handler(function(Throwable $e){
  __diag_log('UNCAUGHT EXCEPTION: ' . get_class($e) . ' ' . $e->getMessage() . ' @ ' . $e->getFile() . ':' . $e->getLine());
  http_response_code(500);
  header('Content-Type: text/plain; charset=utf-8');
  echo "DIAG: Uncaught " . get_class($e) . " @ " . $e->getFile() . ":" . $e->getLine() . "\n";
  echo "Msg: " . $e->getMessage() . "\n";
  echo "Trace:\n" . $e->getTraceAsString();
  exit;
});

set_error_handler(function(int $severity, string $message, string $file = '', int $line = 0){
  // Converte tudo para log e segue a execução
  __diag_log("PHP ERROR [$severity] $message @ $file:$line");
  return true;
});

register_shutdown_function(function(){
  $err = error_get_last();
  if ($err) {
    __diag_log("SHUTDOWN: type {$err['type']} {$err['message']} @ {$err['file']}:{$err['line']}");
  } else {
    __diag_log("SHUTDOWN: normal");
  }
});
