<?php

declare(strict_types=1);
/**
 * diag_router.php
 * Mostra como a requisição chega no PHP e algumas variáveis úteis.
 * Coloque em /admin/controller/ ou na raiz e acesse diretamente.
 */
require_once __DIR__ . '/diag_bootstrap.php';
header('Content-Type: text/plain; charset=utf-8');

echo "== DIAG ROUTER ==\n";
printf("SCRIPT_FILENAME: %s\n", $_SERVER['SCRIPT_FILENAME'] ?? '');
printf("SCRIPT_NAME:     %s\n", $_SERVER['SCRIPT_NAME'] ?? '');
printf("PHP_SELF:        %s\n", $_SERVER['PHP_SELF'] ?? '');
printf("REQUEST_URI:     %s\n", $_SERVER['REQUEST_URI'] ?? '');
printf("QUERY_STRING:    %s\n", $_SERVER['QUERY_STRING'] ?? '');
printf("DOCUMENT_ROOT:   %s\n", $_SERVER['DOCUMENT_ROOT'] ?? '');
printf("HTTP_HOST:       %s\n", $_SERVER['HTTP_HOST'] ?? '');

$cwd = getcwd();
printf("getcwd():        %s\n", $cwd ?: '');

echo "\n-- GET --\n";
var_export($_GET);
echo "\n\n-- POST --\n";
var_export($_POST);

$root = dirname(__DIR__); // se estiver em /admin/controller, root = /admin
$root2 = dirname($root);  // tentativa de achar a raiz do site
echo "\n\n-- PATHS --\n";
printf("__DIR__:         %s\n", __DIR__);
printf("root guess 1:    %s\n", $root);
printf("root guess 2:    %s\n", $root2);

$routesFile1 = $root2 . '/routes.php';
$routesFile2 = $root . '/routes.php';
$routesFile3 = __DIR__ . '/routes.php';
echo "\n-- routes.php checks --\n";
foreach ([$routesFile1, $routesFile2, $routesFile3] as $f) {
  printf("%s : %s\n", $f, file_exists($f) ? 'OK' : 'MISSING');
}

echo "\n-- htaccess (if any) --\n";
foreach ([$root2.'/.htaccess', $root.'/.htaccess', __DIR__.'/.htaccess'] as $f) {
  printf("%s : %s\n", $f, file_exists($f) ? 'OK' : 'MISSING');
}

echo "\nDone.\n";
