<?php


declare(strict_types=1);
require "core.php";

/**
 * Guardas de i18n para evitar avisos em PHP 8+
 */
if (!isset($translation) || !is_array($translation)) { $translation = []; }
if (!isset($langStrings) || !is_array($langStrings)) { $langStrings = []; }

/**
 * Helper simples de tradução com fallback.
 * Busca em $translation, depois em $langStrings; se não achar, usa o default.
 */
if (!function_exists('t')) {
    function t(string $key, string $default = '') {
        global $translation, $langStrings;
        if (isset($translation[$key]) && $translation[$key] !== '') return $translation[$key];
        if (isset($langStrings[$key]) && $langStrings[$key] !== '') return $langStrings[$key];
        return $default;
    }
}

// SEO Title: título base + título específico da página de erro
$titleSeoHeader = getSeoTitle(
    t('tr_1', 'Erro'),
    t('tr_eptitle', 'Ocorreu um erro')
);

// SEO Description
$descriptionSeoHeader = getSeoDescription(
    t('tr_3', 'Ocorreu um erro ao processar sua solicitação.')
);

// Page Title (usado nas views)
$pageTitle = t('tr_eptitle', 'Ocorreu um erro');

include './header.php';
require './views/error.view.php';
include './footer.php';
