<?php
declare(strict_types=1);

require_once __DIR__ . '/core.php';

header('Content-Type: application/json; charset=utf-8');

try {
  // Aceita GET ou POST (beacon geralmente é POST com Content-Type text/plain ou form)
  $event = $_REQUEST['event'] ?? '';
  $event = is_string($event) ? trim($event) : '';

  $dealId  = isset($_REQUEST['deal_id']) ? (int)$_REQUEST['deal_id'] : null;
  $storeId = isset($_REQUEST['store_id']) ? (int)$_REQUEST['store_id'] : null;

  $coupon = $_REQUEST['coupon_code'] ?? null;
  if (!is_string($coupon)) $coupon = null;

  $meta = null;
  if (isset($_REQUEST['meta'])) {
    // meta pode vir como JSON string
    $m = $_REQUEST['meta'];
    if (is_string($m) && $m !== '') {
      $decoded = json_decode($m, true);
      if (is_array($decoded)) $meta = $decoded;
    }
  }

  if (!isset($connect) || !$connect) {
    $connect = connect();
  }

  if (function_exists('nd_track_event')) {
    nd_track_event($connect, (string)$event, [
      'deal_id'      => $dealId,
      'store_id'     => $storeId,
      'coupon_code'  => $coupon,
      'meta'         => is_array($meta) ? $meta : null,
    ]);
  }

  echo json_encode(['ok' => true], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} catch (Throwable $e) {
  http_response_code(200);
  echo json_encode(['ok' => false], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
}
