<?php

declare(strict_types=1);
header('Content-Type: text/plain; charset=utf-8');
$base = __DIR__;
$targets = [
  'core.php',
  'index.php',
  'admin/functions.php',
];

foreach ($targets as $rel) {
    $p = $base . '/' . $rel;
    if (!file_exists($p)) {
        echo "[MISS] $rel (file not found)\n";
        continue;
    }
    $real = realpath($p);
    $md5  = md5_file($p);
    $mtime= date('c', filemtime($p));
    echo "=== $rel ===\n";
    echo "realpath: $real\nmd5: $md5\nmtime: $mtime\n";
    $lines = file($p);
    // Show first 120 lines with line numbers for quick spot-check
    $max = min(120, count($lines));
    for ($i=0; $i<$max; $i++) {
        $ln = $i+1;
        $content = rtrim(str_replace(["\r","\n"],["",""], $lines[$i]));
        echo str_pad($ln, 4, ' ', STR_PAD_LEFT) . ": " . $content . "\n";
    }
    echo "\n";
}

// Also show which PHP loads we're hitting
echo "PHP SAPI: " . php_sapi_name() . "\n";
echo "Loaded ini: " . php_ini_loaded_file() . "\n";
echo "Include path: " . get_include_path() . "\n";
