<?php declare(strict_types=1);
/**
 * /forgot.php — versão limpa (r2)
 * - strict_types primeiro (sem BOM/sem espaços)
 * - Nenhum "?>" no meio/final
 * - Um único require de core.php (dentro do PHP)
 * - Sem texto/HTML antes do header.php
 */

if (function_exists('ob_get_level') && ob_get_level() === 0) { ob_start(); }
require __DIR__ . '/core.php';

// ==== Fallbacks i18n ====
if (!isset($translation) || !is_array($translation)) { $translation = []; }
$translation += [
    'tr_forgotpage'   => $translation['tr_forgotpage']   ?? 'Recuperar senha',
    'tr_email_label'  => $translation['tr_email_label']  ?? 'E-mail',
    'tr_enter_btn'    => $translation['tr_enter_btn']    ?? 'Enviar',
    'tr_back_signin'  => $translation['tr_back_signin']  ?? 'Back to Sign In',
    'tr_1'            => $translation['tr_1']            ?? 'Home',
    'tr_3'            => $translation['tr_3']            ?? 'Descrição do site',
    'tr_158'          => $translation['tr_158']          ?? 'Por favor, informe o e-mail.',
    'tr_163'          => $translation['tr_163']          ?? 'E-mail inválido.',
    'tr_166'          => $translation['tr_166']          ?? 'E-mail não encontrado.',
    'tr_167'          => $translation['tr_167']          ?? 'Enviamos instruções para redefinir sua senha.',
    'tr_168'          => $translation['tr_168']          ?? 'Algo deu errado. Tente novamente.',
    'tr_177'          => $translation['tr_177']          ?? 'Você já solicitou redefinição recentemente. Verifique seu e-mail.',
    'tr_161'          => $translation['tr_161']          ?? 'Falha no reCAPTCHA.',
];

if (!function_exists('tr')){
    function tr(string $k, string $d=''): string {
        $t = $GLOBALS['translation'] ?? [];
        return htmlspecialchars((string)($t[$k] ?? $d), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
    }
}

// SEO
$titleSeoHeader       = getSeoTitle($translation['tr_1'], $translation['tr_forgotpage']);
$descriptionSeoHeader = getSeoDescription($translation['tr_3']);

$errors = [];
$success = '';
$fullHeight = true;

if (isLogged()) {
    header('Location: '. $urlPath->home());
    exit;
}

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
    $user_email = strtolower((string)($_POST['user_email'] ?? ''));
    $user_email = filter_var($user_email, FILTER_SANITIZE_EMAIL);

    // reCAPTCHA (se habilitado)
    if ((int)($settings['st_recaptcha_enable'] ?? 0) === 1){
        $secretKey = (string)($settings['st_recaptchasecretkey'] ?? '');
        $verifyCaptcha = (string)($_POST['g-recaptcha-response'] ?? '');
        if ($secretKey && $verifyCaptcha) {
            $recaptchaUrl = "https://www.google.com/recaptcha/api/siteverify?secret={$secretKey}&response={$verifyCaptcha}";
            $verify = @json_decode(@file_get_contents($recaptchaUrl), true);
            if (!$verify || empty($verify['success'])) {
                $errors[] = $translation['tr_161'];
            }
        } else {
            $errors[] = $translation['tr_161'];
        }
    }

    if ($user_email === '') {
        $errors[] = $translation['tr_158'];
    } elseif (!filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = $translation['tr_163'];
    }

    if (empty($errors)) {
        try {
            $statement = $connect->prepare("SELECT * FROM users WHERE user_email = :user_email LIMIT 1");
            $statement->execute([':user_email' => $user_email]);
            $result = $statement->fetch();
            if ($result == false) {
                $errors[] = $translation['tr_166'];
            } else {
                $currentDate = date("Y-m-d H:i:s");
                $state = $connect->prepare("SELECT * FROM tokens WHERE token_email = :token_email");
                $state->execute([':token_email' => $user_email]);
                $check = $state->fetch();
                if ($check && $check['token_date'] >= $currentDate) {
                    $errors[] = $translation['tr_177'];
                }
            }
        } catch (Throwable $e) {
            $errors[] = $translation['tr_168'];
        }
    }

    if (empty($errors)) {
        $dateFormat = mktime((int)date("H"), (int)date("i"), (int)date("s"), (int)date("m"), (int)date("d")+1, (int)date("Y"));
        $token_date = date("Y-m-d H:i:s", $dateFormat);
        $token_key  = hash('sha512', (string)(2418*2) . $user_email);
        $generateKey = substr(hash('sha512', uniqid((string)mt_rand(), true)), 3, 10);
        $token_key  = $token_key . $generateKey;

        try {
            $statement = $connect->prepare("INSERT INTO tokens (token_email, token_key, token_date) VALUES (:token_email, :token_key, :token_date)");
            $statement->execute([
                ':token_email' => $user_email,
                ':token_key'   => $token_key,
                ':token_date'  => $token_date
            ]);
        } catch (Throwable $e) {
            $errors.append($translation['tr_168']);
        }

        if (empty($errors)) {
            try {
                $userInfo = getUserInfoByEmail($user_email);
                $array_content = [
                    "{LOGO_URL}"   => $urlPath->image($theme['th_logo'] ?? ''),
                    "{SITE_DOMAIN}"=> $urlPath->home(),
                    "{SITE_NAME}"  => $translation['tr_1'],
                    "{USER_NAME}"  => $userInfo['user_name'] ?? '',
                    "{USER_EMAIL}" => $userInfo['user_email'] ?? $user_email,
                    "{RESET_URL}"  => $urlPath->reset(['email' => $user_email, 'key' => $token_key])
                ];
                $emailTemplate = getEmailTemplate($connect, 2);
                if ($emailTemplate) {
                    $emailContent = json_decode((string)$emailTemplate['email_content'], true);
                    $mail = sendMail(
                        $array_content,
                        $emailContent[0]['message'] ?? '',
                        $user_email,
                        $emailTemplate['email_fromname'] ?? '',
                        $emailContent[0]['subject'] ?? 'Reset Password',
                        (int)($emailTemplate['email_plaintext'] ?? 0)
                    );
                    if ($mail === 'TRUE') {
                        $success = $translation['tr_167'];
                    } else {
                        $errors[] = $translation['tr_168'];
                    }
                } else {
                    $errors[] = $translation['tr_168'];
                }
            } catch (Throwable $e) {
                $errors[] = $translation['tr_168'];
            }
        }
    }
}

require __DIR__ . '/header.php';
require __DIR__ . '/views/forgot.view.php';
require __DIR__ . '/footer.php';
