<?php declare(strict_types=1);
require_once __DIR__ . '/includes/nd-geo-utils.php';
use ND\Coupons\Support\Helpers;

use voku\helper\AntiXSS;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Razorpay\Api\Api;
if (!defined('ND_FUNCTIONS_LOADED')) { define('ND_FUNCTIONS_LOADED', true); }

 // ND: server-side language cookie fallback (?lang=pt|en|es)
if (!defined('ND_GT_SERVER_FALLBACK')) {
  define('ND_GT_SERVER_FALLBACK', true);
  if (isset($_GET['lang'])) {
    $lang = strtolower(preg_replace('/[^a-z]/','', $_GET['lang']));
    if (in_array($lang, ['pt','en','es'])) {
      $val = '/pt/' . $lang;
      $domain = $_SERVER['HTTP_HOST'];
      // Root domain (handle com.br)
      $parts = explode('.', $domain);
      $root = $domain;
      if (count($parts) >= 3) $root = implode('.', array_slice($parts, -3));
      // Set cookies for host and root
      setcookie('googtrans', $val, time()+3600*24*365, '/', $domain, false, true);
      setcookie('googtrans', $val, time()+3600*24*365, '/', '.' . $root, false, true);
      // Also on "wwwless"
      $wwwless = preg_replace('/^www\./','', $domain);
      setcookie('googtrans', $val, time()+3600*24*365, '/', '.' . $wwwless, false, true);
      // Redirect without query param to avoid loops
      $uri = strtok($_SERVER["REQUEST_URI"], '?');
      header("Location: ".$uri, true, 302);
      exit;
    }
  }
}

// Helpers PHP 8.2
if (!function_exists('nd_str')) { function nd_str($v){ return (string)($v ?? ''); } }
if (!function_exists('nd_num')) { function nd_num($v){ return is_numeric($v) ? (float)$v : 0.0; } }
if (!function_exists('e'))      { function e($v){ return htmlspecialchars(\ND\Coupons\Support\Helpers::toString($v), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); } }

if (!function_exists('getGravatar')) {
function getGravatar($email, $s = 150, $d = 'mp', $r = 'g', $img = false, $atts = array()) {
    $url = 'https://www.gravatar.com/avatar/'.md5(strtolower(trim($email)))."?s=$s&d=$d&r=$r";
    if ($img) {
        $url = '<img src="' . $url . '"';
        foreach ($atts as $key => $val) $url .= ' ' . $key . '="' . $val . '"';
        $url .= ' />';
    }
    return $url;
}}

// Helpers PHP 8.2 (enforced)
// Helpers PHP 8.2
/*--------------------*/
// Descrição: ND Cupons 
// Autor: ND Tecnologia 
// Autor URI: https://www.ndmidia.com.br 
/*--------------------*/

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/classes/vendor/autoload.php';
require_once __DIR__ . '/classes/slugify.php';
require_once __DIR__ . '/classes/fileuploader.php';
require_once __DIR__ . '/classes/csrf.php';
require_once __DIR__ . '/admin/countries.php';

$csrf = new CSRF();

/*------------------------------------------------------------ */
/* DB & AUTH HELPERS */
/*------------------------------------------------------------ */

if (!function_exists('connect')) {
function connect(){
    global $database;
    try{
        $connect = new PDO(
            'mysql:host='.$database['host'].';dbname='.$database['db'],
            $database['user'],
            $database['pass'],
            array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES \'UTF8\'')
        );
        $connect->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $connect;
    }catch (PDOException $e){
        return false;
    }
}}
if (!function_exists('isLogged')) {
function isLogged(){
    return (isset($_SESSION['signedin']) && $_SESSION['signedin'] == true);
}}
if (!function_exists('isAdmin')) {
function isAdmin(){
    if (isset($_SESSION['user_email'])) {
        $userEmail = filter_var(strtolower($_SESSION['user_email']), FILTER_SANITIZE_EMAIL);
        $sentence = connect()->prepare("SELECT users.user_email, users.user_role, roles.role_admin FROM users, roles WHERE users.user_role = roles.role_id AND users.user_email = :email");
        $sentence->execute([":email" => $userEmail]);
        $row = $sentence->fetch();
        return ($row && $row['role_admin'] == 1);
    }
    return false;
}}
if (!function_exists('isExclusive')) {
function isExclusive($value){ return $value == 1; }}
if (!function_exists('isVerified')) {
function isVerified($value){ return $value == 1; }}
if (!function_exists('isEditing')) {
function isEditing(){ return isset($_GET['action']) && $_GET['action'] == 'edit'; }}
if (!function_exists('isFavorites')) {
function isFavorites(){ return isset($_GET['action']) && $_GET['action'] == 'favorites'; }}

/*------------------------------------------------------------ */
/* SANITIZE & SMALL HELPERS */
/*------------------------------------------------------------ */

if (!function_exists('echoOutput')) {
function echoOutput($data){ return htmlspecialchars((string)$data, ENT_COMPAT, 'UTF-8'); }}
if (!function_exists('textTruncate')) {
function textTruncate($data, $chars) {
    if(strlen($data) > $chars) {
        $data = substr($data.' ', 0, $chars).'...';
    }
    return $data;
}}
if (!function_exists('echoNoHtml')) {
function echoNoHtml($data){
    $data = strip_tags($data);
    $data = htmlentities($data, ENT_QUOTES, "UTF-8");
    return substr($data, 0, 255);
}}
if (!function_exists('clearGetData')) {
function clearGetData($data){
    $antiXss = new AntiXSS();
    return $antiXss->xss_clean($data);
}}
if (!function_exists('lengthInput')) {
function lengthInput($data, $min, $max = NULL){
    $characters = strlen($data);
    $spaces = preg_match('/\s/',$data);
    if ($max) {
        return ($characters >= $min && $characters <= $max && !$spaces);
    }
    return ($characters >= $min && !$spaces);
}}
if (!function_exists('validateInput')) {
function validateInput($data){ return preg_match('@[^\w]@', $data) ? true : false; }}

/*------------------------------------------------------------ */
/* GET PARAM HELPERS */
/*------------------------------------------------------------ */

if (!function_exists('getCurrentPageSlug')) { function getCurrentPageSlug(){ return isset($_GET['slug']) && !empty($_GET['slug']) ? clearGetData($_GET['slug']) : NULL; } }
if (!function_exists('getNumPage')) { function getNumPage(){ return (isset($_GET['p']) && (int)$_GET['p']) ? (int)clearGetData($_GET['p']) : 1; } }
if (!function_exists('getItemId')) { function getItemId(){ return (isset($_GET['id']) && is_numeric($_GET['id'])) ? (int)$_GET['id'] : NULL; } }
if (!function_exists('getFilterParam')) { function getFilterParam(){ return isset($_GET['filte']) && $_GET['filte'] ? clearGetData($_GET['filte']) : NULL; } }
if (!function_exists('getIDCategory')) { function getIDCategory(){ return isset($_GET['category']) && $_GET['category'] ? clearGetData($_GET['category']) : NULL; } }
if (!function_exists('getIDLocation')) {
function getIDLocation(){
    return (isset($_GET['location']) && $_GET['location']) ? clearGetData($_GET['location']) : NULL;
}}
if (!function_exists('getIDStore')) { function getIDStore(){ return isset($_GET['store']) && $_GET['store'] ? clearGetData($_GET['store']) : NULL; } }
if (!function_exists('getIDRating')) { function getIDRating(){ return isset($_GET['rating']) && $_GET['rating'] ? clearGetData($_GET['rating']) : NULL; } }
if (!function_exists('getIDPrice')) { function getIDPrice(){ return isset($_GET['price']) && $_GET['price'] ? clearGetData($_GET['price']) : NULL; } }
if (!function_exists('getIDSubCategory')) { function getIDSubCategory(){ return isset($_GET['subcategory']) && $_GET['subcategory'] ? clearGetData($_GET['subcategory']) : NULL; } }
if (!function_exists('getIDUser')) { function getIDUser(){ return isset($_GET['user']) && $_GET['user'] ? clearGetData($_GET['user']) : NULL; } }
if (!function_exists('getTypeData')) { function getTypeData(){ return isset($_GET['type']) && $_GET['type'] ? clearGetData($_GET['type']) : NULL; } }
if (!function_exists('getSortBy')) { function getSortBy($value){ return (isset($_GET['sortby']) && $_GET['sortby'] === $value) ? "value = '$value' selected" : "value = '$value'"; } }
if (!function_exists('getSlugItem')) { function getSlugItem(){ return isset($_GET['slug']) && $_GET['slug'] ? clearGetData($_GET['slug']) : NULL; } }
if (!function_exists('getSearchQuery')) { function getSearchQuery(){ return isset($_GET['query']) && $_GET['query'] ? clearGetData($_GET['query']) : NULL; } }
if (!function_exists('getSlugCategory')) { function getSlugCategory(){ return isset($_GET['category']) && $_GET['category'] ? clearGetData($_GET['category']) : NULL; } }
if (!function_exists('getSlugSubCategory')) { function getSlugSubCategory(){ return isset($_GET['subcategory']) && $_GET['subcategory'] ? clearGetData($_GET['subcategory']) : NULL; } }
if (!function_exists('getSlugLocation')) { function getSlugLocation(){ return isset($_GET['location']) && $_GET['location'] ? clearGetData($_GET['location']) : NULL; } }
if (!function_exists('getFreqParam')) { function getFreqParam(){ return isset($_GET['freq']) && $_GET['freq'] ? clearGetData($_GET['freq']) : NULL; } }
if (!function_exists('getSlugStore')) { function getSlugStore(){ return isset($_GET['store']) && $_GET['store'] ? clearGetData($_GET['store']) : NULL; } }
if (!function_exists('getParamsSort')) { function getParamsSort(){ return isset($_GET['sortby']) && !empty($_GET['sortby']) ? clearGetData($_GET['sortby']) : NULL; } }
if (!function_exists('getItemParam')) { function getItemParam(){ return isset($_GET['item']) && $_GET['item'] ? clearGetData($_GET['item']) : NULL; } }
if (!function_exists('getUniqueParam')) { function getUniqueParam(){ return isset($_GET['unique']) && $_GET['unique'] ? clearGetData($_GET['unique']) : NULL; } }

/*------------------------------------------------------------ */
/* DATES & TIMEZONES */
/*------------------------------------------------------------ */

if (!function_exists('getIntervalParam')) {
function getIntervalParam(){
    $interval = isset($_GET['interval']) && $_GET['interval'] ? clearGetData($_GET['interval']) : "last7days";
    $intervals = array("today", "yesterday", "last7days", "last30days", "last6months", "lastyear", "alltime");
    return in_array($interval, $intervals) ? $interval : false;
}}
if (!function_exists('getDateByInterval')) {
function getDateByInterval($interval){
    $date = new DateTime("now", new DateTimeZone(getTimeZone()));
    $intervals = array("today", "yesterday", "last7days", "last30days", "last6months", "lastyear", "alltime");
    if (!in_array($interval, $intervals)) return false;
    switch($interval) {
        case 'today': return $date;
        case 'yesterday': $date->sub(new \DateInterval('P1D')); return $date;
        case 'last7days': $date->sub(new \DateInterval('P7D')); return $date;
        case 'last30days': $date->sub(new \DateInterval('P1M')); return $date;
        case 'last6months': $date->sub(new \DateInterval('P6M')); return $date;
        case 'lastyear': $date->sub(new \DateInterval('P1Y')); return $date;
        case 'alltime': $date->sub(new \DateInterval('P5Y')); return $date;
    }
}}
if (!function_exists('formatDate')) {
function formatDate($date){
    $sentence = connect()->prepare("SELECT st_dateformat FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();
    $newDate = date($row['st_dateformat'], strtotime($date));
    return echoOutput($newDate);
}}
if (!function_exists('generatePassword')) {
function generatePassword() {
    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
    $pass = array();
    for ($i = 0; $i < 8; $i++) { $pass[] = $alphabet[rand(0, strlen($alphabet) - 1)]; }
    return implode($pass);
}}
if (!function_exists('maskEmail')) {
function maskEmail($email){
    $mail_parts = explode('@', $email);
    $username = '@'.$mail_parts[0];
    return $username;
}}

/*------------------------------------------------------------ */
/* USER HELPERS */
/*------------------------------------------------------------ */

if (!function_exists('getUserInfo')) {
function getUserInfo(){
    if (isset($_SESSION['signedin']) && $_SESSION['signedin'] == true) {
        $email = filter_var(strtolower($_SESSION['user_email']), FILTER_VALIDATE_EMAIL);
        if($email) {
            $sentence = connect()->prepare("SELECT * FROM users WHERE user_status = 1 AND user_email = :user_email LIMIT 1");
            $sentence->execute([':user_email' => $email]);
            return $sentence->fetch();
        }
    }
    return null;
}}
if (!function_exists('getUserInfoByEmail')) {
function getUserInfoByEmail($userEmail){
    if ($userEmail) {
        $sentence = connect()->prepare("SELECT * FROM users WHERE user_status = 1 AND user_email = :user_email LIMIT 1");
        $sentence->execute([':user_email' => $userEmail]);
        return $sentence->fetch();
    }
    return false;
}}
if (!function_exists('isUserVerified')) {
function isUserVerified($userEmail){
    $sentence = connect()->prepare("SELECT * FROM users WHERE user_email = :user_email AND user_verified = 1 LIMIT 1");
    $sentence->execute([':user_email' => $userEmail]);
    return (bool)$sentence->fetch();
}}

if (!function_exists('numTotalPages')) {
function numTotalPages($total_items, $items_page){ return ceil($total_items / $items_page); }}
if (!function_exists('countFormat')) {
function countFormat($num) {
    if($num>1000) {
        $x = round($num);
        $x_number_format = number_format($x);
        $x_array = explode(',', $x_number_format);
        $x_parts = array('k', 'm', 'b', 't');
        $x_count_parts = count($x_array) - 1;
        $x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
        $x_display .= $x_parts[$x_count_parts - 1];
        return $x_display;
    }
    return $num;
}}
if (!function_exists('getSocialMedia')) {
function getSocialMedia($connect){
    $sentence = $connect->prepare("SELECT st_facebook,st_twitter,st_youtube,st_instagram,st_linkedin,st_whatsapp FROM settings");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('isInFav')) {
function isInFav($connect, $userId, $itemId){
    $sentence = $connect->prepare("SELECT * FROM favorites WHERE user = :user AND item = :item LIMIT 1");
    $sentence->execute([':user' => $userId, ':item' => $itemId]);
    return $sentence->fetch();
}}

/*------------------------------------------------------------ */
/* TIMEZONE HELPERS */
/*------------------------------------------------------------ */

if (!function_exists('getTimeZone')) {
function getTimeZone(){
    $sentence = connect()->prepare("SELECT st_timezone FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();
    return !empty($row['st_timezone']) ? $row['st_timezone'] : "UTC";
}}
if (!function_exists('getDateByTimeZone')) {
function getDateByTimeZone($format = NULL){
    $sentence = connect()->prepare("SELECT st_timezone FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();
    $date = new DateTime("now", new DateTimeZone($row['st_timezone']));
    return $format ? $date->format($format) : $date->format('Y-m-d H:i');
}}
if (!function_exists('getDateOnlyByTimeZone')) {
function getDateOnlyByTimeZone(){
    $sentence = connect()->prepare("SELECT st_timezone FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();
    $date = new DateTime("now", new DateTimeZone($row['st_timezone']));
    return $date->format('Y-m-d');
}}

/*------------------------------------------------------------ */
/* SEO */
/*------------------------------------------------------------ */

if (!function_exists('getSeoTitle')) {
function getSeoTitle($pageTitle = NULL, $pageSubTitle = NULL){
    if (!$pageSubTitle) return $pageTitle;
    if (!$pageTitle) return $pageSubTitle;
    if ($pageTitle && $pageSubTitle) return $pageSubTitle.' - '.$pageTitle;
    return null;
}}
if (!function_exists('getSeoDescription')) {
function getSeoDescription($generalDescription, $itemDescription = NULL, $seoDescription = NULL){
    if (!$itemDescription && !$seoDescription) return echoNoHtml($generalDescription);
    if ($seoDescription) return echoNoHtml($seoDescription);
    return echoNoHtml($itemDescription);
}}

/*------------------------------------------------------------ */
/* PLANS & TAXES */
/*------------------------------------------------------------ */

if (!function_exists('getPlans')) {
function getPlans($connect){
    $sentence = $connect->prepare("SELECT * FROM plans WHERE plan_status = 1 ORDER BY plan_order ASC");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getPlanById')) {
function getPlanById($connect, $id){
    if(!$id) return false;
    $sentence = $connect->prepare("SELECT * FROM plans WHERE plan_status = 1 AND plan_id = :plan_id LIMIT 1");
    $sentence->execute([':plan_id' => $id]);
    return $sentence->fetch();
}}
if (!function_exists('getTaxesById')) {
function getTaxesById($plan_taxes){
    $plan_taxes = json_decode($plan_taxes);
    if(empty($plan_taxes)) return null;
    $plan_taxes = implode(',', $plan_taxes);
    $sentence = connect()->prepare("SELECT * FROM taxes WHERE tax_id IN ({$plan_taxes})");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('calcTaxesByPrice')) {
function calcTaxesByPrice($price, $percentage){
    return ($percentage / 100) * $price;
}}
if (!function_exists('getTaxesByPlan')) {
function getTaxesByPlan($plan_taxes){
    $plan_taxes = json_decode($plan_taxes);
    if(empty($plan_taxes)) return null;
    $plan_taxes = implode(',', $plan_taxes);
    $sentence = connect()->prepare("SELECT taxes.*, (SELECT SUM(tax_percentage) FROM taxes WHERE tax_type = 'exclusive') AS exclusive_percentage, (SELECT SUM(tax_percentage) FROM taxes WHERE tax_type = 'inclusive') AS inclusive_percentage FROM taxes WHERE tax_id IN ({$plan_taxes})");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getAppliedTaxes')) {
function getAppliedTaxes($planTaxes){
    $user = getUserInfo();
    $userDetails = getUserInfoById($user['user_id']);
    $userBilling = json_decode($userDetails['user_billing'], true);
    if(empty($planTaxes)) return null;
    foreach ($planTaxes as $key => $value) {
        if ($value['tax_countries'] != "[]" && !in_array($userBilling['country'], json_decode($value['tax_countries']))) {
            unset($planTaxes[$key]);
        }
        if (isset($planTaxes[$key])) { $applied_taxes[] = $value['tax_id']; }
    }
    return array_values($planTaxes);
}}
if (!function_exists('calculateTaxes')) {
function calculateTaxes($plan_price, $plan_taxes_array) {
    $price = $plan_price;
    $plan_taxes = getTaxesByPlan($plan_taxes_array);
    if($plan_taxes) {
        $inclusive_taxes_total_percentage = 0;
        foreach($plan_taxes as $row) {
            if($row['tax_type'] == 'exclusive') continue;
            $inclusive_taxes_total_percentage += $row['tax_percentage'];
        }
        $total_inclusive_tax = $price - ($price / (1 + $inclusive_taxes_total_percentage / 100));
        $price_without_inclusive_taxes = $price - $total_inclusive_tax;

        $exclusive_taxes_array = [];
        foreach($plan_taxes as $row) {
            if($row['tax_type'] == 'inclusive') continue;
            $exclusive_taxes_array[] = $price_without_inclusive_taxes * ($row['tax_percentage'] / 100);
        }
        $exclusive_taxes = array_sum($exclusive_taxes_array);
        $price += $exclusive_taxes;
    }
    return $price;
}}
if (!function_exists('getMonthlyPlan')) {
function getMonthlyPlan($connect){
    $sentence = $connect->prepare("SELECT plan_monthly FROM plans WHERE plan_monthly != 0");
    $sentence->execute();
    return $sentence->fetch();
}}
if (!function_exists('gethalfYearPlan')) {
function gethalfYearPlan($connect){
    $sentence = $connect->prepare("SELECT plan_halfyear FROM plans WHERE plan_halfyear != 0");
    $sentence->execute();
    return $sentence->fetch();
}}
if (!function_exists('getAnnualPlan')) {
function getAnnualPlan($connect){
    $sentence = $connect->prepare("SELECT plan_annual FROM plans WHERE plan_annual != 0");
    $sentence->execute();
    return $sentence->fetch();
}}

/*------------------------------------------------------------ */
/* CONTENT LOOKUPS */
/*------------------------------------------------------------ */

if (!function_exists('getUserInfoById')) {
function getUserInfoById($id){
    $sentence = connect()->prepare("SELECT users.*, sellers.seller_logo, sellers.seller_title  FROM users LEFT JOIN sellers ON sellers.seller_user = users.user_id WHERE user_status = 1 AND user_id = :user_id LIMIT 1");
    $sentence->execute([':user_id' => $id]);
    return $sentence->fetch();
}}
if (!function_exists('getLocationBySlug')) {
function getLocationBySlug($connect, $slug){
    $sentence = $connect->prepare("SELECT * FROM locations WHERE location_status = 1 AND location_slug = :location_slug LIMIT 1");
    $sentence->execute([':location_slug' => $slug]);
    return $sentence->fetch();
}}
if (!function_exists('getSellerBySlug')) {
function getSellerBySlug($connect, $slug){
    $sentence = $connect->prepare("SELECT sellers.*, (SELECT COUNT(*) FROM deals WHERE deals.deal_author = sellers.seller_user AND deals.deal_status = 1) AS total_items FROM sellers WHERE seller_status = 1 AND seller_slug = :seller_slug LIMIT 1");
    $sentence->execute([':seller_slug' => $slug]);
    return $sentence->fetch();
}}
if (!function_exists('getTotalDealsByLocation')) {
function getTotalDealsByLocation($itemId){
    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM deals WHERE deal_location = :deal_location AND deal_status = 1");
    $sentence->execute([':deal_location' => $itemId]);
    $row = $sentence->fetch();
    return $row['total'];
}}
if (!function_exists('getReviewsByLocation')) {
function getReviewsByLocation($itemId){
    $sentence = connect()->prepare("SELECT SQL_CALC_FOUND_ROWS AVG(rating) AS rating, COUNT(*) AS total FROM reviews WHERE reviews.item = (SELECT deals.deal_id FROM deals WHERE deals.deal_location = :deal_location LIMIT 1) AND reviews.status = 1");
    $sentence->execute([':deal_location' => $itemId]);
    $row = $sentence->fetch();
    return $row['rating'];
}}
if (!function_exists('getUserFavorites')) {
function getUserFavorites($connect, $userId){
    $sql = "SELECT d.*, f.id AS favorite_id
            FROM favorites f
            INNER JOIN deals d ON d.deal_id = f.item
            WHERE f.user = :user
            ORDER BY f.id DESC";
    $sentence = $connect->prepare($sql);
    $sentence->execute([':user' => $userId]);
    return $sentence->fetchAll();
}}
if (!function_exists('getFeaturedDeals')) {
function getFeaturedDeals(PDO $connect, int $limit = 6) {

    // ND: inclui destaques contratados (Add-on Home 7 dias) + featured clássico
    // - home_fixed (meta_json mode=fixed) sobe primeiro
    // - has_home7 rotaciona diariamente dentro do grupo
    $sql = "
        SELECT
            d.*,
            (SELECT AVG(r.rating)
               FROM reviews r
              WHERE r.item = d.deal_id
                AND r.status = 1) AS rating,
            (SELECT COUNT(*)
               FROM reviews r2
              WHERE r2.item = d.deal_id
                AND r2.status = 1) AS total_reviews,
            c.category_title AS category_name,
            s.store_title    AS store_name,
            COALESCE(ao.has_home7,0)    AS has_home7,
            COALESCE(ao.home_fixed,0)   AS home_fixed
        FROM deals d
        LEFT JOIN categories c
          ON CAST(d.deal_category AS UNSIGNED) = c.category_id
        LEFT JOIN stores s
          ON CAST(d.deal_store    AS UNSIGNED) = s.store_id
        LEFT JOIN (
            SELECT
                store_id,
                MAX(CASE WHEN addon_code='home7' THEN 1 ELSE 0 END) AS has_home7,
                MAX(CASE WHEN addon_code='home7' AND meta_json LIKE '%\"mode\":\"fixed\"%' THEN 1 ELSE 0 END) AS home_fixed
            FROM nd_addon_orders
            WHERE status = 'active'
              AND addon_code = 'home7'
              AND (start_date IS NULL OR start_date <= NOW())
              AND (end_date   IS NULL OR end_date   >= NOW())
            GROUP BY store_id
        ) ao
          ON ao.store_id = CAST(d.deal_store AS UNSIGNED)
        WHERE
            d.deal_status = 1
            AND (d.deal_featured = 1 OR COALESCE(ao.has_home7,0) = 1)
            AND (
                d.deal_expire IS NULL
                OR d.deal_expire >= NOW()
            )
        ORDER BY
            COALESCE(ao.home_fixed,0) DESC,
            COALESCE(ao.has_home7,0) DESC,
            d.deal_featured DESC,
            (CASE WHEN COALESCE(ao.has_home7,0)=1 THEN MD5(CONCAT(d.deal_id, CURDATE())) ELSE '' END) ASC,
            d.deal_created DESC
        LIMIT :limit
    ";

    $st = $connect->prepare($sql);
    $st->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
    $st->execute();

    return $st->fetchAll(PDO::FETCH_ASSOC);
}
}
/* =========================================================
   ND Plan Quotas Helpers (non-breaking)
   - Counts consider only active deals (deal_status = 1)
   - plan_limit: -1 or 0 => ilimitado
   ========================================================= */

if (!function_exists('nd_get_user_plan_settings')) {
function nd_get_user_plan_settings($connect, $user_id) {
    try {
        $stmt = $connect->prepare("SELECT p.* FROM users u LEFT JOIN plans p ON p.plan_id = u.user_plan WHERE u.user_id = :uid LIMIT 1");
        $stmt->execute([':uid' => $user_id]);
        $plan = $stmt->fetch();
        return $plan ?: null;
    } catch (Throwable $e) { return null; }
}}

if (!function_exists('nd_is_unlimited')) {
function nd_is_unlimited($v) {
    return ($v === null || $v === '' || (int)$v === 0 || (int)$v === -1);
}}

if (!function_exists('nd_count_user_deals')) {
function nd_count_user_deals($connect, $user_id, $extra = "") {
    $sql = "SELECT COUNT(*) AS c FROM deals WHERE deal_author = :uid AND deal_status = 1";
    if ($extra) $sql .= " " . $extra;
    $stmt = $connect->prepare($sql);
    $stmt->execute([':uid' => $user_id]);
    $row = $stmt->fetch();
    return (int)($row['c'] ?? 0);
}}

if (!function_exists('nd_count_user_featured')) {
function nd_count_user_featured($connect, $user_id, $exclude_id = null) {
    $extra = "AND deal_featured = 1";
    if (!empty($exclude_id)) $extra .= " AND deal_id <> " . (int)$exclude_id;
    return nd_count_user_deals($connect, $user_id, $extra);
}}

if (!function_exists('nd_count_user_exclusive')) {
function nd_count_user_exclusive($connect, $user_id, $exclude_id = null) {
    $extra = "AND deal_exclusive = 1";
    if (!empty($exclude_id)) $extra .= " AND deal_id <> " . (int)$exclude_id;
    return nd_count_user_deals($connect, $user_id, $extra);
}}

if (!function_exists('nd_user_can_create_deal')) {
function nd_user_can_create_deal($connect, $user_id) {
    $plan = nd_get_user_plan_settings($connect, $user_id);
    if (!$plan) return true; // fail-open (não quebra)
    $limit = isset($plan['plan_limit']) ? (int)$plan['plan_limit'] : 0;
    if (nd_is_unlimited($limit)) return true;
    $active = nd_count_user_deals($connect, $user_id);
    return ($active < $limit);
}}

if (!function_exists('nd_user_remaining_deals')) {
function nd_user_remaining_deals($connect, $user_id) {
    $plan = nd_get_user_plan_settings($connect, $user_id);
    if (!$plan) return PHP_INT_MAX;
    $limit = isset($plan['plan_limit']) ? (int)$plan['plan_limit'] : 0;
    if (nd_is_unlimited($limit)) return PHP_INT_MAX;
    $active = nd_count_user_deals($connect, $user_id);
    return max(0, $limit - $active);
}}

if (!function_exists('nd_user_remaining_featured')) {
function nd_user_remaining_featured($connect, $user_id) {
    $plan = nd_get_user_plan_settings($connect, $user_id);
    if (!$plan) return PHP_INT_MAX;
    $max = isset($plan['plan_featured_total']) ? (int)$plan['plan_featured_total'] : 0;
    if (nd_is_unlimited($max)) return PHP_INT_MAX;
    $current = nd_count_user_featured($connect, $user_id, null);
    return max(0, $max - $current);
}}

if (!function_exists('nd_user_remaining_exclusive')) {
function nd_user_remaining_exclusive($connect, $user_id) {
    $plan = nd_get_user_plan_settings($connect, $user_id);
    if (!$plan) return PHP_INT_MAX;
    $max = isset($plan['plan_exclusive_total']) ? (int)$plan['plan_exclusive_total'] : 0;
    if (nd_is_unlimited($max)) return PHP_INT_MAX;
    $current = nd_count_user_exclusive($connect, $user_id, null);
    return max(0, $max - $current);
}}

if (!function_exists('nd_clamp_feature_flags_by_plan')) {
function nd_clamp_feature_flags_by_plan($connect, $user_id, $candidate_featured, $candidate_exclusive, $exclude_id = null) {
    $plan = nd_get_user_plan_settings($connect, $user_id);
    if (!$plan) return [ (int)$candidate_featured, (int)$candidate_exclusive ];
    $maxFeatured = isset($plan['plan_featured_total']) ? (int)$plan['plan_featured_total'] : 0;
    $maxExclusive = isset($plan['plan_exclusive_total']) ? (int)$plan['plan_exclusive_total'] : 0;

    // Featured
    $featured = (int)$candidate_featured;
    if (!nd_is_unlimited($maxFeatured) && $featured === 1) {
        $current = nd_count_user_featured($connect, $user_id, $exclude_id);
        if ($current >= $maxFeatured) $featured = 0;
    }

    // Exclusive
    $exclusive = (int)$candidate_exclusive;
    if (!nd_is_unlimited($maxExclusive) && $exclusive === 1) {
        $current = nd_count_user_exclusive($connect, $user_id, $exclude_id);
        if ($current >= $maxExclusive) $exclusive = 0;
    }
    return [$featured, $exclusive];
}}
/* ===== end ND Plan Quotas Helpers ===== */

/* =========================================================
   ND Plan Monthly Updates Quota (non-breaking)
   - Start: 1 atualização/mês
   - Performance: 4 atualizações/mês
   - Dominação: ilimitado
   Obs.: quota conta envios de atualização (auto-aprovado ou enviado p/ revisão)
   ========================================================= */

if (!function_exists('nd_ensure_plan_usage_table')) {
function nd_ensure_plan_usage_table(PDO $connect): void {
    static $done = false;
    if ($done) return;
    $done = true;
    try {
        $connect->exec("CREATE TABLE IF NOT EXISTS nd_plan_usage (
            id INT NOT NULL AUTO_INCREMENT,
            user_id INT NOT NULL,
            ym VARCHAR(7) NOT NULL,
            deal_updates_used INT NOT NULL DEFAULT 0,
            created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            UNIQUE KEY uniq_user_month (user_id, ym)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci");
    } catch (Throwable $e) {
        // fail-open
    }
}
}

if (!function_exists('nd_plan_deal_updates_limit')) {
function nd_plan_deal_updates_limit(array $plan): int {
    $pid = (int)($plan['plan_id'] ?? 0);
    // Mantém compatibilidade com seus IDs atuais: 3=Start, 2=Performance, 1=Dominação
    if ($pid === 3) return 1;
    if ($pid === 2) return 4;
    return -1; // ilimitado
}
}

if (!function_exists('nd_get_month_key')) {
function nd_get_month_key(): string {
    try {
        $dt = new DateTime('now');
        return $dt->format('Y-m');
    } catch (Throwable $e) {
        return date('Y-m');
    }
}
}

if (!function_exists('nd_get_deal_updates_used')) {
function nd_get_deal_updates_used(PDO $connect, int $user_id, ?string $ym = null): int {
    $ym = $ym ?: nd_get_month_key();
    nd_ensure_plan_usage_table($connect);
    try {
        $st = $connect->prepare('SELECT deal_updates_used FROM nd_plan_usage WHERE user_id = :u AND ym = :ym LIMIT 1');
        $st->execute([':u' => $user_id, ':ym' => $ym]);
        $row = $st->fetch(PDO::FETCH_ASSOC);
        return (int)($row['deal_updates_used'] ?? 0);
    } catch (Throwable $e) {
        return 0;
    }
}
}

if (!function_exists('nd_user_can_update_deal')) {
function nd_user_can_update_deal(PDO $connect, int $user_id): bool {
    $plan = nd_get_user_plan_settings($connect, $user_id);
    if (!$plan) return true;
    $limit = nd_plan_deal_updates_limit($plan);
    if (nd_is_unlimited($limit)) return true;
    $used = nd_get_deal_updates_used($connect, $user_id, null);
    return $used < $limit;
}
}

if (!function_exists('nd_increment_deal_updates')) {
function nd_increment_deal_updates(PDO $connect, int $user_id): void {
    $plan = nd_get_user_plan_settings($connect, $user_id);
    if (!$plan) return;
    $limit = nd_plan_deal_updates_limit($plan);
    if (nd_is_unlimited($limit)) return; // não precisa registrar

    $ym = nd_get_month_key();
    nd_ensure_plan_usage_table($connect);
    try {
        // upsert
        $connect->prepare('INSERT INTO nd_plan_usage (user_id, ym, deal_updates_used) VALUES (:u, :ym, 1)
            ON DUPLICATE KEY UPDATE deal_updates_used = deal_updates_used + 1')
            ->execute([':u' => $user_id, ':ym' => $ym]);
    } catch (Throwable $e) {
        // fail-open
    }
}
}

/* ===== end ND Plan Monthly Updates Quota ===== */



if (!function_exists('getDealById')) {
function getDealById(PDO $connect, int $id) {
    $sql = "
        SELECT
            d.*,
            c.category_title AS category_name,
            s.store_title    AS store_name
        FROM deals d
        LEFT JOIN categories c ON CAST(d.deal_category AS UNSIGNED) = c.category_id
        LEFT JOIN stores     s ON CAST(d.deal_store    AS UNSIGNED) = s.store_id
        WHERE
            d.deal_id = :id
            AND d.deal_status = 1
            AND (d.deal_expire IS NULL OR d.deal_expire >= NOW())
        LIMIT 1
    ";
    $st = $connect->prepare($sql);
    $st->bindValue(':id', (int)$id, PDO::PARAM_INT);
    $st->execute();
    return $st->fetch(PDO::FETCH_ASSOC) ?: null;
}
}

if (!function_exists('getDealCoupons')) {
function getDealCoupons(PDO $connect, int $dealId, int $limit = 20): array {
    try {
        $sql = "
            SELECT
                dc.*
            FROM deal_coupons dc
            WHERE
                dc.deal_id = :deal_id
            ORDER BY dc.coupon_id DESC
            LIMIT :limit
        ";
        $st = $connect->prepare($sql);
        $st->bindValue(':deal_id', $dealId, PDO::PARAM_INT);
        $st->bindValue(':limit', $limit, PDO::PARAM_INT);
        $st->execute();
        $rows = $st->fetchAll(PDO::FETCH_ASSOC);
        return is_array($rows) ? $rows : [];
    } catch (Throwable $e) {
        return [];
    }
}
}
if (!function_exists('getItemsGallery')) {
function getItemsGallery($connect, $itemId){
    $sentence = $connect->prepare("SELECT * FROM deals_gallery WHERE item = :item ORDER BY created DESC");
    $sentence->execute([':item' => $itemId]);
    return $sentence->fetchAll();
}}
if (!function_exists('getLatestDeals')) {
function getLatestDeals(PDO $connect, int $limit = 10) {

    // ND: prioriza lojas com Add-on Home 7 dias
    // - home_fixed (meta_json mode=fixed) sobe primeiro
    // - has_home7 rotaciona diariamente dentro do grupo
    $sql = "
        SELECT
            d.*,
            (SELECT AVG(r.rating)
               FROM reviews r
              WHERE r.item = d.deal_id
                AND r.status = 1) AS rating,
            (SELECT COUNT(*)
               FROM reviews r2
              WHERE r2.item = d.deal_id
                AND r2.status = 1) AS total_reviews,
            c.category_title AS category_name,
            s.store_title    AS store_name,
            COALESCE(ao.has_home7,0)  AS has_home7,
            COALESCE(ao.home_fixed,0) AS home_fixed
        FROM deals d
        LEFT JOIN categories c
          ON CAST(d.deal_category AS UNSIGNED) = c.category_id
        LEFT JOIN stores s
          ON CAST(d.deal_store    AS UNSIGNED) = s.store_id
        LEFT JOIN (
            SELECT
                store_id,
                MAX(CASE WHEN addon_code='home7' THEN 1 ELSE 0 END) AS has_home7,
                MAX(CASE WHEN addon_code='home7' AND meta_json LIKE '%\"mode\":\"fixed\"%' THEN 1 ELSE 0 END) AS home_fixed
            FROM nd_addon_orders
            WHERE status = 'active'
              AND addon_code = 'home7'
              AND (start_date IS NULL OR start_date <= NOW())
              AND (end_date   IS NULL OR end_date   >= NOW())
            GROUP BY store_id
        ) ao
          ON ao.store_id = CAST(d.deal_store AS UNSIGNED)
        WHERE
            d.deal_status = 1
            AND (
                d.deal_expire IS NULL
                OR d.deal_expire >= NOW()
            )
        ORDER BY
            COALESCE(ao.home_fixed,0) DESC,
            COALESCE(ao.has_home7,0) DESC,
            (CASE WHEN COALESCE(ao.has_home7,0)=1 THEN MD5(CONCAT(d.deal_id, CURDATE())) ELSE '' END) ASC,
            d.deal_created DESC
        LIMIT :limit
    ";

    $st = $connect->prepare($sql);
    $st->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
    $st->execute();

    return $st->fetchAll(PDO::FETCH_ASSOC);
}
}


// cole APENAS dentro do seu functions.php, no lugar da função atual

if (!function_exists('getExclusiveDeals')) {
function getExclusiveDeals(PDO $connect, int $limit = 6) {

    $sql = "
        SELECT
            d.*,
            (SELECT AVG(r.rating)
               FROM reviews r
              WHERE r.item = d.deal_id
                AND r.status = 1) AS rating,
            (SELECT COUNT(*)
               FROM reviews r2
              WHERE r2.item = d.deal_id
                AND r2.status = 1) AS total_reviews,
            c.category_title AS category_name,
            s.store_title    AS store_name
        FROM deals d
        LEFT JOIN categories c
          ON CAST(d.deal_category AS UNSIGNED) = c.category_id
        LEFT JOIN stores s
          ON CAST(d.deal_store    AS UNSIGNED) = s.store_id
        WHERE
            d.deal_status = 1
            AND d.deal_exclusive = 1
            AND (d.deal_expire IS NULL OR d.deal_expire >= NOW())
        ORDER BY d.deal_created DESC
        LIMIT :limit
    ";

    $st = $connect->prepare($sql);
    $st->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
    $st->execute();

    return $st->fetchAll(PDO::FETCH_ASSOC);
}
}


if (!function_exists('getRelatedDeals')) {
function getRelatedDeals(PDO $connect, int $itemId){

    $sql = "
        SELECT
            d.*,
            (SELECT AVG(r.rating) FROM reviews r
              WHERE r.item = d.deal_id AND r.status = 1)  AS rating,
            (SELECT COUNT(*) FROM reviews r2
              WHERE r2.item = d.deal_id AND r2.status = 1) AS total_reviews,
            c.category_title AS category_name,
            s.store_title    AS store_name
        FROM deals d
        LEFT JOIN categories c ON CAST(d.deal_category AS UNSIGNED) = c.category_id
        LEFT JOIN stores     s ON CAST(d.deal_store    AS UNSIGNED) = s.store_id
        WHERE
            d.deal_status = 1
            AND d.deal_id <> :itemId
            AND (d.deal_expire IS NULL OR d.deal_expire >= NOW())
            AND (
                d.deal_category = (SELECT deal_category FROM deals WHERE deal_id = :itemId1 LIMIT 1)
                OR d.deal_store = (SELECT deal_store FROM deals WHERE deal_id = :itemId2 LIMIT 1)
            )
        ORDER BY d.deal_created DESC
        LIMIT 6
    ";

    $st = $connect->prepare($sql);
    $st->bindValue(':itemId',  (int)$itemId,  PDO::PARAM_INT);
    $st->bindValue(':itemId1', (int)$itemId,  PDO::PARAM_INT);
    $st->bindValue(':itemId2', (int)$itemId,  PDO::PARAM_INT);
    $st->execute();

    return $st->fetchAll(PDO::FETCH_ASSOC);
}
}

if (!function_exists('getFeaturedStores')) {
function getFeaturedStores($connect){
    $sentence = $connect->prepare("SELECT stores.*, (SELECT COUNT(*) FROM deals WHERE deals.deal_store = stores.store_id AND deal_status = 1) AS total_items FROM stores WHERE stores.store_featured = 1 AND stores.store_status = 1");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getFeaturedLocations')) {
function getFeaturedLocations($connect){
    $sentence = $connect->prepare("SELECT locations.*, (SELECT COUNT(*) FROM deals WHERE deals.deal_location = locations.location_id AND deal_status = 1) AS total_items FROM locations WHERE locations.location_featured = 1 AND locations.location_status = 1");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getLocations')) {
function getLocations($connect, $limit = NULL){
    if($limit){
        $sentence = $connect->prepare("SELECT * FROM locations WHERE locations.location_status = 1 LIMIT $limit");
    }else{
        $sentence = $connect->prepare("SELECT * FROM locations WHERE locations.location_status = 1");
    }
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getStores')) {
function getStores($connect, $limit = NULL){
    if($limit){
        $sentence = $connect->prepare("SELECT stores.* FROM stores WHERE stores.store_status = 1 LIMIT $limit");
    }else{
        $sentence = $connect->prepare("SELECT stores.* FROM stores WHERE stores.store_status = 1");
    }
    $sentence->execute();
    return $sentence->fetchAll();
}}


if (!function_exists('getSliders')) {
function getSliders($connect){
    $sentence = $connect->prepare("SELECT * FROM sliders WHERE sliders.slider_status = 1");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getMenuCategories')) {
function getMenuCategories($connect){
    $sentence = $connect->prepare("SELECT * FROM categories WHERE categories.category_menu = 1 AND categories.category_status = 1");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getFeaturedCategories')) {
function getFeaturedCategories($connect){
    $sentence = $connect->prepare("SELECT * FROM categories WHERE categories.category_featured = 1 AND categories.category_status = 1");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getCategories')) {
function getCategories($connect){
    $sentence = $connect->prepare("SELECT * FROM categories WHERE categories.category_status = 1");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getTagCategoryBySlug')) {
function getTagCategoryBySlug($slug){
    $sentence = connect()->prepare("SELECT * FROM categories WHERE category_status = 1 AND category_slug = :category_slug LIMIT 1");
    $sentence->execute([':category_slug' => $slug]);
    $row = $sentence->fetch();
    return $row ? $row['category_title'] : false;
}}
if (!function_exists('getTagSubCategoryBySlug')) {
function getTagSubCategoryBySlug($slug){
    $sentence = connect()->prepare("SELECT * FROM subcategories WHERE subcategory_status = 1 AND subcategory_slug = :subcategory_slug LIMIT 1");
    $sentence->execute([':subcategory_slug' => $slug]);
    $row = $sentence->fetch();
    return $row ? $row['subcategory_title'] : false;
}}
if (!function_exists('getTagLocationBySlug')) {
function getTagLocationBySlug($slug){
    $sentence = connect()->prepare("SELECT * FROM locations WHERE location_status = 1 AND location_slug = :location_slug LIMIT 1");
    $sentence->execute([':location_slug' => $slug]);
    $row = $sentence->fetch();
    return $row ? $row['location_title'] : false;
}}
if (!function_exists('getTagStoreBySlug')) {
function getTagStoreBySlug($slug){
    $sentence = connect()->prepare("SELECT * FROM stores WHERE store_status = 1 AND store_slug = :store_slug LIMIT 1");
    $sentence->execute([':store_slug' => $slug]);
    $row = $sentence->fetch();
    return $row ? $row['store_title'] : false;
}}

/* --- SUBCATEGORIES --- */
if (!function_exists('getSubCategories')) {
function getSubCategories($connect, $category_id, $limit = null) {
    $category_id = (int)$category_id;
    $limit_sql = '';
    if ($limit !== null && is_numeric($limit) && (int)$limit > 0) {
        $limit_sql = " LIMIT " . (int)$limit;
    }
    $sql = "SELECT
                s.subcategory_id,
                s.subcategory_title,
                s.subcategory_slug,
                s.subcategory_parent,
                (
                    SELECT COUNT(*)
                    FROM deals d
                    WHERE (CASE WHEN d.deal_subcategory REGEXP '^[0-9]+$' THEN CAST(d.deal_subcategory AS UNSIGNED) ELSE -1 END) = s.subcategory_id
                      AND (d.deal_status = 1 OR d.deal_status = '1')
                ) AS total
            FROM subcategories s
            WHERE s.subcategory_parent = :cat
            ORDER BY s.subcategory_title ASC".$limit_sql;
    try {
        $st = $connect->prepare($sql);
        $st->execute([':cat'=>$category_id]);
        return $st->fetchAll();
    } catch (PDOException $e) {
        $sql2 = "SELECT s.subcategory_id, s.subcategory_title, s.subcategory_slug, s.subcategory_parent, 0 AS total
                 FROM subcategories s
                 WHERE s.subcategory_parent = :cat
                 ORDER BY s.subcategory_title ASC".$limit_sql;
        $st = $connect->prepare($sql2);
        $st->execute([':cat'=>$category_id]);
        return $st->fetchAll();
    }
}}

/* --- REVIEWS --- */
if (!function_exists('getReviewsByDeal')) {
function getReviewsByDeal($connect, $itemId){
    $sentence = $connect->prepare("SELECT reviews.*, users.* FROM reviews LEFT JOIN users ON users.user_id = reviews.user WHERE item = :item AND reviews.status = 1 ORDER BY verified DESC, created DESC LIMIT 6");
    $sentence->execute([':item' => $itemId]);
    $total = $connect->query("SELECT FOUND_ROWS()")->fetchColumn();
    $results = $sentence->fetchAll(PDO::FETCH_ASSOC);
    return array('results' => $results, 'total' => $total);
}}
if (!function_exists('getReviewsByDealAjax')) {
function getReviewsByDealAjax($connect, $itemId, $limit){
    $sentence = $connect->prepare("SELECT SQL_CALC_FOUND_ROWS reviews.*, users.* FROM reviews LEFT JOIN users ON users.user_id = reviews.user WHERE item = :item AND reviews.status = 1 ORDER BY verified DESC, created DESC LIMIT 0,".(int)$limit);
    $sentence->execute([':item' => $itemId]);
    $total = $connect->query("SELECT FOUND_ROWS()")->fetchColumn();
    $results = $sentence->fetchAll(PDO::FETCH_ASSOC);
    return array('results' => $results, 'total' => $total);
}}

if (!function_exists('getStoreRatingSummary')) {
function getStoreRatingSummary(PDO $connect, int $storeId): array {
    $sql = "SELECT AVG(r.rating) AS rating, COUNT(*) AS total
            FROM reviews r
            INNER JOIN deals d ON d.deal_id = r.item
            WHERE d.deal_store = :sid AND r.status = 1";
    $st = $connect->prepare($sql);
    $st->execute([':sid' => $storeId]);
    $row = $st->fetch(PDO::FETCH_ASSOC) ?: ['rating' => null, 'total' => 0];

    return [
        'rating' => $row['rating'] !== null ? (float) $row['rating'] : null,
        'total'  => (int) ($row['total'] ?? 0),
    ];
}
}

if (!function_exists('getLikesCountById')) {
function getLikesCountById($id){
    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM favorites WHERE item = :item");
    $sentence->execute([':item' => $id]);
    $row = $sentence->fetch();
    return $row['total'];
}}

/* --- BUSCA SEGURA --- */
if (!function_exists('getSearch')) {

function getSearch(PDO $connect, int $limit = 9): array
{
    $items_per_page = max(1, (int)$limit);
    $page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
    $off  = max(0, ($page - 1) * $items_per_page);

    // Flags
    $showAll = false;
    if (isset($_GET['show']) && strtolower((string)$_GET['show']) === 'all') { $showAll = true; }
    if (isset($_GET['all']) && (int)$_GET['all'] === 1) { $showAll = true; }
    if (isset($_GET['nearby']) && (int)$_GET['nearby'] === 0) { $showAll = true; }
    if (isset($_GET['per_page']) && (string)$_GET['per_page'] === 'all') { $showAll = true; }

    // Base WHERE
    $where = array("d.deal_status = 1");
    $params = array();

    // Text search (optional)
    $q = isset($_GET['q']) ? trim((string)$_GET['q']) : (isset($_GET['s']) ? trim((string)$_GET['s']) : '');
    if ($q !== '') {
        $where[] = "(d.deal_title LIKE :q OR d.deal_description LIKE :q)";
        $params[':q'] = '%'.$q.'%';
    }

    // Nearby (default ON) – uses cookies or GET lat/lng; ignore if showAll
    if (!$showAll) {
        $userLat = null; $userLng = null;
        if (isset($_GET['lat'], $_GET['lng'])) {
            $userLat = (float)$_GET['lat'];
            $userLng = (float)$_GET['lng'];
        } elseif (!empty($_COOKIE['nd_geo_lat']) && !empty($_COOKIE['nd_geo_lng'])) {
            $userLat = (float)$_COOKIE['nd_geo_lat'];
            $userLng = (float)$_COOKIE['nd_geo_lng'];
        }
        $radiusKm = isset($_GET['radius_km']) ? max(1,(int)$_GET['radius_km']) : 30;

        if ($userLat !== null && $userLng !== null) {
            // Haversine with named placeholders (unique names)
            $where[] = "EXISTS (
                SELECT 1 FROM locations l
                WHERE l.location_id = d.deal_location
                  AND l.location_lat IS NOT NULL
                  AND l.location_lng IS NOT NULL
                  AND (6371 * ACOS( COS(RADIANS(:ulat1)) * COS(RADIANS(l.location_lat)) * COS(RADIANS(l.location_lng) - RADIANS(:ulng)) + SIN(RADIANS(:ulat2)) * SIN(RADIANS(l.location_lat)) )) <= :radius_km
            )";
            $params[':ulat1'] = (string)$userLat;
            $params[':ulat2'] = (string)$userLat;
            $params[':ulng']  = (string)$userLng;
            $params[':radius_km'] = (string)$radiusKm;
        }
    }

    

    // Rating filter (1 to 5 stars, coming from ?rating=)
    if (isset($_GET['rating']) && $_GET['rating'] !== '' && $_GET['rating'] !== 'all') {
        $minRating = (int)$_GET['rating'];
        if ($minRating > 0 && $minRating <= 5) {
            $where[] = "(SELECT AVG(rf.rating) FROM reviews rf WHERE rf.item = d.deal_id AND rf.status = 1) >= :min_rating";
            $params[':min_rating'] = (string)$minRating;
        }
    }

    // Price filter (coming from ?price=, e.g. "0,15" or "75")
    if (isset($_GET['price']) && $_GET['price'] !== '' && $_GET['price'] !== 'all') {
        $price = (string)$_GET['price'];
        if (strpos($price, ',') !== false) {
            $parts = explode(',', $price, 2);
            $pmin = (float)$parts[0];
            $pmax = (float)$parts[1];
            if ($pmin >= 0 && $pmax > 0 && $pmax >= $pmin) {
                $where[] = "CAST(d.deal_price AS DECIMAL(10,2)) BETWEEN :price_min AND :price_max";
                $params[':price_min'] = (string)$pmin;
                $params[':price_max'] = (string)$pmax;
            }
        } else {
            $pmin = (float)$price;
            if ($pmin >= 0) {
                $where[] = "CAST(d.deal_price AS DECIMAL(10,2)) >= :price_min_only";
                $params[':price_min_only'] = (string)$pmin;
            }
        }
    }

// Compile WHERE keeping only conditions with all placeholders present
    $compiled = array();
    foreach ($where as $cond) {
        if (preg_match_all('/:\w+/', $cond, $mm)) {
            $ok = true;
            foreach ($mm[0] as $ph) {
                if (!array_key_exists($ph, $params)) { $ok = false; break; }
            }
            if ($ok) { $compiled[] = $cond; }
        } else {
            $compiled[] = $cond;
        }
    }
    $whereSql = $compiled ? implode(' AND ', $compiled) : '1=1';

    // Order
    $orderBy = 'd.deal_created DESC';

    // COUNT
    $countSql = "SELECT COUNT(*) AS total
                 FROM deals d
                 LEFT JOIN stores s ON s.store_id = d.deal_store
                 WHERE $whereSql";
    $st = $connect->prepare($countSql);
    if (preg_match_all('/:\w+/', $countSql, $mm)) {
        $tokens = array_unique($mm[0]);
        foreach ($tokens as $tk) { if (isset($params[$tk])) { $st->bindValue($tk, $params[$tk], PDO::PARAM_STR); } }
    }
    $st->execute();
    $total = (int)($st->fetchColumn() ?: 0);

    // ITEMS
    $sql = "SELECT DISTINCT
                d.*,
                (SELECT AVG(r2.rating) FROM reviews r2 WHERE r2.item = d.deal_id AND r2.status = 1) AS rating,
                (SELECT COUNT(*) FROM reviews r3 WHERE r3.item = d.deal_id AND r3.status = 1) AS total_reviews,
                c.category_title,
                s.store_id, s.store_title, s.store_slug
            FROM deals d
            LEFT JOIN categories c ON c.category_id = d.deal_category
            LEFT JOIN stores     s ON s.store_id     = d.deal_store
            WHERE $whereSql
            ORDER BY $orderBy";
    if (!$showAll) {
        $sql .= " LIMIT ".(int)$off.", ".(int)$items_per_page;
    }
    $stmt = $connect->prepare($sql);
    if (preg_match_all('/:\w+/', $sql, $mm)) {
        $tokens = array_unique($mm[0]);
        foreach ($tokens as $tk) { if (isset($params[$tk])) { $stmt->bindValue($tk, $params[$tk], PDO::PARAM_STR); } }
    }
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];
    if ($showAll) { $total = is_array($rows) ? count($rows) : $total; }

    return ['items' => $rows, 'total' => $total];
}




}

/* --- LISTAGENS POR ENTIDADE COM WHERE SEGURO --- */

if (!function_exists('getDealsByStore')) {
function getDealsByStore($connect, $items_per_page, $itemId){
    $limit = (getNumPage() > 1) ? getNumPage() * $items_per_page - $items_per_page : 0;
    $now = getDateByTimeZone();
    $sqlQuery = "
        SELECT SQL_CALC_FOUND_ROWS deals.*,
            (SELECT AVG(rating) FROM reviews WHERE reviews.item = deals.deal_id AND reviews.status = 1) AS deal_rating,
            CAST(deals.deal_price AS UNSIGNED) AS price,
            categories.category_title AS category_title,
            subcategories.subcategory_title AS subcategory_title,
            stores.store_title AS store_title,
            locations.location_title AS location_title,
            users.user_name AS author_name,
            (SELECT COUNT(*) FROM reviews WHERE reviews.item = deals.deal_id AND reviews.status = 1) AS total_reviews
        FROM deals
        LEFT JOIN categories ON deals.deal_category = categories.category_id
        LEFT JOIN stores ON deals.deal_store = stores.store_id
        LEFT JOIN locations ON deals.deal_location = locations.location_id
        LEFT JOIN users ON deals.deal_author = users.user_id
        LEFT JOIN subcategories ON deals.deal_subcategory = subcategories.subcategory_id
        LEFT JOIN reviews ON reviews.item = deals.deal_id
        WHERE deals.deal_store = :store
          AND deals.deal_status = 1
          AND (CASE
                WHEN CAST(deals.deal_start AS CHAR(25)) IN ('', '0000-00-00 00:00:00')
                     OR CAST(deals.deal_start AS CHAR(10)) = '0000-00-00'
                     OR deals.deal_start IS NULL
               THEN 1
               ELSE (deals.deal_start <= :now)
              END)
          AND (CASE
                WHEN CAST(deals.deal_expire AS CHAR(25)) IN ('', '0000-00-00 00:00:00')
                     OR CAST(deals.deal_expire AS CHAR(10)) = '0000-00-00'
                     OR deals.deal_expire IS NULL
               THEN 1
               ELSE (:now <= deals.deal_expire)
              END)
        GROUP BY deals.deal_id
        ORDER BY deals.deal_created DESC
        LIMIT $limit, $items_per_page";
    $sentence = $connect->prepare($sqlQuery);
    $sentence->execute([':store'=>$itemId, ':now'=>$now]);
    $total = $connect->query("SELECT FOUND_ROWS()")->fetchColumn();
    $items = $sentence->fetchAll(PDO::FETCH_ASSOC);
    return array('items' => $items, 'total' => $total);
}}



if (!function_exists('getStoreActiveDeals')) {
    /**
     * Versão simplificada para a página pública da loja:
     * retorna apenas as ofertas ativas de uma store.
     */
    function getStoreActiveDeals(PDO $connect, int $storeId, int $limit = 12): array
    {
        $storeId = max(0, (int)$storeId);
        if ($storeId === 0) {
            return [];
        }

        $sql = "
            SELECT
                d.*,
                s.store_title,
                s.store_slug,
                l.location_title
            FROM deals d
            LEFT JOIN stores    s ON s.store_id    = d.deal_store
            LEFT JOIN locations l ON l.location_id = d.deal_location
            WHERE
                d.deal_store = :sid
                AND d.deal_status = 1
                AND (d.deal_start IS NULL OR d.deal_start <= NOW())
                AND (d.deal_expire IS NULL OR d.deal_expire >= NOW())
            ORDER BY d.deal_created DESC
        ";

        if ($limit > 0) {
            $sql .= " LIMIT :lim";
        }

        $stmt = $connect->prepare($sql);
        $stmt->bindValue(':sid', $storeId, PDO::PARAM_INT);
        if ($limit > 0) {
            $stmt->bindValue(':lim', $limit, PDO::PARAM_INT);
        }
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }
}

if (!function_exists('getStorePastDeals')) {
    /**
     * Retorna ofertas expiradas ou desativadas para mostrar como histórico.
     */
    function getStorePastDeals(PDO $connect, int $storeId, int $limit = 12): array
    {
        $storeId = max(0, (int)$storeId);
        if ($storeId === 0) {
            return [];
        }

        $sql = "
            SELECT
                d.*,
                s.store_title,
                s.store_slug,
                l.location_title
            FROM deals d
            LEFT JOIN stores    s ON s.store_id    = d.deal_store
            LEFT JOIN locations l ON l.location_id = d.deal_location
            WHERE
                d.deal_store = :sid
                AND (
                    d.deal_status <> 1
                    OR (d.deal_expire IS NOT NULL AND d.deal_expire < NOW())
                )
            ORDER BY d.deal_created DESC
        ";

        if ($limit > 0) {
            $sql .= " LIMIT :lim";
        }

        $stmt = $connect->prepare($sql);
        $stmt->bindValue(':sid', $storeId, PDO::PARAM_INT);
        if ($limit > 0) {
            $stmt->bindValue(':lim', $limit, PDO::PARAM_INT);
        }
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }
}

if (!function_exists('getDealsByLocation')) {
    function getDealsByLocation(PDO $connect, int $limit = 6, int $locationId = 0): array
    {
        $limit      = max(1, (int)$limit);
        $locationId = max(0, (int)$locationId);

        $sql = "
            SELECT
                d.deal_id,
                d.deal_slug,
                d.deal_title,
                d.deal_image,
                d.deal_price,
                d.deal_start,
                d.deal_expire,
                d.deal_location,
                s.store_id,
                s.store_title,
                s.store_slug
            FROM deals d
            LEFT JOIN stores s ON s.store_id = d.deal_store
            WHERE
                d.deal_status = 1
                AND (d.deal_start IS NULL OR d.deal_start <= NOW())
                AND (d.deal_expire IS NULL OR d.deal_expire >= NOW())
                AND (
                    :locId = 0
                    OR d.deal_location = :locId
                )
            ORDER BY d.deal_id DESC
            LIMIT :lim
        ";

        // ND_STRIP_LIMIT: strip LIMIT when showing all (unless respecting per_page)
        if (!empty($forceAll) && empty($respectPerPageWhenAll)) {
            $sql = preg_replace('/\s+LIMIT\s*:off\s*,\s*:lim\s*;?\s*$/i','', $sql);
        }

        $stmt = $connect->prepare($sql);
        $stmt->bindValue(':locId', $locationId, PDO::PARAM_INT);
        $stmt->bindValue(':lim',   $limit,      PDO::PARAM_INT);
        $stmt->execute();

        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];

        foreach ($rows as &$r) {
            $slug   = trim($r['deal_slug'] ?? '');
            $dealId = (int)($r['deal_id'] ?? 0);
            if ($slug !== '') {
                $r['permalink'] = './?slug=' . rawurlencode($slug);
            } elseif ($dealId > 0) {
                $r['permalink'] = './?deal_id=' . $dealId;
            } else {
                $r['permalink'] = '#';
            }
            if (empty($r['store_name'])) {
                $r['store_name'] = $r['store_title'] ?? '';
            }
        }
        unset($r);

        return $rows;
    }
}

if (!function_exists('getDealsByUser')) {}
if (!function_exists('getDealsByUserr')) {
function getDealsByUserr($connect, $items_per_page, $itemId){
    $limit = (getNumPage() > 1) ? getNumPage() * $items_per_page - $items_per_page : 0;
    $now = getDateByTimeZone();
    $sqlQuery = "
        SELECT SQL_CALC_FOUND_ROWS deals.*,
            (SELECT AVG(rating) FROM reviews WHERE reviews.item = deals.deal_id AND reviews.status = 1) AS deal_rating,
            CAST(deals.deal_price AS UNSIGNED) AS price,
            categories.category_title AS category_title,
            subcategories.subcategory_title AS subcategory_title,
            stores.store_title AS store_title,
            locations.location_title AS location_title,
            users.user_name AS author_name,
            (SELECT COUNT(*) FROM reviews WHERE reviews.item = deals.deal_id AND reviews.status = 1) AS total_reviews
        FROM deals
        LEFT JOIN categories ON deals.deal_category = categories.category_id
        LEFT JOIN stores ON deals.deal_store = stores.store_id
        LEFT JOIN locations ON deals.deal_location = locations.location_id
        LEFT JOIN users ON deals.deal_author = users.user_id
        LEFT JOIN subcategories ON deals.deal_subcategory = subcategories.subcategory_id
        LEFT JOIN reviews ON reviews.item = deals.deal_id
        WHERE deals.deal_author = :user
          AND deals.deal_status = 1
          AND (CASE
                WHEN CAST(deals.deal_start AS CHAR(25)) IN ('', '0000-00-00 00:00:00')
                     OR CAST(deals.deal_start AS CHAR(10)) = '0000-00-00'
                     OR deals.deal_start IS NULL
               THEN 1
               ELSE (deals.deal_start <= :now)
              END)
          AND (CASE
                WHEN CAST(deals.deal_expire AS CHAR(25)) IN ('', '0000-00-00 00:00:00')
                     OR CAST(deals.deal_expire AS CHAR(10)) = '0000-00-00'
                     OR deals.deal_expire IS NULL
               THEN 1
               ELSE (:now <= deals.deal_expire)
              END)
        GROUP BY deals.deal_id
        ORDER BY deals.deal_created DESC
        LIMIT $limit, $items_per_page";
    $sentence = $connect->prepare($sqlQuery);
    $sentence->execute([':user'=>$itemId, ':now'=>$now]);
    $total = $connect->query("SELECT FOUND_ROWS()")->fetchColumn();
    $items = $sentence->fetchAll(PDO::FETCH_ASSOC);
    return array('items' => $items, 'total' => $total);
}
}

if (!function_exists('getDealsByCategory')) {
function getDealsByCategory($connect, $items_per_page, $itemId){
    $limit = (getNumPage() > 1) ? getNumPage() * $items_per_page - $items_per_page : 0;
    $now = getDateByTimeZone();
    $sqlQuery = "
        SELECT SQL_CALC_FOUND_ROWS deals.*,
            (SELECT AVG(rating) FROM reviews WHERE reviews.item = deals.deal_id AND reviews.status = 1) AS deal_rating,
            CAST(deals.deal_price AS UNSIGNED) AS price,
            categories.category_title AS category_title,
            subcategories.subcategory_title AS subcategory_title,
            stores.store_title AS store_title,
            locations.location_title AS location_title,
            users.user_name AS author_name,
            (SELECT COUNT(*) FROM reviews WHERE reviews.item = deals.deal_id AND reviews.status = 1) AS total_reviews,
            COALESCE(ao.has_cat7,0)  AS has_cat7,
            COALESCE(ao.cat_fixed,0) AS cat_fixed
        FROM deals
        LEFT JOIN categories ON deal_category = categories.category_id
        LEFT JOIN stores ON deal_store = stores.store_id
        LEFT JOIN (
            SELECT
                store_id,
                MAX(CASE WHEN addon_code='cat7' THEN 1 ELSE 0 END) AS has_cat7,
                MAX(CASE WHEN addon_code='cat7' AND meta_json LIKE '%\"mode\":\"fixed\"%' THEN 1 ELSE 0 END) AS cat_fixed
            FROM nd_addon_orders
            WHERE status='active'
              AND addon_code='cat7'
              AND (start_date IS NULL OR start_date <= NOW())
              AND (end_date   IS NULL OR end_date   >= NOW())
            GROUP BY store_id
        ) ao ON ao.store_id = stores.store_id
        LEFT JOIN locations ON deal_location = locations.location_id
        LEFT JOIN users ON deal_author = users.user_id
        LEFT JOIN subcategories ON deal_subcategory = subcategories.subcategory_id
        WHERE deals.deal_category = :cat
          AND deals.deal_status = 1
          AND (CASE
                WHEN CAST(deals.deal_expire AS CHAR(25)) IN ('', '0000-00-00 00:00:00')
                     OR CAST(deals.deal_expire AS CHAR(10)) = '0000-00-00'
                     OR deals.deal_expire IS NULL
               THEN 1
               ELSE (:now <= deals.deal_expire)
              END)
        GROUP BY deals.deal_id
        ORDER BY
            COALESCE(ao.cat_fixed,0) DESC,
            COALESCE(ao.has_cat7,0) DESC,
            (CASE WHEN COALESCE(ao.has_cat7,0)=1 THEN MD5(CONCAT(deals.deal_id, CURDATE())) ELSE '' END) ASC,
            deals.deal_created DESC
        LIMIT $limit, $items_per_page";
    $sentence = $connect->prepare($sqlQuery);
    $sentence->execute([':cat'=>$itemId, ':now'=>$now]);
    $total = $connect->query("SELECT FOUND_ROWS()")->fetchColumn();
    $items = $sentence->fetchAll(PDO::FETCH_ASSOC);
    return array('items' => $items, 'total' => $total);
}}
if (!function_exists('getDealsBySubCategory')) {
function getDealsBySubCategory($connect, $items_per_page, $itemId){
    $limit = (getNumPage() > 1) ? getNumPage() * $items_per_page - $items_per_page : 0;
    $now = getDateByTimeZone();
    $sqlQuery = "
        SELECT SQL_CALC_FOUND_ROWS deals.*,
            (SELECT AVG(rating) FROM reviews WHERE reviews.item = deals.deal_id AND reviews.status = 1) AS deal_rating,
            CAST(deals.deal_price AS UNSIGNED) AS price,
            categories.category_title AS category_title,
            subcategories.subcategory_title AS subcategory_title,
            stores.store_title AS store_title,
            locations.location_title AS location_title,
            users.user_name AS author_name,
            (SELECT COUNT(*) FROM reviews WHERE reviews.item = deals.deal_id AND reviews.status = 1) AS total_reviews,
            COALESCE(ao.has_cat7,0)  AS has_cat7,
            COALESCE(ao.cat_fixed,0) AS cat_fixed
        FROM deals
        LEFT JOIN categories ON deal_category = categories.category_id
        LEFT JOIN stores ON deal_store = stores.store_id
        LEFT JOIN (
            SELECT
                store_id,
                MAX(CASE WHEN addon_code='cat7' THEN 1 ELSE 0 END) AS has_cat7,
                MAX(CASE WHEN addon_code='cat7' AND meta_json LIKE '%\"mode\":\"fixed\"%' THEN 1 ELSE 0 END) AS cat_fixed
            FROM nd_addon_orders
            WHERE status='active'
              AND addon_code='cat7'
              AND (start_date IS NULL OR start_date <= NOW())
              AND (end_date   IS NULL OR end_date   >= NOW())
            GROUP BY store_id
        ) ao ON ao.store_id = stores.store_id
        LEFT JOIN locations ON deal_location = locations.location_id
        LEFT JOIN users ON deal_author = users.user_id
        LEFT JOIN subcategories ON deal_subcategory = subcategories.subcategory_id
        WHERE deals.deal_subcategory = :subcat
          AND deals.deal_status = 1
          AND (CASE
                WHEN CAST(deals.deal_expire AS CHAR(25)) IN ('', '0000-00-00 00:00:00')
                     OR CAST(deals.deal_expire AS CHAR(10)) = '0000-00-00'
                     OR deals.deal_expire IS NULL
               THEN 1
               ELSE (:now <= deals.deal_expire)
              END)
        GROUP BY deals.deal_id
        ORDER BY
            COALESCE(ao.cat_fixed,0) DESC,
            COALESCE(ao.has_cat7,0) DESC,
            (CASE WHEN COALESCE(ao.has_cat7,0)=1 THEN MD5(CONCAT(deals.deal_id, CURDATE())) ELSE '' END) ASC,
            deals.deal_created DESC
        LIMIT $limit, $items_per_page";
    $sentence = $connect->prepare($sqlQuery);
    $sentence->execute([':subcat'=>$itemId, ':now'=>$now]);
    $total = $connect->query("SELECT FOUND_ROWS()")->fetchColumn();
    $items = $sentence->fetchAll(PDO::FETCH_ASSOC);
    return array('items' => $items, 'total' => $total);
}}

if (!function_exists('getLocationsByLetter')) {
function getLocationsByLetter(PDO $connect, $letter = null){
    if ($letter === null || $letter === '') {
        $st = $connect->prepare(
            "SELECT locations.* FROM locations WHERE location_status = 1 AND location_title REGEXP '^[0-9]'"
        );
    } else {
        $st = $connect->prepare(
            "SELECT locations.* FROM locations WHERE location_status = 1 AND location_title LIKE :letter"
        );
        $st->bindValue(':letter', $letter.'%', PDO::PARAM_STR);
    }
    $st->execute();
    return $st->fetchAll(PDO::FETCH_ASSOC);
}}
if (!function_exists('getStoresByLetter')) {
function getStoresByLetter(PDO $connect, $letter = null){

    $conditions = ["store_status = 1"];
    $params = [];

    if ($letter === null || $letter === '') {
        $conditions[] = "store_title REGEXP '^[0-9]'";
    } else {
        $conditions[] = "store_title LIKE :letter";
        $params[':letter'] = $letter . '%';
    }

    // Filtros opcionais vindos da query string
    $categoryId = isset($_GET['cat']) ? (int) $_GET['cat'] : 0;
    $locationId = isset($_GET['loc']) ? (int) $_GET['loc'] : 0;
    $openNow    = isset($_GET['open_now']) && $_GET['open_now'] === '1';

    if ($categoryId > 0) {
        $conditions[] = "store_category = :cat";
        $params[':cat'] = $categoryId;
    }

    if ($locationId > 0) {
        $conditions[] = "store_location = :loc";
        $params[':loc'] = $locationId;
    }

    $sql = "SELECT stores.* FROM stores WHERE " . implode(" AND ", $conditions) . " ORDER BY store_title ASC";

    $st = $connect->prepare($sql);

    foreach ($params as $key => $value) {
        if ($key === ':letter') {
            $st->bindValue($key, $value, PDO::PARAM_STR);
        } else {
            $st->bindValue($key, $value, PDO::PARAM_INT);
        }
    }

    $st->execute();
    $stores = $st->fetchAll(PDO::FETCH_ASSOC);

    if ($openNow && function_exists('isStoreOpenNow')) {
        $stores = array_values(array_filter($stores, function(array $store): bool {
            $state = isStoreOpenNow($store['store_hours'] ?? null);
            return $state === true;
        }));
    }

    return $stores;
}
}


if (!function_exists('getStoreRating')) {
function getStoreRating(PDO $connect, int $storeId)
{
    // Calcula a nota média da loja com base nas avaliações das ofertas vinculadas
    $sql = "
        SELECT AVG(rating) AS rating
        FROM reviews
        WHERE status = 1
          AND item IN (
              SELECT deal_id
              FROM deals
              WHERE deal_store = :sid
          )
    ";
    $st = $connect->prepare($sql);
    $st->execute([':sid' => $storeId]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    if (!$row || $row['rating'] === null) {
        return null;
    }
    return (float) $row['rating'];
}
}


/*------------------------------------------------------------ */

if (!function_exists('getStoreReviewStats')) {
function getStoreReviewStats(PDO $connect, int $storeId): array
{
    // Retorna média, quantidade de avaliações e se é recomendado pela comunidade
    $sql = "
        SELECT
            AVG(rating) AS rating,
            COUNT(*)    AS total
        FROM reviews
        WHERE status = 1
          AND item IN (
              SELECT deal_id
              FROM deals
              WHERE deal_store = :sid
          )
    ";
    $st = $connect->prepare($sql);
    $st->execute([':sid' => $storeId]);
    $row = $st->fetch(PDO::FETCH_ASSOC) ?: ['rating' => null, 'total' => 0];

    $rating = $row['rating'] !== null ? (float) $row['rating'] : null;
    $total  = (int)($row['total'] ?? 0);

    // Critério simples para "Indicado pelos moradores"
    $recommended = $rating !== null && $rating >= 4.5 && $total >= 10;

    return [
        'rating'      => $rating,
        'total'       => $total,
        'recommended' => $recommended,
    ];
}
}






if (!function_exists('getTopRatedStores')) {
function getTopRatedStores(PDO $connect, int $limit = 5): array
{
    // Retorna as lojas mais bem avaliadas (Top N)
    $sql = "
        SELECT
            s.*,
            AVG(r.rating) AS rating,
            COUNT(*)      AS reviews_count
        FROM stores s
        INNER JOIN deals d
            ON d.deal_store = s.store_id
           AND d.deal_status = 1
        INNER JOIN reviews r
            ON r.item = d.deal_id
           AND r.status = 1
        WHERE s.store_status = 1
        GROUP BY s.store_id
        HAVING reviews_count >= 3
        ORDER BY rating DESC, reviews_count DESC
        LIMIT :limit
    ";

    $st = $connect->prepare($sql);
    $st->bindValue(':limit', $limit, PDO::PARAM_INT);
    $st->execute();

    return $st->fetchAll(PDO::FETCH_ASSOC);
}
}

if (!function_exists('getPages')) {
function getPages($connect){
    $sentence = $connect->prepare("SELECT * FROM pages WHERE page_status = 1");
    $sentence->execute();
    return $sentence->fetchAll(PDO::FETCH_ASSOC);
}}
if (!function_exists('getDeals')) {
function getDeals($connect){
    // ND: ordena a vitrine priorizando Add-on Home 7 dias
    $sqlQuery = "
        SELECT deals.*,
            categories.category_title AS category_title,
            subcategories.subcategory_title AS subcategory_title,
            stores.store_id AS store_id,
            stores.store_title AS store_title,
            stores.store_image AS store_image,
            stores.store_slug AS store_slug,
            users.user_name AS author_name,
            COALESCE(ao.has_home7,0)  AS has_home7,
            COALESCE(ao.home_fixed,0) AS home_fixed
        FROM deals
        LEFT JOIN categories ON deal_category = categories.category_id
        LEFT JOIN stores ON deal_store = stores.store_id
        LEFT JOIN (
            SELECT
                store_id,
                MAX(CASE WHEN addon_code='home7' THEN 1 ELSE 0 END) AS has_home7,
                MAX(CASE WHEN addon_code='home7' AND meta_json LIKE '%\"mode\":\"fixed\"%' THEN 1 ELSE 0 END) AS home_fixed
            FROM nd_addon_orders
            WHERE status='active'
              AND addon_code='home7'
              AND (start_date IS NULL OR start_date <= NOW())
              AND (end_date   IS NULL OR end_date   >= NOW())
            GROUP BY store_id
        ) ao ON ao.store_id = stores.store_id
        LEFT JOIN users ON deal_author = users.user_id
        LEFT JOIN subcategories ON deal_subcategory = subcategories.subcategory_id
        LEFT JOIN reviews ON reviews.item = deals.deal_id
        WHERE deals.deal_status = 1
        GROUP BY deals.deal_id
        ORDER BY
            COALESCE(ao.home_fixed,0) DESC,
            COALESCE(ao.has_home7,0) DESC,
            (CASE WHEN COALESCE(ao.has_home7,0)=1 THEN MD5(CONCAT(deals.deal_id, CURDATE())) ELSE '' END) ASC,
            deals.deal_created DESC
    ";
    $sentence = $connect->prepare($sqlQuery);
    $sentence->execute();
    return $sentence->fetchAll(PDO::FETCH_ASSOC);
}}
if (!function_exists('getSubCategoriesSiteMap')) {
function getSubCategoriesSiteMap($connect){
    $sentence = $connect->prepare("SELECT subcategories.* FROM subcategories WHERE subcategories.subcategory_status = 1");
    $sentence->execute();
    return $sentence->fetchAll(PDO::FETCH_ASSOC);
}}
if (!function_exists('getDealBySlug')) {
function getDealBySlug(PDO $connect, string $slug) {
    $sql = "
        SELECT
            d.*,
            c.category_title AS category_name,
            s.store_title    AS store_name
        FROM deals d
        LEFT JOIN categories c ON CAST(d.deal_category AS UNSIGNED) = c.category_id
        LEFT JOIN stores     s ON CAST(d.deal_store    AS UNSIGNED) = s.store_id
        WHERE
            d.deal_slug = :slug
            AND d.deal_status = 1
            AND (d.deal_expire IS NULL OR d.deal_expire >= NOW())
        LIMIT 1
    ";
    $st = $connect->prepare($sql);
    $st->bindValue(':slug', $slug, PDO::PARAM_STR);
    $st->execute();
    return $st->fetch(PDO::FETCH_ASSOC) ?: null;
}
}


/*------------------------------------------------------------ */
/* ADS & SETTINGS */
/*------------------------------------------------------------ */

if (!function_exists('getHeaderAd')) {
function getHeaderAd($connect){
    $sentence = $connect->prepare("SELECT * FROM ads WHERE ad_position = 'header' AND ad_status = 1 ORDER BY RAND() LIMIT 1");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getFooterAd')) {
function getFooterAd($connect){
    $sentence = $connect->prepare("SELECT * FROM ads WHERE ad_position = 'footer' AND ad_status = 1 ORDER BY RAND() LIMIT 1");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getSidebarAd')) {
function getSidebarAd($connect){
    $sentence = $connect->prepare("SELECT * FROM ads WHERE ad_position = 'sidebar' AND ad_status = 1 ORDER BY RAND() LIMIT 1");
    $sentence->execute();
    return $sentence->fetchAll();
}}
if (!function_exists('getSettings')) {
function getSettings($connect){
    $sentence = $connect->prepare("SELECT * FROM settings");
    $sentence->execute();
    return $sentence->fetch();
}}
if (!function_exists('getTheme')) {
function getTheme($connect){
    $sentence = $connect->prepare("SELECT * FROM theme");
    $sentence->execute();
    return $sentence->fetch();
}}
if (!function_exists('getDefaultPage')) {
function getDefaultPage($connect, $page){
    if(!$page) return NULL;
    $sentence = $connect->prepare("SELECT * FROM pages WHERE page_status = 1 AND page_id = :page_id LIMIT 1");
    $sentence->execute([':page_id' => $page]);
    return $sentence->fetch();
}}
if (!function_exists('getPageBySlug')) {
function getPageBySlug($connect, $slug){
    $sentence = $connect->prepare("SELECT * FROM pages WHERE page_status = 1 AND page_slug = :page_slug LIMIT 1");
    $sentence->execute([':page_slug' => $slug]);
    return $sentence->fetch();
}}
if (!function_exists('getPageByID')) {
function getPageByID($connect, $id_page){
    $sentence = $connect->prepare("SELECT * FROM pages WHERE page_status = 1 AND page_id = :page_id LIMIT 1");
    $sentence->execute([':page_id' => $id_page]);
    return $sentence->fetch();
}}
if (!function_exists('getSidebarMenu')) {
function getSidebarMenu($connect){
    $f = $connect->query("SELECT * FROM menus WHERE menu_sidebar = 1 AND menu_status = 1 ORDER BY menu_id DESC LIMIT 1")->fetch();
    return $f;
}}
if (!function_exists('getHeaderMenu')) {
function getHeaderMenu($connect){
    $f = $connect->query("SELECT * FROM menus WHERE menu_header = 1 AND menu_status = 1 ORDER BY menu_id DESC LIMIT 1")->fetch();
    return $f;
}}
if (!function_exists('getFooterMenu')) {
function getFooterMenu($connect){
    $f = $connect->query("SELECT * FROM menus WHERE menu_footer = 1 AND menu_status = 1 ORDER BY menu_id DESC LIMIT 1")->fetch();
    return $f;
}}
if (!function_exists('getNavigation')) {
function getNavigation($connect, $idMenu){
    $sentence = $connect->prepare("SELECT navigations.navigation_id, navigations.navigation_page, navigations.navigation_target, COALESCE(pages.page_slug, navigations.navigation_url) AS navigation_url, COALESCE(pages.page_title, navigations.navigation_label) AS navigation_label, navigations.navigation_type FROM navigations LEFT JOIN pages ON page_id = navigations.navigation_page WHERE navigation_menu = '".$idMenu."' ORDER BY navigation_order ASC");
    $sentence->execute();
    return $sentence->fetchAll();
}}

/*------------------------------------------------------------ */
/* EMAIL */
/*------------------------------------------------------------ */

if (!function_exists('getEmailTemplate')) {
function getEmailTemplate($connect, $id){
    if (empty($id) || !(int)$id) return null;
    $f = $connect->query("SELECT * FROM emailtemplates WHERE email_id = ".$id." LIMIT 1")->fetch();
    if (!$f || $f['email_disabled'] == 1) return null;
    return $f;
}}
if (!function_exists('sendMail')) {
function sendMail($array_content, $email_content, $destinationmail, $fromName, $subject, $isHtml, $replyToName = NULL, $replyToAddress = NULL) {
    $sentence = connect()->prepare("SELECT * FROM settings");
    $sentence->execute();
    $settings = $sentence->fetch();

    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host       = $settings['st_smtphost'];
        $mail->SMTPAuth   = true;
        $mail->Username   = $settings['st_smtpemail'];
        $mail->Password   = $settings['st_smtppassword'];
        $mail->SMTPSecure = $settings['st_smtpencrypt'];
        $mail->Port       = $settings['st_smtpport'];

        if (!empty($replyToAddress) && !empty($replyToName)) {
            $mail->addReplyTo($replyToAddress, $replyToName);
        }

        $mail->setFrom($settings['st_smtpemail'], $fromName);
        $mail->CharSet = "UTF-8";
        $mail->AddAddress($destinationmail);
        $mail->isHTML($isHtml);

        $find = array_keys($array_content);
        $replace = array_values($array_content);

        $mailcontent = str_replace($find, $replace, $email_content);
        $mailsubject = str_replace($find, $replace, $subject);

        $mail->Subject = $mailsubject;
        $mail->Body = $mailcontent;
        if (!$mail->send()){
            $result = $mail->ErrorInfo;
        }else{
            $result = 'TRUE';
        }
        return $result;
    } catch (Exception $e) {
        return $e;
    }
}}

/*------------------------------------------------------------ */

/*------------------------------------------------------------ */
/* ADD-ONS ORDERS (operacional) */
/*------------------------------------------------------------ */

if (!function_exists('nd_addons_catalog')) {
function nd_addons_catalog(): array {
    return [
        'home7' => ['key'=>'home7','title'=>'Destaque na Home (7 dias)','type'=>'one_time','duration_days'=>7,'unit_price'=>99.00],
        'cat7'  => ['key'=>'cat7','title'=>'Topo da Categoria (7 dias)','type'=>'one_time','duration_days'=>7,'unit_price'=>79.00],
        'creative' => ['key'=>'creative','title'=>'Pacote Criativo + Oferta Matadora','type'=>'service','duration_days'=>0,'unit_price'=>0.00],
        'exclusive' => ['key'=>'exclusive','title'=>'Exclusividade por segmento/bairro','type'=>'per_month','duration_days'=>0,'unit_price'=>0.00],
        'setup' => ['key'=>'setup','title'=>'Setup de implantação','type'=>'service','duration_days'=>0,'unit_price'=>149.00],
    ];
}}
if (!function_exists('nd_addons_ensure_table')) {
function nd_addons_ensure_table($connect): void {
    if (!$connect) return;
    try {
        $q = $connect->query("SHOW TABLES LIKE 'nd_addon_orders'");
        $exists = (bool)($q && $q->fetch(\PDO::FETCH_NUM));
        if ($exists) return;

        $connect->exec(
            "CREATE TABLE nd_addon_orders (\n".
            "  id INT UNSIGNED NOT NULL AUTO_INCREMENT,\n".
            "  payment_id INT NULL,\n".
            "  payment_external VARCHAR(120) NULL,\n".
            "  payment_processor VARCHAR(32) NULL,\n".
            "  user_id INT NOT NULL,\n".
            "  store_id INT NULL,\n".
            "  addon_key VARCHAR(32) NOT NULL,\n".
            "  addon_title VARCHAR(160) NOT NULL,\n".
            "  billing_type VARCHAR(16) NOT NULL,\n".
            "  months INT NOT NULL DEFAULT 0,\n".
            "  unit_price DECIMAL(10,2) NOT NULL DEFAULT 0.00,\n".
            "  amount_total DECIMAL(10,2) NOT NULL DEFAULT 0.00,\n".
            "  status VARCHAR(24) NOT NULL DEFAULT 'pending_activation',\n".
            "  start_date DATETIME NULL,\n".
            "  end_date DATETIME NULL,\n".
            "  notes TEXT NULL,\n".
            "  meta_json LONGTEXT NULL,\n".
            "  created_at DATETIME NOT NULL,\n".
            "  updated_at DATETIME NULL,\n".
            "  PRIMARY KEY (id),\n".
            "  KEY idx_user (user_id),\n".
            "  KEY idx_store (store_id),\n".
            "  KEY idx_status (status),\n".
            "  KEY idx_dates (start_date,end_date)\n".
            ") ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci"
        );
    } catch (\Throwable $e) {
        // silencioso
    }
}}
if (!function_exists('nd_addons_parse_payment_taxes')) {
function nd_addons_parse_payment_taxes($payment_taxes): array {
    // payment_taxes pode ser: JSON string; array; ou "taxes_ids"
    $payload = [];
    if (is_string($payment_taxes) && trim($payment_taxes) !== '') {
        $decoded = json_decode($payment_taxes, true);
        if (is_array($decoded)) $payload = $decoded;
    } elseif (is_array($payment_taxes)) {
        $payload = $payment_taxes;
    } else {
        $payload = [];
    }

    // Se veio só taxes_ids (ex: "[1,2]"), transforma em payload
    if (isset($payload[0]) && !isset($payload['taxes_ids']) && !isset($payload['addons'])) {
        $payload = ['taxes_ids' => $payload];
    }

    $addons = [];
    if (isset($payload['addons']) && is_array($payload['addons'])) {
        $addons = $payload['addons'];
    }

    return [
        'taxes_ids' => $payload['taxes_ids'] ?? [],
        'addons' => $addons,
        'addons_total' => (float)($payload['addons_total'] ?? 0),
        'addons_charge_now' => (float)($payload['addons_charge_now'] ?? 0),
        'raw' => $payload,
    ];
}}
if (!function_exists('nd_addons_months_from_frequency')) {
function nd_addons_months_from_frequency(string $frequency): int {
    $f = strtolower(trim($frequency));
    if ($f === 'monthly') return 1;
    if ($f === 'halfyear' || $f === 'halfyea') return 6;
    if ($f === 'annual' || $f === 'yearly') return 12;
    return 1;
}}
if (!function_exists('nd_addons_insert_order')) {
function nd_addons_insert_order($connect, array $row): void {
    if (!$connect) return;
    nd_addons_ensure_table($connect);
    $sql = "INSERT INTO nd_addon_orders (payment_id, payment_external, payment_processor, user_id, store_id, addon_key, addon_title, billing_type, months, unit_price, amount_total, status, start_date, end_date, notes, meta_json, created_at, updated_at)
            VALUES (:payment_id, :payment_external, :payment_processor, :user_id, :store_id, :addon_key, :addon_title, :billing_type, :months, :unit_price, :amount_total, :status, :start_date, :end_date, :notes, :meta_json, :created_at, :updated_at)";
    $st = $connect->prepare($sql);
    $st->execute([
        ':payment_id' => $row['payment_id'] ?? null,
        ':payment_external' => $row['payment_external'] ?? null,
        ':payment_processor' => $row['payment_processor'] ?? null,
        ':user_id' => (int)($row['user_id'] ?? 0),
        ':store_id' => $row['store_id'] ?? null,
        ':addon_key' => (string)($row['addon_key'] ?? ''),
        ':addon_title' => (string)($row['addon_title'] ?? ''),
        ':billing_type' => (string)($row['billing_type'] ?? 'one_time'),
        ':months' => (int)($row['months'] ?? 0),
        ':unit_price' => (float)($row['unit_price'] ?? 0),
        ':amount_total' => (float)($row['amount_total'] ?? 0),
        ':status' => (string)($row['status'] ?? 'pending_activation'),
        ':start_date' => $row['start_date'] ?? null,
        ':end_date' => $row['end_date'] ?? null,
        ':notes' => $row['notes'] ?? null,
        ':meta_json' => $row['meta_json'] ?? null,
        ':created_at' => $row['created_at'] ?? getDateByTimeZone(),
        ':updated_at' => $row['updated_at'] ?? null,
    ]);
}}
if (!function_exists('nd_addons_register_from_payment')) {
function nd_addons_register_from_payment($connect, int $payment_id, string $payment_external, string $payment_processor, int $user_id, string $payment_frequency, $payment_taxes, bool $is_paid): void {
    if (!$connect || $user_id <= 0) return;

    $parsed = nd_addons_parse_payment_taxes($payment_taxes);
    $addons = $parsed['addons'];
    if (empty($addons) || !is_array($addons)) return;

    $catalog = nd_addons_catalog();
    $monthsCount = nd_addons_months_from_frequency($payment_frequency);

    // Exclusividade (segmento/bairro) pode vir do checkout
    $segment = (string)($parsed['raw']['exclusive_segment'] ?? '');
    $neighborhood = (string)($parsed['raw']['exclusive_neighborhood'] ?? '');
    $segment = trim($segment);
    $neighborhood = trim($neighborhood);


    // Evita duplicidade: se já existir ao menos 1 add-on para este payment_id, não reinsere
    try {
        nd_addons_ensure_table($connect);
        $ck = $connect->prepare("SELECT COUNT(*) FROM nd_addon_orders WHERE payment_id = :pid");
        $ck->execute([':pid' => $payment_id]);
        if ((int)$ck->fetchColumn() > 0) return;
    } catch (\Throwable $e) {}

    $chargeNow = (float)($parsed['addons_charge_now'] ?? 0);
    $paidForAddonsNow = ($is_paid && $chargeNow > 0.0);

    $now = getDateByTimeZone();

    $statusPaid = $paidForAddonsNow ? 'pending_activation' : ($is_paid ? 'pending_payment' : 'pending_payment');

    // home7
    if (!empty($addons['home7'])) {
        nd_addons_insert_order($connect, [
            'payment_id' => $payment_id,
            'payment_external' => $payment_external,
            'payment_processor' => $payment_processor,
            'user_id' => $user_id,
            'store_id' => null,
            'addon_key' => 'home7',
            'addon_title' => $catalog['home7']['title'],
            'billing_type' => 'one_time',
            'months' => 0,
            'unit_price' => 99.00,
            'amount_total' => 99.00,
            'status' => $statusPaid,
            'created_at' => $now,
            'meta_json' => json_encode(['source'=>'payment','frequency'=>$payment_frequency], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
        ]);
    }
    // cat7
    if (!empty($addons['cat7'])) {
        nd_addons_insert_order($connect, [
            'payment_id' => $payment_id,
            'payment_external' => $payment_external,
            'payment_processor' => $payment_processor,
            'user_id' => $user_id,
            'store_id' => null,
            'addon_key' => 'cat7',
            'addon_title' => $catalog['cat7']['title'],
            'billing_type' => 'one_time',
            'months' => 0,
            'unit_price' => 79.00,
            'amount_total' => 79.00,
            'status' => $statusPaid,
            'created_at' => $now,
            'meta_json' => json_encode(['source'=>'payment','frequency'=>$payment_frequency], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
        ]);
    }
    // creative (select)
    $creative = (int)($addons['creative'] ?? 0);
    if ($creative > 0) {
        nd_addons_insert_order($connect, [
            'payment_id' => $payment_id,
            'payment_external' => $payment_external,
            'payment_processor' => $payment_processor,
            'user_id' => $user_id,
            'store_id' => null,
            'addon_key' => 'creative',
            'addon_title' => $catalog['creative']['title'],
            'billing_type' => 'service',
            'months' => 0,
            'unit_price' => (float)$creative,
            'amount_total' => (float)$creative,
            'status' => $statusPaid,
            'created_at' => $now,
            'meta_json' => json_encode(['source'=>'payment','frequency'=>$payment_frequency,'selected'=>$creative], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
        ]);
    }
    // setup (checkbox) - pode ser grátis em 6/12
    if (!empty($addons['setup'])) {
        $setupPrice = 149.00;
        // se vier no meta_json que foi grátis, respeita (compat)
        if (isset($parsed['raw']['addons_setup_cost'])) $setupPrice = (float)$parsed['raw']['addons_setup_cost'];
        // fallback: se a tela calculou 0, deixa 0
        if (isset($parsed['raw']['addons']) && isset($parsed['raw']['addons']['setup_cost'])) $setupPrice = (float)$parsed['raw']['addons']['setup_cost'];

        // Se o checkout marcou setup como selecionado e o valor final era 0, considera grátis
        if ((float)($parsed['raw']['addons_total'] ?? 0) >= 0 && isset($parsed['raw']['addons']) && is_array($parsed['raw']['addons']) && array_key_exists('setup', $parsed['raw']['addons']) ) {
            // não dá pra inferir com precisão; não força nada
        }

        // Se for semestral/anual, normalmente 0 (no checkout)
        if (in_array(strtolower($payment_frequency), ['halfyear','halfyea','annual'], true)) {
            // se não pagou add-ons agora, mesmo assim registramos como incluso para operação
            if ($setupPrice === 149.00 && !$paidForAddonsNow) {
                // mantém como 149, mas ainda pending_payment (o admin pode marcar como incluso/grátis)
            }
        }

        nd_addons_insert_order($connect, [
            'payment_id' => $payment_id,
            'payment_external' => $payment_external,
            'payment_processor' => $payment_processor,
            'user_id' => $user_id,
            'store_id' => null,
            'addon_key' => 'setup',
            'addon_title' => $catalog['setup']['title'],
            'billing_type' => 'service',
            'months' => 0,
            'unit_price' => (float)$setupPrice,
            'amount_total' => (float)$setupPrice,
            'status' => $statusPaid,
            'created_at' => $now,
            'meta_json' => json_encode(['source'=>'payment','frequency'=>$payment_frequency,'included'=>($setupPrice<=0.0)], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
        ]);
    }
    // exclusive (select mensal)
    $exclusive = (int)($addons['exclusive'] ?? 0);
    if ($exclusive > 0) {
        $total = (float)$exclusive * (float)$monthsCount;

        $exclusiveMeta = ['source'=>'payment','frequency'=>$payment_frequency,'monthly'=>$exclusive,'months'=>$monthsCount];
        if ($segment !== '') $exclusiveMeta['segment'] = $segment;
        if ($neighborhood !== '') $exclusiveMeta['neighborhood'] = $neighborhood;

        nd_addons_insert_order($connect, [
            'payment_id' => $payment_id,
            'payment_external' => $payment_external,
            'payment_processor' => $payment_processor,
            'user_id' => $user_id,
            'store_id' => null,
            'addon_key' => 'exclusive',
            'addon_title' => $catalog['exclusive']['title'],
            'billing_type' => 'per_month',
            'months' => $monthsCount,
            'unit_price' => (float)$exclusive,
            'amount_total' => (float)$total,
            'status' => $statusPaid,
            'created_at' => $now,
            'meta_json' => json_encode($exclusiveMeta, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
        ]);
    }
}}



if (!function_exists('nd_exclusive_is_available')) {
function nd_exclusive_is_available($connect, string $segment, string $neighborhood): bool {
    if (!$connect) return true;
    nd_addons_ensure_table($connect);

    $seg = mb_strtolower(trim($segment));
    $nei = mb_strtolower(trim($neighborhood));
    if ($seg === '' || $nei === '') return true;

    // Procura exclusividade ativa no mesmo segmento+bairro (case-insensitive)
    $segPattern = '%"segment":"' . $seg . '"%';
    $neiPattern = '%"neighborhood":"' . $nei . '"%';

    try {
        $st = $connect->prepare("
            SELECT COUNT(*) 
            FROM nd_addon_orders
            WHERE addon_code = 'exclusive'
              AND status = 'active'
              AND (start_date IS NULL OR start_date <= NOW())
              AND (end_date   IS NULL OR end_date   >= NOW())
              AND LOWER(meta_json) LIKE :seg
              AND LOWER(meta_json) LIKE :nei
            LIMIT 1
        ");
        $st->execute([':seg' => $segPattern, ':nei' => $neiPattern]);
        return ((int)$st->fetchColumn() === 0);
    } catch (Throwable $e) {
        // Em caso de erro, não bloqueia a venda (fail-open), mas loga
        error_log('nd_exclusive_is_available error: ' . $e->getMessage());
        return true;
    }
}}


/* PAYMENT PROCESSING (webhooks & cancel) */
/*------------------------------------------------------------ */

if (!function_exists('getTransactionById')) {
function getTransactionById($connect, $id, $processor){
    $sentence = $connect->prepare("SELECT * FROM payments WHERE payment_external = :payment_external AND payment_processor = :payment_processor");
    $sentence->execute([':payment_external' => $id, ':payment_processor' => $processor]);
    $row = $sentence->fetch();
    return $row ? $row : false;
}}
if (!function_exists('cancelUserSubscription')) {
function cancelUserSubscription($settings, $user_id) {
    $user = getUserInfoById($user_id);
    if(empty($user['user_payment_subscription_id'])) return true;

    switch($user['user_payment_processor']) {
        case 'stripe':
            \Stripe\Stripe::setApiKey($settings['st_stripe_secret']);
            $subscription = \Stripe\Subscription::retrieve($user['user_payment_subscription_id']);
            $subscription->cancel();
        break;
        case 'paypal':
            try {
                $paypal_api_url = get_api_url_paypal($settings);
                $headers = get_headers_paypal($settings);
            } catch (\Exception $exception) { throw new \Exception($exception->getCode() . ':' . $exception->getMessage()); }
            $response = \Unirest\Request::post($paypal_api_url . 'v1/billing/subscriptions/' . $user['user_payment_subscription_id'] . '/cancel', $headers, \Unirest\Request\Body::json(['reason' => "Canceled By User"]));
            if($response->code >= 400) { throw new \Exception($response->body->name . ':' . $response->body->message); }
        break;
        case 'paystack':
            $payment_subscription_id = explode('###', $user['user_payment_subscription_id']);
            $code = $payment_subscription_id[0];
            $token = $payment_subscription_id[1];
            $response = \Unirest\Request::post(get_api_url_paystack() . 'subscription/disable', get_headers_paystack($settings), \Unirest\Request\Body::json(['code' => $code,'token' => $token]));
            if(!$response->body->status) { throw new \Exception($response->body->message); }
        break;
        case 'razorpay':
            $razorpay = new Api($settings['st_razorpay_publickey'], $settings['st_razorpay_secretkey']);
            try { $razorpay->subscription->fetch($user['user_payment_subscription_id'])->cancel(); }
            catch (\Exception $exception) { throw new \Exception($exception->getMessage()); }
        break;
        case 'mollie':
            $mollie = new \Mollie\Api\MollieApiClient();
            $mollie->setApiKey($settings['st_mollie_api']);
            $payment_subscription_id = explode('###', $user['user_payment_subscription_id']);
            $customer_id = $payment_subscription_id[0];
            $subscription_id = $payment_subscription_id[1];
            try { $mollie->subscriptions->cancelForId($customer_id, $subscription_id); }
            catch (\Exception $exception) { throw new \Exception($exception->getMessage()); }
        break;
    }

    $statment = connect()->prepare("UPDATE users SET user_payment_subscription_id = :user_payment_subscription_id, user_plan_canceled_date = :user_plan_canceled_date WHERE user_id = :user_id");
    $statment->execute([
        ':user_id' => $user_id,
        ':user_payment_subscription_id' => '',
        ':user_plan_canceled_date' => getDateByTimeZone()
    ]);
}}
if (!function_exists('webhookProcessPayment')) {
function webhookProcessPayment($connect, $settings, $payment_processor, $payment_taxes, $external_payment_id, $payment_total, $payment_currency, $user_id, $plan_id, $payment_frequency, $code, $discount_amount, $base_amount, $payment_type, $payment_subscription_id, $payer_email, $payer_name) {

    $plan = getPlanById($connect, $plan_id);
    if(!$plan) { http_response_code(400);die(); }
    if(getTransactionById($connect, $external_payment_id, $payment_processor)) { http_response_code(400);die(); }

    $user = getUserInfoById($user_id);
    if(!$user) { http_response_code(400);die(); }

    if(!empty($user['user_payment_subscription_id']) && ($payment_subscription_id && $user['user_payment_subscription_id'] != $payment_subscription_id)) {
        try { cancelUserSubscription($settings, $user_id); }
        catch (\Exception $exception) { echo $exception->getMessage(); http_response_code(400); die(); }
    }

    // Normaliza payment_taxes (pode vir como array ou string)
    $paymentTaxesString = $payment_taxes;
    if (!is_string($paymentTaxesString)) {
        $paymentTaxesString = json_encode($paymentTaxesString, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }

    // Descobre o próximo ID disponível (a tabela foi criada sem AUTO_INCREMENT)
    $nextPaymentId = null;
    try {
        $stmtNext = $connect->query("SELECT IFNULL(MAX(payment_id), 0) + 1 AS next_id FROM payments");
        $rowNext  = $stmtNext ? $stmtNext->fetch(\PDO::FETCH_ASSOC) : null;
        if ($rowNext && isset($rowNext['next_id'])) {
            $nextPaymentId = (int) $rowNext['next_id'];
        }
    } catch (\Throwable $e) {
        $nextPaymentId = null;
    }
    if ($nextPaymentId === null || $nextPaymentId <= 0) {
        $nextPaymentId = 1;
    }

    $statment = $connect->prepare("INSERT INTO payments (
        payment_id, payment_user_id, payment_plan_id, payment_subscription_id, payment_processor, payment_frequency, payment_code, payment_discount_amount, payment_base_amount, payment_email, payment_external, payment_name, payment_taxes, payment_total_amount, payment_currency, payment_date
    ) VALUES (
        :payment_id, :payment_user_id, :payment_plan_id, :payment_subscription_id, :payment_processor, :payment_frequency, :payment_code, :payment_discount_amount, :payment_base_amount, :payment_email, :payment_external, :payment_name, :payment_taxes, :payment_total_amount, :payment_currency, :payment_date
    )");
    $statment->execute([
        ':payment_id' => $nextPaymentId,
        ':payment_user_id' => $user_id,
        ':payment_plan_id' => $plan_id,
        ':payment_subscription_id' => $payment_subscription_id,
        ':payment_processor' => $payment_processor,
        ':payment_frequency' => $payment_frequency,
        ':payment_code' => $code,
        ':payment_discount_amount' => $discount_amount,
        ':payment_base_amount' => $base_amount,
        ':payment_email' => $payer_email,
        ':payment_external' => $external_payment_id,
        ':payment_name' => $payer_name,
        ':payment_taxes' => $paymentTaxesString,
        ':payment_total_amount' => $payment_total,
        ':payment_currency' => $payment_currency,
        ':payment_date' => getDateByTimeZone()
    ]);

    // Registra add-ons deste pagamento (operacional)
    try {
        nd_addons_register_from_payment($connect, (int)$nextPaymentId, (string)$external_payment_id, (string)$payment_processor, (int)$user_id, (string)$payment_frequency, $paymentTaxesString, true);
    } catch (\Throwable $e) {
        // silencioso
    }

    $current_plan_expiration_date = ($plan_id == $user['user_plan']) ? $user['user_plan_expiration_date'] : '';

    switch($payment_frequency) {
        case 'monthly': $plan_expiration_date = (new \DateTime($current_plan_expiration_date))->modify('+30 days')->format('Y-m-d H:i:s'); break;
        case 'halfyear':
        case 'halfyea': $plan_expiration_date = (new \DateTime($current_plan_expiration_date))->modify('+6 months')->format('Y-m-d H:i:s'); break;
        case 'annual': $plan_expiration_date = (new \DateTime($current_plan_expiration_date))->modify('+12 months')->format('Y-m-d H:i:s'); break;
    }

    $statement = $connect->prepare("UPDATE users SET
        user_plan = :user_plan,
        user_plan_expiration_date = :user_plan_expiration_date,
        user_payment_subscription_id = :user_payment_subscription_id,
        user_payment_processor = :user_payment_processor,
        user_payment_total_amount = :user_payment_total_amount,
        user_payment_currency = :user_payment_currency,
        user_plan_canceled_date = :user_plan_canceled_date
        WHERE user_id = :user_id");
    $statement->execute([
        ':user_id' => $user_id,
        ':user_plan' => $plan_id,
        ':user_plan_expiration_date' => $plan_expiration_date,
        ':user_payment_subscription_id' => $payment_subscription_id,
        ':user_payment_processor' => $payment_processor,
        ':user_payment_total_amount' => $payment_total,
        ':user_payment_currency' => $payment_currency,
        ':user_plan_canceled_date' => null
    ]);
}}

/*------------------------------------------------------------ */
/* PAYMENTS UTILS */
/*------------------------------------------------------------ */

if (!function_exists('getFrequency')) {
function getFrequency($frequency){
    if($frequency == 'monthly'){return 30;}
    if($frequency == 'halfyea'){return 183;}
    if($frequency == 'annual'){return 365;}
}}
if (!function_exists('getTimeFreq')) {
function getTimeFreq($frequency){
    if($frequency == 'monthly'){return '+1 month';}
    if($frequency == 'halfyea'){return '+6 months';}
    if($frequency == 'annual'){return '+1 year';}
}}
if (!function_exists('getPlanPrice')) {
function getPlanPrice($connect, $planId, $frequency){
    $statement = $connect->prepare("SELECT * FROM plans WHERE plan_id = :plan_id LIMIT 1");
    $statement->execute([':plan_id' => $planId]);
    $planDetails = $statement->fetch();
    if($frequency == "monthly"){return $planDetails['plan_monthly'];}
    if($frequency == "halfyear"){return $planDetails['plan_halfyea'];}
    if($frequency == "annual"){return $planDetails['plan_annual'];}
    return null;
}}
if (!function_exists('getCouponPrice')) {
function getCouponPrice($connect, $planId, $codeCoupon, $frequency){
    $statement = $connect->prepare("SELECT * FROM plans WHERE plan_id = :plan_id LIMIT 1");
    $statement->execute([':plan_id' => $planId]);
    $planDetails = $statement->fetch();

    if($frequency == "monthly"){ $getPrice = $planDetails['plan_monthly']; }
    elseif($frequency == "halfyear"){ $getPrice = $planDetails['plan_halfyea']; }
    elseif($frequency == "annual"){ $getPrice = $planDetails['plan_annual']; }
    else{ return null; }

    $statement = $connect->prepare("SELECT * FROM codes WHERE code_coupon = :code_coupon AND code_status = 1 LIMIT 1");
    $statement->execute([':code_coupon' => $codeCoupon]);
    $codeDetails = $statement->fetch();

    if(!$codeDetails){
        return array('base_amount' => $getPrice, 'price' => $getPrice, 'code' => null, 'discount_amount' => 0);
    }else{
        $allowedCoupons = json_decode($planDetails['plan_codes']);
        if(!in_array($codeDetails['code_id'], $allowedCoupons)){
            return array('base_amount' => $getPrice, 'price' => $getPrice, 'code' => null, 'discount_amount' => 0);
        }else{
            $statement = $connect->prepare("SELECT COUNT(payment_id) AS total FROM payments WHERE payment_code = :payment_code");
            $statement->execute([':payment_code' => $codeDetails['code_id']]);
            $usedQuantity = $statement->fetch()['total'];

            if($usedQuantity >= $codeDetails['code_quantity']){
                return array('base_amount' => $getPrice, 'price' => $getPrice, 'code' => null, 'discount_amount' => 0);
            }else{
                $discountPrice = number_format(($getPrice * $codeDetails['code_discount'] / 100), 2, '.', '');
                $totalPrice    = ($getPrice - ($codeDetails['code_discount'] / 100) * $getPrice);
                return array('base_amount' => $getPrice, 'price' => $totalPrice, 'code' => $codeCoupon, 'discount_amount' => $discountPrice);
            }
        }
    }
}}
if (!function_exists('getFrequencyText')) {
function getFrequencyText($frequency){
    if($frequency == 'monthly'){ return 'Monthly'; }
    if($frequency == 'halfyea' || $frequency == 'biannually'){ return '6 Months'; }
    if($frequency == 'annual'){ return 'Annual'; }
}}
if (!function_exists('getPaymentById')) {
function getPaymentById($itemId){
    $user = getUserInfo();
    if(!$user) return false;
    $userDetails = getUserInfoById($user['user_id']);
    $sentence = connect()->prepare("SELECT payments.*, plans.*, users.*, codes.* FROM payments LEFT JOIN users ON payments.payment_user_id = users.user_id LEFT JOIN plans ON payments.payment_plan_id = plans.plan_id LEFT JOIN codes ON payments.payment_code = codes.code_coupon WHERE payment_id = :payment_id AND payment_user_id = :payment_user_id LIMIT 1");
    $sentence->execute([':payment_id' => $itemId, ':payment_user_id' => $userDetails['user_id']]);
    $row = $sentence->fetch();
    return $row ? $row : false;
}}
if (!function_exists('getUserCurrentPlan')) {
function getUserCurrentPlan(){
    $user = getUserInfo();
    if(!$user) return false;
    $userDetails = getUserInfoById($user['user_id']);
    $sentence = connect()->prepare("SELECT payments.*, plans.*, users.* FROM payments LEFT JOIN users ON payments.payment_user_id = users.user_id LEFT JOIN plans ON payments.payment_plan_id = plans.plan_id WHERE payment_user_id = :payment_user_id ORDER BY payments.payment_date DESC LIMIT 1");
    $sentence->execute([':payment_user_id' => $userDetails['user_id']]);
    $row = $sentence->fetch();
    return $row ? $row : false;
}}
if (!function_exists('hasStore')) {
function hasStore($userId){
    if(!$userId) return false;
    $sentence = connect()->prepare("SELECT * FROM sellers WHERE seller_user = :seller_user AND seller_status = 1");
    $sentence->execute([':seller_user' => $userId]);
    return (bool)$sentence->fetch();
}}
if (!function_exists('isSeller')) {}
if (!function_exists('isSellerr')) {
function isSellerr(){
    $user = getUserInfo();
    if(!$user) return false;
    $userDetails = getUserInfoById($user['user_id']);
    $sentence = connect()->prepare("SELECT * FROM users WHERE user_id = :user_id AND user_pro = 1 AND user_status = 1");
    $sentence->execute([':user_id' => $userDetails['user_id']]);
    return (bool)$sentence->fetch();
}
}
if (!function_exists('isActiveSeller')) {}
if (!function_exists('isActiveSellerr')) {
function isActiveSellerr($userId){
    if(!$userId) return false;
    $userDetails = getUserInfoById($userId);
    $sentence = connect()->prepare("SELECT st_timezone FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();
    $date = new DateTime("now", new DateTimeZone($row['st_timezone']));
    $formtedDate = $date->format('Y-m-d H:i:s');
    return ($userDetails['user_plan_expiration_date'] > $formtedDate);
}
}
if (!function_exists('isExpiredSubscription')) {
function isExpiredSubscription(){
    $user = getUserInfo();
    if(!$user) return false;
    $userDetails = getUserInfoById($user['user_id']);
    if(empty($userDetails['user_plan_expiration_date'])) return false;
    $sentence = connect()->prepare("SELECT st_timezone FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();
    $date = new DateTime("now", new DateTimeZone($row['st_timezone']));
    $formtedDate = $date->format('Y-m-d H:i:s');
    return !($userDetails['user_plan_expiration_date'] > $formtedDate);
}}
if (!function_exists('expirationReminderAlert')) {
function expirationReminderAlert(){
    $user = getUserInfo();
    if(empty($user)) return false;
    $userDetails = getUserInfoById($user['user_id']);
    if(empty($userDetails['user_plan_expiration_date'])) return false;
    $now = new DateTime($userDetails['user_plan_expiration_date']);
    $expire = new DateTime(getDateByTimeZone());
    $days = $expire->diff($now)->format('%a');
    return ($days <= 7);
}}

/*------------------------------------------------------------ */
/* PAYPAL */
/*------------------------------------------------------------ */

if (!function_exists('get_api_url_paypal')) {
function get_api_url_paypal($settings) {
    $sandbox_api_url = 'https://api-m.sandbox.paypal.com/';
    $live_api_url = 'https://api-m.paypal.com/';
    return $settings['st_paypal_mode'] == 'live' ? $live_api_url : $sandbox_api_url;
}}
if (!function_exists('get_access_token_paypal')) {
function get_access_token_paypal($settings) {
    $access_token = null;
    if($access_token) return $access_token;
    \Unirest\Request::auth($settings['st_paypal_id'], $settings['st_paypal_secret']);
    $response = \Unirest\Request::post(get_api_url_paypal($settings) . 'v1/oauth2/token', [], \Unirest\Request\Body::form(['grant_type' => 'client_credentials']));
    if($response->code >= 400) { throw new \Exception($response->body->error . ':' . $response->body->error_description); }
    return $access_token = $response->body->access_token;
}}
if (!function_exists('get_headers_paypal')) {
function get_headers_paypal($settings) {
    return [
        'Content-Type' => 'application/json',
        'Authorization' => 'Bearer ' . get_access_token_paypal($settings)
    ];
}}

/*------------------------------------------------------------ */
/* PAYSTACK */
/*------------------------------------------------------------ */

if (!function_exists('get_api_url_paystack')) {
function get_api_url_paystack() {
    return 'https://api.paystack.co/';
}}
if (!function_exists('get_headers_paystack')) {
function get_headers_paystack($settings) {
    return [
        'Content-Type' => 'application/json',
        'Authorization' => 'Bearer ' . $settings['st_paystack_secret']
    ];
}}
if (!function_exists('getFrePayStack')) {
function getFrePayStack($frequency){
    if($frequency == 'monthly'){return 'monthly';}
    if($frequency == 'halfyea'){return 'biannually';}
    if($frequency == 'annual'){return 'annually';}
}}

/*------------------------------------------------------------ */
/* PRICE & DISPLAY */
/*------------------------------------------------------------ */

if (!function_exists('getPercent')) {
function getPercent($newprice, $oldprice, $translation){
    $new = str_replace(',', '.', echoOutput($newprice));
    $old = str_replace(',', '.', echoOutput($oldprice));
    $calc = (($old - $new) / $old) * 100;
    $percent = round(abs($calc));
    return $percent.$translation['tr_9'];
}}
if (!function_exists('getPrice')) {
function getPrice($price){
    if($price === null || $price === '') return null;
    $sentence = connect()->prepare("SELECT st_currency, st_currencyposition, st_decimalnumber, st_decimalseparator FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();
    $num = str_replace(',', '.', echoOutput($price));
    $dec = (int)($row['st_decimalnumber'] ?? 0);
    $sep = $row['st_decimalseparator'] ?? '.';
    $th  = $sep;

    $fmt = number_format(\ND\Coupons\Support\Helpers::toNumber($num), $dec, $sep, $th);
    if ($dec === 0) { $fmt = number_format(\ND\Coupons\Support\Helpers::toNumber($num), 0, '', ''); }

    $cur = $row['st_currency'] ?? '';
    $pos = $row['st_currencyposition'] ?? 'left';

    if ($pos == 'left')          $out = $cur . $fmt;
    elseif ($pos == 'left-space')  $out = $cur . ' ' . $fmt;
    elseif ($pos == 'right')       $out = $fmt . $cur;
    elseif ($pos == 'right-space') $out = $fmt . ' ' . $cur;
    else                           $out = $cur . $fmt;

    return $out;
}}
if (!function_exists('getPriceNoCurrency')) {
function getPriceNoCurrency($price){
    $sentence = connect()->prepare("SELECT st_decimalnumber, st_decimalseparator FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();
    $num = str_replace(',', '.', echoOutput($price));
    $dec = (int)($row['st_decimalnumber'] ?? 0);
    if ($dec != 0) {
        return rtrim(rtrim(number_format(\ND\Coupons\Support\Helpers::toNumber($num), $dec, '.', '.'), '0'), '.');
    }
    return number_format(\ND\Coupons\Support\Helpers::toNumber($num), $dec, '.', '');
}}

if (!function_exists('memberSince')) {
function memberSince($date){
    $timestamp = strtotime($date);
    $months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'Septembe', 'Octobe', 'Novembe', 'Decembe'];
    $month = date('m', $timestamp) - 1;
    $year = date('Y', $timestamp);
    return $months[$month] . " $year";
}}
if (!function_exists('getIcon')) {
function getIcon($icon){
    return empty($icon) ? "ti ti-minus" : "ti ti-".$icon;
}}
if (!function_exists('formatRating')) {
function formatRating($value){
    if(empty($value)) return false;
    if($value <= 5){ return number_format(echoOutput($value), 1); }
    return "5.0";
}}

/*------------------------------------------------------------ */
/* TRACKING & GEO */
/*------------------------------------------------------------ */

if (!function_exists('getIp')) {
function getIp() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    }
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ips[0]);
    }
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    }
    return $_SERVER['REMOTE_ADDR'] ?? '';
}
}

if (!function_exists('getDeviceType')) {
function getDeviceType($user_agent) {
    $mobileRegex = '/(?:phone|windows\s+phone|ipod|blackberry|(?:android|bb\d+|meego|silk|googlebot) .+? mobile|palm|windows\s+ce|opera mini|avantgo|mobilesafari|docomo)/i';
    $tabletRegex = '/(?:ipad|playbook|(?:android|bb\d+|meego|silk)(?! .+? mobile))/i';
    if(preg_match_all($mobileRegex, $user_agent)) return 'mobile';
    if(preg_match_all($tabletRegex, $user_agent)) return 'tablet';
    return 'desktop';
}}
if (!function_exists('getInfoByIp')) {
function getInfoByIp($ip){
    $cfCountry = $_SERVER['HTTP_CF_IPCOUNTRY'] ?? null;

    $ctx  = stream_context_create(['http' => ['timeout' => 2]]);
    $url1 = 'https://geoplugin.net/json.gp?ip=' . urlencode($ip);
    $json1 = @file_get_contents($url1, false, $ctx);
    $d1 = $json1 ? json_decode($json1) : null;

    $countryName = ''; $countryCode = ''; $city = ''; $timezone = '';

    if (is_object($d1) && !empty($d1->geoplugin_countryCode)) {
        $countryName = $d1->geoplugin_countryName ?? '';
        $countryCode = $d1->geoplugin_countryCode ?? '';
        $city        = $d1->geoplugin_city ?? '';
        $timezone    = $d1->geoplugin_timezone ?? '';
    } else {
        $url2 = 'https://ipapi.co/'.urlencode($ip).'/json/';
        $json2 = @file_get_contents($url2, false, $ctx);
        $d2 = $json2 ? json_decode($json2) : null;
        if (is_object($d2) && empty($d2->error)) {
            $countryName = $d2->country_name ?? '';
            $countryCode = $d2->country ?? '';
            $city        = $d2->city ?? '';
            $timezone    = $d2->timezone ?? '';
        }
    }

    if (!$countryCode && $cfCountry) {
        $countryCode = $cfCountry;
    }

    return [
        'country'       => $countryName ?: '',
        'country_code'  => $countryCode ?: '',
        'countryName'   => $countryName ?: '',
        'countryCode'   => $countryCode ?: '',
        'city'          => $city ?: '',
        'timezone'      => $timezone ?: ''
    ];
}
}


if (!function_exists('showStars')) {
function showStars($value){
    $totalRating = 5;
    $starRating = is_numeric($value) ? (float)$value : 0.0;
    for ($i = 1; $i <= $totalRating; $i++) {
        if ($starRating < $i) {
            if (round($starRating) == $i) {
                echo "<i class='ion-ios-star-half'></i>";
            } else {
                echo "<i class='ion-ios-star-outline'></i>";
            }
        } else {
            echo "<i class='ion-ios-star'></i>";
        }
    }
}
}


if (!function_exists('isExpired')) {
function isExpired($date){
    if(empty($date)) return false;
    return !(getDateByTimeZone() < $date);
}}
if (!function_exists('isNew')) {
function isNew($date){
    if(empty($date)) return false;
    $daydiff = abs(round((strtotime($date) - strtotime(getDateByTimeZone()))/86400));
    return ($daydiff < 7);
}}
if (!function_exists('timeLeft')) {
function timeLeft($date, $translation){
    if(empty($date)) return false;
    $date1 = date_create($date);
    $date2 = date_create(getDateByTimeZone());
    $diff = date_diff($date1, $date2);
    $hour = $diff->h;
    $minutes = $diff->i;
    $hourdiff = round((strtotime($date) - strtotime(getDateByTimeZone()))/3600, 1);
    if((int)$hourdiff  < 24 && (int)$hourdiff >= 1){
        return $hour.' '.$translation['tr_17'];
    }elseif((int)$hourdiff <= 1){
        return $minutes.' '.$translation['tr_18'];
    }else{
        return false;
    }
}}
if (!function_exists('getCountDown')) {
function getCountDown($date){
    $sentence = connect()->prepare("SELECT st_timezone FROM settings");
    $sentence->execute();
    $row = $sentence->fetch();
    $datetime= date_create($date, timezone_open($row['st_timezone']));
    return $datetime->format(DateTime::ATOM);
}}
if (!function_exists('insertTrack')) {

function insertTrack($connect, $itemId){
    try {
        $user = getUserInfo();
        $cookie_name = 'd_tracking_' . $itemId;

        if(isset($_COOKIE[$cookie_name]) && (int) $_COOKIE[$cookie_name] >= 3) return;

        // Proteção extra
        if (empty($_SERVER['HTTP_USER_AGENT'])) { return; }

        $whichbrowser = new \WhichBrowser\Parser($_SERVER['HTTP_USER_AGENT']);
        if(isset($whichbrowser->device) && isset($whichbrowser->device->type) && $whichbrowser->device->type == 'bot') return;

        $browser_name = $whichbrowser->browser->name ?? null;
        $os_name = $whichbrowser->os->name ?? null;
        $browser_language = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? mb_substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2) : null;
        $device_type = getDeviceType($_SERVER['HTTP_USER_AGENT']);
        $is_unique = isset($_COOKIE[$cookie_name]) ? 0 : 1;

        $getIp = getIp();

        $locationInfo = null;
        try {
            $locationInfo = getLocationInfoFromIp($getIp);
        } catch (\Throwable $e) {
            $locationInfo = null;
        }

        $country_name = isset($locationInfo['country']) ? $locationInfo['country'] : (isset($locationInfo['countryName']) ? $locationInfo['countryName'] : null);
        $country_code = isset($locationInfo['country_code']) ? $locationInfo['country_code'] : (isset($locationInfo['countryCode']) ? $locationInfo['countryCode'] : null);
        $city_name    = isset($locationInfo['city']) ? $locationInfo['city'] : null;

        $referrer = isset($_SERVER['HTTP_REFERER']) ? parse_url($_SERVER['HTTP_REFERER']) : null;

        if (!$connect) { return; }

        $params = [
            ':track_user' => ($user ? $user['user_id'] : null),
            ':track_item' => $itemId,
            ':track_country_name' => $country_name,
            ':track_country_code' => ($country_code ? strtolower($country_code) : null),
            ':track_city' => $city_name,
            ':track_os' => $os_name,
            ':track_browser' => $browser_name,
            ':track_host' => ($referrer ? ($referrer['host'] ?? null) : null),
            ':track_path' => ($referrer ? ($referrer['path'] ?? null) : null),
            ':track_ip' => $getIp,
            ':track_device' => $device_type,
            ':track_browser_language' => $browser_language,
            ':track_is_unique' => $is_unique,
            ':track_datetime' => getDateByTimeZone()
        ];

        // Tentativa 1: modelo com AUTO_INCREMENT (track_id omitido)
        try {
            $statment = $connect->prepare("INSERT INTO tracking (
                track_user, track_item, track_country_name, track_country_code, track_city, track_os, track_browser,
                track_host, track_path, track_ip, track_device, track_browser_language, track_is_unique, track_datetime
            ) VALUES (
                :track_user, :track_item, :track_country_name, :track_country_code, :track_city, :track_os, :track_browser,
                :track_host, :track_path, :track_ip, :track_device, :track_browser_language, :track_is_unique, :track_datetime
            )");
            $statment->execute($params);
        } catch (\PDOException $e) {
            // Tentativa 2: compatibilidade para instalações antigas sem AUTO_INCREMENT
            try {
                $nextId = 1;
                $stId = $connect->query("SELECT COALESCE(MAX(track_id),0)+1 AS next_id FROM tracking");
                if ($stId) {
                    $rowId = $stId->fetch(\PDO::FETCH_ASSOC);
                    if ($rowId && isset($rowId['next_id'])) {
                        $nextId = (int) $rowId['next_id'];
                    }
                }

                $params2 = $params;
                $params2[':track_id'] = $nextId;

                $statment = $connect->prepare("INSERT INTO tracking (
                    track_id, track_user, track_item, track_country_name, track_country_code, track_city, track_os, track_browser,
                    track_host, track_path, track_ip, track_device, track_browser_language, track_is_unique, track_datetime
                ) VALUES (
                    :track_id, :track_user, :track_item, :track_country_name, :track_country_code, :track_city, :track_os, :track_browser,
                    :track_host, :track_path, :track_ip, :track_device, :track_browser_language, :track_is_unique, :track_datetime
                )");
                $statment->execute($params2);
            } catch (\Throwable $e2) {
                // Silencioso para não quebrar a navegação
            }
        }

        // Atualiza cookie de tracking (máx 3 por item)
        try {
            $count = isset($_COOKIE[$cookie_name]) ? (int) $_COOKIE[$cookie_name] : 0;
            $count++;
            @setcookie($cookie_name, (string)$count, time() + (86400 * 30), "/");
        } catch (\Throwable $e) {}

    } catch (\Throwable $e) {
        // Silencioso
        return;
    }
}
}
if (!function_exists('getSellerById')) {
function getSellerById($userId){
    $sentence = connect()->prepare("SELECT * FROM sellers WHERE seller_user = :seller_user AND seller_status = 1 LIMIT 1");
    $sentence->execute([':seller_user' => $userId]);
    return $sentence->fetch();
}}
if (!function_exists('getSellerSlug')) {
function getSellerSlug($slug){
    $sentence = connect()->prepare("SELECT COUNT(*) AS total FROM sellers WHERE seller_slug LIKE :slug");
    $sentence->execute([':slug'=>"$slug%"]);
    $row = $sentence->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}}

/* === ND SECURITY HELPERS (final v11) === */
if (!function_exists('nd_safe_html')) {
  function nd_safe_html(string $html): string {
    if (class_exists('HTMLPurifier')) {
      static $purifier = null;
      if ($purifier === null) {
        $config = HTMLPurifier_Config::createDefault();
        $config->set('Core.Encoding', 'UTF-8');
        $config->set('HTML.Doctype', 'HTML5');
        $config->set('Cache.SerializerPath', sys_get_temp_dir());
        $config->set('HTML.SafeIframe', true);
        $config->set('URI.SafeIframeRegexp', '%^https?://(www\.)?(youtube\.com/embed/|player\.vimeo\.com/video/)%;');
        $purifier = new HTMLPurifier($config);
      }
      return $purifier->purify($html);
    }
    $html = preg_replace('#<(script|style|iframe|object|embed|meta|link)\b[^>]*>.*?</\1>#is', '', $html);
    $html = preg_replace('#\son\w+\s*=\s*([\'"]).*?\1#i', '', $html);
    $html = preg_replace('#(href|src)\s*=\s*([\'"])\s*(javascript:|data:)#i', '$1=$2#', $html);
    $allowed = '<p><br><strong><em><ul><ol><li><blockquote><code><pre>'
             . '<h1><h2><h3><h4><h5><h6><a><img><hr><span><div>';
    $html = strip_tags($html, $allowed);
    $html = preg_replace('#<a\b([^>]*)>#i', '<a$1 rel="nofollow noopener" target="_blank">', $html);
    return $html;
  }
}

if (!function_exists('nd_security_headers')) {
  function nd_security_headers(): void {
    @header('X-Frame-Options: SAMEORIGIN');
    @header('X-Content-Type-Options: nosniff');
    @header('Referrer-Policy: strict-origin-when-cross-origin');
    @header("Permissions-Policy: geolocation=(self), microphone=(), camera=()");
    @header("Content-Security-Policy: default-src 'self' https: data:; img-src 'self' https: data:; script-src 'self' https: 'unsafe-inline' 'unsafe-eval'; style-src 'self' https: 'unsafe-inline'");
  }
}
/* === /ND SECURITY HELPERS (final v11) === */

if (!function_exists('firstLetter')) {
function firstLetter($string){
    if (!is_string($string) || $string === '') return 'A';
    $output = mb_substr($string, 0, 1, 'UTF-8');
    return (!ctype_digit($output)) ? $output : "A";
}
}

// ND: retorna URL externa da loja
if (!function_exists('nd_get_store_external_url')) {
  function nd_get_store_external_url($store_id) {
    $store_id = (int)$store_id;
    if ($store_id <= 0) return null;
    try {
global $connect;
 $conn= $connect;
      if (!isset($conn) || !is_object($conn)) return null;

      $cols = [];
      $res = $conn->query("SHOW COLUMNS FROM stores");
      if ($res) { while ($row = $res->fetch(PDO::FETCH_ASSOC)) {  $cols[$row['Field']] = true; } }

      $col = null;
      if (isset($cols['store_url'])) { $col = 'store_url'; }
      elseif (isset($cols['store_website'])) { $col = 'store_website'; }

      if (!$col) return null;

      $stmt = $conn->prepare("SELECT `$col` AS url FROM stores WHERE store_id = :id LIMIT 1");
      $stmt->execute([':id'=>$store_id]);
      $row = $stmt->fetch(PDO::FETCH_ASSOC);

      if (!$row) return null;
      $url = trim((string)($row['url'] ?? ''));
      if ($url === '') return null;

      if (!preg_match('~^https?://~i', $url)) {
        $url = 'https://' . ltrim($url, '/');
      }
      return $url;
    } catch (Throwable $e) {
      return null;
    }
  }
}

/* ==== ND Universal Deal Link Helper (safe, idempotent) ==== */
if (!function_exists('nd_deal_link')) {
  function nd_deal_link($item, $urlPath = null) {
    // 1) Prefer controllers' provided links
    $href = null;
    if (is_array($item)) {
      $href = $item['detail_link'] ?? ($item['permalink'] ?? ($item['url'] ?? null));
    } elseif (is_object($item)) {
      $href = $item->detail_link ?? ($item->permalink ?? ($item->url ?? null));
    }

    // Extract ID/Slug in a defensive way
    $id   = null; $slug = null;
    if (is_array($item)) {
      $id   = $item['deal_id'] ?? ($item['id'] ?? ($item['item_id'] ?? null));
      $slug = $item['deal_slug'] ?? ($item['slug'] ?? null);
    } elseif (is_object($item)) {
      $id   = isset($item->deal_id) ? $item->deal_id : (isset($item->id) ? $item->id : (isset($item->item_id) ? $item->item_id : null));
      $slug = isset($item->deal_slug) ? $item->deal_slug : (isset($item->slug) ? $item->slug : null);
    }

    if ($href && is_string($href) && $href !== '') {
      return $href;
    }

    // 2) Principal fallback da sua base: abrir via raiz com ?deal_id=ID
    if (!empty($id)) {
      return '/?deal_id=' . rawurlencode((string)$id);
    }

    // 3) Fallbacks adicionais (se só houver slug)
    if (!empty($slug)) {
      // Tentar roteador, se existir
      if (is_object($urlPath) && method_exists($urlPath, 'deal')) {
        try { return $urlPath->deal(null, $slug); } catch (\Throwable $e) {}
      }
      return '/deal/' . rawurlencode((string)$slug);
    }

    // 4) Sem nada, não quebra click
    return '#';
  }
}
/* ==== /ND Universal Deal Link Helper ==== */


if (!function_exists('getStoreBySlug')) {
    function getStoreBySlug($connect, $slug){
        $st = $connect->prepare("SELECT * FROM stores WHERE store_slug = :slug LIMIT 1");
        $st->execute([':slug'=>$slug]);
        return $st->fetch(PDO::FETCH_ASSOC);
    }
}

if (!function_exists('getStoreByTitle')) {
    function getStoreByTitle($connect, $title){
        $st = $connect->prepare("SELECT * FROM stores WHERE store_title = :title LIMIT 1");
        $st->execute([':title'=>$title]);
        return $st->fetch(PDO::FETCH_ASSOC);
    }
}

if (!function_exists('slugify_basic')) {
    function slugify_basic($text){
        $text = iconv('UTF-8', 'ASCII//TRANSLIT', (string)$text);
        $text = preg_replace('~[^\pL\d]+~u', '-', $text);
        $text = trim($text, '-');
        $text = strtolower($text);
        $text = preg_replace('~[^-a-z0-9]+~', '', $text);
        if (empty($text)) { $text = 'loja'; }
        return $text;
    }
}

if (!function_exists('getStoresByUser')) {
    function getStoresByUser($connect, $user_id){
        $st = $connect->prepare("SELECT * FROM stores WHERE store_user_id = :uid ORDER BY store_title ASC");
        $st->execute([':uid'=>(int)$user_id]);
        return $st->fetchAll(PDO::FETCH_ASSOC);
    }
}

if (!function_exists('getOrCreateStoreForSeller')) {
    function getOrCreateStoreForSeller($connect, $seller){
        if(!$seller) return null;
        $title  = trim($seller['seller_title'] ?? '');
        $slug   = trim($seller['seller_slug'] ?? '');
        $url    = trim($seller['seller_website'] ?? '');
        $logo   = trim($seller['seller_logo'] ?? '');
        $userId = (int)($seller['seller_user'] ?? 0);

        if ($slug === '') { $slug = slugify_basic($title); }

        // Se já existem lojas vinculadas explicitamente a este usuário, retornamos todas no getStoresForUser.
        if ($userId > 0) {
            try {
                $existing = getStoresByUser($connect, $userId);
                if (!empty($existing)) {
                    // Sincroniza título/url/logo da primeira loja, se estiverem diferentes
                    $row0 = $existing[0];
                    $upd = [];

                    if ($title !== '' && $title !== ($row0['store_title'] ?? '')) {
                        $upd['store_title'] = $title;
                    }
                    if ($url !== '' && $url !== ($row0['store_url'] ?? '')) {
                        $upd['store_url'] = $url;
                    }
                    if ($logo !== '' && $logo !== ($row0['store_image'] ?? '')) {
                        $upd['store_image'] = $logo;
                    }

                    if (!empty($upd)) {
                        $setParts = [];
                        foreach ($upd as $k => $v) {
                            $setParts[] = "$k = :$k";
                        }
                        $sql = "UPDATE stores SET ".implode(',', $setParts)." WHERE store_id = :id";
                        $st = $connect->prepare($sql);
                        $upd['id'] = $row0['store_id'];
                        $st->execute($upd);

                        // recarrega linha principal
                        $st2 = $connect->prepare("SELECT * FROM stores WHERE store_id = :id LIMIT 1");
                        $st2->execute([':id'=>$row0['store_id']]);
                        $row0 = $st2->fetch(PDO::FETCH_ASSOC);
                    }
                    return $row0;
                }
            } catch (Throwable $e) {
                // se a coluna store_user_id não existir ainda, ignoramos e seguimos fluxo antigo
            }
        }

        // Tenta por slug
        $row = getStoreBySlug($connect, $slug);
        if($row){
            // Sincroniza campos principais com o perfil do anunciante
            $upd = [];
            if ($title !== '' && $title !== ($row['store_title'] ?? '')) {
                $upd['store_title'] = $title;
            }
            if ($url !== '' && $url !== ($row['store_url'] ?? '')) {
                $upd['store_url'] = $url;
            }
            if ($logo !== '' && $logo !== ($row['store_image'] ?? '')) {
                $upd['store_image'] = $logo;
            }
            if (!empty($upd)) {
                $setParts = [];
                foreach ($upd as $k => $v) {
                    $setParts[] = "$k = :$k";
                }
                $sql = "UPDATE stores SET ".implode(',', $setParts)." WHERE store_id = :id";
                $st = $connect->prepare($sql);
                $upd['id'] = $row['store_id'];
                $st->execute($upd);

                $st2 = $connect->prepare("SELECT * FROM stores WHERE store_id = :id LIMIT 1");
                $st2->execute([':id'=>$row['store_id']]);
                $row = $st2->fetch(PDO::FETCH_ASSOC);
            }
            return $row;
        }

        // Tenta por título
        if ($title !== '') {
            $row = getStoreByTitle($connect, $title);
            if($row){ return $row; }
        }

        // Garante slug único
        $base = $slug; $i=1;
        while(getStoreBySlug($connect, $slug)){
            $slug = $base.'-'.$i; $i++;
        }

        // Tenta inserir com vínculo explícito ao usuário (store_user_id), se a coluna existir.
        $inserted = false;
        if ($userId > 0) {
            try {
                $st = $connect->prepare("INSERT INTO stores (store_title, store_description, store_featured, store_slug, store_image, store_url, store_status, store_user_id) VALUES (:t, :d, 0, :s, :img, :url, 1, :uid)");
                $st->execute([
                    ':t'=>$title ?: 'Minha Loja',
                    ':d'=>$seller['seller_description'] ?? '',
                    ':s'=>$slug,
                    ':img'=>$logo,
                    ':url'=>$url,
                    ':uid'=>$userId
                ]);
                $inserted = true;
            } catch (Throwable $e) {
                $inserted = false;
            }
        }

        if (!$inserted) {
            $st = $connect->prepare("INSERT INTO stores (store_title, store_description, store_featured, store_slug, store_image, store_url, store_status) VALUES (:t, :d, 0, :s, :img, :url, 1)");
            $st->execute([
                ':t'=>$title ?: 'Minha Loja',
                ':d'=>$seller['seller_description'] ?? '',
                ':s'=>$slug,
                ':img'=>$logo,
                ':url'=>$url
            ]);
        }

        $id = $connect->lastInsertId();
        $st2 = $connect->prepare("SELECT * FROM stores WHERE store_id = :id LIMIT 1");
        $st2->execute([':id'=>$id]);
        return $st2->fetch(PDO::FETCH_ASSOC);
    }
}

if (!function_exists('getStoresForUser')) {
    function getStoresForUser($connect, $user_id){
        $user_id = (int)$user_id;
        if ($user_id <= 0) { return []; }

        // Primeiro tentamos a relação explícita stores.store_user_id (multi-loja por anunciante)
        try {
            $st = $connect->prepare("SELECT * FROM stores WHERE store_user_id = :uid ORDER BY store_title ASC");
            $st->execute([':uid'=>$user_id]);
            $rows = $st->fetchAll(PDO::FETCH_ASSOC);
            if (!empty($rows)) { return $rows; }
        } catch (Throwable $e) {
            // coluna ainda não criada → segue fluxo antigo
        }

        // Fallback: compatibilidade antiga → uma loja derivada do cadastro do anunciante
        $seller = getSellerById($user_id);
        if(!$seller){ return []; }
        $row = getOrCreateStoreForSeller($connect, $seller);
        return $row ? [$row] : [];
    }
}

/*------------------------------------------------------------ */
/* WHATSAPP BUSINESS HELPERS (NOTIFICAÇÕES PARA COMERCIANTES) */
/*------------------------------------------------------------ */

if (!function_exists('nd_whatsapp_log')) {
    /**
     * Log simples para depuração do WhatsApp.
     * @param string $message
     * @param array<string,mixed> $context
     */
    function nd_whatsapp_log(string $message, array $context = []): void
    {
        if (function_exists('nd_whatsapp_get_config')) {
            $cfg = nd_whatsapp_get_config();
            if (isset($cfg['debug_log']) && $cfg['debug_log'] === false) { return; }
        } elseif (defined('WHATSAPP_DEBUG_LOG') && WHATSAPP_DEBUG_LOG === false) {
            return;
        }

        try {
            $baseDir = __DIR__ . '/storage/logs';
            if (!is_dir($baseDir)) {
                @mkdir($baseDir, 0755, true);
            }

            $line = '[' . date('Y-m-d H:i:s') . '] ' . $message;
            if (!empty($context)) {
                $line .= ' | ' . json_encode($context, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
            }
            $line .= PHP_EOL;

            @file_put_contents($baseDir . '/whatsapp.log', $line, FILE_APPEND);
        } catch (Throwable $e) {
            // silêncio
        }
    }
}

if (!function_exists('nd_normalize_phone')) {
    /**
     * Normaliza número para formato E.164 básico.
     * Aceita números com ou sem +55.
     */
    function nd_normalize_phone(?string $raw, ?string $defaultCountry = null): ?string
    {
        if (empty($raw)) { return null; }

        $digits = preg_replace('/\D+/', '', $raw ?? '');
        if (empty($digits)) { return null; }

        $defaultCountry = $defaultCountry ?? (function_exists('nd_whatsapp_get_config') ? (string)(nd_whatsapp_get_config()['default_country'] ?? '55') : (defined('WHATSAPP_DEFAULT_COUNTRY_CODE') ? WHATSAPP_DEFAULT_COUNTRY_CODE : '55'));

        // Se já começa com country code e tem tamanho plausível
        if (strlen($digits) >= 12 && strlen($digits) <= 15 && strpos($digits, $defaultCountry) === 0) {
            return '+' . $digits;
        }

        // Caso brasileiro comum (DDD + número)
        if (strlen($digits) === 10 || strlen($digits) === 11) {
            return '+' . $defaultCountry . $digits;
        }

        // Se passou um número internacional sem +
        if (strlen($digits) >= 8 && strlen($digits) <= 15) {
            return '+' . $digits;
        }

        return null;
    }
}



if (!function_exists('nd_whatsapp_get_config')) {
    /**
     * Retorna configuração efetiva do WhatsApp Business.
     * Prioridade:
     * 1) Settings do banco (quando disponíveis)
     * 2) Constantes definidas em config.php
     *
     * @return array<string,mixed>
     */
    function nd_whatsapp_get_config(): array
    {
        // Tenta primeiro usar as configurações já carregadas no bootstrap (core.php)
        $st = $GLOBALS['settings'] ?? null;

        // Se ainda não houver settings disponíveis, tenta carregar direto do banco.
        if (!is_array($st) && function_exists('connect')) {
            try {
                $pdo = connect();
                if ($pdo instanceof PDO) {
                    $stmt = $pdo->query("SELECT * FROM settings LIMIT 1");
                    if ($stmt !== false) {
                        $row = $stmt->fetch(PDO::FETCH_ASSOC);
                        if (is_array($row) && !empty($row)) {
                            $st = $row;
                            // Mantém em memória para próximas chamadas.
                            $GLOBALS['settings'] = $st;
                        }
                    }
                }
            } catch (Throwable $e) {
                // Silencioso: se der erro aqui, caímos para os valores de config.php.
            }
        }

        $enabled = null;
        $version = null;
        $phoneId = null;
        $token   = null;
        $country = null;
        $debug   = null;

        if (is_array($st)) {
            if (array_key_exists('st_whatsapp_api_enabled', $st)) {
                $enabled = (bool) ((int) $st['st_whatsapp_api_enabled']);
            }
            if (!empty($st['st_whatsapp_api_version'])) {
                $version = (string) $st['st_whatsapp_api_version'];
            }
            if (!empty($st['st_whatsapp_phone_number_id'])) {
                $phoneId = (string) $st['st_whatsapp_phone_number_id'];
            }
            if (!empty($st['st_whatsapp_access_token'])) {
                $token = (string) $st['st_whatsapp_access_token'];
            }
            if (!empty($st['st_whatsapp_default_country'])) {
                $country = (string) $st['st_whatsapp_default_country'];
            }
            if (array_key_exists('st_whatsapp_debug_log', $st)) {
                $debug = (bool) ((int) $st['st_whatsapp_debug_log']);
            }
        }

        // Fallback: se algo não vier do banco, usa valores do config.php.
        if ($enabled === null) { $enabled = defined('WHATSAPP_API_ENABLED') ? (bool) WHATSAPP_API_ENABLED : false; }
        if ($version === null) { $version = defined('WHATSAPP_API_VERSION') ? (string) WHATSAPP_API_VERSION : 'v20.0'; }
        if ($phoneId === null) { $phoneId = defined('WHATSAPP_PHONE_NUMBER_ID') ? (string) WHATSAPP_PHONE_NUMBER_ID : ''; }
        if ($token === null)   { $token   = defined('WHATSAPP_ACCESS_TOKEN') ? (string) WHATSAPP_ACCESS_TOKEN : ''; }
        if ($country === null) { $country = defined('WHATSAPP_DEFAULT_COUNTRY_CODE') ? (string) WHATSAPP_DEFAULT_COUNTRY_CODE : '55'; }
        if ($debug === null)   { $debug   = defined('WHATSAPP_DEBUG_LOG') ? (bool) WHATSAPP_DEBUG_LOG : true; }

        return [
            'enabled'        => $enabled,
            'version'        => $version,
            'phone_number_id'=> $phoneId,
            'access_token'   => $token,
            'default_country'=> $country,
            'debug_log'      => $debug,
        ];
    }
}
if (!function_exists('nd_whatsapp_is_enabled')) {
    function nd_whatsapp_is_enabled(): bool
    {
        $cfg = nd_whatsapp_get_config();
        return !empty($cfg['enabled'])
               && !empty($cfg['phone_number_id'])
               && !empty($cfg['access_token']);
    }
}
if (!function_exists('nd_send_whatsapp_message')) {
    /**
     * Envia mensagem de texto simples via WhatsApp Cloud API.
     * Retorna array com sucesso, http_code e response.
     *
     * @param string $to Número em E.164
     * @param string $body Texto
     * @return array<string,mixed>
     */
    function nd_send_whatsapp_message(string $to, string $body): array
    {
        if (!nd_whatsapp_is_enabled()) {
            nd_whatsapp_log('WhatsApp desabilitado - mensagem não enviada', ['to' => $to]);
            return ['success' => false, 'disabled' => true, 'http_code' => 0, 'response' => null];
        }

        $cfg = function_exists('nd_whatsapp_get_config') ? nd_whatsapp_get_config() : [];

        $version = $cfg['version'] ?? (defined('WHATSAPP_API_VERSION') ? WHATSAPP_API_VERSION : 'v20.0');
        $phoneNumberId = $cfg['phone_number_id'] ?? (defined('WHATSAPP_PHONE_NUMBER_ID') ? WHATSAPP_PHONE_NUMBER_ID : '');
        $token = $cfg['access_token'] ?? (defined('WHATSAPP_ACCESS_TOKEN') ? WHATSAPP_ACCESS_TOKEN : '');

        $url = "https://graph.facebook.com/{$version}/{$phoneNumberId}/messages";

        $payload = [
            'messaging_product' => 'whatsapp',
            'to' => ltrim($to, '+'),
            'type' => 'text',
            'text' => [
                'preview_url' => false,
                'body' => $body
            ]
        ];

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ],
            CURLOPT_POSTFIELDS => json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            CURLOPT_TIMEOUT => 12,
            CURLOPT_CONNECTTIMEOUT => 6
        ]);

        $resp = curl_exec($ch);
        $err  = curl_error($ch);
        $code = (int) curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($resp === false) {
            nd_whatsapp_log('Erro cURL WhatsApp', ['to' => $to, 'error' => $err]);
            return ['success' => false, 'http_code' => $code, 'error' => $err, 'response' => null];
        }

        $decoded = json_decode((string)$resp, true);

        $ok = $code >= 200 && $code < 300;
        if (!$ok) {
            nd_whatsapp_log('Falha envio WhatsApp', ['to' => $to, 'http_code' => $code, 'response' => $decoded ?? $resp]);
        }

        return ['success' => $ok, 'http_code' => $code, 'response' => $decoded ?? $resp];
    }
}

if (!function_exists('nd_get_store_whatsapp_by_deal')) {
    /**
     * Busca dados da loja vinculada a uma oferta.
     * @return array<string,mixed>|null
     */
    function nd_get_store_whatsapp_by_deal($connect, int $deal_id): ?array
    {
        try {
            $sql = "SELECT d.deal_id, d.deal_title, d.deal_store,
                           s.store_id, s.store_title, s.store_whatsapp
                    FROM deals d
                    LEFT JOIN stores s ON s.store_id = d.deal_store
                    WHERE d.deal_id = :deal_id
                    LIMIT 1";
            $st = $connect->prepare($sql);
            $st->bindValue(':deal_id', $deal_id, PDO::PARAM_INT);
            $st->execute();
            $row = $st->fetch();
            if (!$row) { return null; }
            return $row;
        } catch (Throwable $e) {
            nd_whatsapp_log('Erro ao buscar loja da oferta', ['deal_id' => $deal_id, 'error' => $e->getMessage()]);
            return null;
        }
    }
}

if (!function_exists('nd_notify_store_coupon_created')) {
    /**
     * Notifica o comerciante quando um novo cupom de oferta é criado.
     *
     * @param PDO $connect
     */
    function nd_notify_store_coupon_created($connect, int $deal_id, string $coupon_title, string $coupon_code, int $discount_percent, $quantity = null): array
    {
        $storeData = nd_get_store_whatsapp_by_deal($connect, $deal_id);
        if (!$storeData) {
            nd_whatsapp_log('Nenhuma loja vinculada ao cupom', ['deal_id' => $deal_id, 'coupon_code' => $coupon_code]);
            return ['success' => false, 'reason' => 'no_store'];
        }

        $rawPhone = $storeData['store_whatsapp'] ?? null;
        $to = nd_normalize_phone(is_string($rawPhone) ? $rawPhone : null);
        if (!$to) {
            nd_whatsapp_log('Loja sem WhatsApp cadastrado', ['store_id' => $storeData['store_id'] ?? null, 'deal_id' => $deal_id]);
            return ['success' => false, 'reason' => 'no_phone'];
        }

        $qText = ($quantity === null || $quantity === '' || (int)$quantity === 0) ? 'ilimitado' : (string)$quantity;

        $msg  = "✅ Novo cupom criado!\n";
        $msg .= "Loja: " . ($storeData['store_title'] ?? 'Sua loja') . "\n";
        $msg .= "Oferta: " . ($storeData['deal_title'] ?? '') . "\n";
        $msg .= "Cupom: " . $coupon_title . "\n";
        $msg .= "Código: " . $coupon_code . "\n";
        $msg .= "Desconto: " . $discount_percent . "%\n";
        $msg .= "Quantidade: " . $qText . "\n";
        $msg .= "Painel: " . (defined('SITE_URL') ? SITE_URL : '') . "/dashboard/coupons.php";

        return nd_send_whatsapp_message($to, $msg);
    }
}


if (!function_exists('nd_whatsapp_notify_merchant_coupon_redeemed')) {
    /**
     * Notifica o comerciante quando um cliente resgata (copia) um cupom de oferta.
     *
     * @param PDO   $connect
     * @param int   $deal_id
     * @param string $coupon_code
     * @param string|null $coupon_title
     * @return array<string,mixed>
     */
    function nd_whatsapp_notify_merchant_coupon_redeemed($connect, int $deal_id, string $coupon_code, ?string $coupon_title = null): array
    {
        try {
            $storeData = nd_get_store_whatsapp_by_deal($connect, $deal_id);
            if (!$storeData) {
                if (function_exists('nd_whatsapp_log')) {
                    nd_whatsapp_log('Nenhuma loja vinculada ao cupom no resgate', [
                        'deal_id' => $deal_id,
                        'coupon_code' => $coupon_code,
                    ]);
                }
                return ['ok' => false, 'reason' => 'no_store'];
            }

            $rawPhone = $storeData['store_whatsapp'] ?? null;
            $to = nd_normalize_phone(is_string($rawPhone) ? $rawPhone : null);
            if (!$to) {
                if (function_exists('nd_whatsapp_log')) {
                    nd_whatsapp_log('Loja sem WhatsApp cadastrado no resgate', [
                        'store_id' => $storeData['store_id'] ?? null,
                        'deal_id' => $deal_id,
                        'coupon_code' => $coupon_code,
                    ]);
                }
                return ['ok' => false, 'reason' => 'no_phone'];
            }

            $dealTitle   = $storeData['deal_title']  ?? '';
            $storeTitle  = $storeData['store_title'] ?? 'Sua loja';
            $couponLabel = $coupon_title ?: $coupon_code;

            $msg  = "🎟️ Cupom resgatado!\n";
            $msg .= "Loja: {$storeTitle}\n";
            if ($dealTitle !== '') {
                $msg .= "Oferta: {$dealTitle}\n";
            }
            $msg .= "Cupom: {$couponLabel}\n";
            $msg .= "Código: {$coupon_code}\n";
            $msg .= "Data/hora: " . date('d/m/Y H:i') . "\n";
            $msg .= "\nPeça para o cliente apresentar este código no momento da compra.";

            $res = nd_send_whatsapp_message($to, $msg);
            $ok  = !empty($res['success']);

            if (function_exists('nd_whatsapp_log')) {
                nd_whatsapp_log('WhatsApp resgate de cupom enviado', [
                    'deal_id' => $deal_id,
                    'coupon_code' => $coupon_code,
                    'ok' => $ok,
                    'response' => $res['response'] ?? null,
                ]);
            }

            $res['ok'] = $ok;
            return $res;
        } catch (Throwable $e) {
            if (function_exists('nd_whatsapp_log')) {
                nd_whatsapp_log('Erro ao notificar resgate de cupom', [
                    'deal_id' => $deal_id,
                    'coupon_code' => $coupon_code,
                    'error' => $e->getMessage(),
                ]);
            }
            return ['ok' => false, 'reason' => 'exception', 'error' => $e->getMessage()];
        }
    }
}



if (!function_exists('nd_whatsapp_notify_merchant_coupon_used')) {
    /**
     * Notifica o comerciante quando um cupom é marcado como UTILIZADO no painel.
     *
     * @param PDO   $connect
     * @param int   $deal_id
     * @param string $coupon_code
     * @param string|null $coupon_title
     * @param string|null $used_by Nome/identificação do usuário do painel
     * @return array<string,mixed>
     */
    function nd_whatsapp_notify_merchant_coupon_used($connect, int $deal_id, string $coupon_code, ?string $coupon_title = null, ?string $used_by = null): array
    {
        try {
            $storeData = nd_get_store_whatsapp_by_deal($connect, $deal_id);
            if (!$storeData) {
                if (function_exists('nd_whatsapp_log')) {
                    nd_whatsapp_log('Nenhuma loja vinculada ao cupom no uso', [
                        'deal_id' => $deal_id,
                        'coupon_code' => $coupon_code,
                    ]);
                }
                return ['ok' => false, 'reason' => 'no_store'];
            }

            $rawPhone = $storeData['store_whatsapp'] ?? null;
            $to = nd_normalize_phone(is_string($rawPhone) ? $rawPhone : null);
            if (!$to) {
                if (function_exists('nd_whatsapp_log')) {
                    nd_whatsapp_log('Loja sem WhatsApp cadastrado no uso', [
                        'store_id' => $storeData['store_id'] ?? null,
                        'deal_id' => $deal_id,
                        'coupon_code' => $coupon_code,
                    ]);
                }
                return ['ok' => false, 'reason' => 'no_phone'];
            }

            $dealTitle   = $storeData['deal_title']  ?? '';
            $storeTitle  = $storeData['store_title'] ?? 'Sua loja';
            $couponLabel = $coupon_title ?: $coupon_code;

            $msg  = "✅ Cupom utilizado!\n";
            $msg .= "Loja: {$storeTitle}\n";
            if ($dealTitle !== '') {
                $msg .= "Oferta: {$dealTitle}\n";
            }
            $msg .= "Cupom: {$couponLabel}\n";
            $msg .= "Código: {$coupon_code}\n";
            if (!empty($used_by)) {
                $msg .= "Registrado por: {$used_by}\n";
            }
            $msg .= "Data/hora: " . date('d/m/Y H:i');

            $res = nd_send_whatsapp_message($to, $msg);
            $ok  = !empty($res['success']);

            if (function_exists('nd_whatsapp_log')) {
                nd_whatsapp_log('WhatsApp uso de cupom enviado', [
                    'deal_id' => $deal_id,
                    'coupon_code' => $coupon_code,
                    'ok' => $ok,
                    'response' => $res['response'] ?? null,
                ]);
            }

            $res['ok'] = $ok;
            return $res;
        } catch (Throwable $e) {
            if (function_exists('nd_whatsapp_log')) {
                nd_whatsapp_log('Erro ao notificar uso de cupom', [
                    'deal_id' => $deal_id,
                    'coupon_code' => $coupon_code,
                    'error' => $e->getMessage(),
                ]);
            }
            return ['ok' => false, 'reason' => 'exception', 'error' => $e->getMessage()];
        }
    }
}
