<?php
declare(strict_types=1);
if (session_status() === PHP_SESSION_NONE) { session_start(); }
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/_nd_boot.php';

$item = isset($_GET['item']) ? trim((string)$_GET['item']) : '';
if ($item === '') {
  // tenta pelas rotas padrão ?deal_id=
  $item = isset($_GET['deal_id']) ? trim((string)$_GET['deal_id']) : '';
}
if ($item === '') { echo json_encode(['error'=>'missing item']); exit; }

try {
  $statsSql = "SELECT COALESCE(AVG(rating),0) AS avg_rating, COUNT(*) AS total
               FROM reviews WHERE item = ? AND status = 1";
  $stm = $pdo->prepare($statsSql);
  $stm->execute([$item]);
  $stats = $stm->fetch() ?: ['avg_rating'=>0,'total'=>0];

  $listSql = "SELECT id, `user`, comment, rating, verified, created
              FROM reviews
              WHERE item = ? AND status = 1
              ORDER BY created DESC LIMIT 100";
  $stm = $pdo->prepare($listSql);
  $stm->execute([$item]);
  $items = $stm->fetchAll();

  echo json_encode([
    'stats'=>[
      'avg'=> (float)$stats['avg_rating'],
      'count'=> (int)$stats['total']
    ],
    'items'=>$items
  ], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error'=>'db_error','detail'=>$e->getMessage()]);
}
