<?php
declare(strict_types=1);
require __DIR__ . '/core.php';

$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($id <= 0) { header('Location: ' . $urlPath->home()); exit; }

$deal = getDealById($connect, $id);
if (!$deal) { header('Location: ' . $urlPath->home()); exit; }

$dest = trim((string)($deal['deal_link'] ?? ''));
if (empty($dest)) {
  header('Location: ' . $urlPath->deal($deal['deal_id'], $deal['deal_slug']));
  exit;
}
if (!preg_match('@^https?://@i', $dest)) { $dest = 'https://' . ltrim($dest, '/'); }

try {
  $st = $connect->prepare('UPDATE deals SET deal_clicks = deal_clicks + 1 WHERE deal_id = :id');
  $st->execute([':id' => $id]);
} catch (Throwable $e) { /* ignore */ }

header('Referrer-Policy: no-referrer-when-downgrade');
header('Location: ' . $dest, true, 302);
exit;
