<?php

declare(strict_types=1);
header('Content-Type: text/plain; charset=utf-8');
$base = __DIR__;
$needle = 'langStrings[0]';
$rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($base, FilesystemIterator::SKIP_DOTS));
foreach ($rii as $file) {
    if ($file->isDir()) continue;
    if (substr($file->getFilename(), -4) !== '.php') continue;
    $path = $file->getPathname();
    $contents = @file_get_contents($path);
    if ($contents === false) continue;
    if (strpos($contents, $needle) !== false) {
        echo $path . "\n";
    }
}
echo "Done. DELETE this file after use.\n";
