<?php
require_once __DIR__.'/includes/location_prefilter.php';
require_once __DIR__ . '/init_lang.php'; // i18n bootstrap (no output here)
include $_SERVER['DOCUMENT_ROOT'] . '/partials/lang-switch.php';

/**
 * Helpers/URLs p/ autenticação (defensivos)
 * Mantidos em PHP puro para não gerar saída antes da view.
 */
if (!function_exists('nd_is_active_path')) {
    function nd_is_active_path(string $slug): bool {
        $uri = strtok($_SERVER['REQUEST_URI'] ?? '', '?') ?: '/';
        return (stripos($uri, $slug) !== false);
    }
}
$nd_has = function($obj, $fn) { return is_object($obj ?? null) && method_exists($obj, $fn); };

$ND_URL_LOGIN   = $nd_has($urlPath ?? null, 'login')   ? $urlPath->login()   : '/signin';
$ND_URL_LOGOUT  = $nd_has($urlPath ?? null, 'logout')  ? $urlPath->logout()  : './signout';
$ND_URL_PROFILE = 'https://conecta.ndmidia.com.br/dashboard/profile.php';
$ND_URL_SIGNUP  = $nd_has($urlPath ?? null, 'signup')  ? $urlPath->signup()  : './signup';

// Use suas funções do tema se existirem; fallback genérico
$ND_IS_LOGGED = function_exists('isLogged') ? isLogged() : (!empty($_SESSION['user_id']) || !empty($_SESSION['user']['id']));

// Expor dados para a view
$__ND_AUTH = [
    'login'    => $ND_URL_LOGIN,
    'signout'   => $ND_URL_LOGOUT,
    'profile'  => $ND_URL_PROFILE,
    'signup'   => $ND_URL_SIGNUP,
    'isLogged' => $ND_IS_LOGGED,
];
$__AUTH = $__ND_AUTH;

// Render da view do header (HTML começa lá)
require_once __DIR__ . '/views/header.view.php';
