<?php

declare(strict_types=1);
require '../core.php';

$payload = @file_get_contents('php://input');
$data = json_decode($payload);

// Try to get payment ID
$payment_id = null;

if(isset($_GET['id'])) {
    $payment_id = (string) $_GET['id'];
} elseif(isset($data->data->id)) {
    $payment_id = (string) $data->data->id;
} elseif(isset($data->id)) {
    $payment_id = (string) $data->id;
}

if(!$payment_id) {
    die('');
}

$mpEndpoint = 'https://api.mercadopago.com/v1/payments/' . urlencode($payment_id);

$mpHeaders = [
    'Authorization' => 'Bearer ' . $settings['st_mercadopago_access_token'],
    'Content-Type'  => 'application/json',
];

try {
    $response = \Unirest\Request::get($mpEndpoint, $mpHeaders);
} catch (\Exception $exception) {
    if(isAdmin()) {
        echo $exception->getMessage();
    }
    die('');
}

if(!isset($response->body->status) || $response->body->status !== 'approved') {
    die('');
}

$payment = $response->body;

$external_payment_id = isset($payment->id) ? (string) $payment->id : '';
$payment_total       = isset($payment->transaction_amount) ? (float) $payment->transaction_amount : 0;
$payment_currency    = isset($payment->currency_id) ? (string) $payment->currency_id : $settings['st_currencycode'];
$payment_type        = 'mercadopago';
$payment_subscription_id = '';

$payer_email = isset($payment->payer->email) ? $payment->payer->email : '';
$payer_name  = '';
if(isset($payment->payer->first_name) || isset($payment->payer->last_name)) {
    $payer_name = trim(
        (isset($payment->payer->first_name) ? $payment->payer->first_name : '') . ' ' .
        (isset($payment->payer->last_name) ? $payment->payer->last_name : '')
    );
}

$metadata = isset($payment->metadata) ? $payment->metadata : null;

$user_id          = isset($metadata->user_id) ? (int) $metadata->user_id : 0;
$plan_id          = isset($metadata->plan_id) ? (int) $metadata->plan_id : 0;
$payment_frequency = isset($metadata->payment_frequency) ? $metadata->payment_frequency : '';
$code             = isset($metadata->code) ? $metadata->code : '';
$discount_amount  = isset($metadata->discount_amount) ? (float) $metadata->discount_amount : 0;
$base_amount      = isset($metadata->base_amount) ? (float) $metadata->base_amount : 0;
$taxes_ids        = isset($metadata->taxes_ids) ? $metadata->taxes_ids : null;

webhookProcessPayment(
    $connect,
    $settings,
    'mercadopago',
    $taxes_ids,
    $external_payment_id,
    $payment_total,
    $payment_currency,
    $user_id,
    $plan_id,
    $payment_frequency,
    $code,
    $discount_amount,
    $base_amount,
    $payment_type,
    $payment_subscription_id,
    $payer_email,
    $payer_name
);

die('successful');

