<?php
if (!isset($translation) || !is_array($translation)) $translation = array();
if (!function_exists('__t_helper')){
  function __t_helper($k,$d=''){ global $translation; return isset($translation[$k]) ? $translation[$k] : ($d!==''?$d:$k); }
}
if (!function_exists('h')){
  function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}
if (!function_exists('url_page')){
  function url_page($slug){
    if (is_array($slug)) {
      $slug = isset($slug['slug']) ? $slug['slug'] : (isset($slug['path']) ? $slug['path'] : '');
    } elseif (is_object($slug)) {
      if (isset($slug->slug)) { $slug = $slug->slug; }
      elseif (method_exists($slug,'__toString')) { $slug = (string)$slug; }
      else { $slug = ''; }
    } elseif (!is_string($slug)) { $slug = ''; }
    $slug = (string)$slug;
    $base = defined('SITE_URL') ? rtrim(SITE_URL,'/') : '';
    return $base . '/' . ltrim($slug,'/');
  }
}
if (!function_exists('build_qs')){
  function build_qs($overrides=array()){ $q=$_GET; if(is_array($overrides)){ foreach($overrides as $k=>$v){ $q[$k]=$v; } } return http_build_query($q); }
}
if (!function_exists('render_rating_stars')){
  function render_rating_stars($rating){ $r=floatval($rating); $full=floor($r); $half=($r-$full)>=0.5?1:0; return str_repeat('★',$full).($half?'☆':''); }
}
if (!function_exists('compute_discount')){
  function compute_discount($price,$old){ $p=floatval(preg_replace('/[^0-9\.]/','',(string)$price)); $o=floatval(preg_replace('/[^0-9\.]/','',(string)$old)); return ($o>$p && $p>0)? round((($o-$p)/$o)*100) : 0; }
}
if (!function_exists('paginate')){
  function paginate($total,$per_page,$page){
    $total=max(0,intval($total)); $per_page=max(1,intval($per_page)); $page=max(1,intval($page));
    $pages=max(1,intval(ceil($total/$per_page))); if($pages<=1) return '';
    $html='<ul class="uk-pagination uk-flex-center">';
    $prev=max(1,$page-1); $next=min($pages,$page+1);
    $html.='<li><a href="?'.h(build_qs(['page'=>$prev])).'">&laquo;</a></li>';
    for($i=1;$i<=$pages;$i++){ $active=$i==$page?' class="uk-active"':''; $html.='<li'.$active.'><a href="?'.h(build_qs(['page'=>$i])).'">'.$i.'</a></li>'; }
    $html.='<li><a href="?'.h(build_qs(['page'=>$next])).'">&raquo;</a></li>';
    $html.='</ul>'; return $html;
  }
}
?>