<?php
declare(strict_types=1);

/**
 * Retorna [lat, lng] do usuário com a prioridade:
 *   1) GET ?lat=&lng=
 *   2) cookies nd_geo_lat / nd_geo_lng
 *   3) centro da cidade do slug atual (?location= ou cookie nd_location_slug)
 * Retorna [null, null] se nada encontrado.
 */
function nd_getUserOrigin(PDO $connect): array {
    $lat = $lng = null;

    if (isset($_GET['lat'], $_GET['lng'])) {
        $lat = (float)$_GET['lat'];
        $lng = (float)$_GET['lng'];
    } elseif (!empty($_COOKIE['nd_geo_lat']) && !empty($_COOKIE['nd_geo_lng'])) {
        $lat = (float)$_COOKIE['nd_geo_lat'];
        $lng = (float)$_COOKIE['nd_geo_lng'];
    } else {
        $slug = isset($_GET['location']) ? urldecode((string)$_GET['location'])
                : (isset($_COOKIE['nd_location_slug']) ? (string)$_COOKIE['nd_location_slug'] : '');
        if ($slug !== '') {
            $stmt = $connect->prepare("SELECT location_lat, location_lng FROM locations WHERE location_slug = :slug LIMIT 1");
            $stmt->execute([':slug' => strtolower(trim($slug))]);
            if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $lat = (float)$row['location_lat'];
                $lng = (float)$row['location_lng'];
            }
        }
    }
    return [$lat, $lng];
}

/** Fragmento SQL Haversine (km) entre (:ulat,:ulng) e l.location_* */
function nd_haversine_sql(): string {
    // Usa placeholders únicos (:ulat1, :ulat2, :ulng) para compatibilidade com PDO MySQL (sem emulate prepares)
    return "(6371 * ACOS( COS(RADIANS(:ulat1)) * COS(RADIANS(l.location_lat)) * COS(RADIANS(l.location_lng) - RADIANS(:ulng)) + SIN(RADIANS(:ulat2)) * SIN(RADIANS(l.location_lat)) ))";
}
