<?php
// Standalone tracking implementation (safe to include multiple times).
if (!function_exists('insertTrack')) {
function insertTrack($connect, $itemId){
    error_log('ND: insertTrack (nd-tracking.php) iniciou, item=' . $itemId);

    $user = function_exists('getUserInfo') ? getUserInfo() : null;
    $cookie_name = 'd_tracking_' . $itemId;

    // Anti-flood básico (pode ajustar depois)
    if(isset($_COOKIE[$cookie_name]) && (int) $_COOKIE[$cookie_name] >= 3) {
        // continua gravando pelo menos um por request para debug? descomente para estrito:
        // return;
    }

    // Browser/OS/device, sem quebrar se lib não existir
    $browser_name = null; $os_name = null; $device_type = null;
    try {
        if (class_exists('\\WhichBrowser\\Parser', false)) {
            $wb = new \WhichBrowser\Parser($_SERVER['HTTP_USER_AGENT'] ?? '');
            if ($wb && isset($wb->device) && $wb->device->type === 'bot') {
                // se quiser ignorar bot, descomente:
                // return;
            }
            $browser_name = $wb->browser->name ?? null;
            $os_name      = $wb->os->name ?? null;
        }
        if (function_exists('getDeviceType')) {
            $device_type = getDeviceType($_SERVER['HTTP_USER_AGENT'] ?? '');
        }
    } catch (\Throwable $e) {
        error_log('ND: WhichBrowser erro: '.$e->getMessage());
    }

    $browser_language  = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? mb_substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2) : null;

    // IP e binário
    $ip_txt = function_exists('getIp') ? getIp() : ($_SERVER['REMOTE_ADDR'] ?? '127.0.0.1');
    $ip_bin = @inet_pton($ip_txt) ?: null;
    error_log('ND: insertTrack ip_txt=' . $ip_txt . ' binlen=' . (is_string($ip_bin)?strlen($ip_bin):0));

    // Geo com fallback
    $country_name = null; $country_code = null; $city_name = null;
    try {
        if (function_exists('getInfoByIp')) {
            $loc = getInfoByIp($ip_txt);
            $country_name = $loc['country'] ?? ($loc['countryName'] ?? null);
            $country_code = $loc['country_code'] ?? ($loc['countryCode'] ?? null);
            $city_name    = $loc['city'] ?? null;
        }
    } catch (\Throwable $e) { error_log('ND: geo fail ' . $e->getMessage()); }

    $referrer = null;
    if (!empty($_SERVER['HTTP_REFERER'])) {
        $referrer = @parse_url($_SERVER['HTTP_REFERER']);
    }

    $sql = "INSERT INTO tracking (
                track_user, track_item,
                track_country_name, track_country_code, track_city,
                track_os, track_browser, track_host, track_path,
                track_ip, track_device, track_browser_language,
                track_is_unique, track_datetime
            ) VALUES (
                :user, :item,
                :cname, :ccode, :city,
                :os, :browser, :host, :path,
                :ipbin, :device, :lang,
                :uniq, NOW()
            )";

    $stmt = $connect->prepare($sql);
    $stmt->bindValue(':user',   $user['id'] ?? null, \PDO::PARAM_INT);
    $stmt->bindValue(':item',   $itemId, \PDO::PARAM_INT);
    $stmt->bindValue(':cname',  $country_name);
    $stmt->bindValue(':ccode',  $country_code);
    $stmt->bindValue(':city',   $city_name);
    $stmt->bindValue(':os',     $os_name);
    $stmt->bindValue(':browser',$browser_name);
    $stmt->bindValue(':host',   $referrer['host'] ?? null);
    $stmt->bindValue(':path',   $referrer['path'] ?? null);
    if ($ip_bin === null) {
        $stmt->bindValue(':ipbin', null, \PDO::PARAM_NULL);
    } else {
        $stmt->bindValue(':ipbin', $ip_bin, \PDO::PARAM_STR);
    }
    $stmt->bindValue(':device', $device_type);
    $stmt->bindValue(':lang',   $browser_language);
    $stmt->bindValue(':uniq',   isset($_COOKIE[$cookie_name]) ? 0 : 1, \PDO::PARAM_INT);
    $stmt->execute();

    // Atualiza contador
    try{
        $upd = $connect->prepare('UPDATE deals SET deal_clicks = (deal_clicks + 1) WHERE deal_id = :id');
        $upd->execute([':id' => $itemId]);
    } catch (\Throwable $e) {
        error_log('ND: update clicks falhou: '.$e->getMessage());
    }

    // Cookie anti-flood simples
    $cookie_new_value = isset($_COOKIE[$cookie_name]) ? (int) $_COOKIE[$cookie_name] + 1 : 1;
    @setcookie($cookie_name, (int) $cookie_new_value, time()+60*60*24*1);

    error_log('ND: insertTrack finalizado.');
}
}
