<?php
// includes/seo_local.php
// Uso: seo_local_jsonld($deal, $locationRow);

function seo_local_jsonld(array $deal, ?array $loc) {
  $name = $deal['deal_title'] ?? 'Oferta';
  $price = $deal['deal_price'] ?? null;
  $currency = $deal['deal_currency'] ?? 'BRL';
  $url = (isset($_SERVER['REQUEST_SCHEME']) ? $_SERVER['REQUEST_SCHEME'] : 'https') . '://' . ($_SERVER['HTTP_HOST'] ?? '') . ($_SERVER['REQUEST_URI'] ?? '');

  $json = [
    "@context" => "https://schema.org",
    "@type" => "Product",
    "name" => $name,
    "url" => $url,
    "offers" => [
      "@type" => "Offer",
      "priceCurrency" => $currency,
      "availability" => "http://schema.org/InStock"
    ]
  ];
  if ($price !== null) $json["offers"]["price"] = (string)$price;

  if ($loc) {
    $area = [
      "@type" => "AdministrativeArea",
      "name" => $loc['location_title'] ?? ''
    ];
    $json["areaServed"] = $area;
    $json["availableAtOrFrom"] = $area;
  }

  echo '<script type="application/ld+json">'.json_encode($json, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE).'</script>';
}
