<?php

declare(strict_types=1);
// === ND Helpers Loader (guarded) ===
$___h_candidates = [
    __DIR__ . '/app/Support/helpers.php',
    // if this bootstrap sits in a subfolder:
    dirname(__DIR__) . '/app/Support/helpers.php',
    // fallback if only 'Support/helpers.php' got uploaded to project root
    __DIR__ . '/Support/helpers.php',
];
$___loaded = false;
foreach ($___h_candidates as $___h) {
    if (is_file($___h)) {
        require_once $___h;
        $___loaded = true;
        break;
    }
}
if (!$___loaded) {
    trigger_error('ND Helpers not found (tried: ' . implode(', ', $___h_candidates) . ')', E_USER_WARNING);
}
// === /ND Helpers Loader ===

?>
<?php
// === i18n FORCE GUARD (v5) ===
if (!isset($langStrings) || !is_array($langStrings)) { $langStrings = array(); }
if (!isset($translation) || !is_array($translation)) { $translation = array(); }
// ==================================

require "core.php";


// ===== Single Deal Router (id ou slug) — bloco mínimo =====
$dealId = isset($_GET['deal_id']) ? (int)$_GET['deal_id'] : 0;
$slug   = isset($_GET['slug']) ? trim($_GET['slug']) : '';
$deal   = null;

if ($dealId > 0 && function_exists('getDealById')) {
    $deal = getDealById($connect, $dealId);
} elseif ($slug !== '' && function_exists('getDealBySlug')) {
    $deal = getDealBySlug($connect, $slug);
}
// ==========================================================
// i18n sync (v5)
if (isset($translation) && is_array($translation)) { $langStrings = $translation; $translation = $translation; }

// =======================================================
// Single Deal Router (sem criar arquivo novo)
// Se houver ?deal_id=123, carregamos a oferta e exibimos o detalhe
// =======================================================
$dealId = isset($_GET['deal_id']) ? (int)$_GET['deal_id'] : 0;
$deal   = null;

if ($dealId > 0 && function_exists('getDealById')) {
    // Função a ser adicionada no seu functions.php
    // (já te enviei o bloco; garante aliases e filtro de expiração seguro)
    $deal = getDealById($connect, $dealId);
}
$dealId = isset($_GET['deal_id']) ? (int)$_GET['deal_id'] : 0;
$slug   = isset($_GET['slug']) ? trim($_GET['slug']) : '';
$deal   = null;

if ($dealId > 0 && function_exists('getDealById')) {
    $deal = getDealById($connect, $dealId);
} elseif ($slug !== '' && function_exists('getDealBySlug')) {
    $deal = getDealBySlug($connect, $slug);
}

// =======================================================
// SEO: se estiver em página de oferta, usa título/descrição da oferta;
// caso contrário, mantém o comportamento original.
// =======================================================


// Carrega cupons da oferta, se houver deal_id e função disponível
$dealCoupons = [];
if (isset($dealId) && $dealId > 0 && isset($connect) && $connect instanceof PDO && function_exists('getDealCoupons')) {
    try {
        $dealCoupons = getDealCoupons($connect, (int)$dealId, 50);
    } catch (Throwable $e) {
        $dealCoupons = [];
    }
}

// Seo Title
$titleSeoHeader = $deal
    ? getSeoTitle((isset($translation['tr_1']) ? $translation['tr_1'] : 'Ofertas'),
                  (isset($deal['deal_title']) ? $deal['deal_title'] : 'Oferta'))
    : getSeoTitle((isset($translation['tr_1']) ? $translation['tr_1'] : ''));

// Seo Description
$descriptionSeoHeader = $deal
    ? getSeoDescription(isset($deal['deal_description']) ? $deal['deal_description'] : '')
    : getSeoDescription((isset($translation['tr_3']) ? $translation['tr_3'] : ''));

include './header.php';
include './views/index.view.php';
include './footer.php';

?>
