<?php

declare(strict_types=1);

// Avoid double bootstrap
if (defined('ND_I18N_BOOTSTRAPPED')) { return; }
define('ND_I18N_BOOTSTRAPPED', true);
// Carregador de chaves agrupadas para __('a.b.c')
if (session_status() === PHP_SESSION_NONE) {
if (session_status() !== PHP_SESSION_ACTIVE) { @session_start(); }
}
$lang = $_SESSION['lang'] ?? 'en';
$file = __DIR__ . "/languages/{$lang}.php";
if (!file_exists($file)) {
  $file = __DIR__ . "/languages/en.php";
}
$langData = require $file;
if (!function_exists('__')) { function __($key) {
    global $langData;
    $keys = explode('.', $key);
    $value = $langData;
    foreach ($keys as $k) {
        if (!is_array($value) || !array_key_exists($k, $value)) return $key;
        $value = $value[$k];
    }
    return $value;
}

// END i18n wrappers
}

// Safe translation helper: __t('key', 'fallback')
if (!function_exists('__t')) {
    function __t(string $key, string $default = ''): string {
        $table = $GLOBALS['tr'] ?? [];
        if (isset($table[$key]) && $table[$key] !== '') {
            return (string)$table[$key];
        }
        return $default !== '' ? $default : $key;
    }
}
