<?php
/* ND translation fallbacks */
$translation = isset($translation) && is_array($translation) ? $translation : [];
$translation += [
  'tr_376' => $translation['tr_376'] ?? 'Monthly',
  'tr_377' => $translation['tr_377'] ?? '6 Months',
  'tr_378' => $translation['tr_378'] ?? 'Annual',
  'tr_379' => $translation['tr_379'] ?? 'Popular',
  'tr_380' => $translation['tr_380'] ?? 'Save',
  'tr_381' => $translation['tr_381'] ?? 'per month',
  'tr_382' => $translation['tr_382'] ?? 'per 6 months',
  'tr_383' => $translation['tr_383'] ?? 'per year',
  'tr_384' => $translation['tr_384'] ?? 'Choose plan',
  'tr_385' => $translation['tr_385'] ?? 'Features',
  'tr_386' => $translation['tr_386'] ?? 'Unlimited Deals',
  'tr_387' => $translation['tr_387'] ?? 'Priority Support',
  'tr_388' => $translation['tr_388'] ?? 'Cancel anytime',
];
?>

<?php if($itemDetails['page_show_title'] == 1): ?>
<?php include './sections/page-title.php'; ?>
<?php else: ?>
<div class="uk-margin-medium-top"></div>
<?php endif; ?>

<?php if($itemDetails['page_ad_header'] == 1): ?>
<?php include './sections/views/header-ad.view.php'; ?>
<?php endif; ?>

<?php if(!empty($itemDetails['page_content'])): ?>
<div class="uk-container">
<div class="uk-width-1-1">
<?php echo nd_safe_html($itemDetails['page_content'] ?? ''); ?>
</div>
</div>
<?php endif; ?>

<div class="uk-container uk-margin-top">
    <?php include './sections/plans.php'; ?>
</div>

<div class="uk-section uk-section-muted uk-padding-small">
  <div class="uk-container">
    <div class="uk-grid-large" uk-grid>

      <div class="uk-width-1-1 uk-width-2-3@s">
        <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
          <h3 class="uk-margin-remove">Add-ons (onde mora sua margem)</h3>
          <p class="uk-margin-small-top">Turbinadores fáceis de explicar e de alto valor percebido.</p>

          <div class="uk-child-width-1-2@s uk-grid-small" uk-grid>
            <div>
              <div class="uk-padding-small uk-background-muted uk-border-rounded">
                <div class="uk-text-bold">Destaque na Home (7 dias)</div>
                <div class="uk-text-muted">R$ 99</div>
              </div>
            </div>
            <div>
              <div class="uk-padding-small uk-background-muted uk-border-rounded">
                <div class="uk-text-bold">Topo da Categoria (7 dias)</div>
                <div class="uk-text-muted">R$ 79</div>
              </div>
            </div>
            <div>
              <div class="uk-padding-small uk-background-muted uk-border-rounded">
                <div class="uk-text-bold">Pacote Criativo + Oferta Matadora</div>
                <div class="uk-text-muted">Setup: R$ 150–300</div>
              </div>
            </div>
            <div>
              <div class="uk-padding-small uk-background-muted uk-border-rounded">
                <div class="uk-text-bold">Exclusividade por segmento/bairro</div>
                <div class="uk-text-muted">Mensal: R$ 300–900</div>
              </div>
            </div>
          </div>
</div>

      <div class="uk-width-1-1 uk-width-1-3@s">
        <div class="uk-card uk-card-default uk-card-body uk-border-rounded uk-card-bordered">
          <h3 class="uk-margin-remove">Taxa de implantação</h3>
          <p class="uk-margin-small-top">Para evitar oferta fraca e frustração no primeiro mês.</p>

          <ul class="uk-list uk-list-bullet uk-margin-top">
            <li><b>Setup opcional:</b> R$ 149 (cadastro + primeira oferta + ajustes básicos)</li>
            <li><b>Setup grátis:</b> nos planos de <b>6</b> ou <b>12 meses</b> (melhora conversão)</li>
          </ul>
</div>

    </div>
  </div>
</div>

<div class="uk-section uk-section-muted uk-padding-small">
  <div class="uk-container">
    <div class="uk-card uk-card-default uk-card-body">
      <h3 class="uk-heading-line uk-text-center"><span>Perguntas frequentes</span></h3>
      <div class="uk-child-width-1-2@s uk-grid-large uk-margin-top" uk-grid>
        <div>
          <h4>Quais métodos de pagamento vocês aceitam?</h4>
          <p>Aceitamos pagamentos via cartão de crédito, PIX e outras formas que forem sendo liberadas pela plataforma.</p>

          <h4>Posso cancelar minha assinatura?</h4>
          <p>Sim. Você pode cancelar a qualquer momento. O acesso permanece ativo até o fim do período já pago.</p>
        </div>
        <div>
          <h4>Posso mudar de planos?</h4>
          <p>Sim. Você pode alterar de plano sempre que desejar. Ao trocar de plano, o sistema ajusta automaticamente sua assinatura.</p>

          <h4>O que acontece quando minha assinatura expira?</h4>
          <p>Após o término da assinatura, suas ofertas deixam de ser exibidas e você perde o acesso aos recursos do plano.</p>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="uk-section">
  <div class="uk-container uk-text-center">
    <h3>Ainda tem dúvidas?</h3>
    <a href="<?php echo $urlPath->contact(); ?>" class="uk-button uk-button-primary uk-border-rounded uk-margin-top">
      Contate-nos
    </a>
  </div>
</div>

