<?php
// URL base segura para "Limpar filtros"
$storesBaseUrl = (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'stores'))
    ? $urlPath->stores()
    : './stores';
?>

<div class="nd-stores-page">

    <!-- FIXES só nesta página -->
    <style>
        /* =========================================
           ND - STORES (Lojas) - FIXES
           ========================================= */

        html, body{
            height: auto !important;
            min-height: 0 !important;
        }
        body{
            padding-bottom: 0 !important;
            margin-bottom: 0 !important;
        }

        .nd-stores-page{
            min-height: auto !important;
            padding-bottom: 0 !important;
            margin-bottom: 0 !important;
        }

        /* Se existir separador global antes do footer nesta rota, oculta */
        .nd-stores-page + .uk-container.uk-margin-medium-top{
            margin-top: 0 !important;
            padding-top: 0 !important;
        }
        .nd-stores-page + .uk-container.uk-margin-medium-top hr{
            display: none !important;
        }

        /* Slider: garantir que a imagem fique "inteira" */
        .nd-stores-page .uk-slideshow-items > li{
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .nd-stores-page .uk-slideshow-items > li img{
            width: 100%;
            height: 100%;
            object-fit: contain !important; /* imagem inteira */
        }

        /* Legenda do slider */
        .nd-stores-slider-caption{
            display:inline-block;
            padding:6px 12px;
            border:1px solid #e53935;
            border-radius:8px;
            color:#e53935;
            font-size:16px;
            font-weight:700;
            letter-spacing:.03em;
            text-transform:uppercase;
        }
        @media (min-width: 960px){
            .nd-stores-slider-caption{ font-size:18px; }
        }
    </style>

    <script>
        // Reforço contra CSS do tema aplicado depois
        document.addEventListener('DOMContentLoaded', function () {
            document.body.style.setProperty('padding-bottom', '0px', 'important');
            document.body.style.setProperty('margin-bottom', '0px', 'important');
        });
    </script>

    <?php if($itemDetails['page_show_title'] == 1): ?>
        <?php include './sections/page-title.php'; ?>
    <?php else: ?>
        <div class="uk-margin-medium-top"></div>
    <?php endif; ?>

    <?php
    // Slider igual ao da home (apenas módulo de slides)
    $getSliders = function_exists('getSliders') ? getSliders($connect) : [];
    ?>

    <?php if (!empty($getSliders)): ?>
        <div class="tas_home_3 uk-container uk-margin-top uk-margin-small-bottom">
            <div class="uk-position-relative uk-visible-toggle uk-light" tabindex="-1"
                 uk-slideshow="animation: fade; ratio: 7:3">
                <ul class="uk-slideshow-items">
                    <?php foreach ($getSliders as $item): ?>
                        <?php
                            $sliderLink  = $item['slider_link'] ?? '#';
                            $sliderTitle = $item['slider_title'] ?? $sliderLink;
                            $sliderImg   = $item['slider_image'] ?? '';
                            $imgSrc      = ($sliderImg && isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'image'))
                                ? $urlPath->image($sliderImg)
                                : $sliderImg;
                        ?>
                        <li>
                            <a href="<?php echo echoOutput($sliderLink); ?>">
                                <img class="uk-border-rounded"
                                     src="<?php echo echoOutput($imgSrc); ?>"
                                     alt="<?php echo echoOutput($sliderTitle); ?>">
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>

                <a class="uk-position-center-left uk-position-small uk-hidden-hover nextprevbtn"
                   href="#" uk-slidenav-previous uk-slideshow-item="previous">
                    <i class="ti ti-chevron-left"></i>
                </a>
                <a class="uk-position-center-right uk-position-small uk-hidden-hover nextprevbtn"
                   href="#" uk-slidenav-next uk-slideshow-item="next">
                    <i class="ti ti-chevron-right"></i>
                </a>
            </div>
        </div>

        <div class="uk-text-center uk-margin-small-top">
            <span class="nd-stores-slider-caption">Lojas participantes do ecossistema ND Conecta.</span>
        </div>
    <?php endif; ?>

    <div class="uk-container uk-margin-small-top">
        <div class="uk-grid-small uk-flex-middle" uk-grid>
            <div class="uk-width-expand">
                <!-- Espaço reservado caso queira colocar um subtítulo futuro -->
            </div>
            <div class="uk-width-1-1 uk-width-auto@m">
                <form class="uk-search uk-search-default uk-width-1-1" action="<?php echo $urlPath->search(); ?>">
                    <span uk-search-icon></span>
                    <input class="uk-search-input uk-border-pill" type="search" name="s" placeholder="Buscar por loja...">
                </form>
            </div>
        </div>
    </div>

    <?php if($itemDetails['page_ad_header'] == 1): ?>
        <?php include './sections/views/header-ad.view.php'; ?>
    <?php endif; ?>

    <?php
    // ===== Normalização das letras (evita Undefined array key "arrayLetter") =====
    $letters = [];
    if (isset($translation['arrayLetter']) && is_array($translation['arrayLetter']) && !empty($translation['arrayLetter'])) {
        $letters = $translation['arrayLetter'];
    } else {
        $letters = range('A', 'Z');
    }

    // Filtros por categoria e status aberto
    $selectedCat  = isset($_GET['cat']) ? (int) $_GET['cat'] : 0;
    $selectedOpen = isset($_GET['open_now']) && $_GET['open_now'] === '1';

    $storeCategories = [];

    if (function_exists('getCategories')) {
        try { $storeCategories = getCategories($connect); } catch (Throwable $e) { $storeCategories = []; }
    }
    ?>

    <!-- Filtros (sem Região/Bairro) -->
    <div class="uk-container uk-margin-small-top">
        <form class="uk-grid-small uk-flex-middle uk-child-width-1-1 uk-child-width-auto@s" uk-grid method="get">

            <div>
                <label class="uk-form-label uk-text-meta">Categoria</label>
                <div class="uk-form-controls">
                    <select class="uk-select uk-border-rounded" name="cat">
                        <option value="0">Todas</option>
                        <?php foreach ($storeCategories as $cat): ?>
                            <?php $catId = (int)($cat['category_id'] ?? 0); ?>
                            <option value="<?php echo $catId; ?>" <?php echo $selectedCat === $catId ? 'selected' : ''; ?>>
                                <?php echo echoOutput($cat['category_title'] ?? ''); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <div>
                <label class="uk-form-label uk-text-meta">Status</label>
                <div class="uk-form-controls">
                    <label>
                        <input class="uk-checkbox" type="checkbox" name="open_now" value="1" <?php echo $selectedOpen ? 'checked' : ''; ?>>
                        Aberto agora
                    </label>
                </div>
            </div>

            <div>
                <button class="uk-button uk-button-primary uk-border-rounded uk-margin-small-top@s" type="submit">
                    Aplicar filtros
                </button>
                <?php if ($selectedCat || $selectedOpen): ?>
                    <a href="<?php echo $storesBaseUrl; ?>" class="uk-button uk-button-text uk-margin-small-top@s">Limpar filtros</a>
                <?php endif; ?>
            </div>

        </form>
    </div>

    <?php
    $topStores = [];
    if (function_exists('getTopRatedStores')) {
        try { $topStores = getTopRatedStores($connect, 5); } catch (Throwable $e) { $topStores = []; }
    }

    $premiumStores = [];
    if (function_exists('getFeaturedStores')) {
        try { $premiumStores = getFeaturedStores($connect); } catch (Throwable $e) { $premiumStores = []; }
    }
    ?>

    <?php if (!empty($topStores) || !empty($premiumStores)): ?>
        <div class="uk-section uk-section-muted uk-padding-small uk-padding-remove-horizontal">
            <div class="uk-container">
                <div class="uk-grid-medium" uk-grid>

                    <?php if (!empty($topStores)): ?>
                        <div class="uk-width-1-1 uk-width-expand@m">
                            <h3 class="uk-h4 uk-margin-small-bottom">Top 5 mais bem avaliadas</h3>

                            <div class="uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-5@m uk-grid-small" uk-grid>
                                <?php foreach ($topStores as $item):
                                    $storeId = (int)($item['store_id'] ?? 0);

                                    $storeStats = function_exists('getStoreReviewStats')
                                        ? getStoreReviewStats($connect, $storeId)
                                        : ['rating' => null, 'total' => 0, 'recommended' => false];

                                    $storeRating       = $storeStats['rating'];
                                    $storeReviewsCount = $storeStats['total'];
                                    $storeRecommended  = $storeStats['recommended'];

                                    $storeOpenStateList = function_exists('isStoreOpenNow')
                                        ? isStoreOpenNow($item['store_hours'] ?? null)
                                        : null;

                                    $href = (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'store'))
                                        ? $urlPath->store($item['store_slug'])
                                        : './store/' . rawurlencode($item['store_slug']);

                                    $logo = $item['store_image'] ?? '';
                                    $logoUrl = ($logo && isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'image'))
                                        ? $urlPath->image($logo)
                                        : $logo;
                                ?>
                                    <div>
                                        <a class="uk-text-secondary" href="<?php echo $href; ?>">
                                            <div class="uk-card uk-card-default uk-card-small uk-border-rounded uk-overflow-hidden">
                                                <div class="uk-card-body uk-padding-small">
                                                    <div class="uk-grid-small uk-flex-middle" uk-grid>
                                                        <div class="uk-width-auto">
                                                            <?php if ($logoUrl): ?>
                                                                <img class="uk-border-circle"
                                                                     src="<?php echo htmlspecialchars($logoUrl, ENT_QUOTES, 'UTF-8'); ?>"
                                                                     width="48" height="48"
                                                                     alt="<?php echo echoOutput($item['store_title'] ?? ''); ?>">
                                                            <?php else: ?>
                                                                <div class="uk-border-circle uk-background-muted" style="width:48px;height:48px;"></div>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="uk-width-expand">
                                                            <div class="uk-text-small uk-text-bold uk-text-truncate">
                                                                <?php echo echoOutput($item['store_title'] ?? ''); ?>
                                                            </div>

                                                            <div class="uk-text-meta">
                                                                <?php if ($storeRating !== null): ?>
                                                                    <span uk-icon="star"></span>
                                                                    <span class="uk-margin-small-left">
                                                                        <?php echo number_format($storeRating, 1, ',', '.'); ?>
                                                                    </span>
                                                                    <?php if (!empty($storeReviewsCount)): ?>
                                                                        <span class="uk-margin-small-left">
                                                                            (<?php echo (int)$storeReviewsCount; ?> avaliações)
                                                                        </span>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>

                                                                <?php if (!empty($storeRecommended)): ?>
                                                                    <span class="uk-label uk-label-primary uk-label-small uk-margin-small-left">Indicado</span>
                                                                <?php endif; ?>

                                                                <?php if ($storeOpenStateList === true): ?>
                                                                    <span class="uk-label uk-label-success uk-label-small uk-margin-small-left">Aberto agora</span>
                                                                <?php elseif ($storeOpenStateList === false): ?>
                                                                    <span class="uk-label uk-label-danger uk-label-small uk-margin-small-left">Fechado</span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($premiumStores)): ?>
                        <div class="uk-width-1-1 uk-width-auto@m">
                            <h3 class="uk-h4 uk-margin-small-bottom">Vitrine Premium</h3>
                            <p class="uk-text-meta uk-margin-remove-top">Lojas em destaque no ecossistema ND Conecta.</p>

                            <div class="uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-2@m uk-grid-small" uk-grid>
                                <?php foreach ($premiumStores as $item):
                                    $href = (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'store'))
                                        ? $urlPath->store($item['store_slug'])
                                        : './store/' . rawurlencode($item['store_slug']);

                                    $logo = $item['store_image'] ?? '';
                                    $logoUrl = ($logo && isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'image'))
                                        ? $urlPath->image($logo)
                                        : $logo;
                                ?>
                                    <div>
                                        <a class="uk-text-secondary" href="<?php echo $href; ?>">
                                            <div class="uk-card uk-card-default uk-card-small uk-border-rounded uk-overflow-hidden">
                                                <div class="uk-card-body uk-padding-small">
                                                    <div class="uk-grid-small uk-flex-middle" uk-grid>
                                                        <div class="uk-width-auto">
                                                            <?php if ($logoUrl): ?>
                                                                <img class="uk-border-circle"
                                                                     src="<?php echo htmlspecialchars($logoUrl, ENT_QUOTES, 'UTF-8'); ?>"
                                                                     width="40" height="40"
                                                                     alt="<?php echo echoOutput($item['store_title'] ?? ''); ?>">
                                                            <?php else: ?>
                                                                <div class="uk-border-circle uk-background-muted" style="width:40px;height:40px;"></div>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="uk-width-expand">
                                                            <div class="uk-text-small uk-text-bold uk-text-truncate">
                                                                <?php echo echoOutput($item['store_title'] ?? ''); ?>
                                                            </div>
                                                            <div class="uk-text-meta">Destaque</div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="uk-container">

        <div class="uk-flex uk-flex-center uk-grid-small" uk-grid>
            <?php foreach ($letters as $char): ?>
                <a class="uk-link-text" href="#section-<?php echo echoOutput($char); ?>" uk-scroll><?php echo echoOutput($char); ?></a>
            <?php endforeach; ?>
            <a class="uk-link-text" href="#section-09" uk-scroll>0-9</a>
        </div>

        <div class="uk-margin-medium-top uk-margin-bottom">

            <?php foreach ($letters as $char): ?>
                <h3 class="uk-heading-line uk-text-bold" id="section-<?php echo echoOutput($char); ?>">
                    <span><?php echo echoOutput($char); ?></span>
                </h3>

                <div class="uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-5@m uk-child-width-1-6@l uk-grid-small" uk-grid>
                    <?php $getStores = getStoresByLetter($connect, $char); ?>
                    <?php foreach($getStores as $item): ?>

                        <?php
                            $href = (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'store'))
                                ? $urlPath->store($item['store_slug'])
                                : './store/' . rawurlencode($item['store_slug']);

                            $img = $item['store_image'] ?? '';
                            $imgUrl = ($img && isset($urlPath) && is_object($urlPath) && method_exists($urlPath,'image'))
                                ? $urlPath->image($img)
                                : $img;

                            $storeStats = function_exists('getStoreReviewStats')
                                ? getStoreReviewStats($connect, (int)($item['store_id'] ?? 0))
                                : ['rating' => null, 'total' => 0, 'recommended' => false];

                            $storeRating       = $storeStats['rating'];
                            $storeReviewsCount = $storeStats['total'];
                            $storeRecommended  = $storeStats['recommended'];

                            $storeOpenStateList = function_exists('isStoreOpenNow')
                                ? isStoreOpenNow($item['store_hours'] ?? null)
                                : null;
                        ?>

                        <div>
                            <a class="uk-text-secondary" href="<?php echo $href; ?>">
                                <img class="uk-border-rounded" src="<?php echo echoOutput($imgUrl); ?>"
                                     alt="<?php echo echoOutput($item['store_title'] ?? ''); ?>"
                                     width="50" height="50">
                                <span class="uk-text-middle uk-margin-small-left">
                                    <?php echo echoOutput($item['store_title'] ?? ''); ?>
                                </span>

                                <div class="uk-text-meta uk-margin-small-top">
                                    <?php if ($storeRating !== null): ?>
                                        <span uk-icon="star"></span>
                                        <span class="uk-margin-small-left">
                                            <?php echo number_format($storeRating, 1, ',', '.'); ?>
                                        </span>
                                        <?php if (!empty($storeReviewsCount)): ?>
                                            <span class="uk-margin-small-left">
                                                (<?php echo (int)$storeReviewsCount; ?> avaliações)
                                            </span>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <?php if (!empty($item['store_featured'])): ?>
                                        <span class="uk-label uk-label-warning uk-margin-small-left">Destaque</span>
                                    <?php endif; ?>

                                    <?php if (!empty($storeRecommended)): ?>
                                        <span class="uk-label uk-label-primary uk-margin-small-left">Indicado pelos moradores</span>
                                    <?php endif; ?>

                                    <?php if ($storeOpenStateList === true): ?>
                                        <span class="uk-label uk-label-success uk-margin-small-left">Aberto agora</span>
                                    <?php elseif ($storeOpenStateList === false): ?>
                                        <span class="uk-label uk-label-danger uk-margin-small-left">Fechado</span>
                                    <?php endif; ?>
                                </div>
                            </a>
                        </div>

                    <?php endforeach; ?>
                </div>
            <?php endforeach; ?>

            <h3 class="uk-heading-line uk-text-bold" id="section-09"><span>0-9</span></h3>
            <div class="uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-5@m uk-child-width-1-6@l uk-grid-small" uk-grid>
                <?php $getStores = getStoresByLetter($connect); ?>
                <?php foreach($getStores as $item): ?>

                    <?php
                        $href = (isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'store'))
                            ? $urlPath->store($item['store_slug'])
                            : './store/' . rawurlencode($item['store_slug']);

                        $img = $item['store_image'] ?? '';
                        $imgUrl = ($img && isset($urlPath) && is_object($urlPath) && method_exists($urlPath,'image'))
                            ? $urlPath->image($img)
                            : $img;

                        $storeStats = function_exists('getStoreReviewStats')
                            ? getStoreReviewStats($connect, (int)($item['store_id'] ?? 0))
                            : ['rating' => null, 'total' => 0, 'recommended' => false];

                        $storeRating       = $storeStats['rating'];
                        $storeReviewsCount = $storeStats['total'];
                        $storeRecommended  = $storeStats['recommended'];

                        $storeOpenStateList = function_exists('isStoreOpenNow')
                            ? isStoreOpenNow($item['store_hours'] ?? null)
                            : null;
                    ?>

                    <div>
                        <a class="uk-text-secondary" href="<?php echo $href; ?>">
                            <img class="uk-border-rounded" src="<?php echo echoOutput($imgUrl); ?>"
                                 alt="<?php echo echoOutput($item['store_title'] ?? ''); ?>"
                                 width="50" height="50">
                            <span class="uk-text-middle uk-margin-small-left">
                                <?php echo echoOutput($item['store_title'] ?? ''); ?>
                            </span>

                            <div class="uk-text-meta uk-margin-small-top">
                                <?php if ($storeRating !== null): ?>
                                    <span uk-icon="star"></span>
                                    <span class="uk-margin-small-left">
                                        <?php echo number_format($storeRating, 1, ',', '.'); ?>
                                    </span>
                                    <?php if (!empty($storeReviewsCount)): ?>
                                        <span class="uk-margin-small-left">
                                            (<?php echo (int)$storeReviewsCount; ?> avaliações)
                                        </span>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if (!empty($item['store_featured'])): ?>
                                    <span class="uk-label uk-label-warning uk-margin-small-left">Destaque</span>
                                <?php endif; ?>

                                <?php if (!empty($storeRecommended)): ?>
                                    <span class="uk-label uk-label-primary uk-margin-small-left">Indicado pelos moradores</span>
                                <?php endif; ?>

                                <?php if ($storeOpenStateList === true): ?>
                                    <span class="uk-label uk-label-success uk-margin-small-left">Aberto agora</span>
                                <?php elseif ($storeOpenStateList === false): ?>
                                    <span class="uk-label uk-label-danger uk-margin-small-left">Fechado</span>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>

                <?php endforeach; ?>
            </div>

        </div><!-- /uk-margin-medium-top -->
    </div><!-- /uk-container -->

</div><!-- /nd-stores-page -->
