<?php
/* nd-card clean build — Search/Home unified card
 * Returns string (ob buffer). Use: echo nd_render_deal_card($item, $urlPath, $translation);
 */

if (!function_exists('nd_get')) {
  function nd_get($src, $key) {
    if (is_array($src)) return array_key_exists($key,$src) ? $src[$key] : null;
    if (is_object($src)) {
      if (isset($src->$key)) return $src->$key;
      if ($src instanceof ArrayAccess && isset($src[$key])) return $src[$key];
      $m = 'get' . str_replace(' ', '', ucwords(str_replace(['_','-'], ' ', $key)));
      if (method_exists($src,$m)) { try { return $src->$m(); } catch (Throwable $e) {} }
      if (method_exists($src,$key)) { try { return $src->$key(); } catch (Throwable $e) {} }
    }
    return null;
  }
}
if (!function_exists('nd_pick')) {
  function nd_pick($item, $keys, $fallback=null) {
    foreach ($keys as $k) { $v = nd_get($item,$k); if ($v!==null && $v!=='') return $v; }
    return $fallback;
  }
}
if (!function_exists('nd_plain_text')) {
  function nd_plain_text($html){
    $s = strip_tags((string)$html);
    $s = html_entity_decode($s, ENT_QUOTES, 'UTF-8');
    $s = preg_replace('/\s+/u',' ', trim($s));
    return $s;
  }
}
if (!function_exists('nd_clean_text')) {
  function nd_clean_text($s,$max=120){ $s=trim((string)$s); if ($s==='' ) return ''; $s=str_replace(["
","
"],' ',$s); if (mb_strlen($s)>$max) $s=mb_substr($s,0,$max-1).'…'; return $s; }
}
if (!function_exists('nd_card_money')) {
  function nd_card_money($v){ if ($v===null||$v==='') return ''; return 'R$ '.number_format((float)$v,2,',','.'); }
}
if (!function_exists('nd_card_discount')) {
  function nd_card_discount($price,$old,$declared=null){
    $p=floatval($price); $o=floatval($old);
    if ($declared!==null && $declared!=='') return (int)$declared;
    if ($p>0&&$o>0&&$o>$p) return (int)round(100-($p*100/$o));
    return null;
  }
}
if (!function_exists('nd_coerce_base')) {
  function nd_coerce_base($urlPath){
    if (is_object($urlPath) && method_exists($urlPath,'deals')) return rtrim($urlPath->deals(),'/');
    return '';
  }
}
if (!function_exists('nd_card_img')) {
  function nd_card_img($item,$urlPath=null){
    $img = nd_pick($item,['deal_image','image','img','photo','thumb']);
    if (!$img) return '/assets/img/placeholder.svg';
    $img = trim((string)$img);
    if (preg_match('~^(https?:)?//~',$img)) return $img;
    if ($img[0] !== '/') {
      if (strpos($img,'/') === false) return '/images/'.$img;
      return '/'.$img;
    }
    return $img;
  }
}
if (!function_exists('nd_parse_date')) {
  function nd_parse_date($v){
    if (!$v) return null;
    try {
      if ($v instanceof DateTime) return $v;
      $ts = is_numeric($v) ? (int)$v : strtotime((string)$v);
      if (!$ts) return null;
      $d = new DateTime('@'.$ts); $d->setTimezone(new DateTimeZone(date_default_timezone_get()));
      return $d;
    } catch (Throwable $e){ return null; }
  }
}
if (!function_exists('nd_seconds_left')) {
  function nd_seconds_left($item){
    $exp = nd_pick($item,['expires_at','deal_expire','expire_at','expires','valid_until','ends_at']);
    $d = nd_parse_date($exp);
    if (!$d) return 0;
    $now = new DateTime('now');
    return max(0, $d->getTimestamp() - $now->getTimestamp());
  }
}
if (!function_exists('nd_is_new')) {
  function nd_is_new($item,$days=7){
    $keys=['created_at','deal_created','created','date','published_at','updated_at'];
    foreach($keys as $k){ $d=nd_parse_date(nd_get($item,$k)); if($d){ $now=new DateTime('now'); if(($now->getTimestamp()-$d->getTimestamp())<=($days*86400)) return true; } }
    return false;
  }
}

/** Render card (returns string) */
if (!function_exists('nd_render_deal_card')) {
  function nd_render_deal_card($item, $urlPath=null, $translation=array()) {
    // data
    $titleRaw    = nd_pick($item,['deal_title','title','name']);
    $subtitleRaw = nd_pick($item,['deal_description','subtitle','short_description','description']);
    $subtitleRaw = nd_plain_text($subtitleRaw);
    $title    = nd_clean_text($titleRaw, 90);
    $subtitle = nd_clean_text($subtitleRaw, 140);

    $catName   = nd_pick($item,['category_name','cat_name','category','categoria','category_title','cat_title']);
    $storeName = nd_pick($item,['store_title','store_name','store']);
    $exclusive = (bool) nd_pick($item,['is_exclusive','exclusive','deal_exclusive','vip'], false);

    $price     = nd_pick($item,['deal_price','price','valor','preco'], null);
    $oldPreço  = nd_pick($item,['deal_old_price','deal_oldprice','oldprice','old_price','preco_antigo','compare_at','compare_at_price'], null);
    $declared  = nd_pick($item,['deal_discount','discount','desconto'], null);
    $discount  = nd_card_discount($price,$oldPreço,$declared);

    $rating    = (float) nd_pick($item,['rating','avg_rating','stars'], 0);
    $reviews   = (int)   nd_pick($item,['total_reviews','reviews','votes','review_count'], 0);

    $timeLeft  = nd_seconds_left($item);
// ND PATCH: use global helper
    $href = nd_deal_link($item, $urlPath);
    // end of patch

    $img = nd_card_img($item,$urlPath);

    // i18n
    $tReviews = $translation['HOME_REVIEWS'] ?? 'avaliações';

    ob_start(); ?>
<a class="nd-card" href="<?php echo htmlspecialchars($href); ?>">
  <div class="nd-card__media">
    <?php $imgSrc = htmlspecialchars($img); ?>
    <img class="nd-card__img card-img deal-img" src="<?= $imgSrc ?>" loading="lazy" alt="<?php echo htmlspecialchars($title); ?>">

    <?php if ($catName): ?>
      <span class="nd-badge nd-badge--left"><?php echo htmlspecialchars($catName); ?></span>
    <?php endif; ?>

    <?php if ($exclusive): ?>
      <span class="nd-badge nd-badge--right">★ Exclusivo</span>
    <?php endif; ?>

    <?php if (nd_is_new($item,7)): ?>
      <span class="nd-badge nd-badge--new">Novo</span>
    <?php endif; ?>

    <?php if ($timeLeft>0): ?>
      <span class="nd-ribbon"><span class="time">
        <?php
          $h = floor($timeLeft/3600); $m = floor(($timeLeft%3600)/60); $d = floor($h/24); $h = $h%24;
          if ($d>0) { echo 'Restam '.$d.' d '.$h.' h'; }
          else { echo 'Restam '.$h.' h '.$m.' min'; }
        ?>
      </span></span>
    <?php endif; ?>
  </div>

  <div class="nd-card__body">
    <?php if ($title): ?><h3 class="nd-card__title"><?php echo htmlspecialchars($title); ?></h3><?php endif; ?>
    <?php if ($subtitle): ?><p class="nd-card__subtitle"><?php echo htmlspecialchars($subtitle); ?></p><?php endif; ?>

    <?php $sr = max(0, min(5, (int)round($rating))); $stars = str_repeat('★',$sr).str_repeat('☆',5-$sr); ?>
    <div class="nd-card__rating"><span class="nd-stars"><?php echo $stars; ?></span><span class="nd-reviews">(<?php echo (int)$reviews; ?> <?php echo $tReviews; ?>)</span></div>

    <div class="nd-card__price">
      <?php if ($oldPreço!==null && $oldPreço!==''): ?><span class="nd-price-old"><?php echo nd_card_money($oldPreço); ?></span><?php endif; ?>
      <?php if ($price!==null && $price!==''): ?><span class="nd-price-new"><?php echo nd_card_money($price); ?></span><?php endif; ?>
      <?php if ($discount!==null): ?><span class="nd-discount-pill"><?php echo (int)$discount; ?>% Off</span><?php endif; ?>
    </div>
  </div>
</a>
<?php
    return ob_get_clean();
  }
}
?>