<?php
// partials/cat-i18n.php — helper único para rótulos de categorias i18n

if (!function_exists('cat_label_i18n')) {
  function cat_label_i18n(string $slug, string $fallback = ''): string {
    $s = trim(mb_strtolower($slug));

    static $MAP = [
      // slugs nativos (pt) + traduções
      'comida-e-bebida'    => ['pt-br'=>'Comida & Bebida','en'=>'Food & Drink','es'=>'Comida y Bebida'],
      'hoteis-e-viagens'   => ['pt-br'=>'Hotéis & Viagens','en'=>'Hotels & Travel','es'=>'Hoteles y Viajes'],
      'coisas-para-fazer'  => ['pt-br'=>'Coisas para fazer','en'=>'Things to do','es'=>'Cosas para hacer'],
      'entretenimento'     => ['pt-br'=>'Entretenimento','en'=>'Entertainment','es'=>'Entretenimiento'],
      'beleza-spas'        => ['pt-br'=>'Beleza & Spas','en'=>'Beauty & Spas','es'=>'Belleza & Spas'],
      'saude-fitness'      => ['pt-br'=>'Saúde & Fitness','en'=>'Health & Fitness','es'=>'Salud & Fitness'],
      'varejo'             => ['pt-br'=>'Varejo','en'=>'Retail','es'=>'Venta minorista'],
      'automotivo'         => ['pt-br'=>'Automotivo','en'=>'Automotive','es'=>'Automotriz'],

      // slugs que estavam faltando
      'servicos-domesticos'=> ['pt-br'=>'Serviços Domésticos','en'=>'Home Services','es'=>'Servicios domésticos'],
      'aprendizagem-online'=> ['pt-br'=>'Aprendizagem on-line','en'=>'Online Learning','es'=>'Aprendizaje en línea'],
      'aprendizagem-on-line'=>['pt-br'=>'Aprendizagem on-line','en'=>'Online Learning','es'=>'Aprendizaje en línea'],
      'bebe-criancas'      => ['pt-br'=>'Bebê & Crianças','en'=>'Baby & Kids','es'=>'Bebé y niños'],
      'bebe-e-criancas'    => ['pt-br'=>'Bebê & Crianças','en'=>'Baby & Kids','es'=>'Bebé y niños'],
      'eletronicos'        => ['pt-br'=>'Eletrônicos','en'=>'Electronics','es'=>'Electrónica'],

      // equivalentes que às vezes vêm em EN
      'food-drink'         => ['pt-br'=>'Comida & Bebida','en'=>'Food & Drink','es'=>'Comida y Bebida'],
      'hotels-travel'      => ['pt-br'=>'Hotéis & Viagens','en'=>'Hotels & Travel','es'=>'Hoteles y Viajes'],
      'things-to-do'       => ['pt-br'=>'Coisas para fazer','en'=>'Things to do','es'=>'Cosas para hacer'],
      'entertainment'      => ['pt-br'=>'Entretenimento','en'=>'Entertainment','es'=>'Entretenimiento'],
      'beauty-spas'        => ['pt-br'=>'Beleza & Spas','en'=>'Beauty & Spas','es'=>'Belleza & Spas'],
      'health-fitness'     => ['pt-br'=>'Saúde & Fitness','en'=>'Health & Fitness','es'=>'Salud & Fitness'],
      'retail'             => ['pt-br'=>'Varejo','en'=>'Retail','es'=>'Venta minorista'],
      'automotive'         => ['pt-br'=>'Automotivo','en'=>'Automotive','es'=>'Automotriz'],
      'home-services'      => ['pt-br'=>'Serviços Domésticos','en'=>'Home Services','es'=>'Servicios domésticos'],
      'online-learning'    => ['pt-br'=>'Aprendizagem on-line','en'=>'Online Learning','es'=>'Aprendizaje en línea'],
      'baby-kids'          => ['pt-br'=>'Bebê & Crianças','en'=>'Baby & Kids','es'=>'Bebé y niños'],
      'electronics'        => ['pt-br'=>'Eletrônicos','en'=>'Electronics','es'=>'Electrónica'],
    ];

    if (session_status() === PHP_SESSION_NONE) { @session_start(); }
    $lang = isset($_SESSION['lang']) ? strtolower($_SESSION['lang']) : 'en';
    $lang = in_array($lang, ['pt-br','en','es'], true) ? $lang : 'en';

    if ($s && isset($MAP[$s][$lang])) {
      return $MAP[$s][$lang];
    }

    if ($fallback !== '') return $fallback;
    return $s ? ucwords(str_replace(['-','_'],' ', $s)) : '';
  }
}
