<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
$lang = isset($_SESSION['lang']) ? strtolower($_SESSION['lang']) : 'pt-br';
if ($lang === 'pt') $lang = 'pt-br';
if (!in_array($lang, ['pt-br','es','en'])) $lang = 'en';
?>
<script>
(function(){
  "use strict";
  if (window.__CAT_I18N_V4_INSTALLED__) return;
  window.__CAT_I18N_V4_INSTALLED__ = true;

  var LANG = <?php echo json_encode($lang, JSON_UNESCAPED_UNICODE); ?>;

  // ===== dicionários =====
  var CATS = {
    "Destaque Categories": { "pt-br":"Categorias em Destaque", "es":"Categorías destacadas", "en":"Destaque Categories" },
    "Food & Drink":        { "pt-br":"Comida & Bebida",        "es":"Comida y bebida",      "en":"Food & Drink" },
    "Hotels & Travel":     { "pt-br":"Hotéis & Viagens",       "es":"Hoteles y viajes",     "en":"Hotels & Travel" },
    "Entertainment":       { "pt-br":"Entretenimento",         "es":"Entretenimiento",      "en":"Entertainment" },
    "Things to do":        { "pt-br":"Coisas para fazer",      "es":"Cosas para hacer",     "en":"Things to do" },
    "Beauty & Spas":       { "pt-br":"Beleza & Spas",          "es":"Belleza y spas",       "en":"Beauty & Spas" },
    "Health & Fitness":    { "pt-br":"Saúde & Fitness",        "es":"Salud y fitness",      "en":"Health & Fitness" },
    "Retail":              { "pt-br":"Varejo",                 "es":"Venta minorista",      "en":"Retail" },
    "Automotive":          { "pt-br":"Automotivo",             "es":"Automotriz",           "en":"Automotive" },
    "Baby & Kids":         { "pt-br":"Bebê & Crianças",        "es":"Bebé y niños",         "en":"Baby & Kids" },
    "Electronics":         { "pt-br":"Eletrônicos",            "es":"Electrónica",          "en":"Electronics" },
    "View All":            { "pt-br":"Ver tudo",               "es":"Ver todo",             "en":"View All" }
  };
  var SUBS = CATS; // subcategorias usam o mesmo mapa

  function norm(s){ return (s||"").replace(/\u00A0/g," ").replace(/\s+/g," ").trim(); }
  function lookup(t){
    var key = Object.keys(CATS).find(k => k.toLowerCase()===t.toLowerCase());
    return key ? CATS[key][LANG] : null;
  }

  function setTextNode(el, target){
    // só altera quando necessário para reduzir mutações
    for (var i=0;i<el.childNodes.length;i++){
      var n = el.childNodes[i];
      if (n.nodeType===Node.TEXT_NODE){
        var cur = norm(n.nodeValue);
        var rep = lookup(cur);
        if (rep && rep !== cur) { n.nodeValue = " "+rep+" "; el.setAttribute('data-i18n-cat','1'); }
      }
    }
    // fallback curto
    var curTxt = norm(el.innerText||"");
    var rep2 = lookup(curTxt);
    if (rep2 && rep2 !== curTxt && curTxt.length<=40){
      el.innerText = rep2;
      el.setAttribute('data-i18n-cat','1');
    }
  }

  function translateBlock(block){
    if (!block || block.getAttribute('data-i18n-cat-block')==='1') return;
    block.setAttribute('data-i18n-cat-block','1');

    // título
    var h = block.querySelector('h1,h2,h3,h4');
    if (h) setTextNode(h);

    // botão View All
    block.querySelectorAll('a,button,input[type=button],input[type=submit]').forEach(function(el){
      var t = norm(el.innerText || el.value || "");
      if (/^view\s*all$/i.test(t)) {
        var rep = CATS["View All"][LANG];
        if ('value' in el && el.type && /^submit|button$/i.test(el.type)) { if (el.value!==rep) el.value = rep; }
        else if (el.innerText!==rep) { el.innerText = rep; }
        el.setAttribute('data-i18n-cat','1');
      }
    });

    // rótulos/legendas — apenas elementos curtos e ainda não marcados
    block.querySelectorAll('.uk-text-truncate, .tas-cat-card, .uk-card, a, span, div')
      .forEach(function(el){
        if (el.getAttribute('data-i18n-cat')==='1') return;
        var t = norm(el.innerText||"");
        if (!t || t.length>40) return;
        if (lookup(t)) setTextNode(el);
      });
  }

  function findBlock(){
    // procura seção com heading do bloco
    var blocks = Array.from(document.querySelectorAll('section,div'));
    for (var b of blocks){
      var h = b.querySelector('h1,h2,h3,h4');
      if (!h) continue;
      var ht = norm(h.textContent);
      if (/^(featured\s+categories|categorias\s+em\s+destaque|categorías\s+destacadas)$/i.test(ht)) {
        return b;
      }
    }
    return null;
  }

  var observer = null;
  var pending = false;
  var stopAt = Date.now() + 15000; // 15s de janela de “auto-heal”

  function run(){
    if (pending) return;
    pending = true;
    requestAnimationFrame(function(){
      pending = false;
      if (observer) observer.disconnect(); // evita “loop”
      try {
        var block = findBlock();
        if (block) translateBlock(block);
      } finally {
        if (Date.now() < stopAt) observer.observe(document.body,{childList:true,subtree:true});
      }
    });
  }

  // kickoff
  if (document.readyState==='loading'){
    document.addEventListener('DOMContentLoaded', function(){
      run(); setTimeout(run,200); setTimeout(run,800);
    });
  } else {
    run(); setTimeout(run,200); setTimeout(run,800);
  }

  // observer com debounce
  observer = new MutationObserver(function(muts){
    // só reage a adições
    for (var m of muts){ if (m.addedNodes && m.addedNodes.length){ run(); break; } }
  });
  observer.observe(document.body,{childList:true,subtree:true});

  // hard-stop do observer após 15s
  setTimeout(function(){ if (observer) observer.disconnect(); }, 16000);
})();
</script>
