<?php
/**
 * partials/filters-cats-i18n.php
 *
 * Renderização dos Filtros (Categorias + Subcategorias) no mesmo
 * HTML esperado pelo tema (uk-nav, uk-parent, uk-nav-sub etc.),
 * mas com rótulos traduzidos em PT/EN/ES no lado do servidor.
 */

@include_once __DIR__ . '/cat-i18n.php';
@include_once __DIR__ . '/subcat-i18n.php';

// Fonte de dados (fallback seguro)
if (!isset($menuCategories) || !is_array($menuCategories)) {
  if (isset($connect)) {
    try { $menuCategories = getMenuCategories($connect); } catch (\Exception $e) { $menuCategories = []; }
  } else {
    $menuCategories = [];
  }
}

if (empty($menuCategories)) { return; }
?>

<div class="widget">
  <h4 class="widget_heading"></h4>

  <?php foreach ($menuCategories as $cat): ?>
    <?php
      $slug   = $cat['category_slug']  ?? '';
      $title  = $cat['category_title'] ?? '';
      $subs   = $cat['subcategories']  ?? [];
      $label  = cat_label_i18n($slug, $title);
    ?>
    <ul class="uk-nav-default filterCategory uk-nav-parent-icon uk-nav" uk-nav>
      <li class="uk-parent">
        <!-- IMPORTANTE: manter o <span data-value> porque o JS do tema usa -->
        <a class="uk-text-secondary uk-text-capitalize" data-current="">
          <span data-value="<?php echo htmlspecialchars($slug, ENT_QUOTES, 'UTF-8'); ?>">
            <?php echo echoOutput($label); ?>
          </span>
        </a>

        <?php if (is_array($subs) && !empty($subs)): ?>
          <ul class="uk-nav-sub filterSubCategory">
            <?php foreach ($subs as $sub): ?>
              <?php
                $subSlug  = $sub['subcategory_slug']  ?? ($sub['slug'] ?? '');
                $subTitle = $sub['subcategory_title'] ?? ($sub['title'] ?? '');
                if (!$subSlug) {
                  // fallback: slug a partir do título
                  $subSlug = strtolower(preg_replace('/[^a-z0-9]+/i', '-', $subTitle));
                }
              ?>
              <?php if ($subTitle !== ''): ?>
                <li>
                  <!-- O JS do tema usa data-value; não usar href aqui -->
                  <a data-value="<?php echo htmlspecialchars($subSlug, ENT_QUOTES, 'UTF-8'); ?>">
                    <?php echo echoOutput(sub_label_i18n($subTitle)); ?>
                  </a>
                </li>
              <?php endif; ?>
            <?php endforeach; ?>
          </ul>
        <?php endif; ?>
      </li>
    </ul>
  <?php endforeach; ?>
</div>

<style>
/* Aparência mais estável (sem quebrar em uma coluna estreita) */
.sidebar .widget .uk-nav a,
.tas-search-sidebar .uk-nav a {
  color: #111;
  white-space: normal;
  line-height: 1.35;
}

.sidebar .widget .uk-nav > li > a { font-weight: 600; }
.sidebar .widget .uk-nav-sub a { font-weight: 400; }

.sidebar .widget .uk-nav { margin-bottom: 8px; }
.sidebar .widget .uk-nav-sub { margin-top: 6px; }

@media (min-width: 960px) { /* igual breakpoint @m do UIkit */
  .sidebar { max-width: 260px; }
}
</style>
