<?php
/* Remove spans vazios, chips “EN/PT/ES” e separadores residuais (|, ·, •, –) ao final do título */
?>
<script>
(function(){
  function isChipText(s){ return /^(EN|PT|ES)$/i.test(s.trim()); }
  function stripTailArtifacts(txt){
    return txt.replace(/[|\u00B7\u2022\u2013\u2014]+$/g, '').replace(/\s+$/,'').trim();
  }
  function cleanHeading(h){
    // remover spans vazios e chips
    h.querySelectorAll('span, i').forEach(function(el){
      var t = (el.innerText || el.textContent || '').trim();
      if (!t || isChipText(t) || /badge/i.test(el.className||'') || /lang-chip/i.test(el.className||'')) {
        el.remove();
      }
    });
    // limpar caractere-resíduo no final
    var t = (h.innerText || h.textContent || '').replace(/\u00A0/g,' ');
    t = stripTailArtifacts(t);
    // seta apenas o texto, preservando classes do heading
    // (mantém os spans “bons” como wrappers do tema)
    if (h.firstChild && h.firstChild.nodeType === Node.TEXT_NODE) {
      h.firstChild.nodeValue = t + ' ';
    } else {
      // injeta texto simples se não houver text node
      h.insertBefore(document.createTextNode(t + ' '), h.firstChild);
    }
  }
  function run(){
    document.querySelectorAll('h1,h2,h3').forEach(cleanHeading);
  }
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', function(){ run(); setTimeout(run,250); setTimeout(run,1000); });
  } else {
    run(); setTimeout(run,250); setTimeout(run,1000);
  }
  new MutationObserver(function(){ run(); })
    .observe(document.body, {subtree:true, childList:true, characterData:true});
})();
</script>
