<?php
// partials/home-headings-force.php — força os títulos das seções da home
if (session_status() === PHP_SESSION_NONE) { session_start(); }
$lang = isset($_SESSION['lang']) ? strtolower($_SESSION['lang']) : 'en';
if (!isset($translation) || !is_array($translation)) $translation = [];

function _t($k, $en, $pt, $es) {
  global $translation, $lang;
  if (!empty($translation[$k])) return $translation[$k];
  if ($lang === 'pt-br') return $pt;
  if ($lang === 'es') return $es;
  return $en;
}

$MAP = [
  _t('HOME_EXCLUSIVE_DEALS','Exclusive Deals','Ofertas Exclusivas','Ofertas Exclusivas'),
  _t('HOME_FEATURED_DEALS','Destaque Deals','Ofertas em Destaque','Ofertas Destacadas'),
  _t('HOME_FEATURED_CATEGORIES','Destaque Categories','Categorias em Destaque','Categorías Destacadas'),
  _t('HOME_LATEST_DEALS','Latest Deals','Últimas Ofertas','Últimas Ofertas'),
  _t('HOME_FEATURED_STORES','Destaque Stores','Lojas em Destaque','Tiendas Destacadas'),
  _t('HOME_FEATURED_LOCATIONS','Destaque Locations','Locais em Destaque','Ubicaciones Destacadas'),
  _t('HOME_PLANS','Pricing','Planos','Precios'),
];
?>
<script>
(function(){
  // Pega blocos de seção que têm o botão "View All" / "Ver tudo"
  var btnLabel = /^(ver\s+tudo|view\s+all|ver\s+todo)$/i;
  function isEmptyTitle(el){
    if (!el) return true;
    var t = (el.textContent||'').replace(/\u00A0/g,' ').trim();
    return t.length < 2; // vazio ou só um badge perdido
  }
  function setText(el, txt){
    // preserva ícones/spans e altera só o text node
    var done=false;
    for (var i=0;i<el.childNodes.length;i++){
      var n = el.childNodes[i];
      if (n.nodeType===Node.TEXT_NODE){ n.nodeValue = ' ' + txt + ' '; done=true; break; }
    }
    if (!done) el.appendChild(document.createTextNode(' ' + txt));
  }

  var sections = [];
  document.querySelectorAll('a,button').forEach(function(b){
    var t = (b.innerText||b.textContent||'').trim();
    if (btnLabel.test(t)) {
      // tenta achar um h1..h4 no mesmo bloco/linha
      var h = b.closest('div,section,header,li,ul')?.querySelector('h1,h2,h3,h4');
      if (!h) {
        // sobe um nível
        var up = b.parentElement?.parentElement;
        if (up) h = up.querySelector('h1,h2,h3,h4');
      }
      if (h) sections.push(h);
    }
  });

  // Remove badges pequenos tipo "EN"/"PT"/"ES"
  sections.forEach(function(h){
    h.querySelectorAll('span').forEach(function(sp){
      var st = (sp.innerText||sp.textContent||'').trim();
      if (/^(EN|PT|ES)$/i.test(st) || /\bbadge\b/i.test(sp.className||'')) sp.remove();
    });
  });

  var MAP = <?php echo json_encode($MAP, JSON_UNESCAPED_UNICODE); ?>;
  var idx = 0;
  sections.forEach(function(h){
    if (idx < MAP.length && isEmptyTitle(h)) {
      setText(h, MAP[idx]);
      idx++;
    }
  });
})();
</script>
