<?php
// partials/home-headings-i18n.php  (FIX)
// Traduz os títulos das seções da HOME e o botão "View All" sem tocar em listas de categorias.

if (session_status() === PHP_SESSION_NONE) { session_start(); }
$lang = isset($_SESSION['lang']) ? strtolower($_SESSION['lang']) : 'en';
if (!isset($translation) || !is_array($translation)) $translation = [];

function _h_tr($key, $fallbacks) {
  global $translation, $lang;
  if (isset($translation[$key]) && is_string($translation[$key]) && $translation[$key] !== '') return $translation[$key];
  $l = in_array($lang, ['pt-br','es','en']) ? $lang : 'en';
  return isset($fallbacks[$l]) ? $fallbacks[$l] : $fallbacks['en'];
}

$L = [
  'EXCLUSIVE_DEALS'     => _h_tr('HOME_EXCLUSIVE_DEALS',     ['pt-br'=>'Ofertas Exclusivas','es'=>'Ofertas Exclusivas','en'=>'Exclusive Deals']),
  'FEATURED_DEALS'      => _h_tr('HOME_FEATURED_DEALS',      ['pt-br'=>'Ofertas em Destaque','es'=>'Ofertas Destacadas','en'=>'Destaque Deals']),
  'FEATURED_CATEGORIES' => _h_tr('HOME_FEATURED_CATEGORIES', ['pt-br'=>'Categorias em Destaque','es'=>'Categorías Destacadas','en'=>'Destaque Categories']),
  'LATEST_DEALS'        => _h_tr('HOME_LATEST_DEALS',        ['pt-br'=>'Últimas Ofertas','es'=>'Últimas Ofertas','en'=>'Latest Deals']),
  'FEATURED_STORES'     => _h_tr('HOME_FEATURED_STORES',     ['pt-br'=>'Lojas em Destaque','es'=>'Tiendas Destacadas','en'=>'Destaque Stores']),
  'FEATURED_LOCATIONS'  => _h_tr('HOME_FEATURED_LOCATIONS',  ['pt-br'=>'Locais em Destaque','es'=>'Ubicaciones Destacadas','en'=>'Destaque Locations']),
  'PLANS'               => _h_tr('HOME_PLANS',               ['pt-br'=>'Planos','es'=>'Precios','en'=>'Pricing']),
  'CATEGORIES'          => _h_tr('HOME_CATEGORIES',          ['pt-br'=>'Categorias','es'=>'Categorías','en'=>'Categories']),
  'VIEW_ALL'            => _h_tr('BTN_VIEW_ALL',             ['pt-br'=>'Ver tudo','es'=>'Ver todo','en'=>'View All']),
];
?>
<script>
(function(){
  // heurística leve para rodar só na home
  var hints = ['exclusive deals','featured','latest deals','categories','stores','locations','pricing'];
  var pageText = (document.body.innerText || '').toLowerCase();
  var hit = hints.some(function(h){ return pageText.indexOf(h) !== -1; });
  if (!hit) return;

  var L = <?php echo json_encode($L, JSON_UNESCAPED_UNICODE); ?>;

  var RX = [
    {re:/^\s*Exclusive\s+Deals\s*$/i,            key:'EXCLUSIVE_DEALS'},
    {re:/^\s*Destaque\s+Deals\s*$/i,             key:'FEATURED_DEALS'},
    {re:/^\s*Destaque\s+Categories\s*$/i,        key:'FEATURED_CATEGORIES'},
    {re:/^\s*Latest\s+Deals\s*$/i,               key:'LATEST_DEALS'},
    {re:/^\s*Destaque\s+Stores\s*$/i,            key:'FEATURED_STORES'},
    {re:/^\s*Destaque\s+Locations\s*$/i,         key:'FEATURED_LOCATIONS'},
    {re:/^\s*Pricing\s*$/i,                      key:'PLANS'},
    {re:/^\s*Categories\s*$/i,                   key:'CATEGORIES'}
  ];

  function norm(s){ return (s||'').replace(/\u00A0/g,' ').replace(/\s+/g,' ').trim(); }

  function setText(el, text){
    for (var i=0;i<el.childNodes.length;i++){
      var n = el.childNodes[i];
      if (n.nodeType === Node.TEXT_NODE){ n.nodeValue = ' ' + text + ' '; return; }
    }
    el.appendChild(document.createTextNode(' ' + text));
  }

  function translateHeadings(root){
    root = root || document;
    var headings = root.querySelectorAll('h1,h2,h3,h4,h5,h6,.uk-heading,.uk-h1,.uk-h2,.uk-h3,.uk-h4');
    headings.forEach(function(el){
      var t = norm(el.innerText || el.textContent || '');
      if (t.split(' ').length > 5) return;
      for (var i=0;i<RX.length;i++){
        if (RX[i].re.test(t)){ setText(el, L[RX[i].key]); break; }
      }
    });
  }

  function translateViewAll(root){
    root = root || document;
    var btns = root.querySelectorAll('a,button');
    btns.forEach(function(el){
      var t = norm(el.innerText || el.textContent || '');
      if (/^view\s+all$/i.test(t)) setText(el, L.VIEW_ALL);
    });
  }

  function run(doc){
    translateHeadings(doc);
    translateViewAll(doc);
  }

  if (document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', function(){ run(document); setTimeout(run,200); setTimeout(run,800); });
  } else {
    run(document);
    setTimeout(run,200); setTimeout(run,800);
  }
  new MutationObserver(function(){ run(document); }).observe(document.body, {childList:true, subtree:true});
})();
</script>
