<?php
if (defined('ND_LANGSWITCH_ALREADY_INCLUDED')) { return; }
define('ND_LANGSWITCH_ALREADY_INCLUDED', true);
// ND Mídia — Unified Language Switch (neutro + compat com dashboard)
?>
<style>
  /* Estilo NEUTRO (sem posição). O flutuante só ativa com .is-floating */
  #langSwitchRoot { display:inline-flex; gap:6px; align-items:center;
                    font: 12px/1.4 system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif }
  #langSwitchRoot a, #langSwitchRoot button{
    display:inline-flex; align-items:center; gap:6px;
    margin-left:0; padding:4px 8px; border-radius:999px;
    border:1px solid #e3e3e3; background:#fff; text-decoration:none; color:#333; cursor:pointer
  }
  #langSwitchRoot .active { font-weight:600; }
  #langSwitchRoot img { width:18px; height:12px; object-fit:cover; border-radius:2px }

  /* Modo flutuante opcional (para páginas públicas). O script remove no dashboard. */
  #langSwitchRoot.is-floating{
    position:fixed;
    top:6px;
    right:12px;
    z-index:9999;
  }

  /* Mobile / tablets pequenos */
  @media (max-width:768px){
    #langSwitchRoot.is-floating{
      top:6px;
      right:8px;
    }
    #langSwitchRoot a, #langSwitchRoot button{ padding:3px 6px; font-size:11px }
  }

  /* Google translate escondido */
  #google_translate_element { position:absolute; left:-9999px; width:1px; height:1px; overflow:hidden }
  .goog-te-banner-frame { display:none !important }
  body { top:0 !important }
</style>

<!--
  data-floating deixa flutuante no site público.
  No dashboard, o script detecta #langInline e remove o floating.
-->
<div id="langSwitchRoot" class="lang-switch is-floating" data-floating aria-label="Selecionar idioma">
  <a href="#" data-lang="pt" class="active"><img src="https://flagcdn.com/w20/br.png" alt="PT">PT</a>
  <a href="#" data-lang="en"><img src="https://flagcdn.com/w20/us.png" alt="EN">EN</a>
  <a href="#" data-lang="es"><img src="https://flagcdn.com/w20/es.png" alt="ES">ES</a>
</div>
<div id="google_translate_element" aria-hidden="true"></div>

<script>
(function(){
  // Helpers de cookie para Google Translate
  function rootDomain(host){
    var p = (host||'').split('.');
    if (p.length>=3) return '.'+p.slice(-3).join('.');
    if (p.length>=2) return '.'+p.slice(-2).join('.');
    return host||'';
  }
  function setCookie(name, value, domain){
    var exp = new Date(Date.now()+31536e6).toUTCString(); // 1 ano
    var secure = location.protocol==='https:'?'; secure':'';
    document.cookie = name+'='+encodeURIComponent(value)+'; expires='+exp+'; path=/'+secure;
    if (domain) document.cookie = name+'='+encodeURIComponent(value)+'; expires='+exp+'; path=/; domain='+domain+secure;
  }
  function getCookie(name){
    return ('; '+document.cookie).split('; '+name+'=').pop().split(';').shift();
  }

  // Marca idioma ativo
  function markActive(){
    try{
      var val = decodeURIComponent(getCookie('googtrans')||'').trim();
      var cur = (val.match(/\/pt\/(\w+)/)||[])[1] || 'pt';
      document.querySelectorAll('#langSwitchRoot [data-lang]').forEach(function(a){
        a.classList.toggle('active', a.getAttribute('data-lang')===cur);
      });
    }catch(e){}
  }

  // Click para trocar idioma
  function bindClicks(){
    if (window.__nd_lang_bound__) return; // evita bind duplicado
    document.addEventListener('click', function(e){
      var a = e.target.closest('#langSwitchRoot [data-lang]');
      if (!a) return;
      e.preventDefault();
      var lang = a.getAttribute('data-lang') || 'pt';
      var v = '/pt/' + lang;
      var rd = rootDomain(location.hostname);
      setCookie('googtrans', v);
      setCookie('googtrans', v, rd);
      setCookie('googtrans', v, '.'+location.hostname.replace(/^www\./,''));
      location.reload();
    });
    window.__nd_lang_bound__ = true;
  }

  // Carrega Google Translate uma vez
  function ensureGT(){
    if (window.__nd_gt_loaded__) { markActive(); return; }
    window.googleTranslateElementInit = function(){
      try{
        new google.translate.TranslateElement({
          pageLanguage: 'pt',
          includedLanguages: 'pt,en,es',
          autoDisplay: false,
          layout: google.translate.TranslateElement.InlineLayout.SIMPLE
        }, 'google_translate_element');
      }catch(e){}
      markActive();
    };
    var s = document.createElement('script');
    s.src = 'https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit';
    s.async = true;
    document.head.appendChild(s);
    window.__nd_gt_loaded__ = true;
  }

  // Se existir #langInline (dashboard), move para lá e remove modo flutuante
  function moveIntoDashboard(){
    var host = document.getElementById('langInline');
    var box  = document.getElementById('langSwitchRoot');
    if (!box) return;
    if (host) {
      host.innerHTML = '';
      host.appendChild(box);
      box.classList.remove('is-floating');    // remove posição fixa
      box.removeAttribute('style');           // limpa estilos inline se houver
      // limpa posições de filhos
      box.querySelectorAll('*').forEach(function(n){
        if (n.style){
          if (n.style.position === 'fixed' || n.style.position === 'absolute') n.style.position = '';
          if (n.style.right) n.style.right = '';
          if (n.style.top)   n.style.top   = '';
        }
      });
    }
  }

  // Boot
  bindClicks();
  ensureGT();
  markActive();
  // tenta mover agora e após o load (garante que #langInline já exista)
  moveIntoDashboard();
  window.addEventListener('load', moveIntoDashboard);
})();
</script>
