<?php
// partials/nav-i18n.php  (v4 C server-side, sem JS)

if (!isset($translation) || !is_array($translation)) { $translation = []; }

/**
 * Mapa de rotas "can00nicas" -> rtulo traduzido.
 * Se a navega0400o do banco apontar para estas rotas, o label  sobrescrito.
 */
$navMap = [
  '/'            => $translation['NAV_HOME']        ?? 'Home',
  '/search'      => $translation['NAV_SEARCH']      ?? 'Search',
  '/categories'  => $translation['NAV_CATEGORIES']  ?? 'Categories',
  '/locations'   => $translation['NAV_LOCATIONS']   ?? 'Locations',
  '/stores'      => $translation['NAV_STORES']      ?? 'Stores',
  '/pricing'     => $translation['NAV_PRICING']     ?? 'Pricing',
  '/contact-us'  => $translation['NAV_CONTACT']     ?? 'Contact',
  // adicione outras rotas can00nicas aqui se precisar:
  // '/about'    => $translation['NAV_ABOUT'] ?? 'About',
];

/**
 * Aplica o mapa em um array de navega0400o vindo do banco.
 * Aceita tanto header quanto footer.
 */
$applyNavMap = function (&$nav) use ($navMap) {
  if (!is_array($nav)) return;
  foreach ($nav as &$item) {
    $type = $item['navigation_type'] ?? 'custom';
    // Para "page", o sistema normalmente usa apenas o slug (ex.: 'pricing')
    $url  = ($type === 'custom')
      ? ($item['navigation_url'] ?? '')
      : ('/' . ltrim(($item['navigation_url'] ?? ''), '/'));

    // normaliza "/" duplo e remove query/fragment pra casar com $navMap
    $url = '/' . ltrim(parse_url($url, PHP_URL_PATH) ?? '', '/');

    if (isset($navMap[$url])) {
      $item['navigation_label'] = $navMap[$url];
    }
  }
  unset($item);
};

// Aplica no header/footer se estiverem carregados
if (isset($navigationHeader)) { $applyNavMap($navigationHeader); }
if (isset($navigationFooter)) { $applyNavMap($navigationFooter); }

// Nada de sada/JS aqui. Apenas ajustamos os labels antes de renderizar.
