<?php
// Sidebar da oferta (CTA + preços)
// Aceita $itemDetails ou $deal
$src = [];
if (isset($itemDetails) && is_array($itemDetails)) { $src = $itemDetails; }
elseif (isset($deal) && is_array($deal))           { $src = $deal; }

// Helper para ler primeira chave existente
$pick = function(array $keys, $default=null) use ($src) {
    foreach ($keys as $k) {
        if (isset($src[$k]) && $src[$k] !== '' && $src[$k] !== null) return $src[$k];
    }
    return $default;
};

$old = (float) $pick(['deal_oldprice','deal_old_price','old_price'], 0);
$now = (float) $pick(['deal_price','price'], 0);

// Store data
$storeId   = (int) ($pick(['store_id'], 0));
$storeSlug = trim((string) $pick(['store_slug','slug_store'], ''));

// Link vindo do próprio deal
$btnUrlRaw = (string) $pick(['deal_url','deal_link','url','link','coupon_url','offer_url'], '');
$btnUrlRaw = html_entity_decode(trim($btnUrlRaw), ENT_QUOTES, 'UTF-8');

// URL externa da loja (tabela stores.store_url ou store_website)
$storeExternal = function_exists('nd_get_store_external_url') ? nd_get_store_external_url($storeId) : null;

// Se o link do deal vier sem http(s), prefixa https://
if ($btnUrlRaw !== '' && !preg_match('~^https?://~i', $btnUrlRaw)) {
    $btnUrlRaw = 'https://' . ltrim($btnUrlRaw, '/');
}

// URL absoluta atual (fallback seguro para compartilhar)
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host   = $_SERVER['HTTP_HOST'] ?? 'conecta.ndmidia.com.br';
$uri    = $_SERVER['REQUEST_URI'] ?? '/';
$currentUrl = $scheme . '://' . $host . $uri;

// Define o link final do botão seguindo a prioridade:
// 1) link configurado no deal
// 2) site externo da loja
// 3) busca por loja via slug
// 4) URL atual (fallback)
$link = '';
if (!empty($btnUrlRaw) && filter_var($btnUrlRaw, FILTER_VALIDATE_URL)) {
    $link = $btnUrlRaw;
} elseif (!empty($storeExternal) && filter_var($storeExternal, FILTER_VALIDATE_URL)) {
    $link = $storeExternal;
} elseif (!empty($storeSlug) && isset($urlPath) && is_object($urlPath) && method_exists($urlPath, 'search')) {
    $link = $urlPath->search(['store' => $storeSlug]);
} else {
    $link = $currentUrl;
}

// Formatação de preço
$fmtOld = $old > 0 ? 'R$ ' . number_format($old, 2, ',', '.') : '';
$fmtNow = $now > 0 ? 'R$ ' . number_format($now, 2, ',', '.') : '';

// Abre em nova aba quando o link não é do mesmo host (affiliates/externo)
$target = '_self';
if ($link && parse_url($link, PHP_URL_HOST) && parse_url($link, PHP_URL_HOST) !== $host) {
    $target = '_blank';
}

// Render
?>
<aside class="nd-offer-sidebar">
  <div class="nd-card uk-card uk-card-default uk-border-rounded uk-padding-small">
    <div class="nd-badge uk-margin-small-bottom">
      <span class="uk-label uk-label-danger uk-text-uppercase">Mais Bem Avaliado</span>
    </div>

    <div class="nd-prices">
      <?php if ($fmtOld): ?><span class="nd-price-old"><?php echo $fmtOld; ?></span><?php endif; ?>
      <span class="nd-price-now"><?php echo $fmtNow; ?></span>
    </div>

    <a class="uk-button uk-button-primary uk-border-pill uk-width-1-1"
       href="<?php echo htmlspecialchars($link, ENT_QUOTES, 'UTF-8'); ?>"
       target="<?php echo htmlspecialchars($target, ENT_QUOTES, 'UTF-8'); ?>"
       rel="noopener">
      Aproveitar oferta
    </a>

    <div class="uk-text-center uk-margin-small-top">
      <a href="#" class="uk-icon-button" uk-icon="heart" title="Salvar" aria-label="Save"></a>
    </div>
  </div>
</aside>
